/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ax25k.h"
#include "main.h"

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <qsocketnotifier.h>

#include "toolbox.h"
#include <time.h>


#ifdef HAVE_BROKEN_AX25_H
#include "../linkt/local_ax25.h"
#include <netrose/rose.h>
#elif HAVE_NETAX25_AX25_H
#include <netax25/ax25.h>
#include <netrose/rose.h>
#else
#include <linux/ax25.h>
#include <linux/rose.h>
#endif


#ifdef HAVE_NETAX25_AXLIB_H
   #include <netax25/axconfig.h>
   #include <netax25/axlib.h> 
#elif HAVE_AX25_AXUTILS_H
   #include <ax25/axconfig.h>
   #include <ax25/axutils.h>
#else
   #include <axconfig.h>
   #include <axutils.h>
#endif

#include "ax25k.moc"

#include <qsocketnotifier.h>
#include <kmsgbox.h>


extern TopLevel *toplevel;

// als extern deklariert in global.h
bool ax25_readportlist;


AX25::AX25( char *call, char *path, char *port, char *mycall ) : QObject( 0 )
{
   int error;
   int paclen;
   char tmp[100];


   if (!ax25_readportlist)
   {
      if (ax25_config_load_ports() == 0)
      {
         KMsgBox::message(0, klocale->translate("ConvKT-Error"), klocale->translate("No AX.25 port data avialable"));
         return;
      }

      if (ax25_config_get_addr(port) == NULL)
      {
         sprintf(tmp, klocale->translate("Invalid port setting for port %s."), port);
         KMsgBox::message(0, klocale->translate("ConvKT-Error"), tmp);
         return;
      }
      ax25_readportlist = true;
   }

   paclen = ax25_config_get_paclen(port);

   if ((fd = makeConnect( call, path, port, &error, mycall )) == -1)
   {
      switch (error)
      {
         case 1: // invalid parameter
                 KMsgBox::message(0, klocale->translate("ConvKT-Error"), klocale->translate("Cannot connect: Invalid parameter."));
                 break;
         case 2: // cannot open socket
                 KMsgBox::message(0, klocale->translate("ConvKT-Error"), klocale->translate("Cannot connect: Cannot open socket."));
                 break;
         case 3: // cannot bind socket
                 KMsgBox::message(0, klocale->translate("ConvKT-Error"), klocale->translate("Cannot connect: Cannot bind socket."));
                 break;
         case 4: // cannot connect twice
                 KMsgBox::message(0, klocale->translate("ConvKT-Error"), klocale->translate("Cannot connect: Cannot connect twice."));
                 break;
         case 0xFF: // unknown port name
                 KMsgBox::message(0, klocale->translate("ConvKT-Error"), klocale->translate("Cannot connect: Unknown port name."));
                 break;
      }
      return;
   }


   timer = new QTimer( this );
   connect(timer, SIGNAL(timeout()), this, SLOT(poll()));
   timer->start(200, true);

   sockrx = new QSocketNotifier( fd, QSocketNotifier::Read, this );
   connect( sockrx, SIGNAL(activated(int)), this, SLOT(rxFrame(int)) );
}


AX25::~AX25()
{
   delete timer;
   ::close(fd);
   delete sockrx;
}


int AX25::makeConnect( char *call, char *digis, char *port, int *error, char *mycall )
{
  struct full_sockaddr_ax25 ax25;
  int addrlen;
  struct full_sockaddr_ax25 ax25_d;
  int addrlen_d;
  int fd,i;
  char tmp[500];

  if (digis == NULL)
     strcpy(tmp, call);
  else if (digis[0] == '\0')
          strcpy(tmp, call);
       else
          sprintf(tmp,"%s %s",call,digis);

#ifdef HAVE_NETAX25_AXLIB_H
  addrlen_d = ax25_aton(tmp,&ax25_d);
#else
  addrlen_d = convert_call(tmp,&ax25_d);
#endif
  if (addrlen_d == -1)
  {
     *error = 1;
     return -1;
  }


  fd = socket(AF_AX25,SOCK_SEQPACKET,0);
  if (fd < 0)
  {
     *error = 2;
     return -1;
  }
  
  ax25.fsa_ax25.sax25_family = AF_AX25;
  ax25.fsa_ax25.sax25_ndigis = 1;
#ifdef HAVE_NETAX25_AXLIB_H
  ax25_aton_entry(mycall,
                     ax25.fsa_ax25.sax25_call.ax25_call);
  ax25_aton_entry(ax25_config_get_addr(port),
                     ax25.fsa_digipeater[0].ax25_call);
#else
  convert_call_entry(mycall,
                     ax25.fsa_ax25.sax25_call.ax25_call);
  convert_call_entry(ax25_config_get_addr(port),
                     ax25.fsa_digipeater[0].ax25_call);
#endif
  addrlen = sizeof(struct full_sockaddr_ax25);


  if (bind(fd,(struct sockaddr *)&ax25,addrlen) == -1)
  {
    ::close(fd);
    *error = 3;
    return -1;
  }

  i = TRUE;
  ioctl(fd,FIONBIO,&i);

  if (::connect(fd,(struct sockaddr *)&ax25_d,addrlen_d)) {
    if (errno != EINPROGRESS) {
      ::close(fd);
      *error = 4;
      return -1;
    }
  }
  
  return(fd);
}


void AX25::poll()
{
   int axstate;
   int tries,/*unack,*/squeue;
   ax25_info_struct axinfo;
   int err;
   bool restarttimer=true;


   if ((err = ioctl(fd, SIOCAX25GETINFO, &axinfo)) != -1)
   {
      tries = axinfo.n2count;
/*      if (axinfo.vs < axinfo.va)
         unack = 8 + p->vs - p->va;
      else
         unack = p->vs - p->va;*/
      squeue = axinfo.snd_q / 256;
      if ((squeue == 0) && (axinfo.snd_q > 0)) squeue = 1;

      switch (axinfo.state)
      {
         case 0:
           restarttimer = false;    // *kein* break!
         case 1:
           axstate = axinfo.state;
           break;
         case 2:
           axstate = 3;
           break;
         case 3:
           axstate = 4;
           break;
            case 4:
           axstate = 6;
           break;
         default:
           axstate = 0;
           break;
       }

          // Aenderungen an die Channel-Klasse zurueckgeben
//          tmp->channel->setUnack(unack);
/*          tmp->channel->setSQueue(squeue);
          tmp->channel->setTries(tries);
          if (axstate == 0)
             disc.append(tmp->channel);
          else*/
             toplevel->setStatus(axstate);
   }
/*   else
   {
//         disc.append(tmp->channel);
   }*/

   if (restarttimer)
      timer->start(200, true);
}


//   void Channel::rxFrame(int socket)
//
// Diese Funktion wird aufgerufen, wenn von unserer Verbindung Daten
// gekommen sind.
void AX25::rxFrame(int socket)
{
   char tmp[1001];
   int len;

   len = read(socket, tmp, 1000);

   if (len == 0) return;
   if (len == -1)
   {
      if (errno == ENOTCONN)
      {
         // Reconnecten
         toplevel->reconnectHost();
         delete this;
      }
      else
         printf("read-error: %s (%i)\n", strerror(errno), errno);
      return;
   }

   toplevel->workWithFrame( tmp, len );
}


