VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmHF150 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "HF-150 Control Program For UI-View32"
   ClientHeight    =   2085
   ClientLeft      =   4440
   ClientTop       =   4350
   ClientWidth     =   5070
   Icon            =   "frmHF150.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2085
   ScaleWidth      =   5070
   Begin VB.Frame Frame2 
      Caption         =   "Mode"
      Height          =   675
      Left            =   3120
      TabIndex        =   6
      Top             =   1050
      Width           =   1815
      Begin VB.OptionButton optMode 
         Alignment       =   1  'Right Justify
         Caption         =   "&Man"
         Height          =   195
         Index           =   0
         Left            =   120
         TabIndex        =   7
         Top             =   300
         Width           =   675
      End
      Begin VB.OptionButton optMode 
         Alignment       =   1  'Right Justify
         Caption         =   "&Auto"
         Height          =   195
         Index           =   1
         Left            =   960
         TabIndex        =   8
         Top             =   300
         Width           =   675
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Sideband"
      Height          =   675
      Left            =   3120
      TabIndex        =   3
      Top             =   210
      Width           =   1815
      Begin VB.OptionButton optSB 
         Alignment       =   1  'Right Justify
         Caption         =   "&LSB"
         Height          =   195
         Index           =   1
         Left            =   960
         TabIndex        =   5
         Top             =   300
         Width           =   675
      End
      Begin VB.OptionButton optSB 
         Alignment       =   1  'Right Justify
         Caption         =   "&USB"
         Height          =   195
         Index           =   0
         Left            =   120
         TabIndex        =   4
         Top             =   300
         Width           =   675
      End
   End
   Begin VB.ListBox lstStations 
      BackColor       =   &H00000000&
      BeginProperty Font 
         Name            =   "Fixedsys"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFF00&
      Height          =   1410
      Left            =   120
      TabIndex        =   2
      Top             =   300
      Width           =   2835
   End
   Begin MSCommLib.MSComm Comm1 
      Left            =   1260
      Top             =   780
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      CommPort        =   2
      DTREnable       =   -1  'True
      BaudRate        =   1200
   End
   Begin VB.Label labMode 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Manual Mode - double-click the list to select a frequency"
      ForeColor       =   &H00800000&
      Height          =   195
      Left            =   180
      TabIndex        =   9
      Top             =   1800
      Width           =   3990
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Frequency kHz"
      Height          =   195
      Left            =   1620
      TabIndex        =   1
      Top             =   60
      Width           =   1080
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Callsign"
      Height          =   195
      Left            =   180
      TabIndex        =   0
      Top             =   60
      Width           =   540
   End
   Begin VB.Menu mnuExit 
      Caption         =   "E&xit"
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "&Options"
      Begin VB.Menu mnuAlwaysOnTop 
         Caption         =   "&Always On Top"
      End
      Begin VB.Menu mnuComPort 
         Caption         =   "&COM Port"
         Begin VB.Menu mnuPort 
            Caption         =   "COM&1"
            Index           =   1
         End
         Begin VB.Menu mnuPort 
            Caption         =   "COM&2"
            Index           =   2
         End
         Begin VB.Menu mnuPort 
            Caption         =   "COM&3"
            Index           =   3
         End
         Begin VB.Menu mnuPort 
            Caption         =   "COM&4"
            Index           =   4
         End
      End
   End
   Begin VB.Menu mnuAbout 
      Caption         =   "A&bout"
   End
End
Attribute VB_Name = "frmHF150"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'This project is a very simple example of how an ActiveX client can use
'the DX spot data from UI-View32 to change the frequency of a rig.
'It works with the Lowe HF150 via the IF150 interface. It should be
'very easy to change it to control other rigs.
'
'It needs UI-View32 V1.10 or later.

Const USB = 0
Const LSB = 1
Const MANUAL = 0
Const AUTO = 1
Const FREQ_COMMAND = "FRQ "
Const SETUP_SECTION = "SETUP"
Const SWP_NOMOVE = 2
Const SWP_NOSIZE = 1
Const HWND_TOPMOST = -1
Const HWND_NOTOPMOST = -2

Private WithEvents mUIV As clsUIV
Attribute mUIV.VB_VarHelpID = -1
Private mintMode As Integer
Private mintComPort As Integer
Private mstrIniFile As String
Private mintSB As Integer
Private mblnOnTop As Boolean
Private mintLastLeft As Integer
Private mintLastTop As Integer
Private mstrMode(1) As String

Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, _
        ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, _
        ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Private Declare Function GetPrivateProfileString Lib "kernel32" _
        Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, ByVal lpDefault As String, _
        ByVal lpReturnedString As String, ByVal nSize As Long, _
        ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" _
        Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, ByVal lpString As Any, _
        ByVal lpFileName As String) As Long

Private Sub About()
Dim strA As String

strA = "This program is a very simple example of how an ActiveX client can use " & _
    "the DX spot data from UI-View32 to change the frequency of a rig. " & _
    "It works with the Lowe HF150 via the IF150 interface. The source code " & _
    "is provided, and it should be very easy for other developers to change " & _
    "it to control other rigs. NOTE - you must be using UI-View32 V1.10 or later."
    
MsgBox strA, vbInformation

End Sub

Private Sub SaveIni()
Dim blnMin As Boolean

blnMin = (WindowState = vbMinimized)
If Not blnMin Then
    mintLastLeft = Left
    mintLastTop = Top
End If
WritePrivateProfileString SETUP_SECTION, "LEFT", Format$(mintLastLeft), mstrIniFile
WritePrivateProfileString SETUP_SECTION, "TOP", Format$(mintLastTop), mstrIniFile
WritePrivateProfileString SETUP_SECTION, "MINIMIZED", TrueOrFalse(blnMin), mstrIniFile

End Sub

Private Function TrueOrFalse(blnI As Boolean) As String

If blnI = False Then TrueOrFalse = "FALSE" Else TrueOrFalse = "TRUE"

End Function

Private Function IsitTrue(strA As String) As Boolean

strA = UCase$(strA)
If strA = "YES" Or strA = "TRUE" Or strA = "1" Or strA = "ON" Then IsitTrue = True

End Function

Private Sub LoadIni()
Dim strA As String
Dim intI As Integer
Dim strSection As String

intI = (Screen.Width - Width) / 2
strA = GetIniStringWriteDefault(mstrIniFile, SETUP_SECTION, "LEFT", Format$(intI))
Left = Val(strA)

intI = (Screen.Height - Height) / 2
strA = GetIniStringWriteDefault(mstrIniFile, SETUP_SECTION, "TOP", Format$(intI))
Top = Val(strA)

strA = GetIniStringWriteDefault(mstrIniFile, SETUP_SECTION, "MINIMIZED", "FALSE")
If IsitTrue(strA) Then WindowState = vbMinimized

strA = GetIniStringWriteDefault(mstrIniFile, SETUP_SECTION, "COM_PORT", "1")
intI = Val(strA)
mintComPort = intI
mnuPort(mintComPort).Checked = True

strA = GetIniStringWriteDefault(mstrIniFile, SETUP_SECTION, "SB", "0")
mintSB = Val(strA)

strA = GetIniStringWriteDefault(mstrIniFile, SETUP_SECTION, "MODE", "0")
intI = Val(strA)
optMode(intI) = True
mintMode = intI

strA = GetIniStringWriteDefault(mstrIniFile, SETUP_SECTION, "ALWAYS_ON_TOP", "FALSE")
mblnOnTop = IsitTrue(strA)
mnuAlwaysOnTop.Checked = mblnOnTop
If mblnOnTop Then SetWindowPos Me.hwnd, HWND_TOPMOST, 0&, 0&, 0&, 0&, SWP_NOMOVE + SWP_NOSIZE

End Sub

Private Function GetIniStringWriteDefault(strIniName As String, strSection As String, strParam As String, strDefault As String) As String
Dim strA As String
Dim intRet As Integer

strA = GetIniString(strIniName, strSection, strParam, strDefault)

If strA = strDefault Then
    intRet = WritePrivateProfileString(strSection, strParam, strDefault, strIniName)
End If

GetIniStringWriteDefault = strA

End Function

Private Function GetIniString(strFname As String, section As String, KeyName As String, KeyDefault As String)
Dim lngX As Long
Dim strTmp As String

strTmp = Space$(500)

lngX = GetPrivateProfileString(section, KeyName, KeyDefault, strTmp, Len(strTmp), strFname)
GetIniString = Left(strTmp, lngX)

End Function

Private Sub CloseComPort()

If Comm1.PortOpen Then Comm1.PortOpen = False

End Sub

Private Sub OpenComPort()
Dim strA As String

On Error GoTo OpenComPortErr
Comm1.CommPort = mintComPort
Comm1.PortOpen = True
Exit Sub

OpenComPortErr:
strA = "An error occurred opening the COM port. " & _
        "The system error message is '" & Error(Err) & "'"
MsgBox strA, vbExclamation
Exit Sub

End Sub

Private Sub Form_Load()

Set mUIV = New clsUIV
Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
mstrIniFile = App.Path & "\" & App.EXEName & ".INI"
mstrMode(MANUAL) = "Manual Mode - double-click the list to select a frequency"
mstrMode(AUTO) = "Auto Mode - the frequency changes whenever a spot is received"

'Set the COM port params according to the rig being used.
Comm1.Settings = "1200,N,8,1"
Comm1.Handshaking = comNone
LoadIni

OpenComPort
'This will send the U/LSB command to the rig
'because it generates a click event.
optSB(mintSB) = True

End Sub

Private Sub Form_Resize()

If WindowState <> vbMinimized Then
    mintLastLeft = Left
    mintLastTop = Top
End If

End Sub

Private Sub Form_Unload(Cancel As Integer)

If Comm1.PortOpen Then Comm1.PortOpen = False
SaveIni

End Sub


Private Sub Label4_Click()

End Sub

Private Sub lstStations_DblClick()
Dim intI As Integer
Dim strA As String

intI = lstStations.ListIndex
If intI < 0 Then Exit Sub
strA = lstStations.List(intI)
strA = Trim$(Mid$(strA, 11))
'The HF-150 has a very simple frequency command format, more processing
'of the data from UI-View32 may be needed for other rigs.
If Comm1.PortOpen Then Comm1.Output = FREQ_COMMAND & strA & vbCr

End Sub


Private Sub lstStations_KeyPress(KeyAscii As Integer)

If KeyAscii = vbKeyReturn Then lstStations_DblClick

End Sub


Private Sub mnuAbout_Click()

About

End Sub

Private Sub mnuAlwaysOnTop_Click()
Dim lngT As Long

mblnOnTop = Not mblnOnTop
mnuAlwaysOnTop.Checked = mblnOnTop
If mblnOnTop Then lngT = HWND_TOPMOST Else lngT = HWND_NOTOPMOST
SetWindowPos Me.hwnd, lngT, 0&, 0&, 0&, 0&, SWP_NOMOVE + SWP_NOSIZE
WritePrivateProfileString SETUP_SECTION, "ALWAYS_ON_TOP", TrueOrFalse(mblnOnTop), mstrIniFile

End Sub

Private Sub mnuExit_Click()

Unload Me

End Sub

Private Sub mnuPort_Click(Index As Integer)
Dim intI As Integer

For intI = 1 To 4
    mnuPort(intI).Checked = (Index = intI)
Next intI

WritePrivateProfileString SETUP_SECTION, "COM_PORT", Format$(Index), mstrIniFile

mintComPort = Index
CloseComPort
OpenComPort

End Sub

Private Sub mUIV_NotifyDXSpot(strDxSpot As String, strCallsign As String, strFreq As String, intLat As Integer, intLong As Integer, intBearing As Integer, intDistance As Integer)
Dim intI As Integer

'If we've got 100 stations in the list then cut back to 80.
If lstStations.ListCount >= 100 Then
    For intI = 1 To 20
        lstStations.RemoveItem 0
    Next intI
End If

lstStations.AddItem Left$(strCallsign & Space$(10), 10) & Right$(Space$(10) & strFreq, 10)
lstStations.ListIndex = lstStations.NewIndex
'The HF-150 has a very simple frequency command format, more processing
'of the data from UI-View32 may be needed for other rigs.
If mintMode = AUTO Then
    If Comm1.PortOpen Then Comm1.Output = FREQ_COMMAND & strFreq & vbCr
End If

End Sub


Private Sub mUIV_UIView32IsClosing()

Unload Me

End Sub


Private Sub optMode_Click(Index As Integer)

mintMode = Index
labMode = mstrMode(mintMode)
WritePrivateProfileString SETUP_SECTION, "MODE", Format$(Index), mstrIniFile

End Sub

Private Sub optSB_Click(Index As Integer)
Dim strA As String

'Change the commands according to the rig being used.
'Buttons for CW, FM, AM, etc, can, of course be added.
If Index = 0 Then strA = "USB" Else strA = "LSB"
If Comm1.PortOpen Then Comm1.Output = "MOD " & strA & vbCr
WritePrivateProfileString SETUP_SECTION, "SB", Format$(Index), mstrIniFile

End Sub


