/* $Header: /home/alan/dlg/tiger/src/RCS/tgr.h,v 1.4 1996/07/15 04:49:21 alan Exp $ 
 * 1994 Census TIGER/Line records as found on CDROM (with CRLF's)
 * Source: TIGER/Line(R) Files, 1994 Technical Documentation, Chapter 6 
 */

#ifndef _TGR_H_
#define _TGR_H_ 1

#ifdef TGR_LL
typedef char LL[19];
#define LON 0
#define LON_LEN 10
#define LAT 10
#define LAT_LEN 9
#endif /* TGR_LL */

struct tgr1 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char tlid[10];		/* TIGER/Line ID, */
				/* Permanent Record */
				/* Number */
  char side1[1];		/* Single-Side Code */
				/* Complete Chain */
  char source[1];		/* Source or First */
				/* Source Code of */
				/* Update */
  char fedirp[2];		/* Feature Direction, */
				/* Prefix */
  char fename[30];		/* Feature Name */
  char fetype[4];		/* Feature Type */
  char fedirs[2];		/* Feature Direction, */
				/* Suffix */
  char cfcc[3];			/* Census Feature */
				/* Class Code */
  char fraddl[11];		/* Start Address Left */
  char toaddl[11];		/* End Address Left */
  char fraddr[11];		/* Start Address */
				/* Right */
  char toaddr[11];		/* End Address Right */
  char friaddl[1];		/* Start Imputed */
				/* address Flag Left */
  char toiaddl[1];		/* End Imputed */
				/* Address Flag Left */
  char friaddr[1];		/* Start Imputed */
				/* Address Flag Right */
  char toiaddr[1];		/* End Imputed */
  char zipl[5];			/* ZIP Code(R) Left */
  char zipr[5];			/* ZIP Code(R) Right */
  char fairl[5];		/* FIPS 55 Code */
				/* (American */
				/* Indian/Alaska */
				/* Native Area), */
				/* Current Left */
  char fairr[5];		/* FIPS 55 Code */
				/* (American */
				/* Indian/Alaska */
				/* Native */
				/* Area), Current Right */
  char trustl[1];		/* American Indian */
				/* Trust */
				/* Land Flag Left */
  char trustr[1];		/* American Indian */
				/* Trust Land Flag */
				/* Right */
  char bbspcen[1];		/* BBSP Census Bureau */
				/* Complete Chain Flag */
  char bbsppart[1];		/* BBSP Participant */
				/* Complete Chain Flag */
  char statel[2];		/* FIPS State Code, */
				/* Current Left */
  char stater[2];		/* FIPS State Code, */
				/* Right */
  char countyl[3];		/* FIPS County Code, */
				/* Current Left */
  char countyr[3];		/* FIPS County Code, */
				/* Current Right */
  char fmcdl[5];		/* FIPS 55 Code */
				/* (MCD/CCD) Left, */
				/* Current */
  char fmcdr[5];		/* FIPS 55 Code */
				/* (MCD/CCD) Right, */
				/* Current */
  char fsmcdl[5];		/* FIPS 55 Code */
				/* (Sub-MCD),Current */
				/* Left */
  char fsmcdr[5];		/* FIPS 55 Code */
				/* (Sub-MCD),Current */
				/* Right */
  char fpll[5];			/* FIPS 55 Code */
				/* (Place/CDP),Current */
				/* Left */
  char fplr[5];			/* FIPS 55 Code */
				/* (Place/CDP), */
				/* Current Right */
  char ctbna90l[6];		/* Census Tract/BNA */
				/* Code,1990 Left */
  char ctbna90r[6];		/* Census Tract/BNA */
				/* Code,1990 Right */
  char blk90l[4];		/* Block Number, */
				/* 1990 Left */
  char blk90r[4];		/* Block Number, */
				/* 1990 Right */
#ifdef TGR_LL
  LL fr;			/* Start long/lat */
  LL to;			/* end long/lat */
#else
  char frlong[10];		/* Start Longitude */
  char frlat[9];		/* Start Latitude */
  char tolong[10];		/* End Longitude */
  char tolat[9];		/* End Latitude */
#endif /* TGR_LL */
  char crlf[2];
};

struct tgr2 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char tlid[10];		/* TIGER/Line ID, */
				/* Permanent Record */
				/* Number */
  char rtsq[3];			/* Record Sequence */
				/* Number */
#ifdef TGR_LL
  LL ll[10];			/* 10 points of long/lat */
#else
  char long1[10];		/* Point 1, Longitude */
  char lat1[9];			/* Point 1, Latitude */
  char long2[10];		/* Point 2, Longitude */
  char lat2[9];			/* Point 2, Latitude */
  char long3[10];		/* Point 3, Longitude */
  char lat3[9];			/* Point 3, Latitude */
  char long4[10];		/* Point 4, Longitude */
  char lat4[9];			/* Point 4, Latitude */
  char long5[10];		/* Point 5, Longitude */
  char lat5[9];			/* Point 5, Latitude */
  char long6[10];		/* Point 6, Longitude */
  char lat6[9];			/* Point 6, Latitude */
  char long7[10];		/* Point 7, Longitude */
  char lat7[9];			/* Point 7, Latitude */
  char long8[10];		/* Point 8, Longitude */
  char lat8[9];			/* Point 8, Latitude */
  char long9[10];		/* Point 9, Longitude */
  char lat9[9];			/* Point 9, Latitude */
  char long10[10];		/* Point 10, Longitude */
  char lat10[9];		/* Point 10, Latitude */
#endif TGR_LL
  char crlf[2];
};

struct tgr3 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char tlid[10];		/* TIGER/Line ID, */
				/* Permanent Record */
				/* Number */
  char state90l[2];		/* FIPS State Code, */
				/* 1990 Left */
  char state90r[2];		/* FIPS State Code, */
				/* 1990 Right */
  char coun90l[3];		/* FIPS County Code, */
				/* 1990 Left */
  char coun90r[3];		/* FIPS County Code, */
				/* 1990 Right */
  char fmcd90l[5];		/* FIPS 55 Code */
				/* (MCD/CCD), */
				/* 1990 Left */
  char fmcd90r[5];		/* FIPS 55 Code */
				/* (MCD/CCD), */
				/* 1990 Right */
  char fpl90l[5];		/* FIPS 55 Code */
				/* (Place/CDP), */
				/* 1990 Left */
  char fpl90r[5];		/* FIPS 55 Code */
				/* (Place/CDP), */
				/* 1990 Right */
  char ctbna90l[6];		/* Census Tract/BNA */
				/* Code,1990 Left */
  char ctbna90r[6];		/* Census Tract/BNA */
				/* Code,1990 Right */
  char rs1[3];			/* Reserved Space 1 */
  char rs2[3];			/* Reserved Space 2 */
  char rs3[3];			/* Reserved Space 3 */
  char rs4[3];			/* Reserved Space 4 */
  char blk90l[4];		/* Block Number, */
				/* 1990 Left */
  char blk90r[4];		/* Block Number, */
				/* 1990 Right */
  char airl[4];			/* Census American */
				/* Indian/Alaska */
				/* Native Area Code, */
				/* Current Left */
  char airr[4];			/* Census American */
				/* Indian/Alaska */
				/* Native Area Code, */
				/* Current Right */
  char rs5[3];			/* Reserved Space 5 */
  char rs6[3];			/* Reserved Space 6 */
  char anrcl[2];		/* Census Alaska Native */
				/* RegionalCorporation */
				/* Code,Current Left */
  char anrcr[2];		/* Census Alaska Native */
				/* Regional Corporation */
				/* Code,Current Right */
  char rs7[4];			/* Reserved Space 7 */
  char rs8[4];			/* Reserved Space 8 */
  char vtdl[4];			/* Census Voting */
				/* District Code, */
				/* 1990 Left */
  char vtdr[4];			/* Census Voting */
				/* District Code, */
				/* 1990 Right */
  char crlf[2];
};

struct tgr4 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char tlid[10];		/* TIGER/Line ID, */
				/* Permanent Record */
				/* Number */
  char rtsq[3];			/* Record Sequence */
				/* Number */
  char feat1[8];		/* Line Additional */
				/* Name Identification */
				/* Number,First */
  char feat2[8];		/* Line Additional */
				/* Name Identification */
				/* Number,Second */
  char feat3[8];		/* Line Additional */
				/* Name Identification */
				/* Number,Third */
  char feat4[8];		/* Line Additional */
				/* Name Identification */
				/* Number,Fourth */
  char feat5[8];		/* Line Additional */
				/* Name Identification */
				/* Number,Fifth */
  char crlf[2];
};

struct tgr5 {
  char rt[1];			/* Record Type */
  char state[2];		/* FIPS State Code, */
				/* Current */
  char county[3];		/* FIPS County Code, */
				/* Current */
  char feat[8];			/* Line Name */
				/* Identification */
				/* Number */
  char fedirp[2];		/* Feature Direction, */
				/* Prefix */
  char fename[30];		/* Feature Name */
  char fetype[4];		/* Feature Type */
  char fedirs[2];		/* Feature Direction, */
				/* Suffix */
  char crlf[2];
};

struct tgr6 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char tlid[10];		/* TIGER/Line ID, */
				/* Permanent Record */
				/* Number */
  char rtsq[3];			/* Record Sequence */
				/* Number */
  char fraddl[11];		/* Start Address */
				/* Left */
  char toaddl[11];		/* End Address Left */
  char fraddr[11];		/* Start Address */
				/* Right */
  char toaddr[11];		/* End Address Right */
  char friaddl[1];		/* Start Imputed */
				/* Address Flag Left */
  char toiaddl[1];		/* End Imputed Address */
				/* Flag Left */
  char friaddr[1];		/* Start Imputed */
				/* Address Flag Right */
  char toiaddr[1];		/* End Imputed Address */
				/* Flag Right */
  char zipl[5];			/* ZIP Code(R) Left */
  char zipr[5];			/* ZIP Code(R) Right */
  char crlf[2];
};

struct tgr7 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, */
				/* Current */
  char county[3];		/* FIPS County Code, */
				/* Current */
  char land[10];		/* Landmark Identification */
				/* Number */
  char source[1];		/* Source or First Source */
				/* Code to Update */
  char cfcc[3];			/* Census Feature Class */
				/* Code */
  char laname[30];		/* Landmark Name */
#ifdef TGR_LL
  LL la;			/* lon/lat */
#else
  char lalong[10];		/* Longitude */
  char lalat[9];		/* Latitude */
#endif /* TGR_LL */
  char filler[1];		/* Filler (to make even */
				/* character count) */
  char crlf[2];			
};

struct tgr8 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, */
				/* Current */
  char county[3];		/* FIPS County Code, */
				/* Current */
  char cenid[5];		/* Census File */
				/* Identification Code */
  char polyid[10];		/* Polygon Identification */
				/* Code */
  char land[10];		/* Landmark Identification */
				/* Number */
  char filler[1];		/* Filler (to make even */
				/* character count) */
  char crlf[2];
};

struct tgr9 {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, */
				/* Current */
  char county[3];		/* FIPS County Code, */
				/* Current */
  char cenid[5];		/* Census File */
				/* Identification Code */
  char polyid[10];		/* Polygon Identification */
				/* Code */
  char source[1];		/* Source or First Source */
				/* Code to Update */
  char cfcc[3];			/* Census Feature Class */
				/* Code */
  char kglname[30];		/* Key Geographic */
				/* Location Name */
  char kgladd[11];		/* Key Geographic Location */
				/* Address */
  char kglzip[5];		/* Key Geographic Location */
				/* ZIP Code */
  char kglzip4[4];		/* +4 Postal Add-on Code */
				/* for KGL */
  char feat[8];			/* Line Name */
				/* Identification Number */
  char filler[1];		/* Filler (to make even */
				/* character count) */
  char crlf[2];
};

struct tgrA {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, */
				/* Current */
  char county[3];		/* FIPS County Code, */
				/* Current */
  char cenid[5];		/* Census File */
				/* Identification Code */
  char polyid[10];		/* Polygon Identification */
  char fair[5];			/* FIPS 55 Code (American */
				/* Indian/Alaska Native */
				/* Area), 1990 */
  char fmcd[5];			/* FIPS 55 Code */
				/* (MCD/CCD), 1990 */
  char fpl[5];			/* FIPS 55 Code */
				/* (Place/CDP), 1990 */
  char ctbna90[6];		/* Census Tract/BNA */
				/* Code, 1990 */
  char blk90[4];		/* Block Number, 1990 */
  char cd106[2];		/* Congressional District */
				/* Number, 106th */
  char cd108[2];		/* Congressional District */
				/* Number, 108th */
  char sdelm[5];		/* School District Code, */
				/* Elementary School */
  char sdmid[5];		/* School District Code, */
				/* Middle School */
  char sdsec[5];		/* School District Code, */
				/* Secondary School */
  char sduni[5];		/* School District Code, */
				/* Unified District */
  char taz[6];			/* Traffic Analysis Zone */
				/* Code */
  char ua[4];			/* Census Urbanized Area */
				/* Code */
  char urbflag[1];		/* Urban Flag */
  char ctpp[4];			/* Census Transportation */
				/* Planning Package Area */
				/* Code */
  char rs9[9];			/* Reserved Space 9 */
  char crlf[2];
};		

struct tgrC {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, Year */
  char county[3];		/* FIPS County Code, Year */
  char fipsyr[2];		/* FIPS Code and Name */
				/* Relationship Applicable */
				/* Year */
  char fips[5];			/* FIPS 55 Code, Year */
  char fipscc[2];		/* FIPS 55 Class Code,Year */
  char pdc[1];			/* Census Place */
				/* Description Code,Year */
  char lasad[2];		/* Legal/Administrative/ */
				/* Statistical Area */
				/* Description Code,Year */
  char anrc[2];			/* Census Alaska Native */
				/* Regional Corporation */
				/* Code,Year */
  char cmsamsa[4];		/* Consolidated */
				/* Metropolitan */
				/* Statistical Area */
				/* Metropolitan Statistical */
				/* Area Code, Year */
  char pmsa[4];			/* Primary Metropolitan */
				/* Statistical Area Code, */
				/* Year */
  char air[4];			/* Census American Indian/ */
				/* Alaska Native Area */
				/* Code,Year */
  char vtd[6];			/* Census Voting */
				/* District Code, Year */
  char ua[4];			/* Census Urbanized Area */
				/* Code, Year */
  char name[66];		/* Name of Geographic Area */
  char crlf[2];
};	

struct tgrH {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, Year */
  char county[3];		/* FIPS County Code, Year */
  char fipsyr[2];		/* FIPS Code and Name */
				/* Relationship Applicable */
				/* Year */
  char fips[5];			/* FIPS 55 Code, Year */
  char fipscc[2];		/* FIPS 55 Class Code,Year */
  char pdc[1];			/* Census Place */
				/* Description Code,Year */
  char lasad[2];		/* Legal/Administrative/ */
				/* Statistical Area */
				/* Description Code,Year */
  char anrc[2];			/* Census Alaska Native */
				/* Regional Corporation */
				/* Code,Year */
  char cmsamsa[4];		/* Consolidated */
				/* Metropolitan */
				/* Statistical Area */
				/* Metropolitan Statistical */
				/* Area Code, Year */
  char pmsa[4];			/* Primary Metropolitan */
				/* Statistical Area Code, */
				/* Year */
  char air[4];			/* Census American Indian/ */
				/* Alaska Native Area */
				/* Code,Year */
  char vtd[6];			/* Census Voting */
				/* District Code, Year */
  char ua[4];			/* Census Urbanized Area */
				/* Code, Year */
  char name[66];		/* Name of Geographic Area */
  char crlf[2];
};

struct tgrI {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char tlid[10];		/* TIGER/Line ID, */
				/* Permanent Record */
				/* Number */
  char state[2];		/* FIPS State Code,Current */
  char county[3];		/* FIPS County Code,Current */
  char rtlink[1];		/* Record Type of Link */
  char cenidl[5];		/* Census File */
				/* Identification Code Left */
  char polyidl[10];		/* Polygon Identification */
				/* Code Left */
  char cenidr[5];		/* Census File */
				/* Identification Code */
				/* Right */
  char polyidr[10];		/* Polygon Identification */
				/* Code Right */
  char filler[1];		/* Filler (to make even */
				/* character count) */
  char crlf[2];
};	

struct tgrP {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code,Current */
  char county[3];		/* FIPS County Code,Current */
  char cenid[5];		/* Census File */
				/* Identification Code */
  char polyid[10];		/* Polygon Identification */
				/* Code */
#ifdef TGR_LL
  LL ctr;			/* Polygon Center Point */
#else
  char ctrlong[10];		/* Polygon Center Point */
				/* Longitude */
  char ctrlat[9];		/* Polygon Center Point */
				/* Latitude */
#endif /* TGR_LL */
  char crlf[2];			
};				

struct tgrR {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, */
				/* Current */
  char county[3];		/* FIPS County Code, */
				/* Current */
  char cenid[5];		/* Census File */
				/* Identification Code */
  char maxid[10];		/* TIGER/Line ID, Minimum */
				/* Permanent ID for */
				/* Census File */
  char minid[10];		/* TIGER/Line ID, Minimum */
				/* Permanent ID for */
				/* Census File */
  char highid[10];		/* TIGER/Line ID, Current */
				/* High ID for Census File */
  char filler[1];		/* Filler (to make even */
				/* character count) */
				
  char crlf[2];		
};			
			

struct tgrS {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char state[2];		/* FIPS State Code, Current */
  char county[3];		/* FIPS County Code,Current */
  char cenid[5];		/* Census File */
				/* Identification Code */
  char polyid[10];		/* Polygon Identification */
				/* Code */
  char water[1];		/* Water Flag */
  char cmsamsa[4];		/* FIPS Consolidated */
				/* Metropolitan Statistical */
				/* Area/ Metropolitan */
				/* Statistical Area Code, */
				/* Current */
  char pmsa[4];			/* FIPS Primary Metropolitan */
				/* Statistical Area Code, */
				/* Current */
  char fair[5];			/* FIPS 55 Code (American */
				/* Indian/ Alaska Native */
				/* Area), Current */
  char air[4];			/* Census American Indian/ */
				/* Alaska Native Area Code, */
				/* Current */
  char trust[1];		/* American Indian Trust */
				/* Land Flag */
  char anrc[2];			/* Census Alaska Native */
				/* Regional Corporation */
				/* Code,Current */
  char statecu[2];		/* FIPS State Code, Current */
  char countycu[3];		/* FIPS County Code,Current */
  char fccity[5];		/* FIPS 55 Code */
				/* (Consolidated City), */
				/* Current */
  char fmcd[5];			/* FIPS 55 Code (MCD/CCD), */
				/* Current */
  char fsmcd[5];		/* FIPS 55 Code (Sub-MCD), */
				/* Current */
  char fpl[5];			/* FIPS 55 Code */
				/* (Place/CDP), Current */
  char ctbna90[6];		/* Census Tract/BNA Code,1990 */
  char blk90[4];		/* Block Number, 1990 */
  char rs10[1];			/* Reserved Space 10 (2000 */
				/* Block Suffix) */
  char cdcu[2];			/* Congressional District */
				/* Number, Current */
  char stsenate[6];		/* State Senate District */
				/* Code */
  char sthouse[6];		/* State House District */
				/* Code */
  char vtd00[6];		/* Census Voting District */
				/* Code (2000) */
  char rs11[6];			/* Reserved Space 11 */
				/* (CT2000) */
  char rs12[1];			/* Reserved Space 12 */
				/* (BG2000) */
  char rs13[5];			/* Reserved Space 13 */
				/* (CCD2000) */
  char rs14[5];			/* Reserved Space 14 */
				/* (CDP2000) */
  char filler[1];		/* Filler (to make even */
				/* character count) */
				
  char crlf[2];
};

struct tgrZ {
  char rt[1];			/* Record Type */
  char version[4];		/* Version Number */
  char tlid[10];		/* TIGER/Line ID, Permanent */
				/* Record Number */
  char rtsq[3];			/* Record Sequence Number */
  char zip4l[4];		/* +4 Postal Add-on Code */
				/* Left */
  char zip4r[4];		/* +4 Postal Add-on Code */
				/* Right */
  char crlf[2];			
};				
				
#endif /* _TGR_H_ */
