#ifdef TEST
#define DEBUG 1
#endif
/*
 * mic_e: function to reformat APRS Mic Encoder compressed position report
 *  into a conventional (non-binary) tracker report.
 * $Log: mic_e.c,v $
 * Revision 1.3  1997/05/16 03:49:50  alan
 * untested corrections to match production rev.
 *
 * Revision 1.2  1997/05/03 05:39:37  alan
 * 1st pass at adding rev 1 changes.  Some stuff doesn't match docs.
 *
 */
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include "mic_e.h"

static char *msgname[] = {
  "Off duty",
  "Enroute",
  "In Service",
  "Returning",
  "Committed",
  "Special",
  "PRIORITY",
  "EMERGENCY"
};

int
fmt_mic_e(t,i,l,buf1,l1,buf2,l2,tick)
u_char *t,*i;			/* tocall,info */
int l;				/* lenght of info */
u_char *buf1,*buf2;
int *l1,*l2;
time_t tick;
{
  u_int msg,sp,dc,se,spd,cse;
  char north, west;
  int lon1,lonDD,lonMM,lonHH;
  char *bp;
  struct tm *gmt;
  enum {none=0, BETA, REV1} rev = none; /* mic_e revision level */
  int gps_valid = 0;
  char symtbl = '/', symbol = '$';

  *l1 = *l2 = 0;
  
  switch (i[0]) {		/* possible valid MIC-E flags */
  case 0x60:
    gps_valid = 1;
    rev = REV1;
    break;
  case 0x27:
    gps_valid = 0;
    rev = REV1;
    break;
  case 0x1c:
    gps_valid = 1;
    rev = BETA;
    break;
  case 0x1d:
    gps_valid = 0;
    rev = BETA;
    break;
  default:
    gps_valid = 0;
    rev = none;
    break;
  }
  if (l >= 7 && (rev != none)) {
    msg = ((t[0]&0x40)?0:4) + ((t[1]&0x40)?0:2) + ((t[2]&0x40)?0:1);
    north = t[3]&0x40?'N':'S';
    west = t[5]&0x40?'W':'E';
    lon1 = t[4]&0x40;
    lonDD = i[1] - 28;
    lonMM = i[2] - 28;
    lonHH = i[3] - 28;
#ifdef DEBUG
    fprintf(stderr,"raw lon %02x %02x %02x\n",i[1],i[2],i[3]);
    fprintf(stderr,"before: lonDD=%d, lonMM=%d, lonHH=%d\n",lonDD,lonMM,lonHH);
#endif
    if (rev >= REV1) {
      if (180 <= lonDD && lonDD <= 189)
	lonDD -= 80;
      if (190 <= lonDD && lonDD <= 199)
	lonDD -= 190;
      if (lon1)
	lonDD += 100;
      if (lonMM > 60)
	lonMM -= 60;
    }
#ifdef DEBUG
    fprintf(stderr,"after: lonDD=%d, lonMM=%d, lonHH=%d\n",lonDD,lonMM,lonHH);
#endif
    sp = i[4] - 28;
    dc = i[5] - 28;
    se = i[6] - 28;
#ifdef DEBUG
    fprintf(stderr,"sp=%02x dc==%02x se=%02x\n",sp,dc,se);
#endif
    spd = sp*10+dc/10;
    cse = (dc%10)*100+se;
    if (rev >= REV1) {
      if (spd >= 800)
	spd -= 800;
      if (cse >= 400)
	cse -= 400;
    }
    gmt = gmtime(&tick);
#ifdef DEBUG
    fprintf(stderr,"symbol=0x%02x, symtbl=0x%02x\n",i[7],i[8]);
#endif
    symtbl = (l >= 8 && rev >= REV1)? i[8] : '/';
    /* rev1 bug workaround:  sends null symbol/table bytes */
    if (symtbl != '/' && symtbl != '\\' 
	&& !('0' <= symtbl && symtbl <= '9')
	&& !('A' <= symtbl && symtbl <= 'J')
	&& symtbl != '*' && symtbl != '!')
      symtbl = '/';
    symbol = i[7];
    if (!isprint(symbol))
      symbol = '$';

    sprintf(buf1,"@%02d%02d%02dh%d%d%d%d.%d%d%c%c%03d%02d.%02d%c%c%03d/%03dMIC/M%d/%s...",
	    gmt->tm_hour,gmt->tm_min,gmt->tm_sec,
	    t[0]&0x0f,t[1]&0x0f,t[2]&0x0f,t[3]&0x0f,t[4]&0x0f,t[5]&0x0f,
	    north,symtbl,
	    lonDD,lonMM,lonHH,
	    west,
	    symbol,
	    cse,spd,
	    msg,msgname[msg]);
    bp = &buf1[(*l1 = strlen(buf1))-1];
    if (l >= 11) {
      int n = (rev == BETA)?8:9;
      unsigned int hex2i(u_char,u_char);
      switch (i[n]) {
      case 0x60:
	sprintf(buf2,"T#MIC%03d%03d",
		hex2i(i[n+1],i[n+2]),
		hex2i(i[n+3],i[n+4]));
	n+=4;
	*l2 = strlen(buf2);
	break;
      case 0x27:
	sprintf(buf2,"T#MIC%03d%03d%03d%03d%03d",
		hex2i(i[n+1],i[n+2]),
		hex2i(i[n+3],i[n+4]),
		hex2i(i[n+5],i[n+6]),
		hex2i(i[n+7],i[n+8]),
		hex2i(i[n+9],i[n+10]));
	n+=10;
	*l2 = strlen(buf2);
	break;
      case 0x1d:
	sprintf(buf2,"T#MIC%03d%03d%03d%03d%03d",
		i[n+1],i[n+2],i[n+3],i[n+4],i[n+5]);
	n+=5;
	*l2 = strlen(buf2);
	break;
      default:
	break;			/* no telemetry */
      }
      if (n < l) {		/* comments/btext */
	bcopy(&i[n],bp,l-n);
	*l1 += l-n-1;
      }
    }
  }
  return ((*l1>0)+(*l2>0));
}

#ifdef TEST
main()
{
  char b[100];
  char ob1[512],ob2[512];
  int ol1,ol2;

  while (gets(b)) {
    time_t tick;
    time(&tick);
    fmt_mic_e(&b[8],&b[31],strlen(&b[31]),ob1,&ol1,ob2,&ol2,tick);
    if (ol2) {
      fwrite(ob2,ol2,1,stdout);	/* telemetry */
      putchar('\n');
    }
    if (ol1) {
      fwrite(ob1,ol1,1,stdout);	/* posit */
      putchar('\n');
    }
  }
}
#endif

unsigned int hex2i(u_char a,u_char b)
{
  int r = 0;

  if (a >= '0' && a <= '9') {
   r = (a-'0') << 4;
  } else if (a >= 'A' && a <= 'F') {
   r = (a-'A'+10) << 4;
  }
  if (b >= '0' && b <= '9') {
   r += (b-'0');
  } else if (b >= 'A' && b <= 'F') {
   r += (b-'A'+10);
  }
  return r;
}
