{ Ausgabe eine Auslesestatistik fuer DIEBOX anhand von RLOG.BOX }
{ Version 0.3 - DL1MCX @ OE9XPI }

Program FStat;
Uses Crt, Dos;

Const
  MaxDir = 4096;
  NoError = 0;
  OpenError = 1; FormatError = 2;

Type
  AnyStr     = String[255];
  DirRec     = Record
                 DosFile : String[14];
                 count   : Word;
               End;

  DirPtr     = ^DirRec;
  DirArr     = Array[1..MaxDir] of DirPtr;

  LessFunc = function(X, Y: DirPtr):Boolean;

Var
  Con,
  RFile        : Text;
  UserPfad,
  InfoPfad,
  SysPfad      : String;
  LogBegin,
  LogEnd,
  filename,
  datum,
  bytecount,
  absender,
  titel        : AnyStr;
  returncode   : byte;
  Dir          : DirArr;
  Count,RCount : Word;
  Less         : LessFunc;
  DisplCount   : Word;

{-------------------------------------------------------------------------
 ConstStr  fuellt einen String auf die Gesamtlaenge L mit Zeichen ch auf;
          Fuer Posi wird "r" oder "l" erwartet (rechts- oder linksbuendig)
--------------------------------------------------------------------------}
FUNCTION ConstStr (Zeile:String; L:Integer; ch, Posi:Char) : String;
Var B_Str : String;
Laenge    : Byte;
BEGIN
  Laenge := L - length(Zeile);
  IF (L < 0 ) THEN L := 0;
  IF (L > 255) THEN L := 255;
  fillchar(B_Str,Laenge+2,ch);
  B_Str[0] := Chr(Laenge);

  If Posi = 'l'
    then ConstStr  := Zeile + B_Str;
  IF Posi = 'r'
    then ConstStr  := B_Str + Zeile;
END;

{------------------------------------------------------------------------------
 isCall prft, ob RUBRIK ein Call oder 'ne Rubrik ist
+-----------------------------------------------------------------------------}
FUNCTION isCall (Rubrik : String ): Boolean;
const
  digit = ['0'..'9'];

var
  i      :  shortint;
  ok     :  boolean;
  count  :  shortint;
  suffix :  shortint;

begin

  ok     := false;
  suffix := 0;
  count  := length (Rubrik);
  if count in [2..7]
  then

    for i:=1 to 3 do
    begin
      if    ( Rubrik [i] in digit )
        and ( i in [2,3] )
      then ok := true
    end;

    if ok then
      if ( Rubrik [1] in digit ) and
         ( Rubrik [2] in digit )
       then ok := false;       (* keine Calls mit 2 fhrenden Ziffern *)

    if ok then
    for i:=count downto 1 do
      if     not ( Rubrik [i] in digit )
      then inc (suffix);

  if ok and ( suffix < 5 ) then
    if not ( Rubrik [count] in digit )  then
      ok := true
    else ok := false;

  isCall := ok;
end;

{-----------------------------------------------------------------------
 Sortierfunktionen
 -----------------------------------------------------------------------}
{$F+}

(* numerisch sortieren *)
function MoreCount(X, Y : DirPtr): Boolean;
begin
  MoreCount := X^.Count > Y^.Count;
end;

{$F-}

{----------------------------------------------------------------------
 QuickSort  Sortieralgorithmus
 ----------------------------------------------------------------------}
procedure QuickSort(L, R: Integer);
var
  I, J: Integer;
  X, Y: DirPtr;
  Z   : DirPtr;
begin
  I := L;
  J := R;
  X := Dir[(L + R) div 2];
  repeat
    while Less(Dir[I], X) do Inc(I);
    while Less(X, Dir[J]) do Dec(J);
    if I <= J then
    begin
      Y := Dir[I];
      Dir[I] := Dir[J];
      Dir[J] := Y;
      Inc(I);
      Dec(J);
    end;
  until I > J;
  if L < J then QuickSort(L, J);
  if I < R then QuickSort(I, R);
end;

{------------------------------------------------------------------------------
 Take_Pfad  liefert einen String mit dem kompl. Pfad zu den INFO- / USER-Files
+-----------------------------------------------------------------------------}
PROCEDURE Take_Pfad(Var UserPfad, InfoPfad, SysPfad : String);
Var  i         : Shortint;
     Zeile     : String;
     ConfigBox : Text;
BEGIN
  ASSIGN(ConfigBox,'CONFIG.BOX');
  {$I-} RESET(ConfigBox); {$I+}    (* Config.Box oeffnen um Pfad zu holen *)
  IF IOResult <> 0
   then
     begin
       writeln(Con,#13#10'Fehler beim ffnen von CONFIG.BOX');
       close(con);
       halt;
     end
   else
     begin
       For i:=1 to 36 Do Readln(ConfigBox,Zeile);
       UserPfad := Copy(Zeile,1,(i-1));
       Readln(ConfigBox,Zeile);
       InfoPfad := Copy(Zeile,1,(i-1));
       Readln(ConfigBox,Zeile);
       SysPfad  := Copy(Zeile,1,(i-1));
       CLOSE(ConfigBox);
     end;
END;

{-----------------------------------------------------------------------
 Lesen des Boxfileheaders
 -----------------------------------------------------------------------}
FUNCTION GetBoxfileInfo (BoxFile : AnyStr): ShortInt;
var
  Zeile1,
  Zeile2  : AnyStr;
  dummy   : char;
  i       : integer;
  bf      : Text;

begin
  GetBoxfileInfo := noerror;
  assign(bf,BoxFile);
  {$I-} Reset(bf); {$I+}
  if IOResult <> 0
    then GetBoxfileInfo := openerror
    else
      begin
        GetBoxfileInfo := noerror;
        Readln(bf,Zeile1);
        Readln(bf,Zeile1);
        Readln(bf,Zeile2);
(*
SP @DL           de:DF5QF  07.09.92 20:15  10   1931 Bytes
Autodo - Hilfe ?
*** Bulletin-ID: 079209DB0BQ ***
*** Received from OE9XPI ***
*)
        Absender := Copy(Zeile1,22,6);
        Filename := Copy(Zeile1,2,(Pos(' ',Zeile1)-1));
        Datum := Copy(Zeile1,29,14);
        ByteCount := Copy(Zeile1,48,6);
        titel := Copy(Zeile2,1,80);
        close(bf);
      end;
end;

{--------------
 GetDisplayCount
 --------------}
Procedure GetDisplayCount;
Var
  e: Integer;

Begin
  If ParamCount = 1 then
    Val(ParamStr(1),DisplCount,e)
  else
    DisplCount := 50;
  If DisplCount > Count then DisplCount := Count;
End;

{-------------------------
 OpenRFile oeffnet LogFile
 -------------------------}
Function OpenRFile : Byte;
Begin
  ASSIGN(RFile,'\PROTO\RLOG.BOX');
  {$I-} RESET(RFile); {$I+}
  IF IOResult <> 0
    then OpenRFile := OpenError
  else
    OpenRFile := noerror;
End;

{-------------------------------------
 ReadRFile liest Daten aus Logfile ein
 -------------------------------------}
Procedure ReadRFile;
Var
  i,z   : Word;
  Zeile : AnyStr;
  Board : String[12];
  DosFile : String[16];
  found : boolean;

Begin
  i := 0;
  While (not EOF(RFile) and (i < MaxDir)) do
    begin
      Readln(RFile,Zeile);
    
(*
 1 22.06.92 00:18 DL1MCX: IBM         1 ZBPKNL
*)
      if i = 0 then LogBegin := Copy(Zeile,4,14);
      Board := Copy(Zeile,27,9);
      Board := Copy(Board,1,Pos(' ',Board)-1);
      If (not(iscall(Board)) and (length(Board) > 1)) then
        begin
          DosFile := Board + Copy(Zeile,41,6);
          found := false;
          z := 1;
          While ((z <= i) and (not found)) do
            begin
              If Dir[z]^.DosFile = DosFile then
                begin
                  found := true;
                  inc(Dir[z]^.count);
                end;
              inc(z);
            end;
          If (not found) then
            begin
              inc(i);
              If (MaxAvail < SizeOf(DirRec))
              then
                begin
                  Writeln(Con,#13#10'Nicht gengend Speicher, Programm abgebrochen');
                  close(RFile);
                  close(con);
                  halt;
                end
              else
                begin
                  New(Dir[i]);
                  Dir[i]^.DosFile := DosFile;
                  Dir[i]^.count := 1;
                end;
            end;

          end;
    End;
    LogEnd := Copy(Zeile,4,14);
    Count := i;
    if (i = MaxDir) then
      writeln(con,#13#10'Speichermangel - Daten unvollstndig !');
  Close(RFile);
End;

{------------------------
 WriteStat gibt Liste aus
 ------------------------}
Procedure WriteStat;
Var
  i             : Word;
  Board         : String[8];
  DosFile       : String[6];
  CountStr      : String[5];
  Zeile,
  ProtfilePath,
  Outline       : AnyStr;
  found         : boolean;

Begin
  For i := 1 to DisplCount do
    begin
      found := false;
      Zeile := Dir[i]^.DosFile;
      Board := Copy(Zeile,1,length(Zeile)-6);
      ProtfilePath := InfoPfad + Board;
      DosFile := Copy(Zeile,length(Zeile)-5,6);
      returncode := GetBoxfileInfo(ProtfilePath + '\' + DosFile);
      if returncode = noerror then
      begin
        found := true;
        Str(Dir[i]^.Count,CountStr);
        Outline := ConstStr(CountStr,5,' ','r') + ' '
        + ConstStr(Board,8,' ','l') + ' < ' + Absender +  ' ' + Datum + ' ' +
        + bytecount + ' ' + Copy(titel,1,33);
        Writeln(Con,Outline);
      end;
      if(not found) then
        begin
          Outline := ConstStr(CountStr,5,' ','r') + ' '
          + ConstStr(Board,8,' ','l');
          Writeln(Con,Outline);
        end;
  end;
End;

Begin
  DirectVideo := False;
  RCount := 0;
  Less := MoreCount;
  ASSIGN(Con,'');
  REWRITE(Con);
  Write(Con,#13#10'FStat v0.3 (DL1MCX)');
  Take_Pfad(UserPfad,InfoPfad,Syspfad);
  Returncode := OpenRFile;
  if Returncode = noerror then
    begin
      ReadRFile;
      GetDisplayCount;
      Writeln(Con,' - Statistik vom ',Logbegin,' bis ',LogEnd,#13#10);
      Writeln(Con,'Count File       Call   Datum    Zeit   Bytes Titel'#13#10);
      quicksort (1,Count);
      WriteStat;
    end;
  Writeln(Con);
  Close(Con);
End.

