/* Socket status display code
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "config.h"
#include "mbuf.h"
#include "proc.h"
#ifdef LZW
#include "lzw.h"
#endif
#include "usock.h"
#include "socket.h"
#include "ax25.h"
#include "netrom.h"
#include "tcp.h"
#include "udp.h"
#include "commands.h"

/* Socket status display command */
int
dosock(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct usock *up;
	int s, i;
	struct sockaddr fsock;
	char *cp;

	if(argc < 2){
		tputs("S#  Type    PCB      Remote socket             Owner\n");
		for(s = SOCKBASE; s < Nusock + SOCKBASE; s++) {
			if((up = itop(s)) == NULLUSOCK)
				continue;

			i = sizeof(fsock);
			cp = (getpeername(s,(char *)&fsock,&i) == 0 && i != 0)
			  ? psocket(&fsock) : "";

			tprintf("%3d %-8s%-8lx %-26s%-8lx %-10s\n",
			 s,Socktypes[up->type],ptol(up->cb.p),cp,
			 ptol(up->owner),up->owner->name);
		}
		return 0;
	}
	s = atoi(argv[1]);
	if(s < SOCKBASE || s >= Nusock+SOCKBASE){
		tputs("Number out of range\n");
		return 1;
	}
	if((up = itop(s)) == NULLUSOCK){
		tputs("Socket not in use\n");
		return 0;
	}

	tprintf("%s %lx %s",
		Socktypes[up->type],
		ptol(up->cb.p),
		up->flag == SOCK_ASCII ? "ascii" : "binary");
	if(up->eol[0] != '\0'){
		tprintf(" eol seq:");
		for(i = 0; up->eol[i] != '\0' && i < sizeof(up->eol); i++)
			tprintf(" %02x",up->eol[i]);
	}
	tputs("\n");
	if(up->cb.p == NULL)
		return 0;
	switch(up->type){
	case TYPE_RAW:
	case TYPE_LOCAL_DGRAM:
		tprintf("Inqlen: %d packets\n",socklen(s,0));
		tprintf("Outqlen: %d packets\n",socklen(s,1));
		break;
	case TYPE_LOCAL_STREAM:
		tprintf("Inqlen: %d bytes\n",socklen(s,0));
		tprintf("Outqlen: %d bytes\n",socklen(s,1));
		break;
	case TYPE_TCP:
		st_tcp(up->cb.tcb);
		break;
	case TYPE_UDP:
		st_udp(up->cb.udp);
		break;
#ifdef	AX25
	case TYPE_AX25I:
		st_ax25(up->cb.ax25);
		break;
#endif
#ifdef	NETROM
	case TYPE_NETROML4:
		donrdump(up->cb.nr4);
		break;
#endif
	}
#ifdef LZW
	if(up->zout != NULLLZW)
		tprintf("Bytes compressed %ld\n",up->zout->cnt);
	if(up->zin != NULLLZW)
		tprintf("Bytes decompressed %ld\n",up->zin->cnt);
#endif
	return 0;
}

