#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "tcp.h"
#include "ip.h"
#include "trace.h"

/* Dump a TCP segment header. Assumed to be in network byte order */
void
tcp_dump(fp,bpp,source,dest,check)
FILE *fp;
struct mbuf **bpp;
int32 source,dest;	/* IP source and dest addresses */
int check;			/* 0 if checksum test is to be bypassed */
{
	struct tcp seg;
	struct pseudo_header ph;
	int16 csum, dlen;

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	/* Verify checksum */
	ph.source = source;
	ph.dest = dest;
	ph.protocol = TCP_PTCL;
	ph.length = len_p(*bpp);

	csum = (check == 1) ? cksum(&ph,*bpp,ph.length) : 0;

	ntohtcp(&seg,bpp);

	trprintf(fp,"TCP: %u->%u Seq x%lx",seg.source,seg.dest,seg.seq,seg.ack);

	if(seg.flags.ack)
		trprintf(fp," Ack x%lx",seg.ack);
	if(seg.flags.congest)
		trprintf(fp," CE");
	if(seg.flags.urg)
		trprintf(fp," URG");
	if(seg.flags.ack)
		trprintf(fp," ACK");
	if(seg.flags.psh)
		trprintf(fp," PSH");
	if(seg.flags.rst)
		trprintf(fp," RST");
	if(seg.flags.syn)
		trprintf(fp," SYN");
	if(seg.flags.fin)
		trprintf(fp," FIN");

	trprintf(fp," Wnd %u",seg.wnd);

	if(seg.flags.urg)
		trprintf(fp," UP x%x",seg.up);

	/* Print options, if any */
	if(seg.mss)
		trprintf(fp," MSS %u",seg.mss);

	if((dlen = len_p(*bpp)) > 0)
		trprintf(fp," Data %u",dlen);

	if(csum)
		trprintf(fp," CHECKSUM ERROR (%u)",csum);

	trprintf(fp,"\n");
}

