#ifndef _SESSION_H
#define _SESSION_H

#if !defined(__STDIO_DEF_) && !defined(__STDIO_H)
#  include <stdio.h>
#endif

#ifndef _GLOBAL_H
#include "global.h"
#endif

#ifndef _CONFIG_H
#include "config.h"
#endif

#ifndef _HARDWARE_H
#include "hardware.h"
#endif


#ifndef _FTPCLI_H
#include "ftpcli.h"
#endif

#ifndef _TELNET_H
#include "telnet.h"
#endif

#ifndef _ICMP_H
#include "icmp.h"
#endif

#ifndef _AX25_H
#include "ax25.h"
#endif

#ifndef _PROC_H
#include "proc.h"
#endif

#ifndef _TTY_H
#include "tty.h"
#endif

/* Session control structure; only one entry is used at a time */
typedef enum  {
   FREE        = 0, TELNET   = 1, FTP      = 2, AX25TNC  = 3,
   FINGER      = 4, PING     = 5, NRSESSION= 6, COMMAND  =7,
   MORE        = 8, HOP      = 9, TIP      =10, PPPPASS  =11,
   TRACESESSION=12, RAW      =13, HYPER    =14
}Stype;

typedef enum {
 Raw, Cooked
} Fmode;

/* Session control structure; only one entry is used at a time */
struct session {
	Stype type;
	char *name;				/* Name of remote host */
	union {
		struct ftpcli *ftp;
		struct telnet *telnet;
	} cb;
	struct proc *proc;		/* Primary session process (e.g., tn recv) */
	struct proc *proc1;		/* Secondary session process (e.g., tn xmit) */
	struct proc *proc2;		/* Tertiary session process (e.g., upload) */
	int s;					/* Primary network socket (control for FTP) */
	FILE *record;			/* Receive record file */
	char *rfile;			/* Record file name */
	FILE *upload;			/* Send file */
	char *ufile;			/* Upload file name */
	struct ttystate ttystate;
	struct screen *screen;
	int input;				/* Input socket */
	int output;				/* Output socket */
	Fmode flowmode;			/* control "more" mode */
	int row;				/* Rows remaining until "more" */
	int morewait;			/* Output driver is waiting on us */
#define PPROMPT	1
	int flag;
	int swap;
#define MAXCS		10		/* cmd line buffer */
	char Cs[MAXCS][162];
	int cont;
	int tsavex;				/* used for split-screen option */
	int tsavey;
	int bsavex;
	int bsavey;
	int split;
	int lwrap;				/* linewrap col */
};
#define	NULLSESSION	(struct session *)0

extern char *Sestypes[];
extern unsigned Nsessions;			/* Maximum number of sessions */
extern struct session *Sessions;	/* Session descriptors themselves */
extern struct session *Current;		/* Always points to current session */
extern struct session *Lastcurr;	/* Last non-command session */
extern struct session *Command;		/* Pointer to command session */
extern struct session *Trace;		/* Pointer to trace screen DK5DC */

/* In session.c: */
void 	freesession __ARGS((struct session *sp));
struct 	session *sessptr __ARGS((char *cp));
struct 	session *newsession __ARGS((char *name,int type,int split,int swap));
void 	upload __ARGS((int unused,void *sp1,void *p));

/* In pc.c: */
void 	swapscreen __ARGS((struct session *old,struct session *new));

extern int16 Lport;
#define	ALERT_EOF	1

#endif	/* _SESSION_H */
