#include "global.h"
#include "mbuf.h"
#include "arp.h"
#include "netuser.h"
#include "trace.h"

void
arp_dump(fp,bpp)
FILE *fp;
struct mbuf **bpp;
{
	struct arp arp;
	struct arp_type *at;
	char is_ip = 0, op = 0, tmp[30], buf[30];

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	if(ntoharp(&arp,bpp) == -1){
		trprintf(fp,"ARP: bad packet\n");
		return;
	}

	at = (arp.hardware < NHWTYPES) ? &Arp_type[arp.hardware] : NULLATYPE;

	/* Print hardware type in Ascii if known, numerically if not */
	trprintf(fp,"ARP: len %d hwtype %s",
		len_p(*bpp),
		smsg(Arptypes,NHWTYPES,arp.hardware));

	/* Print hardware length only if unknown type, or if it doesn't match
	 * the length in the known types table
	 */
	if(at == NULLATYPE || arp.hwalen != at->hwalen)
		trprintf(fp," hwlen %u",arp.hwalen);

	/* Check for most common case -- upper level protocol is IP */
	if(at != NULLATYPE && arp.protocol == at->iptype){
		trprintf(fp," prot IP op ");
		is_ip = 1;
	} else {
		trprintf(fp," prot 0x%x prlen %u op ",arp.protocol,arp.pralen);
	}

	buf[0] = '\0';

	switch(arp.opcode){
	case RARP_REQUEST:
		strcpy(buf,"REVERSE ");
	case ARP_REQUEST:
		strcat(buf,"REQUEST");
		break;
	case RARP_REPLY:
		strcpy(buf,"REVERSE ");
	case ARP_REPLY:
		strcat(buf,"REPLY");
		op = 1;
		break;
	default:
		sprintf(buf,"%u",arp.opcode);
		break;
	}
	trprintf(fp,"%s\n     HW: sender %s",buf,at->format(tmp,arp.shwaddr));
	if(op)
		trprintf(fp," target %s",at->format(tmp,arp.thwaddr));
	trprintf(fp,"\n");
	if(is_ip){
		trprintf(fp,"     IP: sender %s",inet_ntoa(arp.sprotaddr));
		trprintf(fp," target %s\n",inet_ntoa(arp.tprotaddr));
	}
}
