#include <stdio.h>
#include <dos.h>
#include <time.h>
#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "telnet.h"
#include "session.h"
#include "proc.h"
#include "tty.h"
#include "mailbox.h"
#include "commands.h"
#include "cmdparse.h"
#include "netuser.h"

static char Motd[85];
int Attended = 1;
static int Sttylink = -1;	/* Protoype socket for service */
static int16 Bell = 2;
static void near bell __ARGS((int16 val));

int
dobell(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setintrc(&Bell,"Bell",argc,argv,0,10);
}

/* if flag is set - restrict ax25, telnet and maybe other sessions */
int
doattended(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setbool(&Attended,"Attended",argc,argv);
}

int
domotd(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int i;

	if(argc < 2 && Motd[0] != '\0') {
		tputs(Motd);
		return 0;
	}
	Motd[0] = '\0';

	for(i = 1; i < argc; i++) {
		strcat(Motd,argv[i]);
		if(strlen(Motd) > 80)
			break;
		strcat(Motd," ");
	}
	if(strlen(Motd) > 2)
		strcat(Motd,"\n\0");
	else
		Motd[0] = '\0';
	return 0;
}

static void near
bell(int16 val)
{
	while(val-- > 0) {
		sound(320);
		delay(160);
		sound(480);
		delay(160);
		sound(640);
		delay(160);
		nosound();
		pwait(NULL);
	}
}

int
ttylstart(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in lsocket;
	int s, type;

	if(Sttylink != -1){
		return 0;
	}
	psignal(Curproc,0);	/* Don't keep the parser waiting */
	chname(Curproc,"TTYlink listener");

	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
	lsocket.sin_port = (argc < 2) ? IPPORT_TTYLINK : atoi(argv[1]);

	Sttylink = socket(AF_INET,SOCK_STREAM,0);
	bind(Sttylink,(char *)&lsocket,sizeof(lsocket));
	listen(Sttylink,1);
	for(;;){
		if((s = accept(Sttylink,NULLCHAR,(int *)NULL)) == -1)
			break;	/* Service is shutting down */

		if(availmem() < Memthresh){
			usputs(s,Nospace);
			shutdown(s,1);
		} else {
			type = TELNET;
			newproc("chat",1536,ttylhandle,s,(void *)&type,NULL,0);
		}
	}
	return 0;
}

/* This function handles all incoming "chat" sessions, be they TCP,
 * NET/ROM or AX.25
 */
static void
ttylhandle(s,t,p)
int s;
void *t;
void *p;
{
	struct session *sp;
	char addr[MAXSOCKSIZE];
	struct telnet tn;
	char *cp, *cp1;
	int len = MAXSOCKSIZE, type = *(int *)t;

	sockmode(s,SOCK_ASCII);
	sockowner(s,Curproc);	/* We own it now */

	/* Allocate a session descriptor */
	if((sp = newsession(NULLCHAR,type,1,0)) == NULLSESSION){
		usprintf(s,Nosess);
		close_s(s);
		return;
	}

	log(s,"%4.4s open",Sestypes[type]);

	/* Initialize a Telnet protocol descriptor */
	memset((char *)&tn,0,sizeof(tn));

	tn.session = sp;			/* Upward pointer */
	sp->cb.telnet = &tn;		/* Downward pointer */
	sp->s = s;
	sp->proc = Curproc;

	getpeername(sp->s,addr,&len);
	cp1 = strxdup(psocket(addr));

	if((cp = strchr(cp1,':')) != NULLCHAR)
		*cp = '\0';

	tprintf("Incoming %s session from %s at %s",
		Sestypes[type],cp1,ctime(&currtime));

	if(strcmp(cp1,inet_ntoa(Ip_addr)) == 0) {
		xfree(cp1);
		sp->name = strxdup("Chat");
	} else {
		sp->name = cp1;
	}

	if(Attended && Bell)
		bell(Bell);

	if(Motd != NULLCHAR)
		usputs(s,Motd);

	usprintf(s,"\n%s - I'm %s...\n",Hostname,
		Attended ? "here" : "absent. Pse leave msg");

	tnrecv(&tn);
}

/* Shut down Ttylink server */
int
ttyl0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	close_s(Sttylink);
	Sttylink = -1;
	return 0;
}
