/* the structures used for forwarding statistics */

struct fwd_data	{

	char 	*name;			/* BBS name - from forward.bbs */
	struct fwd_data *next;		/* next in linked list */

	/* these are each 2 element arrays, [0] is incoming, [1] is outgoing */
	long	messages[2];		/* total cumulative messages */

	/* these are for daily and weekly stats - 2 element arrays, as before */
	long	hourly[24][2];		/* hourly messages */
	long	daily[7][2];		/* daily messages */
	long	monthly[31][2];		/* day/month messages */
	long	yearly[12][2];		/* month/year messages */

	/* these are the current hour and day - not updated till period is complete */
	long	hour[2];		/* current hour's messages */
	long	day[2];			/* current day's messages */
	long	month[2];		/* current year's messages */
};


struct fwd_stats	{
	long	days;			/* days that stats are valid for */

	/* last stats start time */
	time_t	start;

	/* last update time */
	time_t	last;

	/* the count of forwarding records */
	short   count;

	/* the individual BBS's data records are stored in a linked list */
	struct fwd_data *head;
};



