#include "global.h"
#include "cmdparse.h"
#include "netuser.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: security.c,v 1.17 1997/02/01 16:56:31 root Exp root $";
#endif

#ifdef TIPMAIL
int32 Mbtipperms = 0;		/* disabled */
#endif
int32 Mbax25perms = 0;		/* disabled */
int32 MbAmprPerms = 0;		/* disabled */
int32 MbNonAmprPerms = 0;	/* disabled */
#ifdef HTTPPBBS
int32 MbHttpPerms = 0;		/* disabled */
#endif
int MBSecure = 0;
int AMPRonly = 0;
uint32 NonSecureAmpr;

extern void usercvt (void);
int dosecurity (int argc,char *argv[],void *p);
#ifdef UNIX
static int doaccessgid (int argc,char *argv[],void *p);
static int doaccessuid (int argc,char *argv[],void *p);
static int docreategid (int argc,char *argv[],void *p);
static int docreateuid (int argc,char *argv[],void *p);
static int docreateperms (int argc,char *argv[],void *p);
static int docreatesecure (int argc,char *argv[],void *p);
long ACCESSgid, ACCESSuid;
long CREATEgid, CREATEuid;
unsigned short CREATEmask;	/*lint !e15 */
int CREATEsecure = 0;
#endif
static int dononsecureampr (int argc,char *argv[],void *p);
static int dononamprsecurity (int argc,char *argv[],void *p);
static int doamprsecurity (int argc,char *argv[],void *p);
static int doax25security (int argc,char *argv[],void *p);
#ifdef HTTPPBBS
static int dohttpsecurity (int argc,char *argv[],void *p);
#endif
#if defined(TIPMAIL) && defined (ALLSERV)
static int dotipsecurity (int argc,char *argv[],void *p);
#endif
static int doampronly (int argc,char *argv[],void *p);
static int dombsecure (int argc,char *argv[],void *p);
int doencode (int argc,char *argv[],void *p);
static int dolevel (int argc,char *argv[],void *p);
static void displaylevel (int theindex);
char *getsecurity (char *name, int32 *perms);


/* security subcommand table */
static struct cmds SECtab[] = {
#ifdef UNIX
	{ "accessgid",		doaccessgid,		0, 0, NULLCHAR },
	{ "accessuid",		doaccessuid,		0, 0, NULLCHAR },
#endif
	{ "ampronly",		doampronly,		0, 0, NULLCHAR },
	{ "amprperms",		doamprsecurity,		0, 0, NULLCHAR },
	{ "ax25perms",		doax25security,		0, 0, NULLCHAR },
#ifdef UNIX
	{ "creategid",		docreategid,		0, 0, NULLCHAR },
	{ "createperms",	docreateperms,		0, 0, NULLCHAR },
	{ "createsecure",	docreatesecure,		0, 0, NULLCHAR },
	{ "createuid",		docreateuid,		0, 0, NULLCHAR },
#endif
	{ "encode",		doencode,		0, 0, NULLCHAR },
#ifdef HTTPPBBS
	{ "httpperms",		dohttpsecurity,		0, 0, NULLCHAR },
#endif
	{ "level",		dolevel,		0, 0, NULLCHAR },
	{ "mbsecure",		dombsecure,		0, 0, NULLCHAR },
	{ "nonamprperms",	dononamprsecurity,	0, 0, NULLCHAR },
	{ "nonsecureampr",	dononsecureampr,	0, 0, NULLCHAR },
#if defined(TIPMAIL) && defined (ALLSERV)
	{ "tipperms",		dotipsecurity,		0, 0, NULLCHAR },
#endif
	{ NULLCHAR,		NULL,			0, 0, NULLCHAR }
};

struct securitylevel {
	char *name;
	char *path;
	int32 perms;
};

#define MAXLEVELS 10

static struct securitylevel seclevel[MAXLEVELS];


static void
displaylevel (int theindex)
{
	tprintf ("%-20.20s %-32.32s 0x%08lx\n", seclevel[theindex].name, seclevel[theindex].path, seclevel[theindex].perms);
}


char *
getsecurity (char *name, int32 *perms)
{
int k;

	for (k = 0; k < MAXLEVELS; k++)	{
		if (seclevel[k].name)
			if (!stricmp (name, seclevel[k].name))	{
				*perms = seclevel[k].perms;
				return (seclevel[k].path);
			}
	}
	return (NULLCHAR);
}


static int
dolevel(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
int k;

	if (argc == 1)	{
		tprintf("%-20.20s %-32.32s %s\n", "Security level", "Directory paths", "Permissions");
		for (k = 0; k < MAXLEVELS; k++)	{
			if (seclevel[k].name != NULLCHAR)
				displaylevel (k);
		}
		return 0;
	}
	if (argc < 4)	{
		tputs ("syntax: security level levelname pathstring permissions\n");
		return 0;
	}
	for (k = 0; k < MAXLEVELS; k++)	{
		if ((seclevel[k].name == NULLCHAR) || !stricmp(seclevel[k].name, argv[1]))
			break;
	}
	if (k == MAXLEVELS)	{
		tprintf ("Can't add another security level. Already have the maximum of %d!\n", MAXLEVELS);
		return 0;
	}
	if (seclevel[k].name == NULLCHAR)
		seclevel[k].name = strdup(argv[1]);
	if (seclevel[k].path != NULLCHAR)
		free (seclevel[k].path);
	seclevel[k].path = strdup(argv[2]);
	seclevel[k].perms = (!strnicmp (argv[3], "0x", 2)) ? htol(argv[3]) : atol(argv[3]);
/*	displaylevel(k);	*/
	return 0;	
}

static int
dononsecureampr(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
uint32 n;

	if(argc < 2)
		tprintf("%s\n",inet_ntoa(NonSecureAmpr));
	else if((n = resolve(argv[1])) == 0)	{
		tprintf(Badhost,argv[1]);
		return 1;
	} else
		NonSecureAmpr = n;
	return 0;
}

int
doencode(argc,argv,p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	usercvt();
	tputs("Password encoding complete!\n");
	return 0;
}

static int
dombsecure(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setbool(&MBSecure,"Mailbox gateway RF secure flag",argc,argv);
}

static int
doampronly(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setbool(&AMPRonly,"Mailbox gateway non-AMPR secure flag",argc,argv);
}

#if defined(TIPMAIL) && defined(ALLSERV)
static int
dotipsecurity(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&Mbtipperms,"Tip security permission (for anonymous)",argc,argv);
}
#endif


#ifdef HTTPPBBS
static int
dohttpsecurity(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&MbHttpPerms,"HTTP security permission (for anonymous)",argc,argv);
}
#endif


static int
doax25security(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&Mbax25perms,"AX25 security permission (for anonymous)",argc,argv);
}

static int
doamprsecurity(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&MbAmprPerms,"AMPR telnet security permission (for anonymous)",argc,argv);
}

static int
dononamprsecurity(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&MbNonAmprPerms,"Non-AMPR telnet security permission (for anonymous)",argc,argv);
}

#ifdef UNIX

static int
doaccessgid(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&ACCESSgid,"Non-sysop file access group ID",argc,argv);
}

static int
doaccessuid(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&ACCESSuid,"Non-sysop file access user ID",argc,argv);
}

static int
docreategid(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&CREATEgid,"File creation group ID",argc,argv);
}

static int
docreateuid(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setlong(&CREATEuid,"File creation user ID",argc,argv);
}



static int
docreateperms(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setshort(&CREATEmask,"File create permissions",argc,argv);
}

static int
docreatesecure(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return setbool(&CREATEsecure,"File creation security",argc,argv);
}

#endif


int
dosecurity(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(SECtab,argc,argv,p);
}


