#include "global.h"
#include <time.h>
#include "mbuf.h"
#include "trace.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: rwhodump.c,v 1.10 1996/12/23 20:37:36 root Exp root $";
#endif

struct outmp {
	char out_line[9];   /* tty name */
	char out_name[9];   /* user id */
	time_t out_time; /* time on */
};


struct whod {
	char wd_vers;
	char wd_type;
	char wd_fill[2];
	time_t  wd_sendtime;
	time_t  wd_recvtime;
	char wd_hostname[33];
	int32  wd_loadav[3];
	time_t  wd_boottime;
	struct    whoent {
		struct    outmp we_utmp;
		int32  we_idle;
        } wd_we[1024 / sizeof (struct whoent)];
};



static int ntohrwhod (struct whod *wp,struct mbuf **bpp);
void rwho_dump (FILE *fp,struct mbuf **bpp);

void
rwho_dump(fp,bpp)
FILE *fp;
struct mbuf **bpp;
{
	int i;
	int32 t;
	char *cp;
	struct whod rwhod;
	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;
	traceprintf(fp,"RWHO: ");
	if(ntohrwhod(&rwhod,bpp) == -1) {
		traceprintf(fp,"bad data\n");
		return;
	}
	if(rwhod.wd_vers != 1)
		traceprintf(fp,"version %d  ",rwhod.wd_vers);
	if(rwhod.wd_type != 1)
        	traceprintf(fp,"type %d  ",rwhod.wd_type);
	cp = ctime(&rwhod.wd_sendtime);
	cp[24] = '\0';
	traceprintf(fp,"send %s  ",cp);
	t = (int32) rwhod.wd_recvtime;
	if(t / 86400)
		traceprintf(fp,"%ld:",t/86400);
	t %= 86400;
	traceprintf(fp,"recv %02ld:%02ld\n",t / 3600,(t % 3600)/60);
	traceprintf(fp,"      host %s  loadvg %ld %ld %ld  ",rwhod.wd_hostname,
		rwhod.wd_loadav[0],rwhod.wd_loadav[1],
		rwhod.wd_loadav[2]);
		traceprintf(fp,"boot %s",ctime(&rwhod.wd_boottime));
	i = 0;
	while(rwhod.wd_we[i].we_utmp.out_line[0] != '\0') {
		traceprintf(fp,"      %-12s%-12s",rwhod.wd_we[i].we_utmp.out_name,
		rwhod.wd_we[i].we_utmp.out_line);
		t = rwhod.wd_we[i].we_idle;
		if(t / 86400)
			traceprintf(fp,"%ld:",t/86400);
		else
			traceprintf(fp,"  ");
		t %= 86400;
		traceprintf(fp,"%02ld:%02ld    ",t / 3600, (t % 3600)/60);    
		traceprintf(fp,"%s",ctime(&rwhod.wd_we[i].we_utmp.out_time));
		++i;
	}
}
static int
ntohrwhod(wp,bpp)
struct whod *wp;
struct mbuf **bpp;
{
	int i;
	char wbuf[60];
	if(pullup(bpp, (unsigned char *) wbuf,60) != 60)
		return -1;
	wp->wd_vers = wbuf[0];
	wp->wd_type = wbuf[1];
	wp->wd_fill[0] = wbuf[2];
	wp->wd_fill[1] = wbuf[3];
	wp->wd_sendtime = (time_t) get32(&wbuf[4]);
	wp->wd_recvtime = (time_t) get32(&wbuf[8]);
	memcpy(wp->wd_hostname,&wbuf[12],32);
	wp->wd_hostname[32] = '\0';
	wp->wd_loadav[0] = (int32) get32(&wbuf[44]);
	wp->wd_loadav[1] = (int32) get32(&wbuf[48]);
	wp->wd_loadav[2] = (int32) get32(&wbuf[52]);
	wp->wd_boottime = (time_t) get32(&wbuf[56]);
	for(i = 0; i < 39; ++i) {
		if(pullup(bpp,(unsigned char *) wbuf,24) != 24) {
			wp->wd_we[i].we_utmp.out_line[0] = '\0';
			return 0;
		}
		memcpy(wp->wd_we[i].we_utmp.out_line,wbuf,8);
		wp->wd_we[i].we_utmp.out_line[8] = '\0';
		memcpy(wp->wd_we[i].we_utmp.out_name,&wbuf[8],8);
		wp->wd_we[i].we_utmp.out_name[8] = '\0';
		wp->wd_we[i].we_utmp.out_time = (time_t) get32(&wbuf[16]);
		wp->wd_we[i].we_idle = (long) get32(&wbuf[20]);
	}
	return 0;
}
