#include "global.h"
#if defined(REJECT) || defined(TEST)
#include "ctype.h"
#ifndef TEST
#include "commands.h"
#include "proc.h"
#endif
#include "reject.h"
#include "files.h"

#if !defined(_lint)
static char _rcsid[] OPTIONAL = "$Id: reject.c,v 1.12 1997/08/19 01:19:22 root Exp root $";
#endif

#ifdef TEST
void kwait (void *v)
{
}

void
rip(s)
register char *s;
{
	register char *cp;

	while((cp = strchr(s,'\n')) != NULLCHAR || (cp = strchr(s,'\r')) != NULLCHAR)
		*cp = '\0';
}

#else
extern int MbReject;
#endif


/* using the following format for REJECT.DAT
 *
 *  action is one of 'R'eject, 'H'old, or 'L'ocal hold
 *       type from to  @bbs bid      max_size    action
 *       B    *    *   *    *_AZGATE 0           R
 */
        
int
reject (cmdstr, rmtuser, xfwd)
const char *cmdstr;
int rmtuser;
int xfwd;
{
register FILE *fp;
char buf[80];
char cmdbuf[80];
const char *cmd[5];
int cmdsize, datsize;
int retval = REJ_NO;
int k;
char *cp, *usestr;
int complex;


#ifndef TEST
	if (!MbReject)
		return (retval);
#if 0
	tcmdprintf ("Reject checking enabled: '%s' (%d)!\n", cmdstr, rmtuser);
#endif
#endif
	if ((fp = fopen (REJECTFile, READ_TEXT)) == NULLFILE)
		return (retval);
	strncpy (cmdbuf, cmdstr, 80);
	cmd[0] = cmd[1] = cmd[2] = cmd[3] = cmd[4] = "*";
	cmdsize = -1;
	if (xfwd)	/* can only get bid from XFWD type */
		cmd[4] = cmdbuf;
	else {
		switch (*cmdbuf)	{
			case 'S':
			case 's':
				/* can get all but cmdsize, though bid and from are optional */
				cp = strtok (cmdbuf," \t");
				if (!cp)
					return (retval);
				cp++;
				if (*cp)	{
					*cp = (char) toupper(*cp);
					cmd[0] = cp;				/* store type */
				} else
					cmd[0] = "P";
				cmd[2] = strtok (NULLCHAR," \t");	/* store to */
				if (cmd[2] == NULLCHAR)
					return REJ_NO;
				if ((cp = strchr (cmd[2], '@')) != NULLCHAR)	{
					*cp++ = 0;
					cmd[3] = cp;
				}
				cp = strtok (NULLCHAR," \t");
				if (cp && *cp == '@')	{
					cmd[3] = strtok (NULLCHAR," \t");
					if (cmd[3] == NULLCHAR)
						cmd[3] = cp + 1;
					cp = strtok (NULLCHAR," \t");
				}
				if (cp && *cp == '<')	{
					if (cp[1])	{
						cmd[1] = &cp[1];
					} else
						cmd[1] = strtok (NULLCHAR," \t");
					cp = strtok (NULLCHAR," \t");
				}
				if (cp && *cp == '$')	{
					if (cp[1])	{
						cmd[4] = &cp[1];
					} else
						cmd[4] = strtok (NULLCHAR," \t");
				}
				break;
			case 'F':
			case 'f':
				/* can get all parameters */
				cp = strtok (cmdbuf," \t");		/* eat this one */
				cmd[0] = strtok (NULLCHAR," \t");	/* store type */
				cmd[1] = strtok (NULLCHAR," \t");	/* store from */
				cmd[3] = strtok (NULLCHAR," \t");	/* store bbs */
				cmd[2] = strtok (NULLCHAR," \t");	/* store to */
				cmd[4] = strtok (NULLCHAR," \t");	/* store bid */
				cp = strtok (NULLCHAR," \t");		/* get size */
				cmdsize = (cp) ? atoi(cp): 0;		/* store size */
				break;
			default:
				break;
		}
	}	
	while (fgets (buf, sizeof (buf), fp) != NULLCHAR) {
		kwait (NULL);
		if(*buf == '#')		/* skip commented lines */
			continue;
		rip (buf);
		if (!*buf)
			continue;	/* skip blank lines */

		usestr = buf;
		complex = 0;
		for (k = 0; k < 5; k++)	{
			if((cp = strtok (usestr," \t")) == NULLCHAR) /* get the this token */
				break;
			usestr = NULLCHAR;

			if (xfwd && k != 4)	/* xfwd'ing only has the bid */
				continue;
			/* if source is not "match all" (partial info), then check it */
			if (strcmp (cmd[k], "*"))	{
				/* okay, if this is xfwd'ing (only a bid to check)
				 * and the bid pattern is "*",
				 * then we have NOT matched
				 */
				if (xfwd && !strcmp(cp, "*"))
					break;
				if (!wildmat (cmd[k], cp, NULLCHARP))
					break;		/* no match */
			} else {	/* matching w/ partial info */
				/* if entry's pattern not "*", skip */
				if (strcmp (cp, "*"))
					break;		/* no match */
			}
			if (k && strcmp (cp, "*"))
				complex = 1;
		}
		if (k != 5)
			continue;

		if((cp = strtok (NULLCHAR," \t")) == NULLCHAR) /* get the sixth token */
			continue;

		if (cmdsize == -1)	{
			if (!complex)
				continue;
		} else {
			datsize = atoi (cp);
			if (datsize > cmdsize)
				continue;		/* size okay */
		}

		if((cp = strtok (NULLCHAR," \t")) == NULLCHAR) /* get the seventh token */
			continue;

		switch (*cp)	{
			case 'A':	retval = REJ_ACCEPT;
					break;
			case 'R':	retval = REJ_REJECT;
					break;
			case 'H':	retval = REJ_HOLD;
					break;
			case 'L':	retval = REJ_LOCALHOLD;
					break;
			case 'D':	retval = REJ_DEFER;
					break;
			default:	/* leave return = REJ_NO */
					break;
		}
		if (rmtuser && retval == REJ_LOCALHOLD)
			continue;
		break;
	}
	(void) fclose (fp);
#if 0
	tcmdprintf ("reject returned: %d\n", retval);
#endif
	return (retval);
}


#ifdef  TEST
extern char *gets();

main()
{
char pattern[80];
char text[80];
    
	for ( ; ; )	{
		printf ("Enter SEND string:  ");
		if (gets(pattern) == NULL)
			break;
		if(text[0] == '\0')
			/* Blank line; go back and get a new pattern. */
			break;
		printf("\nReject value: %d\n", reject (pattern));
	}
	exit(0);
}

#undef TEST
#define mallocw malloc
#define strncmp strcasecmp

#include "wildmat.c"

#endif  /* TEST */

#endif	/* REJECT || TEST */
