#include "global.h"
#ifdef POOLED
#include "pool.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: pool.c,v 1.6 1996/08/29 12:11:16 root Exp root $";
#endif

void *pool_alloc (struct mempool *pool)
{
struct mempoolblock *tmp = NULLPOOLBLK;

	if (!pool->top || (pool->index == pool->bottom->entries))	{
		tmp = (struct mempoolblock *) callocw (1, ((pool->numentries * pool->size) + sizeof(struct mempoolblock)));	/*lint !e737 */
		if (pool->top)	{
			pool->bottom->next = tmp;
			pool->bottom = tmp;
		} else
			pool->top = pool->bottom = tmp;
		pool->index = 0;
		pool->bottom->entries = pool->numentries;
		pool->bottom->base = (char *)(((long)pool->bottom) + sizeof(struct mempoolblock));	/*lint !e737 */
	}
	return ((void *)&pool->bottom->base[pool->index++ * pool->size]);
}


void pool_free (struct mempool *pool)
{
struct mempoolblock *temp, *blk;

	for (blk = pool->top; blk; blk = temp)	{
		temp = blk->next;
		free(blk);
	}
	pool->top = pool->bottom = NULLPOOLBLK;
	pool->index = 0;
}
			
#endif /* POOLED */
