/* NET/ROM header tracing routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "mbuf.h"
#include "netrom.h"
#include "trace.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: nrdump.c,v 1.8 1996/08/29 12:11:16 root Exp root $";
#endif


/* Display NET/ROM network and transport headers */
void
netrom_dump (FILE *fp, struct mbuf **bpp, int check)
{
char src[AXALEN], dest[AXALEN];
char tmp[AXBUF];
char thdr[NR4MINHDR];
register i;

	if (bpp == NULLBUFP || *bpp == NULLBUF)
		return;
	/* See if it is a routing broadcast */
	if (uchar (*(*bpp)->data) == NR3NODESIG) {
		(void) PULLCHAR (bpp);	/* Signature */
		(void) pullup (bpp, (unsigned char *) tmp, ALEN);
		tmp[ALEN] = '\0';
		traceprintf (fp, "NET/ROM Routing: %s\n", tmp);
		for (i = 0; i < NRDESTPERPACK; i++) {
			if (pullup (bpp, (unsigned char *) src, AXALEN) < AXALEN)
				break;
			traceprintf (fp, "        %12s", pax25 (tmp, src));
			(void) pullup (bpp, (unsigned char *) tmp, ALEN);
			tmp[ALEN] = '\0';
			traceprintf (fp, "%8s", tmp);
			(void) pullup (bpp, (unsigned char *) src, AXALEN);
			traceprintf (fp, "    %12s", pax25 (tmp, src));
			tmp[0] = (char) PULLCHAR (bpp);
			traceprintf (fp, "    %3u\n", uchar (tmp[0]));
		}
		return;
	}
	/* See if it is a routing poll - WG7J */
	if (uchar (*(*bpp)->data) == NR3POLLSIG) {
		(void) PULLCHAR (bpp);	/* Signature */
		(void) pullup (bpp, (unsigned char *) tmp, ALEN);
		tmp[ALEN] = '\0';
		traceprintf (fp, "NET/ROM Poll: %s\n", tmp);
		return;
	}
	/* Decode network layer */
	(void) pullup (bpp, (unsigned char *) src, AXALEN);
	traceprintf (fp, "NET/ROM: %s", pax25 (tmp, src));

	(void) pullup (bpp, (unsigned char *) dest, AXALEN);
	traceprintf (fp, "->%s", pax25 (tmp, dest));

	i = PULLCHAR (bpp);
	traceprintf (fp, " ttl %d\n", i);

	/* Read first five bytes of "transport" header */
	(void) pullup (bpp, (unsigned char *) thdr, NR4MINHDR);
	switch (thdr[4] & NR4OPCODE) {
		case NR4OPPID:	/* network PID extension */
			if (thdr[0] == NRPROTO_IP && thdr[1] == NRPROTO_IP) {
				ip_dump (fp, bpp, check);
				return;
			} else
				traceprintf (fp, "         protocol family %x, proto %x",
					  uchar (thdr[0]), uchar (thdr[1]));
			break;
		case NR4OPCONRQ:	/* Connect request */
			traceprintf (fp, "         conn rqst: ckt %d/%d", uchar (thdr[0]), uchar (thdr[1]));
			i = PULLCHAR (bpp);
			traceprintf (fp, " wnd %d", i);
			(void) pullup (bpp, (unsigned char *) src, AXALEN);
			traceprintf (fp, " %s", pax25 (tmp, src));
			(void) pullup (bpp, (unsigned char *) dest, AXALEN);
			traceprintf (fp, "@%s", pax25 (tmp, dest));
			break;
		case NR4OPCONAK:	/* Connect acknowledgement */
			traceprintf (fp, "         conn ack: ur ckt %d/%d my ckt %d/%d",
			  uchar (thdr[0]), uchar (thdr[1]), uchar (thdr[2]),
				     uchar (thdr[3]));
			i = PULLCHAR (bpp);
			traceprintf (fp, " wnd %d", i);
			break;
		case NR4OPDISRQ:	/* Disconnect request */
			traceprintf (fp, "         disc: ckt %d/%d",
				     uchar (thdr[0]), uchar (thdr[1]));
			break;
		case NR4OPDISAK:	/* Disconnect acknowledgement */
			traceprintf (fp, "         disc ack: ckt %d/%d",
				     uchar (thdr[0]), uchar (thdr[1]));
			break;
		case NR4OPINFO:/* Information (data) */
			traceprintf (fp, "         info: ckt %d/%d",
				     uchar (thdr[0]), uchar (thdr[1]));
			traceprintf (fp, " txseq %d rxseq %d",
				     uchar (thdr[2]), uchar (thdr[3]));
			break;
		case NR4OPACK:	/* Information acknowledgement */
			traceprintf (fp, "         info ack: ckt %d/%d",
				     uchar (thdr[0]), uchar (thdr[1]));
			traceprintf (fp, " txseq %d rxseq %d",
				     uchar (thdr[2]), uchar (thdr[3]));
			break;
		default:
			traceprintf (fp, "         unknown transport type %d",
				     thdr[4] & 0x0f);
			break;
	}
	if (thdr[4] & NR4CHOKE)
		traceprintf (fp, " CHOKE");
	if (thdr[4] & NR4NAK)
		traceprintf (fp, " NAK");
	if (thdr[4] & NR4MORE)
		traceprintf (fp, " MORE");
	traceprintf (fp, "\n");
}
