#ifndef	_PC_H
#define	_PC_H
#define _HARDWARE_H

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef _SESSION_H
#include "session.h"
#endif

#ifndef _SOCKET_H
#include "socket.h"
#endif

#if !defined(_TIME_H) && !defined(__dj_include_time_h_)
#include <time.h>
#endif

#if !defined(_IO_H) && !defined(__dj_include_io_h_)
#include <io.h>
#endif

#if !defined(_DOS_H) && !defined(__dj_include_dos_h_)
#include <dos.h>
#endif

/* Extended keyboard codes for function keys */
#define	F1	59	/* Function key 1 */
#define	F2	60
#define	F3	61
#define	F4	62
#define	F5	63
#define	F6	64
#define	F7	65
#define	F8	66
#define	F9	67
#define	F10	68

#define	CURSHOM	71	/* Home key */
#define	CURSUP	72	/* Up arrow key */
#define	PAGEUP	73	/* Page up key */
#define	CURSLEFT 75	/* Cursor left key */
#define CURSRIGHT 77	/* Cursor right key */	
#define	CURSEND	79	/* END key */
#define	CURSDWN	80	/* Down arrow key */
#define	PAGEDWN	81	/* Page down key */

#define	AF1	104	/* ALT-F1 */
#define	AF2	105
#define	AF3	106
#define	AF4	107
#define	AF5	108
#define	AF6	109
#define	AF7	110
#define	AF8	111
#define	AF9	112
#define	AF10	113
#define	AF11	139
#define	AF12	140

struct stopwatch {
	long calls;
	int16 maxval;
	int16 minval;
};
struct screen {
#ifndef TNOS_68K
	char *save;		/* Screen save buffer */
	int row;		/* Saved cursor location */
	int col;
#else
	WINDOW *win;		/* active WINDOW */
	WINDOW *textwin;	/* text area WINDOW */
	WINDOW *splitwin;	/* split screen input WINDOW */
	WINDOW *statwin;	/* status area WINDOW */
#endif
	unsigned char attr;
	unsigned char statline;
};
#define	NULLSCREEN	(struct screen *)0

extern void (*Shutdown[])(void);	/* List of functions to call at shutdown */

#if !defined(_ERRNO_H) && !defined(__dj_include_errno_h_)
extern int errno;
extern char * sys_errlist[];
#endif

extern long dostounix (struct date *, struct time *);
#if !defined(_SYS_STAT_H) && !defined(__dj_include_sys_stat_h_)
extern int mkdir (const char *pathname, mode_t mode);
#endif
#include <unistd.h>
#if 0
extern off_t lseek (int, off_t, int);
extern int unlink (const char *);
extern int rmdir (const char *);
extern int access (const char *, int);
extern int close (int);
extern char *getcwd (char *, size_t);
#endif

/* In 8250.c: */
void asytimer (void);

/* In pc.c: */
int freevect(uint irq);
int setvect(uint irq, int chain, void (*func)(int),int arg);
void freescreen (struct session *sp);
int getmask (unsigned irq);
void ioinit (int hinit);
void setbit (uint port,uint8 bits);
void clrbit (uint port,uint8 bits);
void writebit (uint port,uint8 mask,int val);
void iostop (void);
void kbint (void);
int kbread (void);
int maskoff (unsigned irq);
int maskon (unsigned irq);
void newscreen (struct session *sp);
void pctick (void);
void sysreset (void);

/* In pcgen.asm: */
void giveup (void);
int kbraw (void);
void uchtimer (void);


#define LOCK_FUNCTION(x) { void x##_end(void); (void) _go32_dpmi_lock_code(x, (long)x##_end - (long) x);}
#define LOCK_VARIABLE(x) (void) _go32_dpmi_lock_data((void *)&x, sizeof(x))
#define LOCK_ARRAY(x) (void) _go32_dpmi_lock_data((void *)x, sizeof(x))
#define END_OF_FUNCTION(x) void x##_end(void) {}

#endif	/* _PC_H */
