#!/usr/local/bin/tclsh

set NOSDIR "/nos"

set RELEASE "2.30"
set TAB1 16
set TAB2 8
set SOUNDS n

proc getdir {} {
	global AUTOMATIC NOSDIR
	if {$AUTOMATIC != 1} {
		set prompt "Use default installation directory of $NOSDIR (Y/n) ?"
		if {[info tclversion] > "7.4"} {
			puts "$prompt"
		} else {
			puts -nonewline "$prompt"
		}
		set ans [gets stdin]
		if {$ans != "y" && $ans != ""} {
			puts "Enter new installation base directory:"
			set NOSDIR [gets stdin]
		}
	}
}
proc setbool {description flag value} {
	puts "* $description ($flag) $value"
	bool2 "$description" "$flag" "$value"
}
proc bool2 {description command value} {
	global fdh
	puts $fdh "# $description"
	if {$value == "n"} {
		puts -nonewline $fdh "# "
	}
	puts $fdh "$command"
}

proc bool {description command {default "y"}} {
	global fdh ans
	set choices "Y/n"
	if {$default != "y"} {
		set choices "y/N"
	}
	set done 0
	while {$done == 0} {
		readln "$description \[$choices] " "$default"
		set ans [string tolower $ans]
		if {$ans == "y" || $ans == "n"} {
			set done 1
		} else	{
			puts ">> Enter either 'y' or 'n'....."
		}
	}
	bool2 "$description" "$command" "$ans"
}

proc boollocal {description command {default "y"}} {
	global ans
	set choices "Y/n"
	if {$default != "y"} {
		set choices "y/N"
	}
	set done 0
	while {$done == 0} {
		readln "$description \[$choices] " "$default"
		set ans [string tolower $ans]
		if {$ans == "y" || $ans == "n"} {
			set done 1
		} else	{
			puts ">> Enter either 'y' or 'n'....."
		}
	}
}

proc comment {description} {
	global fdh
	# output to screen
	puts "\n*\n* $description\n*"
	puts $fdh "\n#\n# $description\n#"
}

proc commentstart {description} {
	global fdh
	# output to screen
	puts "\n*\n* $description"
	puts $fdh "\n#\n# $description"
}

proc commentlocal {description} {
	# output to screen
	puts "* $description"
}

proc commentmiddle {description} {
	global fdh
	# output to screen
	puts "* $description"
	puts $fdh "# $description"
}

proc commentend {description} {
	global fdh
	# output to screen
	puts "* $description\n*"
	puts $fdh "# $description\n#"
}

proc readln {prompt {default ""}} {
	global ans AUTOMATIC
	if {[info tclversion] > "7.4"} {
		puts "$prompt"
	} else {
		puts -nonewline "$prompt"
	}
	if {$AUTOMATIC == 0} {
		set ans [gets stdin]
		if {$ans == ""} {
			set ans $default
		}
	} else {
		set ans $default
		puts "$ans"
	}
}

proc setlabel {description flag value} {
	global fdh
	if {$description != ""} {
		puts "* $description ($flag) $value"
		puts $fdh "# $description"
	}
	puts $fdh "$flag $value"
}

proc label {description flag {default ""}} {
	global fdh ans
	set prompt "$description ($flag) "
	if {$default != ""} {
		set prompt "${prompt} \[$default] "
	}
	readln "$prompt" "$default"
	puts $fdh "# $description"
	if {$ans == ""} {
		puts -nonewline $fdh "#"
	}
	puts $fdh "$flag $ans"
}


proc labellocal {description flag {default ""}} {
	global ans
	set prompt "$description ($flag) "
	if {$default != ""} {
		set prompt "${prompt} \[$default] "
	}
	readln "$prompt" "$default"
}

set AUTOEXEC autoexec.tst
set CONFIG_IN setup.in

#
# Open the output files
#
set fdh [open $AUTOEXEC w]
puts $fdh "#\n# Automatically generated autoexec.nos file\n#"


set AUTOMATIC 0
if {[info exists argv] == 1 && [lindex $argv 0] == "auto"} {
	set AUTOMATIC 1
}

getdir
set NOSDIR "[string trimleft [string trimright $NOSDIR " \t\n\r"] " \t\n\r"]"
puts "mksetup.tcl: Using installation directory of: '$NOSDIR'"

if [catch {source $NOSDIR/etc/config.cfg}]	{
	puts "mksetup.tcl: No $NOSDIR/etc/config.cfg found!"
	exit 1
}


source $CONFIG_IN

puts $fdh "\n# end"
close $fdh


puts "Adding your hostname to the domain.txt file"
set fd [open spool/domain.txt a+]
puts $fd "$HOSTNAME.\tIN\tA\t$IPADDR"
close $fd


puts " "
puts "The configuration is complete!"
exit
