#include <stdio.h>
#include <time.h>

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: lscookie.c,v 1.1 1997/02/01 16:56:31 root Exp root $";
#endif


#define COOKIEFILE	"/spool/cookies.dat"
#ifdef MSDOS
#define	READ_TEXT	"rt"
#else
#define	READ_TEXT	"r"
#endif
#define NULLFILE	((FILE *)0)
#define NULLCHAR	((char *)0)



int
main (void)
{
FILE *fp;
char buf[512];
time_t assigned;
long cookie;
int addr[4];
long count = 0;

	if ((fp = fopen (NOSDIR COOKIEFILE, READ_TEXT)) == NULLFILE)	{
		printf ("Couldn't open the cookie data file: %s\n",
			NOSDIR COOKIEFILE);
		return 1;
	}

	puts ("\nThe cookies assigned from this TNOS site:\n");
	printf ("%11.11s    %15.15s    %s\n", "Number", "Site IP Address", "Assigned");
	printf ("%11.11s    %15.15s    %s\n", "======", "===============", "========");
	while (fgets (buf, 512, fp) != NULLCHAR)	{
		sscanf (buf, "%2x%2x%2x%2x_%08ld_%012ld", &addr[0], &addr[1],
			&addr[2], &addr[3], &cookie, &assigned);
		printf ("Cookie #%03ld:   %03d.%03d.%03d.%03d    %s", cookie,
			addr[0], addr[1], addr[2], addr[3], ctime(&assigned));
		count++;
	}
	fclose (fp);

	printf ("\nTotal of %ld cookies have been assigned.\n", count);
	return 0;
}
