/* Internet finger client
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "commands.h"
#include "mbuf.h"
#include "socket.h"
#include "session.h"
#include "netuser.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: finger.c,v 1.13 1997/06/28 16:46:13 root Exp root $";
#endif


int
dofinger (argc, argv, p)
int argc;
char *argv[];
void *p OPTIONAL;
{
struct sockaddr_in sock;
char *cp;
char const *cp2;
int s, i;
struct mbuf *bp;
struct session *sp;
int thesocket;

	/*Make sure this comes from console - WG7J*/
	if (Curproc->input != Command->input)
		return 0;

	/* Allocate a session descriptor */
	if ((sp = newsession (argv[1], FINGER, 0)) == NULLSESSION) {
		tputs (TooManySessions);
		(void) keywait (NULLCHAR, 1);
		return 1;
	}
	sp->ttystate.echo = sp->ttystate.edit = 0;
	sp->flowmode = 1;
	sock.sin_family = AF_INET;
	sock.sin_port = IPPORT_FINGER;
	thesocket = Curproc->output;
	for (i = 1; i < argc; i++) {
		cp = strchr (argv[i], '@');
		if (cp == NULLCHAR) {
			tprintf ("%s@localhost -- ", argv[i]);
			sock.sin_addr.s_addr = 0x7f000001;	/* 127.0.0.1 */
		} else {
			*cp++ = '\0';
			tprintf ("%s@%s -- ", argv[i], cp);
			tprintf ("Resolving %s... ", cp);
			if ((sock.sin_addr.s_addr = resolve (cp)) == 0) {
				tprintf ("Host %s unknown\n", cp);
				continue;
			}
		}
		tprintf ("trying %s", psocket ((struct sockaddr *) &sock));
		if ((sp->s = s = socket (AF_INET, SOCK_STREAM, 0)) == -1) {
			tputs (Nosock);
			break;
		}
		(void) sockmode (s, SOCK_ASCII);
		if (connect (s, (char *) &sock, sizeof (sock)) == -1) {
			cp2 = sockerr (s);
			tprintf (" -- Connect failed: %s\n", cp != NULLCHAR ? cp2 : "");
			(void) shutdown (s, 2);	/* K2MF: To make sure it doesn't linger around */
			close_s (s);
			sp->s = -1;
			continue;
		}
		tputc ('\n');
		usflush (thesocket);
		usprintf (s, "%s\n", argv[i]);
		while (recv_mbuf (s, &bp, 0, NULLCHAR, (int *) 0) > 0)
			(void) send_mbuf (thesocket, bp, 0, NULLCHAR, 0);

		close_s (s);
		sp->s = -1;
	}
	(void) keywait (NULLCHAR, 1);
	freesession (sp);
	return 0;
}
