head	1.15;
access;
symbols;
locks;
comment	@ * @;


1.15
date	93.05.06.10.11.29;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	93.03.08.00.49.03;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	93.02.19.22.41.36;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.05.13.22.17.08;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.05.04.08.55.00;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.02.11.33.02;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.01.12.31.20;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.04.29.21.23.12;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.04.28.23.20.44;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	91.12.18.14.10.52;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.12.18.10.12.28;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.04.20.08.00.42;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.08.14.00.20;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.20.14.28.16;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.31.32;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.15
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* General purpose software timer facilities
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "timer.h"
#include "proc.h"
#include "mbuf.h"
#include "commands.h"
#include "daemon.h"
#include "hardware.h"
#include "socket.h"

/* Head of running timer chain.
 * The list of running timers is sorted in increasing order of expiration;
 * i.e., the first timer to expire is always at the head of the list.
 */
static struct timer *Timers;

static void t_alarm(void *x);

/* Process that handles clock ticks */
void
timerproc(i,v1,v2)
int i;
void *v1,*v2;
{
	register struct timer *t;
	register struct timer *expired;
	void (**vf)(void);
	int i_state;
	int tmp;
	int32 clock;

	for(;;){
		/* Atomic read and decrement of Tick */
		for(;;){
			i_state = dirps();
			tmp = Tick;
			if(tmp != 0){
				Tick--;
				restore(i_state);
				break;
			}	
			restore(i_state);
			pwait(&Tick);
		}
		if(!istate()){
			restore(1);
			printf("timer: ints were off!\n");
		}

		/* Call the functions listed in config.c */
		for(vf = Cfunc;*vf != NULL;vf++)
			(*vf)();

		pwait(NULL);	/* Let them all do their writes */

		if(Timers == NULLTIMER)
			continue;	/* No active timers, all done */

		/* Initialize null expired timer list */
		expired = NULLTIMER;
		clock = rdclock();

		/* Move expired timers to expired list. Note use of
		 * subtraction and comparison to zero rather than the
		 * more obvious simple comparison; this avoids
		 * problems when the clock count wraps around.
		 */
		while(Timers != NULLTIMER && (clock - Timers->expiration) >= 0){
			if(Timers->next == Timers){
				printf("PANIC: Timer loop at %lx\n",
				 (long)Timers);
				iostop();
				exit(1);
			}
			/* Save Timers since stop_timer will change it */
			t = Timers;
			stop_timer(t);
			t->state = TIMER_EXPIRE;
			/* Add to expired timer list */
			t->next = expired;
			expired = t;
		}
		/* Now go through the list of expired timers, removing each
		 * one and kicking the notify function, if there is one
		 */
		while((t = expired) != NULLTIMER){
			expired = t->next;
			if(t->func){
				(*t->func)(t->arg);
			}
		}
		pwait(NULL);	/* Let them run before handling more ticks */
	}
}
/* Start a timer */
void
start_timer(t)
struct timer *t;
{
	register struct timer *tnext;
	struct timer *tprev = NULLTIMER;

	if(t == NULLTIMER)
		return;
	if(t->state == TIMER_RUN)
		stop_timer(t);
	if(t->duration == 0)
		return;		/* A duration value of 0 disables the timer */

	t->expiration = rdclock() + t->duration;
	t->state = TIMER_RUN;

	/* Find right place on list for this guy. Once again, note use
	 * of subtraction and comparison with zero rather than direct
	 * comparison of expiration times.
	 */
	for(tnext = Timers;tnext != NULLTIMER;tprev=tnext,tnext = tnext->next){
		if((tnext->expiration - t->expiration) >= 0)
			break;
	}
	/* At this point, tprev points to the entry that should go right
	 * before us, and tnext points to the entry just after us. Either or
	 * both may be null.
	 */
	if(tprev == NULLTIMER)
		Timers = t;		/* Put at beginning */
	else
		tprev->next = t;

	t->next = tnext;
}
/* Stop a timer */
void
stop_timer(timer)
struct timer *timer;
{
	register struct timer *t;
	struct timer *tlast = NULLTIMER;

	if(timer == NULLTIMER || timer->state != TIMER_RUN)
		return;

	/* Verify that timer is really on list */
	for(t = Timers;t != NULLTIMER;tlast = t,t = t->next)
		if(t == timer)
			break;

	if(t == NULLTIMER)
		return;		/* Should probably panic here */

	/* Delete from active timer list */
	if(tlast != NULLTIMER)
		tlast->next = t->next;
	else
		Timers = t->next;	/* Was first on list */

	t->state = TIMER_STOP;
}
/* Return milliseconds remaining on this timer */
int32
read_timer(t)
struct timer *t;
{
	int32 remaining;

	if(t == NULLTIMER || t->state != TIMER_RUN)
		return 0;
	remaining = t->expiration - rdclock();
	if(remaining <= 0)
		return 0;	/* Already expired */
	else
		return remaining * MSPTICK;
}
void
set_timer(t,interval)
struct timer *t;
int32 interval;
{
	if(t == NULLTIMER)
		return;
	/* Round the interval up to the next full tick, and then
	 * add another tick to guarantee that the timeout will not
	 * occur before the interval is up. This is necessary because
	 * we're asynchronous with the system clock.
	 */	
	if(interval != 0)
		t->duration = 1 + (interval + MSPTICK - 1)/MSPTICK;
	else
		t->duration = 0;
}
/* Delay process for specified number of milliseconds.
 * Normally returns 0; returns -1 if aborted by alarm.
 */
int
pause(ms)
int32 ms;
{
	int val;

	if(Curproc == NULLPROC || ms == 0)
		return 0;
	alarm(ms);
	/* The actual event doesn't matter, since we'll be alerted */
	while(Curproc->alarm.state == TIMER_RUN){
		if((val = pwait(Curproc)) != 0)
			break;
	}
	alarm(0L); /* Make sure it's stopped, in case we were killed */	
	return (val == EALARM) ? 0 : -1;
}
static void
t_alarm(x)
void *x;
{
	alert((struct proc *)x,EALARM);
}
/* Send signal to current process after specified number of milliseconds */
void
alarm(ms)
int32 ms;
{
	if(Curproc != NULLPROC){
		set_timer(&Curproc->alarm,ms);
		Curproc->alarm.func = t_alarm;
		Curproc->alarm.arg = (char *)Curproc;
		start_timer(&Curproc->alarm);
	}
}
/* Convert time count in seconds to printable days:hr:min:sec format */
char *
tformat(t)
int32 t;
{
	static char buf[17],*cp;
	unsigned int days,hrs,mins,secs;
	int minus;

	if(t < 0){
		t = -t;
		minus = 1;
	} else
		minus = 0;

	secs = t % 60;
	t /= 60;
	mins = t % 60;
	t /= 60;
	hrs = t % 24;
	t /= 24;
	days = t;
	if(minus){
		cp = buf+1;
		buf[0] = '-';
	} else
		cp = buf;
	sprintf(cp,"%u:%02u:%02u:%02u",days,hrs,mins,secs);
	
	return buf;
}
	
@


1.14
log
@Add prototype to function pointer
@
text
@d20 1
a20 1
static void t_alarm __ARGS((void *x));
d30 1
a30 1
	void (**vf) __ARGS((void));
@


1.13
log
@Use rdclock() instead of Clock references
@
text
@d30 1
a30 1
	void (**vf)();
@


1.12
log
@src0514
@
text
@d33 1
d64 1
d71 1
a71 1
		while(Timers != NULLTIMER && (Clock - Timers->expiration) >= 0){
d113 1
a113 1
	t->expiration = Clock + t->duration;
d171 1
a171 1
	remaining = t->expiration - Clock;
@


1.11
log
@src0505
@
text
@a55 1
		fflush(Current->output);	/* Flush current session output */
@


1.10
log
@src0503
@
text
@d32 1
d35 10
a44 2
		i_state = dirps();
		while(Tick == 0)
d46 1
a46 3
		Tick = 0;
		restore(i_state);

a57 1
		rflush();	/* Flush out buffered console stuff */
@


1.9
log
@src0501
@
text
@d49 1
a49 1
		fflush(stdout);	/* Flush current session output */
@


1.8
log
@src0429a
@
text
@d49 1
a49 1
		tflush();	/* Flush current session output */
a51 1
		fflush(stdout);	/* And flush out stdout too */
@


1.7
log
@src0428
@
text
@d31 1
d34 1
d38 1
@


1.6
log
@src1218
@
text
@a29 1
	char i_state;
a32 1
		i_state = dirps();	/* Tick is modified by an interrupt */
a35 1
		restore(i_state);
@


1.5
log
@src1217
@
text
@d183 4
a186 1
	t->duration = 1 + (interval + MSPTICK - 1)/MSPTICK;
@


1.4
log
@src0420
@
text
@d178 6
a183 5
	/* Round up small nonzero intervals to one tick */
	if(0 < interval && interval <= MSPTICK)
		t->duration = 1;
	else
		t->duration = interval/MSPTICK;
@


1.3
log
@src0308
@
text
@d15 1
a15 1
 * The list of running timers is sorted in increasing order of interval;
a16 4
 * For performance reasons, the intervals are incremental, so that only
 * the first entry needs to be decremented on each tick. Hence there are
 * special routines for reading the number of ticks remaining on a
 * running timer; you can't just look at the field directly.
a19 3
/* This variable keeps a running count of ticks since program startup */
int32 Clock;

d31 1
d37 1
a37 1
		Tick--;
d41 1
a42 1
			restore(1);
d44 5
a48 2
		refiq();	/* Replenish interrupt pool */
		systick();	/* Machine-dependent per-tick stuff */
d55 1
a55 7
			continue;	/* Nothing to do on this tick */

		/* Decrement the first timer. If it expires,
		 * take it off the running list and put it
		 * on a singly linked list of expired timers
		 */
		Timers->count--;
d60 6
a65 1
		while(Timers != NULLTIMER && Timers->count <= 0){
d97 2
a98 2
	register struct timer *tnext,*tprev;
	int32 tot;
d104 2
a105 2
	if(t->start == 0)
		return;		/* A start value of 0 disables the timer */
d107 1
d109 7
a115 5
	/* Find right place on list for this guy */
	tot = 0;
	tprev = NULLTIMER;
	for(tnext = Timers;tnext != NULLTIMER;tnext = tprev->next){
		if(tnext->count + tot > t->start)
a116 2
		tprev = tnext;
		tot += tnext->count;
d122 1
a122 2
	t->count = t->start - tot;	/* Adjust for entries before us */
	if((t->prev = tprev) == NULLTIMER)
d127 1
a127 5
	if((t->next = tnext) != NULLTIMER){
		tnext->prev = t;
		/* Adjust the following entry's count */
		tnext->count -= t->count;
	}
d131 2
a132 2
stop_timer(t)
register struct timer *t;
d134 10
a143 1
	register struct timer *tp;
d146 8
a153 13
		return;
	if(t->state == TIMER_RUN){
		/* Delete from active timer list */
		if(t->next != NULLTIMER)
			t->next->prev = t->prev;
		if(t->prev != NULLTIMER)
			t->prev->next = t->next;
		else
			Timers = t->next;
		/* Adjust count for the next timer */
		if((tp = t->next) != NULLTIMER)
			tp->count += t->count;
	}
d161 1
a161 2
	register struct timer *tp;
	int32 tot;
d165 5
a169 8

	tot = 0;
	for(tp = Timers;tp != NULLTIMER; tp = tp->next){
		tot += tp->count;
		if(tp == t)
			break;
	}
	return tot * MSPTICK;
d179 2
a180 2
	if(interval > 0 && interval < MSPTICK)
		t->start = 1;
d182 1
a182 1
		t->start = interval/MSPTICK;
@


1.2
log
@src0221
@
text
@d27 1
a27 1
static void t_alarm(void *x);
@


1.1
log
@Initial revision
@
text
@d235 1
a235 1
	static char buf[16];
d237 1
d239 6
d252 7
a258 1
	sprintf(buf,"%u:%02u:%02u:%02u",days,hrs,mins,secs);
@
