head	1.22;
access;
symbols;
locks;
comment	@ * @;


1.22
date	93.05.06.10.11.07;	author karn;	state Exp;
branches;
next	1.21;

1.21
date	93.04.27.23.22.49;	author karn;	state Exp;
branches;
next	1.20;

1.20
date	93.03.15.05.06.37;	author karn;	state Exp;
branches;
next	1.19;

1.19
date	93.03.11.21.11.47;	author karn;	state Exp;
branches;
next	1.18;

1.18
date	93.03.08.00.51.09;	author karn;	state Exp;
branches;
next	1.17;

1.17
date	93.02.23.02.01.21;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	92.12.28.09.14.06;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.12.10.22.08.39;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.06.30.04.54.15;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.06.07.09.22.30;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.06.03.22.08.36;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.05.30.12.02.32;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.21.11.22.22;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.18.10.48.46;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.15.02.24.26;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.05.12.49.22;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.03.13.23.38;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.01.10.13.32;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.04.30.12.25.02;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.04.29.11.52.44;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	92.04.23.10.42.02;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	92.04.20.08.51.56;	author karn;	state Exp;
branches;
next	;


desc
@src0419
@


1.22
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Standard I/O routines with socket support
 * Replaces those in Borland C++ library
 * Copyright 1992 Phil Karn, KA9Q
 */
#include <string.h>
#include <stdarg.h>
#include <mem.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#define __IN_OPEN	1	/* Less stringent open() proto in io.h */
#include <io.h>
#include "global.h"
#include "stdio.h"
#include "mbuf.h"
#include "proc.h"
#include "usock.h"
#include "socket.h"
#include "display.h"
#include "asy.h"

#define	_CREAT(a,b)	_creat((a),(b))
#define _OPEN(a,b)	_open((a),(b))
#define	_CLOSE(a)	_close((a))
#define	_READ(a,b,c)	_read((a),(b),(c))
#define	_WRITE(a,b,c)	_write((a),(b),(c))
#define	_LSEEK(a,b,c)	_lseek((a),(b),(c))
#define	_DUP(a)		dup((a))

long _lseek(int fd,long offset,int whence);

static void _fclose(FILE *fp);
static struct mbuf *_fillbuf(FILE *fp,int cnt);
static FILE *_fcreat(void);

FILE *_Files;
extern unsigned *Refcnt;

/* Open a file and associate it with a (possibly specified) stream */
FILE *
freopen(filename,mode,fp)
char *filename;
char *mode;
FILE *fp;
{
	int modef;
	int textmode = 0;
	int create = 0;
	int append = 0;
	int fd;
	struct stat statbuf;

	if(strchr(mode,'r') != NULLCHAR){
		modef = O_RDONLY;
	} else if(strchr(mode,'w') != NULLCHAR){
		create = 1;
		modef = O_WRONLY;
	} else if(strchr(mode,'a') != NULLCHAR){
		modef = O_WRONLY;
		append = 1;
		if(stat(filename,&statbuf) == -1 && errno == ENOENT)
			create = 1;	/* Doesn't exist, so create */
	} else
		return NULLFILE;	/* No recognizable mode! */

	if(strchr(mode,'+') != NULLCHAR)
		modef = O_RDWR;	/* Update implies R/W */

	if(strchr(mode,'t') != NULLCHAR)
		textmode = 1;
	
	if(create)
		fd = _CREAT(filename,S_IREAD|S_IWRITE);
	else
		fd = _OPEN(filename,modef);
	if(fd == -1)
		return NULLFILE;

	if(fp != NULLFILE){
		_fclose(fp);
	} else {
		if((fp = _fcreat()) == NULLFILE){
			_CLOSE(fd);
			if(create)
				unlink(filename);
			return NULLFILE;
		}
	}
	fp->fd = fd;
	fp->offset = 0;
	fp->type = _FL_FILE;
	fp->bufmode = _IOFBF;
	fp->ptr = strdup(filename);
	if(textmode)
		fp->flags |= _FL_ASCII;
	if(append)
		fp->flags |= _FL_APPEND;
	fp->bufsize = BUFSIZ;
	seteol(fp,Eol);
	return fp;
}
/* Associate a file or socket descripter (small integer) with a stream */
FILE *
fdopen(handle,mode)
int handle;
char *mode;
{
	FILE *fp;
	int textmode = 0;
	int append = 0;

	if(handle == -1)
		return NULLFILE;

	if(strchr(mode,'a') != NULLCHAR)
		append = 1;

	if(strchr(mode,'t') != NULLCHAR)
		textmode = 1;
	
	if((fp = _fcreat()) == NULLFILE)
		return NULLFILE;

	fp->fd = handle;
	fp->bufmode = _IOFBF;
	fp->type = _fd_type(handle);
	if(textmode)
		fp->flags |= _FL_ASCII;
	if(append)
		fp->flags |= _FL_APPEND;

	fp->bufsize = BUFSIZ;
	/* set default eol sequence, can be overridden by user */
	switch(fp->type){
	case _FL_SOCK:
		seteol(fp,eolseq(handle));	/* Socket eol seq */
		break;
	case _FL_FILE:
		seteol(fp,Eol);	/* System end-of-line sequence */
		break;
	}
	fp->refcnt = 1;

	return fp;
}
/* Create a stream in pipe mode (whatever is written can be
 * read back). These always work in binary mode.
 */
FILE *
pipeopen()
{
	FILE *fp;

	if((fp = _fcreat()) == NULLFILE)
		return NULLFILE;

	fp->fd = -1;
	fp->type = _FL_PIPE;
	fp->bufmode = _IOFBF;
	fp->bufsize = BUFSIZ;

	strcpy(fp->eol,"\r\n");
	return fp;
}
/* Open an asynch port for direct I/O. This must have already been attached
 * as a NOS interface. All packet-mode I/O is suspended until this stream
 * is closed.
 */
FILE *
asyopen(name,mode)
char *name;	/* Name of interface */
char *mode;	/* Usual fopen-style mode (used only for text/binary) */
{
	FILE *fp;
	int dev;
	int textmode = 0;

	if((dev = asy_open(name)) == -1)
		return NULL;
	if((fp = _fcreat()) == NULLFILE)
		return NULLFILE;

	if(strchr(mode,'t') != NULLCHAR)
		textmode = 1;

	fp->fd = dev;
	fp->type = _FL_ASY;
	fp->bufmode = _IOFBF;
	if(textmode)
		fp->flags |= _FL_ASCII;

	fp->bufsize = BUFSIZ;
	strcpy(fp->eol,"\r\n");
	return fp;
}
/* Create a new display screen and associate it with a stream. */
FILE *
displayopen(mode,noscrol,sfsize)
char *mode;
int noscrol;
int sfsize;
{
	FILE *fp;
	int textmode = 0;

	if(strchr(mode,'t') != NULLCHAR)
		textmode = 1;

	if((fp = _fcreat()) == NULLFILE)
		return NULLFILE;

	fp->fd = -1;
	fp->type = _FL_DISPLAY;
	fp->bufmode = _IOFBF;
	if(textmode)
		fp->flags |= _FL_ASCII;

	fp->ptr = newdisplay(0,0,noscrol,sfsize);
	fp->bufsize = BUFSIZ;
	strcpy(fp->eol,"\r\n");
	return fp;
}


/* Read string from stdin into buf until newline, which is not retained */
char *
gets(s)
char *s;
{
	int c;
	char *cp;

	cp = s;
	for(;;){
		if((c = getc(stdin)) == EOF)
			return NULLCHAR;

		if(uchar(c) == '\n')
			break;

		if(s != NULLCHAR)
			*cp++ = c;
	}
	if(s != NULLCHAR)
		*cp = '\0';
	return s;
}

/* Read a line from a stream into a buffer, retaining newline */
char *
fgets(buf,len,fp)
char *buf;	/* User buffer */
int len;	/* Length of buffer */
FILE *fp;	/* Input stream */
{
	int c;
	char *cp;

	cp = buf;
	while(len-- > 1){	/* Allow room for the terminal null */
		if((c = getc(fp)) == EOF){
			return NULLCHAR;
		}
		if(buf != NULLCHAR)
			*cp++ = c;
		if(uchar(c) == '\n')
			break;
	}
	if(buf != NULLCHAR)
		*cp = '\0';
	return buf;
}

/* Do printf on a stream */
int
fprintf(FILE *fp,char *fmt,...)
{
	va_list args;
	int len;

	va_start(args,fmt);
	len = vfprintf(fp,fmt,args);
	va_end(args);
	return len;
}
/* Printf on standard output stream */
int
printf(char *fmt,...)
{
	va_list args;
	int len;

	va_start(args,fmt);
	len = vfprintf(stdout,fmt,args);
	va_end(args);
	return len;
}
/* The guts of printf, uses variable arg version of sprintf */
int
vprintf(char *fmt, va_list args)
{
	return vfprintf(stdout,fmt,args);
}

/* The guts of printf, uses variable arg version of sprintf */
int
vfprintf(FILE *fp,char *fmt, va_list args)
{
	int len,cnt,withargs;
	char *buf;

	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return -1;
	if(strchr(fmt,'%') == NULLCHAR){
		/* Common case optimization: no args, so we don't
		 * need vsprintf()
		 */
		withargs = 0;
		buf = fmt;
	} else {
		/* Use a default value that is hopefully longer than the
		 * biggest output string we'll ever print (!)
		 */
		withargs = 1;
		buf = mallocw(BUFSIZ);
		vsprintf(buf,fmt,args);
	}
	len = strlen(buf);
	cnt = fwrite(buf,1,len,fp);
	if(cnt != len)
		cnt = -1;
	if(withargs)
		free(buf);
	return cnt;
}
/* put a char to a stream */ 
int
fputc(c,fp)
int c;
FILE *fp;
{
	int nbytes;
	struct mbuf *bp;
	int eol;

	if(c == '\n' && (fp->flags & _FL_ASCII)){
		nbytes = strlen(fp->eol);
		eol = 1;
	} else {
		nbytes = 1;
		eol = 0;
	}
	bp = fp->obuf;
	if(bp != NULLBUF && bp->size - bp->cnt < nbytes && fflush(fp) == EOF)
		return EOF;
	if(fp->obuf == NULLBUF)
		fp->obuf = ambufw(max(nbytes,fp->bufsize));

	bp = fp->obuf;
	if(eol)
		memcpy(&bp->data[bp->cnt],fp->eol,nbytes);
	else
		bp->data[bp->cnt] = c;
	bp->cnt += nbytes;

	if(bp->cnt == bp->size || (fp->bufmode == _IONBF)
	 || ((fp->bufmode == _IOLBF) && eol)){
		if(fflush(fp) == EOF)
			return EOF;
	}
	return c;
}
/* put a string to a stream */
int
fputs(buf,fp)
char *buf;
FILE *fp;
{
	int cnt,len;

	len = strlen(buf);
	cnt = fwrite(buf,1,len,fp);
	if(cnt != len)
		return EOF;
	return uchar(buf[len-1]);
}

/* Put a string to standard output */
int
puts(s)
char *s;
{
	if(fputs(s,stdout) == EOF)
		return EOF;
	putchar('\n');
	return 1;
}

/* Read a character from the stream */
int
fgetc(fp)
FILE *fp;
{
	int c;

	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return EOF;
	c = _fgetc(fp);
	if(!(fp->flags & _FL_ASCII) || c == EOF || c != fp->eol[0])
		return c;
	/* First char of newline sequence encountered */
	if(fp->eol[1] == '\0')
		return '\n';	/* Translate 1-char eol sequence */
	/* Try to read next input character */
	if((c = _fgetc(fp)) == EOF)
		return fp->eol[0];	/* Got a better idea? */
	if(c == fp->eol[1]){
		/* Translate two-character eol sequence into newline */
		return '\n';
	} else {
		/* CR-NUL sequence on Internet -> bare CR (kludge?) */
		if(c != '\0')
			ungetc(c,fp);
		/* Otherwise return first char unchanged */
		return fp->eol[0];
	}
}
/* Read a character from a stream without newline processing */
int
_fgetc(fp)
FILE *fp;
{
	struct mbuf *bp;

	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return EOF;
	fflush(fp);
	if((bp = fp->ibuf) == NULLBUF || bp->cnt == 0)
		if(_fillbuf(fp,1) == NULLBUF)
			return EOF;
	if(fp->type == _FL_PIPE)
		psignal(&fp->obuf,1);
	return PULLCHAR(&fp->ibuf);
}

/* Flush output on a stream. All actual output is done here. */
int
fflush(fp)
FILE *fp;
{
	struct mbuf *bp;
	int cnt;

	if(fp == NULLFILE || fp->cookie != _COOKIE){
		flushall();
		return 0;
	}
	if(fp->obuf == NULLBUF)
		return 0;	/* Nothing to do */

	bp = fp->obuf;
	fp->obuf = NULLBUF;
	switch(fp->type){
	case _FL_ASY:
		while(bp != NULLBUF){
			asy_write(fp->fd,bp->data,bp->cnt);
			bp = free_mbuf(bp);
		}
		return 0;		
	case _FL_PIPE:
		append(&fp->ibuf,bp);
		psignal(&fp->ibuf,1);
		while(len_p(fp->ibuf) >= BUFSIZ)
			pwait(&fp->obuf);	/* Hold at hiwat mark */	
		return 0;
	case _FL_SOCK:
		return send_mbuf(fp->fd,bp,0,NULLCHAR,0);
	case _FL_FILE:
		do {
			if(fp->flags & _FL_APPEND)
				_LSEEK(fp->fd,0L,SEEK_END);
			else
				_LSEEK(fp->fd,fp->offset,SEEK_SET);
			cnt = _WRITE(fp->fd,bp->data,bp->cnt);
			if(cnt > 0)
				fp->offset += cnt;
			if(cnt != bp->cnt){
				fp->flags |= _FL_ERR;
				free_p(bp);
				return EOF;
			}
			bp = free_mbuf(bp);
		} while(bp != NULLBUF);
		return 0;
	case _FL_DISPLAY:
		do {
			displaywrite(fp->ptr,bp->data,bp->cnt);
			bp = free_mbuf(bp);
		} while(bp != NULLBUF);
		return 0;
	}
	return 0;	/* Can't happen */
}

/* Set the end-of-line sequence on a stream */
int
seteol(fp,seq)
FILE *fp;
char *seq;
{
	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return -1;
	if(seq != NULLCHAR)
		strncpy(fp->eol,seq,sizeof(fp->eol));
	else
		*fp->eol = '\0';
	return 0;
}
/* Enable/disable eol translation, return previous state */
int
fmode(fp,mode)
FILE *fp;
int mode;
{
	int prev;

	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return -1;
	fflush(fp);
	prev = (fp->flags & _FL_ASCII) ? STREAM_ASCII : STREAM_BINARY;
	switch(mode){
	case STREAM_ASCII:	/* Turn on ascii translation */
		fp->flags |= _FL_ASCII;
		break;
	case STREAM_BINARY:	/* Turn it off */
		fp->flags &= ~_FL_ASCII;
		break;
	default:
		break;
	}
	return prev;
}
/* Control blocking behavior for fread on network, pipe and asy streams */
int
fblock(fp,mode)
FILE *fp;
int mode;
{
	int prev;

	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return -1;
	prev = (fp->flags & _FL_PARTREAD) ? PART_READ : FULL_READ;
	switch(mode){
	case FULL_READ:	/* Turn off partial reads */
		fp->flags &= ~_FL_PARTREAD;
		break;
	case PART_READ:	/* Turn it on */
		fp->flags |= _FL_PARTREAD;
		break;
	}
	return prev;
}

int
fclose(fp)
FILE *fp;
{
	if(fp == NULLFILE || fp->cookie != _COOKIE){
		return -1;
	}
	if(--fp->refcnt != 0)
		return 0;	/* Others are still using it */
	_fclose(fp);
	if(fp->prev != NULLFILE)
		fp->prev->next = fp->next;
	else
		_Files = fp->next;

	if(fp->next != NULLFILE)
		fp->next->prev = fp->prev;
	free(fp);
	return 0;
}
int
fseek(fp,offset,whence)
FILE *fp;
long offset;
int whence;
{
	struct stat statbuf;

	if(fp == NULLFILE || fp->cookie != _COOKIE || fp->type != _FL_FILE){
		errno = EINVAL;
		return -1;
	}
	/* Optimize for do-nothing seek */ 
#ifdef	notdef
	if(whence == SEEK_SET && fp->offset == offset)
		return 0;
#endif
	fflush(fp);	/* Flush output buffer */
	/* On relative seeks, adjust for data in input buffer */
	switch(whence){
	case SEEK_SET:
		fp->offset = offset;	/* Absolute seek */
		break;
	case SEEK_CUR:
		/* Relative seek, adjusting for buffered data */
		fp->offset += offset - len_p(fp->ibuf);
		break;
	case SEEK_END:
		/* Find out how big the file currently is */
		if(fstat(fp->fd,&statbuf) == -1)
			return -1;	/* "Can't happen" */
		fp->offset = statbuf.st_size + offset;
		break;
	}
	/* Toss input buffer */
	free_p(fp->ibuf);
	fp->ibuf = NULLBUF;
	fp->flags &= ~_FL_EOF;
	return 0;
}
long
ftell(fp)
FILE *fp;
{
	if(fp == NULLFILE || fp->cookie != _COOKIE || fp->type != _FL_FILE)
		return -1;
	fflush(fp);
	return fp->offset - len_p(fp->ibuf);
}

int
ungetc(c,fp)
int c;
FILE *fp;
{
	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return -1;

	if(c == '\n' && (fp->flags & _FL_ASCII)){
		fp->ibuf = pushdown(fp->ibuf,strlen(fp->eol));
		memcpy(fp->ibuf->data,fp->eol,strlen(fp->eol));
	} else {
		fp->ibuf = pushdown(fp->ibuf,1);
		*fp->ibuf->data = c;
	}
	return c;
}
size_t
fwrite(ptr,size,n,fp)
void *ptr;
size_t size;
size_t n;
FILE *fp;
{
	struct mbuf *bp;
	char *icp,*ocp;
	size_t bytes;
	size_t cnt;
	size_t asize;
	int room;
	int newlines = 0;
	int eollen = 1;
	int doflush = 0;
	
	if(fp == NULLFILE || fp->cookie != _COOKIE || size == 0)
		return 0;
	icp = (char *)ptr;
	bytes = size*n;

	/* Optimization for large binary file writes */
	if(fp->type == _FL_FILE && !(fp->flags & _FL_ASCII) && bytes >= fp->bufsize){
		fflush(fp);
		if(fp->flags & _FL_APPEND)
			_LSEEK(fp->fd,0L,SEEK_END);
		else
			_LSEEK(fp->fd,fp->offset,SEEK_SET);
		cnt = _WRITE(fp->fd,icp,bytes);
		if(cnt > 0)
			fp->offset += cnt;
		if(cnt != bytes)
			return cnt/size;
		return n;
	}
	if(fp->flags & _FL_ASCII){
		/* Count the newlines in the input buffer */
		newlines = memcnt((char *)ptr,'\n',bytes);
		if(newlines != 0){
			eollen = strlen(fp->eol);
			if(fp->flags & _IOLBF)
				doflush = 1;
		}
	}
	while(bytes != 0){
		bp = fp->obuf;
		if(bp != NULLBUF && bp->cnt + eollen > bp->size){
			/* Current obuf is full; flush it */
			if(fflush(fp) == EOF)
				return (bytes - n*size)/size;
		}
		if((bp = fp->obuf) == NULLBUF){
			/* Allocate a new output buffer. The size is the
			 * larger of the buffer size or the amount of data
			 * we have to write (including any expanded newlines)
			 */
			asize = bytes+(eollen-1)*newlines;
			asize = max(fp->bufsize,asize);
			bp = fp->obuf = ambufw(asize);
		}
		if((fp->flags & _FL_ASCII) && newlines != 0){
			/* Copy text to buffer, expanding newlines */
			ocp = bp->data + bp->cnt;
			room = bp->size - bp->cnt;
			for(;room >= eollen && bytes != 0;icp++,bytes--){
				if(*icp == '\n'){
					memcpy(ocp,fp->eol,eollen);
					ocp += eollen;
					room -= eollen;
					newlines--;
				} else {
					*ocp++ = *icp;
					room--;
				}
			}
			bp->cnt = ocp - bp->data;
		} else {
			/* Simply copy binary data to buffer */
			cnt = min(bp->size - bp->cnt,bytes);
			memcpy(bp->data+bp->cnt,icp,cnt);
			bp->cnt += cnt;
			icp += cnt;
			bytes -= cnt;
		}
	}
	/* The final flush. Flush if the stream is unbuffered,
	 * the output buffer is full, or the stream is line buffered
	 * and we've written at least one newline (not necessarily the
	 * last character)
	 */
	if(fp->bufmode == _IONBF || bp->cnt == bp->size || doflush){
		if(fflush(fp) == EOF)
			return (bytes - n*size)/size;
	}
	return n;
}
static struct mbuf *
_fillbuf(fp,cnt)
FILE *fp;
int cnt;
{
	struct mbuf *bp;
	int i;

	if(fp->ibuf != NULLBUF)
		return fp->ibuf;	/* Stuff already in the input buffer */

	switch(fp->type){
	case _FL_ASY:
		fp->ibuf = ambufw(BUFSIZ);
		i = asy_read(fp->fd,fp->ibuf->data,BUFSIZ);
		if(i < 0)
			return NULLBUF;
		fp->ibuf->cnt = i;
		return fp->ibuf;
	case _FL_PIPE:
		while(fp->ibuf == NULLBUF)
			if((errno = pwait(&fp->ibuf)) != 0)	/* Wait for something */
				return NULLBUF;
		return fp->ibuf;
	case _FL_SOCK:
		/* Always grab everything available from a socket */
		if(recv_mbuf(fp->fd,&fp->ibuf,0,NULLCHAR,0) <= 0
		 && errno != EALARM){
			fp->flags |= _FL_EOF;
		}
		return fp->ibuf;
	case _FL_FILE:
		/* Read from file */
		cnt = max(fp->bufsize,cnt);
		bp = ambufw(cnt);		
		_LSEEK(fp->fd,fp->offset,SEEK_SET);
		cnt = _READ(fp->fd,bp->data,cnt);
		if(cnt < 0)
			fp->flags |= _FL_ERR;
		if(cnt == 0)
			fp->flags |= _FL_EOF;
		if(cnt <= 0){
			free_p(bp);	/* Nothing successfully read */
			return NULLBUF;
		}
		fp->offset += cnt;	/* Update pointer */
		/* Buffer successfully read, store it */
		bp->cnt = cnt;
		fp->ibuf = bp;
		return bp;
	case _FL_DISPLAY:	/* Displays are write-only */
		return NULLBUF;
	}
	return NULLBUF;	/* Can't happen */
}
size_t
fread(ptr,size,n,fp)
void *ptr;
size_t size,n;
FILE *fp;
{
	struct mbuf *bp;
	size_t bytes;
	size_t cnt;
	int c;
	size_t tot = 0;
	char *ocp;
	char *cp;

	if(fp == NULLFILE || fp->cookie != _COOKIE || size == 0)
		return 0;
	fflush(fp);
	bytes = n*size;

	ocp = (char *)ptr;
	while(bytes != 0){
		/* Optimization for large binary file reads */
		if(fp->ibuf == NULLBUF
		 && fp->type == _FL_FILE && !(fp->flags & _FL_ASCII)
		 && bytes >= BUFSIZ){
			_LSEEK(fp->fd,fp->offset,SEEK_SET);
			tot = _READ(fp->fd,ocp,bytes);
			if(tot > 0)
				fp->offset += tot;
			if(tot != bytes)
				return tot/size;
			return n;
		}
		/* Replenish input buffer if necessary */
		if(fp->ibuf == NULLBUF){
			if(tot != 0 && (fp->flags & _FL_PARTREAD)){
				/* Would block for more data */
				return tot/size;	
			}
		 	if(_fillbuf(fp,bytes) == NULLBUF){
				/* eof or error */
				return tot/size;
			}
		}
		/* In this pass, read the lesser of the buffer size,
		 * the requested amount, or the amount up to the next
		 * eol sequence (if ascii mode)
		 */
		bp = fp->ibuf;
		cnt = min(bp->cnt,bytes);
		if((fp->flags & _FL_ASCII)
		 && (cp = memchr(bp->data,fp->eol[0],cnt)) != NULLCHAR)
			cnt = min(cnt,cp - bp->data);
		if(cnt != 0){
			cnt = pullup(&fp->ibuf,ocp,cnt);
			ocp += cnt;
			tot += cnt;
			bytes -= cnt;
		} else {
			/* Hit a eol sequence, use fgetc to translate */
			if((c = fgetc(fp)) == EOF)
				return tot/size;

			*ocp++ = c;
			tot++;
			bytes--;
		}
	}
	if(fp->type == _FL_PIPE)
		psignal(&fp->obuf,1);
	return n;
}
void
perror(s)
char *s;
{
	fprintf(stderr,"%s: errno %d",s,errno);
	if(errno < sys_nerr)
		fprintf(stderr,": %s\n",sys_errlist[errno]);
	else if(EMIN <= errno && errno <= EMAX)
		fprintf(stderr,": %s\n",Sock_errlist[errno-EMIN]);
	else
		fprintf(stderr,"\n");
}
int
setvbuf(fp,buf,type,size)
FILE *fp;
char *buf;	/* Ignored; we alloc our own */
int type;
int size;
{
	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return -1;
	fflush(fp);
	if(size == 0)
		type = _IONBF;
	switch(type){
	case _IOFBF:
		fp->bufsize = size;
		break;
	case _IOLBF:
		fp->bufsize = size;
		break;
	case _IONBF:
		fp->bufsize = 1;
		break;
	default:
		return -1;	/* Invalid */
	}
	fp->bufmode = type;
	return 0;
}
void
setbuf(fp,buf)
FILE *fp;
char *buf;
{
	if(buf == NULLCHAR)
		setvbuf(fp,NULLCHAR,_IONBF,0);
	else
		setvbuf(fp,buf,_IOFBF,BUFSIZ);
}
FILE *
tmpfile()
{
	static int num;
	struct stat statbuf;
	FILE *fp;
	char *fname;
	char *tmpdir;
	char *cp;

	/* Determine directory to use. First look for $TMP environment
	 * variable, then use the compiled-in-default, then use the
	 * current directory.
	 */
	if((cp = getenv("TMP")) != NULLCHAR
	 && stat(cp,&statbuf) == 0 && (statbuf.st_mode & S_IFDIR)){
		fname = malloc(strlen(cp) + 11);
		tmpdir = malloc(strlen(cp) + 2);
		strcpy(tmpdir,cp);
		strcat(tmpdir,"/");
	} else if(stat(Tmpdir,&statbuf) == 0 && (statbuf.st_mode & S_IFDIR)){
		fname = malloc(strlen(Tmpdir) + 11);
		tmpdir = malloc(strlen(Tmpdir) + 2);
		strcpy(tmpdir,Tmpdir);
		strcat(tmpdir,"/");
	} else {
		fname = malloc(10);
		tmpdir = strdup("");
	}
	for(;;){
		sprintf(fname,"%stemp.%03d",tmpdir,num);
		if(stat(fname,&statbuf) == -1 && errno == ENOENT)
			break;
		num++;
	}
	free(tmpdir);
	fp = fopen(fname,"w+b");
	free(fname);
	if(fp != NULLFILE)
		fp->flags |= _FL_TMP;
	return fp;
}
/* Do everything to close a stream except freeing the descriptor
 * The reference count is left unchanged, and the descriptor is still
 * on the list
 */
static void
_fclose(fp)
FILE *fp;
{
	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return;
	fflush(fp);
	switch(fp->type){
	case _FL_ASY:
		asy_close(fp->fd);
		break;
	case _FL_SOCK:
		close_s(fp->fd);
		break;
	case _FL_FILE:
		_CLOSE(fp->fd);
		fp->offset = 0;
		break;
	case _FL_DISPLAY:
		closedisplay(fp->ptr);
		fp->ptr = NULL;
		break;
	}
	free_p(fp->obuf);	/* Should be NULLBUF anyway */
	fp->obuf = NULLBUF;
	free_p(fp->ibuf);
	fp->ibuf = NULLBUF;
	if((fp->flags & _FL_TMP) && Refcnt[fp->fd] == 0)
		unlink(fp->ptr);
	free(fp->ptr);
	fp->ptr = NULLCHAR;
	fp->flags = 0;
	fp->fd = -1;
}
/* allocate a new file pointer structure, init a few fields and put on list */
static FILE *
_fcreat()
{
	FILE *fp;

	if((fp = (FILE *)calloc(1,sizeof(FILE))) == NULLFILE)
		return NULLFILE;

	fp->cookie = _COOKIE;
	fp->refcnt = 1;
	fp->next = _Files;
	_Files = fp;
	if(fp->next != NULLFILE)
		fp->next->prev = fp;
	return fp;
}

int
read(fd,buf,cnt)
int fd;
void *buf;
unsigned cnt;
{
	int type = _fd_type(fd);

	if(fd < 0){
		errno = EINVAL;
		return -1;
	}
	switch(type){
	case _FL_FILE:
		return _READ(fd,buf,cnt);
	case _FL_SOCK:
		return recv(fd,buf,cnt,0);
	case _FL_ASY:
		return asy_read(fd,buf,cnt);
	default:
		errno = EINVAL;
		return -1;
	}
}
int
write(fd,buf,cnt)
int fd;
const void *buf;
unsigned cnt;
{
	int type = _fd_type(fd);

	if(fd < 0){
		errno = EINVAL;
		return -1;
	}
	switch(type){
	case _FL_FILE:
		return _WRITE(fd,buf,cnt);
	case _FL_SOCK:
		return send(fd,(char *)buf,cnt,0);
	case _FL_ASY:
		return asy_write(fd,(char *)buf,cnt);
	default:
		errno = EINVAL;
		return -1;
	}
}

/* This entry point is provided for applications that want to call open()
 * directly, instead of using fopen()
 */
int
open(file,mode)
const char *file;
int mode;
{
	return _open(file,mode);
}

int
close(fd)
int fd;
{
	int type = _fd_type(fd);

	if(fd < 0){
		errno = EINVAL;
		return -1;
	}
	switch(type){
	case _FL_FILE:
		return _CLOSE(fd);
	case _FL_SOCK:
		return close_s(fd);
	case _FL_ASY:
		return asy_close(fd);
	default:
		errno = EINVAL;
		return -1;
	}
}

void
fcloseall()
{
	FILE *fp,*fpnext;

	flushall();
	for(fp = _Files;fp != NULLFILE;fp=fpnext){
		fpnext = fp->next;
		fclose(fp);
	}
}
void
flushall()
{
	FILE *fp;

	for(fp = _Files;fp != NULLFILE;fp=fp->next){
		fflush(fp);
	}
}
FILE *
fdup(fp)
FILE *fp;
{
	FILE *nfp;

	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return NULLFILE;	/* Invalid arg */
	switch(fp->type){
	case _FL_FILE:
		/* Allocate new file pointer structure so each can
		 * have its own read/write pointer and buffering
		 */
		if((nfp = _fcreat()) == NULLFILE)
			return NULLFILE;
		nfp->fd = _DUP(fp->fd);
		nfp->offset = fp->offset;
		nfp->type = fp->type;
		nfp->bufmode = fp->bufmode;
		nfp->flags = fp->flags;
		strcpy(nfp->eol,fp->eol);
		nfp->bufsize = fp->bufsize;
		nfp->ptr = strdup(fp->ptr);
		fp = nfp;
		break;
	default:	/* These just share the same file pointer */
		fp->refcnt++;
		break;
	}
	return fp;
}
char *
fpname(fp)
FILE *fp;
{
	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return NULLCHAR;
	if(fp->type == _FL_FILE)
		return fp->ptr;
	return NULLCHAR;
}

void
exit(n)
int n;
{
	fcloseall();
	_exit(n);
}

int
dofiles(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	FILE *fp;
	int i;
	int flags;

	printf("fp       fd   ref  eol   type mod buf  flags\n");
	for(fp = _Files;fp != NULLFILE;fp = fp->next){
		printf("%8lx ",ptol(fp));
		if(fp->fd != -1)
			printf("%-4d",fp->fd);
		else
			printf("    ");
		printf(" %-3d ",fp->refcnt);
		for(i=0;i<EOL_LEN-1;i++){
			if(fp->eol[i] != '\0')
				printf(" %02x",fp->eol[i]);
			else
				printf("   ");
		}
		flags = fp->flags;
		switch(fp->type){
		case _FL_SOCK:
			printf(" sock");
			break;
		case _FL_FILE:
			printf(" file");
			break;
		case _FL_DISPLAY:
			printf(" disp");
			break;
		case _FL_PIPE:
			printf(" pipe");
			break;
		case _FL_ASY:
			printf(" asy");
		}
		printf("%4s",(flags & _FL_ASCII) ? " txt" : " bin");
		switch(fp->bufmode){
		case _IONBF:
			printf(" none");
			break;
		case _IOLBF:
			printf(" line");
			break;
		case _IOFBF:
			printf(" full");
			break;
		}
		if(flags & _FL_EOF)
			printf(" EOF");
		if(flags & _FL_ERR)
			printf(" ERR");
		if(flags & _FL_APPEND)
			printf(" APND");
		if(flags & _FL_TMP)
			printf(" TMP");
		if(fp->type == _FL_FILE && fp->ptr != NULLCHAR)
			printf(" (%s seek=%lu)",(char *)fp->ptr,ftell(fp));
		putchar('\n');
	}
	return 0;
}
@


1.21
log
@Remove erroneous range limit checks on file descriptors, let lower
level routines check them.
@
text
@d30 1
a30 1
long _lseek __ARGS((int fd,long offset,int whence));
d32 3
a34 3
static void _fclose __ARGS((FILE *fp));
static struct mbuf *_fillbuf __ARGS((FILE *fp,int cnt));
static FILE *_fcreat __ARGS((void));
@


1.20
log
@Major changes to way file descriptors are distingushed. The top bits
now distinguish between files, sockets, displays, pipes and asynch
ports. Also create routines for asynch port I/O.
@
text
@a1061 4
		if(fd >= Nfiles){
			errno = EINVAL;
			return -1;
		}
a1063 4
		if(fd >= Nsock){
			errno = EINVAL;
			return -1;
		}
a1095 4
		if(fd >= Nfiles){
			errno = EINVAL;
			return -1;
		}
a1097 4
		if(fd >= Nsock){
			errno = EINVAL;
			return -1;
		}
@


1.19
log
@Bug fixes suggested by Glenn McGregor
Change strcpy of eol sequences to memcpy to avoid clobbering memory
with trailing nulls
Change flow control logic on pipes to avoid deadlocks
@
text
@d20 1
d126 1
a126 4
	if(handle >= Nfiles)
		fp->type = _FL_SOCK;
	else
		fp->type = _FL_FILE;
d165 26
d192 4
d409 1
a409 1
	if(c == EOF || !(fp->flags & _FL_ASCII) || c != fp->eol[0])
d464 6
d543 22
d755 1
d761 7
d838 9
a846 3
		if(fp->ibuf == NULLBUF && _fillbuf(fp,bytes) == NULLBUF){
			/* Must have hit eof or had error */
			return tot/size;
d880 1
d882 3
a884 3
		fprintf(stderr,"%s: %s\n",s,sys_errlist[errno]);
	else if(errno <= EMAX)
		fprintf(stderr,"%s: %s\n",s,Sock_errlist[errno-36]);
d886 1
a886 1
		fprintf(stderr,"%s: errno %d\n",s,errno);
d980 3
d1030 3
a1032 1
	if(fd < 0 || fd >= Nfiles+Nsock){
d1035 3
a1037 1
	} else if(fd < Nfiles)
d1039 1
a1039 1
	else
d1041 6
d1054 3
a1056 1
	if(fd < 0 || fd >= Nfiles+Nsock){
d1059 7
a1065 1
	} else if(fd < Nfiles)
d1067 5
a1071 1
	else
d1073 6
d1096 3
a1098 1
	if(fd < 0 || fd >= Nfiles+Nsock){
d1101 7
a1107 1
	} else if(fd < Nfiles)
d1109 5
a1113 1
	else
d1115 6
d1131 1
a1131 2
		if(fp->fd > 2)
			fclose(fp);
d1168 1
a1168 3
	case _FL_SOCK:	/* These just share the same file pointer */
	case _FL_DISPLAY:
	case _FL_PIPE:
d1203 1
a1203 1
	printf("fp       fd  ref  eol   type mod buf  flags\n");
d1207 1
a1207 1
			printf("%-3d",fp->fd);
d1209 1
a1209 1
			printf("   ");
d1231 2
@


1.18
log
@Create open() function that calls _open(), for convenience of code
that doesn't use stdio
@
text
@d333 1
a333 1
		strcpy(&bp->data[bp->cnt],fp->eol);
d413 2
d589 1
a589 1
		strcpy(fp->ibuf->data,fp->eol);
d663 1
a663 1
					strcpy(ocp,fp->eol);
a707 1
		psignal(&fp->obuf,1);	/* Reawaken writer, if any */
d802 2
@


1.17
log
@fflush stream before changing buffer size in setvbuf, not after
@
text
@d11 1
d974 11
@


1.16
log
@Add third param to displayopen to set scrollback file size, passed on
to newdisplay()
Experimental optimization added to fseek(), then ifdef'ed out -- not
sure if it's correct in presence of buffering and arbitrary read/write
patterns
@
text
@d822 1
a838 1
	fflush(fp);
@


1.15
log
@Call newdisplay with rows and cols = 0 to invoke new default, which
is the physical size of the screen in its current mode
@
text
@d169 1
a169 1
displayopen(mode,noscrol)
d172 1
d189 1
a189 1
	fp->ptr = newdisplay(0,0,noscrol);
d538 5
@


1.14
log
@Add cast in write
@
text
@d188 1
a188 1
	fp->ptr = newdisplay(NROWS,NCOLS,noscrol);
@


1.13
log
@s920612
@
text
@d957 1
a957 1
void *buf;
d966 1
a966 1
		return send(fd,buf,cnt,0);
@


1.12
log
@s920603
@
text
@d83 1
a83 1
				remove(filename);
d916 1
a916 1
		remove(fp->ptr);
@


1.11
log
@s920601
@
text
@d147 1
a147 1
/* Create a stream in loopback mode (whatever is written can be
d151 1
a151 1
loopopen()
d159 1
a159 1
	fp->type = _FL_LOOP;
d432 1
a432 1
	case _FL_LOOP:
d695 1
a695 1
	case _FL_LOOP:
d1030 1
a1030 1
	case _FL_LOOP:
d1090 2
a1091 2
		case _FL_LOOP:
			printf(" loop");
@


1.10
log
@src0521
@
text
@d26 1
d32 1
d35 1
d80 1
a80 2
		fp = (FILE *)calloc(1,sizeof(FILE));
		if(fp == NULLFILE){
a85 6
		fp->cookie = _COOKIE;
		fp->refcnt = 1;
		fp->next = _Files;
		_Files = fp;
		if(fp->next != NULLFILE)
			fp->next->prev = fp;
d88 1
d119 1
a119 2
	fp = (FILE *)calloc(1,sizeof(FILE));
	if(fp == NULLFILE)
a121 6
	fp->cookie = _COOKIE;
	fp->next = _Files;
	_Files = fp;
	if(fp->next != NULLFILE)
		fp->next->prev = fp;

d124 1
a124 1
	if(handle >= SOCKBASE)
d155 1
a155 2
	fp = (FILE *)calloc(1,sizeof(FILE));
	if(fp == NULLFILE)
a157 7
	fp->cookie = _COOKIE;
	fp->refcnt = 1;
	fp->next = _Files;
	_Files = fp;
	if(fp->next != NULLFILE)
		fp->next->prev = fp;

d179 1
a179 2
	fp = (FILE *)calloc(1,sizeof(FILE));
	if(fp == NULLFILE)
a180 6
	fp->cookie = _COOKIE;
	fp->refcnt = 1;
	fp->next = _Files;
	_Files = fp;
	if(fp->next != NULLFILE)
		fp->next->prev = fp;
d443 3
a445 1
				fseek(fp,0L,SEEK_END);
d447 2
d531 4
a534 1
	if(fp == NULLFILE || fp->cookie != _COOKIE || fp->type != _FL_FILE)
d536 1
d539 16
a554 2
	if(whence == SEEK_CUR)
		offset -= len_p(fp->ibuf);
a556 2
	if(_LSEEK(fp->fd,offset,whence) == -1)
		return -1;
d567 1
a567 1
	return tell(fp->fd) - len_p(fp->ibuf);
d612 8
a619 1
		if((cnt = _WRITE(fp->fd,icp,bytes)) != bytes)
d712 1
d722 1
d757 5
a761 1
			if((tot = _READ(fp->fd,ocp,bytes)) != bytes)
a900 1
		fp->fd = -1;
d904 1
a904 1
		fp->fd = -1;
d915 1
a915 1
	if(fp->flags & _FL_TMP)
d920 18
d939 1
d946 4
a949 1
	if(fd < SOCKBASE)
d960 4
a963 1
	if(fd < SOCKBASE)
d973 4
a976 1
	if(fd < SOCKBASE)
d1007 2
d1010 24
a1033 2
		return NULLFILE;
	fp->refcnt++;
d1065 1
a1065 1
	printf("fp       fd  ref  eol   flags\n");
d1067 6
a1072 1
		printf("%8lx %-3d %-3d ",ptol(fp),fp->fd,fp->refcnt);
d1082 1
a1082 1
			printf(" SOCK");
d1085 1
a1085 1
			printf(" FILE");
d1088 1
a1088 1
			printf(" DISP");
d1091 1
a1091 1
			printf(" LOOP");
d1094 1
a1094 1
		printf("%4s",(flags & _FL_ASCII) ? " TXT" : " BIN");
d1097 1
a1097 1
			printf(" UBUF");
d1100 1
a1100 1
			printf(" LBUF");
d1103 1
a1103 1
			printf(" FBUF");
d1115 1
a1115 1
			printf(" (%s)",(char *)fp->ptr);
@


1.9
log
@src0518
@
text
@d892 3
d896 1
a896 1
		close(fp->fd);
@


1.8
log
@src0514
@
text
@d20 9
d71 1
a71 1
	if(fd == -1){
d73 1
a73 1
	}
d95 1
a95 1
	if(textmode){
a96 1
	}
d552 1
a552 1
	if(fp == NULLFILE || fp->cookie != _COOKIE)
d554 4
a557 5
	if(fp->type != _FL_FILE)
		return -1;
	fflush(fp);
	if(lseek(fp->fd,offset,whence) == -1)
		return -1;
d560 2
d569 1
a569 3
	if(fp == NULLFILE || fp->cookie != _COOKIE)
		return -1;
	if(fp->type != _FL_FILE)
d572 1
a572 1
	return tell(fp->fd);
d695 2
a696 1
			pwait(&fp->ibuf);	/* Wait for something */
d702 1
a702 1
		 && errno != EINTR){
@


1.7
log
@src0505
@
text
@d149 27
d201 1
d296 1
a296 1
	int len,withargs;
d299 2
a306 1
		len = strlen(fmt);
d312 1
a312 1
		buf = mallocw(fp->bufsize);
a313 1
		len = strlen(buf);
d315 4
a318 2
	if(fputs(buf,fp) == EOF)
		len = -1;
d321 1
a321 1
	return len;
d344 1
a344 1
		fp->obuf = ambufw(fp->bufsize);
d393 2
d422 2
d439 1
a439 1
	if(fp == NULLFILE){
d449 6
d486 2
d502 2
d544 2
d560 2
d573 3
d596 1
d598 3
a600 2
	int newlines;
	int eollen;
d602 1
a602 1
	if(size == 0)
d608 1
a608 1
	if(fp->type == _FL_FILE && !(fp->flags & _FL_ASCII) && bytes >= BUFSIZ){
a613 1

d617 1
a617 1
		if(newlines != 0)
d619 3
a621 2
	} else {
		newlines = 0;
d623 18
a640 9
	if((fp->flags & _FL_ASCII) && newlines != 0){
		/* Copy to buffer, expanding newlines */
		while(bytes != 0){
			bp = fp->obuf;
			if(bp == NULLBUF || bp->cnt + EOL_LEN > bp->size){
				if(fflush(fp) == EOF)
					return (bytes - n*size)/size;
				bp = fp->obuf = ambufw(fp->bufsize);
			}
d643 1
a643 1
			for(;room >= EOL_LEN && bytes != 0;icp++,bytes--){
d648 1
d655 2
a656 16
			if(room < EOL_LEN || fp->bufmode == _IONBF
			 || ((fp->bufmode == _IOLBF) && newlines != 0)){
				if(fflush(fp) == EOF)
					return (bytes - n*size)/size;
			}
		}
	} else {
		/* Copy binary input to buffer */
		while(bytes != 0){
			bp = fp->obuf;
			if(bp == NULLBUF || bp->cnt == bp->size){
				if(fflush(fp) == EOF)
					return (bytes - n*size)/size;

				bp = fp->obuf = ambufw(fp->bufsize);
			}
a661 4
			if(fp->bufmode == _IONBF || bp->cnt == bp->size){
				if(fflush(fp) == EOF)
					return (bytes - n*size)/size;
			}
d664 9
d686 5
d700 1
a700 4
		if(fp->bufmode == _IONBF)
			cnt = min(fp->bufsize,cnt);
		else
			cnt = fp->bufsize;
d734 1
a734 1
	if(size == 0)
d798 2
d810 1
d879 1
a879 1
	if(fp == NULLFILE)
d928 1
d961 1
a961 1
	if(fp == NULLFILE)
d970 2
d995 1
a995 1
	printf("fp       fd  ref  eol   flags                         file\n");
d1015 3
d1019 1
d1028 1
a1028 1
			printf("     ");
d1031 8
a1038 6
		printf("%4s%4s%4s%5s%4s",
		(flags & _FL_ASCII) ? " TXT" : " BIN",
		(flags & _FL_EOF) ? " EOF" : "",
		(flags & _FL_ERR) ? " ERR" : "",
		(flags & _FL_APPEND) ? " APND" : "",
		(flags & _FL_TMP) ? " TMP" : "");
d1040 1
a1040 1
			fputs((char *)fp->ptr,stdout);
@


1.6
log
@src0503
@
text
@d18 1
d83 3
a85 1
	fp->fname = strdup(filename);
d125 1
d127 3
a129 1
		fp->flags |= _FL_SOCK;
d137 2
a138 1
	if(fp->flags & _FL_SOCK)
d140 2
a141 1
	else
d143 23
d167 9
d177 3
d183 1
d323 2
a324 2
	if(bp->cnt == bp->size || (fp->flags & _FL_UNBUF)
	 || ((fp->flags & _FL_LBUF) && eol)){
d414 2
a415 1
	if(fp->flags & _FL_SOCK){
d417 21
a437 12
	} else do {
		if(fp->flags & _FL_APPEND)
			fseek(fp,0L,SEEK_END);
		cnt = _WRITE(fp->fd,bp->data,bp->cnt);
		if(cnt != bp->cnt){
			fp->flags |= _FL_ERR;
			free_p(bp);
			return EOF;
		}
		bp = free_mbuf(bp);
	} while(bp != NULLBUF);
	return 0;
d500 1
a500 1
	if(fp->flags & _FL_SOCK)
d514 1
a514 1
	if(fp->flags & _FL_SOCK)
d555 1
a555 1
	if(!(fp->flags & (_FL_SOCK|_FL_ASCII)) && bytes >= BUFSIZ){
d592 2
a593 2
			if(room < EOL_LEN || (fp->flags & _FL_UNBUF)
			 || ((fp->flags & _FL_LBUF) && newlines != 0)){
d613 1
a613 1
			if((fp->flags & _FL_UNBUF) || bp->cnt == bp->size){
d631 2
a632 1
	if(fp->flags & _FL_SOCK){
d639 21
a659 14
	}
	/* Read from file */
	if(fp->flags & _FL_UNBUF)
		cnt = min(fp->bufsize,cnt);
	else
		cnt = fp->bufsize;
	bp = ambufw(cnt);		
	cnt = _READ(fp->fd,bp->data,cnt);
	if(cnt < 0)
		fp->flags |= _FL_ERR;
	if(cnt == 0)
		fp->flags |= _FL_EOF;
	if(cnt <= 0){
		free_p(bp);	/* Nothing successfully read */
d662 1
a662 4
	/* Buffer successfully read, store it */
	bp->cnt = cnt;
	fp->ibuf = bp;
	return bp;
d686 2
a687 1
		if(fp->ibuf == NULLBUF && !(fp->flags & (_FL_SOCK|_FL_ASCII))
a745 1
		fp->flags &= ~(_FL_LBUF|_FL_UNBUF);
a748 2
		fp->flags |= _FL_LBUF;
		fp->flags &= ~_FL_UNBUF;
a749 1
		fflush(fp);
a751 3
		fp->flags |= _FL_UNBUF;
		fp->flags &= ~_FL_LBUF;
		fflush(fp);
d756 2
a757 1

d776 1
a776 1
	char fname[15];
d778 1
d784 6
a789 2
	if((tmpdir = getenv("TMP")) != NULLCHAR
	 && stat(tmpdir,&statbuf) == 0 && (statbuf.st_mode & S_IFDIR)){
d791 4
a794 1
		tmpdir = Tmpdir;
d796 2
a797 1
		tmpdir = "";
d805 5
a809 3
	if((fp = fopen(fname,"w+b")) == NULLFILE)
		return NULLFILE;
	fp->flags |= _FL_TMP;
d823 11
a833 2
	close(fp->fd);
	fp->fd = -1;
d839 3
a841 3
		remove(fp->fname);
	free(fp->fname);
	fp->fname = NULLCHAR;
a902 2
	if(fp->flags & _FL_SOCK)
		usesock(fp->fd);
d906 8
d943 23
a965 2
		printf("%5s%4s%4s%4s%5s%5s%4s",
		(flags & _FL_SOCK) ? " SOCK" : " FILE",
a968 1
		(flags & _FL_UNBUF) ? " UBUF" : ((flags & _FL_LBUF) ? " LBUF" : ""),
d971 2
a972 2
		if(fp->fname != NULLCHAR)
			fputs(fp->fname,stdout);
@


1.5
log
@src0501
@
text
@a20 1
static int _fgetc __ARGS((FILE *fp));
d32 1
a32 1
	int binmode = 0;
d54 2
a55 2
	if(strchr(mode,'b') != NULLCHAR)
		binmode = 1;
a65 1
		memset((char *)fp,0,sizeof(FILE));
d69 1
a69 1
			close(fd);
d75 1
d82 2
a83 1
	if(!binmode){
a84 1
		strcpy(fp->eol,"\r\n");	/* TEMP */
d89 1
d99 1
a99 1
	int binmode = 0;
d105 1
a105 1
	if(strchr(mode,'a') != NULLCHAR){
d107 3
a109 3
	}
	if(strchr(mode,'b') != NULLCHAR)
		binmode = 1;
d124 1
a124 1
	if(!binmode){
a125 2
		strcpy(fp->eol,"\r\n");	/* TEMP */
	}
d128 1
d130 7
d279 1
a279 1
	if(bp->cnt == bp->size || fp->flags & _FL_UNBUF
d340 1
a340 1
static int
d346 1
d361 4
d407 1
a407 1
	prev = (fp->flags & _FL_ASCII) ? 1 : 0;
d427 2
d480 1
a480 1
int
d483 2
a484 2
int size;
int n;
d489 2
a490 2
	int bytes;
	int cnt;
d499 9
d510 1
a510 9
		for(newlines=0;;newlines++){
			cnt = bytes - (icp - (char *)ptr);
			if(cnt == 0)
				break;
			if((icp = memchr(icp,'\n',cnt)) == NULLCHAR)
				break;
			icp++;
		}
		icp = (char *)ptr;
d579 2
a580 1
		if(recv_mbuf(fp->fd,&fp->ibuf,0,NULLCHAR,0) <= 0)
d582 1
d605 1
a605 1
int
d608 1
a608 1
int size,n;
d612 2
a613 2
	int bytes;
	int cnt;
d615 1
a615 1
	int tot = 0;
d623 1
d626 7
a667 2
	puts(s);
	puts(": ");
d669 3
a671 1
		puts(sys_errlist[errno]);
d673 1
a673 2
		printf("errno %d",errno);
	putc('\n',stdout);
d693 1
d698 1
d723 1
d725 11
d737 1
a737 1
		sprintf(fname,"/tmp/temp.%03d",num);
a744 1
	fp->fname = strdup(fname);
d747 4
a750 1
/* Do everything to close a stream except freeing the descriptor */
d758 2
a759 4
	if(fp->flags & _FL_SOCK)
		close_s(fp->fd);
	else
		close(fp->fd);
d761 1
d763 2
a764 1
	if(fp->flags & _FL_TMP){
d766 34
a799 2
		free(fp->fname);
	}
d801 1
d823 12
d841 35
@


1.4
log
@src0429
@
text
@a18 5
FILE *_Files;
FILE *stdin;
FILE *stdout;
FILE *stderr;

d23 2
a24 18
void
stdio_init()
{
	stdin = fdopen(0,"r+t");
	stdin->flags |= _FL_ASCII | _FL_LBUF;
	strcpy(stdin->eol,"\r\n");
	stdin->bufsize = BUFSIZ;

	stdout = fdopen(1,"r+t");
	stdout->flags |= _FL_ASCII | _FL_LBUF;
	strcpy(stdout->eol,"\r\n");
	stdout->bufsize = BUFSIZ;

	stderr = fdopen(2,"r+t");
	stderr->flags |= _FL_ASCII | _FL_LBUF;
	strcpy(stderr->eol,"\r\n");
	stderr->bufsize = BUFSIZ;
}
a374 1
#ifdef	notdef
a386 1
#endif
d398 1
a398 1
	case 1:	/* Turn on ascii translation */
d401 1
a401 1
	case 0:	/* Turn it off */
@


1.3
log
@src0429a
@
text
@a436 1
		cprintf("fclose: invalid fp %lx\r\n",ptol(fp));
@


1.2
log
@s920423
@
text
@d436 1
a436 1
	if(fp == NULLFILE || fp->cookie != _COOKIE)
d438 2
@


1.1
log
@Initial revision
@
text
@d19 5
a23 1
FILE _Files[3];
d25 2
d31 14
a44 8
	int i;

	for(i=0;i<=2;i++){
		_Files[i].fd = i;
		_Files[i].flags = _FL_ASCII | _FL_LBUF;
		strcpy(_Files[i].eol,"\r\n");
		_Files[i].bufsize = BUFSIZ;
	}
d97 5
d104 1
a104 1
	if(!binmode)
d106 2
d135 7
d145 1
a145 1
	if(!binmode)
d147 2
d190 2
a191 2
	while(len-- > 1){
		if((c = getc(fp)) == EOF)
d193 1
a193 1

d270 3
a272 1
	char c1;
d274 9
a282 2
	c1 = c;
	if(fwrite(&c1,1,1,fp) == EOF)
d284 15
d321 4
a324 1
	return fputs(s,stdout);
d332 1
a332 1
	char c;
d334 26
a359 2
	if(fread(&c,1,1,fp) == EOF)
		return EOF;
d361 4
a364 1
	return uchar(c);
d366 1
d375 18
a392 17
	if(fp->obuf != NULLBUF){
		bp = fp->obuf;
		fp->obuf = NULLBUF;
		if(fp->flags & _FL_SOCK){
			return send_mbuf(fp->fd,bp,0,NULLCHAR,0);
		} else do {
			if(fp->flags & _FL_APPEND)
				fseek(fp,0L,SEEK_END);
			cnt = _WRITE(fp->fd,bp->data,bp->cnt);
			if(cnt != bp->cnt){
				fp->flags |= _FL_ERR;
				free_p(bp);
				return EOF;
			}
			bp = free_mbuf(bp);
		} while(bp != NULLBUF);
	}
d436 2
d439 7
d457 1
a459 1
	fflush(fp);
d503 3
a505 1

d512 2
d516 1
a516 1

d530 1
a530 1
					return -1;
d549 1
a549 1
					return -1;
d558 2
a559 1
					return -1;
d569 1
a569 1
					return -1;
d575 36
d612 1
a612 1
fread(ptr,n,size,fp)
d614 1
a614 1
int n,size;
d623 1
d625 3
d632 3
a634 24
		if(fp->ibuf == NULLBUF){
			if(fp->flags & _FL_SOCK){
				if(recv_mbuf(fp->fd,&fp->ibuf,0,NULLCHAR,0) <= 0)
					return EOF;
			} else {
				/* Read from file */
				if(fp->flags & _FL_UNBUF)
					cnt = min(fp->bufsize,bytes);
				else
					cnt = fp->bufsize;
				bp = ambufw(cnt);		
				cnt = _READ(fp->fd,bp->data,cnt);
				if(cnt < 0){
					fp->flags |= _FL_ERR;
					free_p(bp);
					return EOF;
				}
				if(cnt == 0){
					free_p(bp);
					bp = NULLBUF;
				}
				bp->cnt = cnt;
				fp->ibuf = bp;
			}	
d636 5
a640 5
		if((bp = fp->ibuf) == NULLBUF){
			/* Still empty, we've hit eof */
			fp->flags |= _FL_EOF;
			return tot / size;
		}
d643 3
a645 15
		 && memchr(bp->data,fp->eol[0],cnt) != NULLCHAR){
			/* Do newline conversion */
			while(cnt-- != 0 && bp != NULLBUF){
				c = PULLCHAR(&bp);
				if(c == fp->eol[0]){
					*ocp++ = '\n';
					(void)PULLCHAR(&bp);
				} else {
					*ocp++ = c;
				}
				tot++;
				bytes--;
			}
			fp->ibuf = bp;
		} else {
d647 1
d650 8
d751 28
@
