head	1.7;
access;
symbols;
locks;
comment	@ * @;


1.7
date	93.03.15.05.01.29;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.09.08.08.24.50;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.30.11.10.10;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.05.11.04.22.04;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.05.01.12.28.48;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	92.04.09.08.58.22;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.22.28;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.7
log
@Restructuring of file descriptors for sockets
@
text
@/* Socket status display code
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "lzw.h"
#include "usock.h"
#include "socket.h"
#include "commands.h"

/* Socket status display command */
int
dosock(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct usock *up;
	int s,i,n;
	struct sockaddr fsock;
	struct socklink *sp;
	char *cp;

	if(argc < 2){
		printf("S#   Type    PCB      Remote socket         Owner\n");
		for(n=0;n<Nsock;n++){
			s = _mk_fd(n,_FL_SOCK);
			up = itop(s);
			if(up == NULLUSOCK)
				continue;

			i = sizeof(fsock);
			if(getpeername(s,(char *)&fsock,&i) == 0 && i != 0)
				cp = psocket(&fsock);
			else
				cp = "";

			printf("%4d %-8s%-8lx %-22s%-8lx %-10s\n",
			 s,Socktypes[up->type],ptol(up->cb.p),cp,
			 ptol(up->owner),up->owner->name);
		}
		return 0;
	}
	s = atoi(argv[1]);
	if(_fd_type(s) != _FL_SOCK){
		printf("Not a valid socket\n");
		return 1;
	}
	up = itop(s);
	if(up == NULLUSOCK){
		printf("Socket not in use\n");
		return 1;
	}
	sp = up->sp;
	printf("%s %lx\n",Socktypes[up->type],ptol(up->cb.p));
	if(up->cb.p == NULL)
		return 0;
	if(sp->status != NULLFP)
		(*sp->status)(up);
	return 0;	
}

@


1.6
log
@Have "socket not in use" return 1 so as to cause the repeat command
to exit
@
text
@d21 1
a21 1
	int s,i;
d27 3
a29 2
		printf("S#  Type    PCB      Remote socket         Owner\n");
		for(s=Nfiles;s<Nsock+Nfiles;s++){
d40 1
a40 1
			printf("%3d %-8s%-8lx %-22s%-8lx %-10s\n",
d47 2
a48 2
	if(s < Nfiles || s >= Nsock+Nfiles){
		printf("Number out of range\n");
@


1.5
log
@s920601
@
text
@d53 1
a53 1
		return 0;
@


1.4
log
@src0514
@
text
@d28 1
a28 1
		for(s=SOCKBASE;s<Nusock+SOCKBASE;s++){
d46 1
a46 1
	if(s < SOCKBASE || s >= Nusock+SOCKBASE){
@


1.3
log
@src0501
@
text
@a60 4
	if(up->zout != NULLLZW)
		printf("Compressed %ld bytes.\n",up->zout->cnt);
	if(up->zin != NULLLZW)
		printf("Decompressed %ld bytes.\n",up->zin->cnt);
@


1.2
log
@src0410
@
text
@d27 1
a27 1
		tprintf("S#  Type    PCB      Remote socket         Owner\n");
d39 1
a39 1
			tprintf("%3d %-8s%-8lx %-22s%-8lx %-10s\n",
d47 1
a47 1
		tprintf("Number out of range\n");
d52 1
a52 1
		tprintf("Socket not in use\n");
d56 1
a56 8
	tprintf("%s %lx %s",Socktypes[up->type],ptol(up->cb.p),
	 up->flag == SOCK_ASCII ? "ascii" : "binary");
	if(up->eol[0] != '\0'){
		tprintf(" eol seq:");
		for(i=0;up->eol[i] != '\0' && i<sizeof(up->eol);i++)
			tprintf(" %02x",up->eol[i]);
	}
	tprintf("\n");
d62 1
a62 1
		tprintf("Compressed %ld bytes.\n",up->zout->cnt);
d64 1
a64 1
		tprintf("Decompressed %ld bytes.\n",up->zin->cnt);
@


1.1
log
@Initial revision
@
text
@a10 4
#include "ax25.h"
#include "netrom.h"
#include "tcp.h"
#include "udp.h"
a11 1
#include "config.h"
d23 1
d55 1
d66 2
a67 27
	switch(up->type){
	case TYPE_RAW:
	case TYPE_LOCAL_DGRAM:
		tprintf("Inqlen: %d packets\n",socklen(s,0));
		tprintf("Outqlen: %d packets\n",socklen(s,1));
		break;
	case TYPE_LOCAL_STREAM:
		tprintf("Inqlen: %d bytes\n",socklen(s,0));
		tprintf("Outqlen: %d bytes\n",socklen(s,1));
		break;
	case TYPE_TCP:
		st_tcp(up->cb.tcb);
		break;
	case TYPE_UDP:
		st_udp(up->cb.udp,0);
		break;
#ifdef	AX25
	case TYPE_AX25I:
		st_ax25(up->cb.ax25);
		break;
#endif
#ifdef	NETROM
	case TYPE_NETROML4:
		donrdump(up->cb.nr4);
		break;
#endif
	}
@
