head	1.16;
access;
symbols;
locks;
comment	@ * @;


1.16
date	93.01.02.08.30.46;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.12.28.09.03.05;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.09.08.08.28.26;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.06.13.05.21.44;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.06.03.22.08.16;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.05.18.07.15.10;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.14.10.37.50;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.04.11.24.04;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.03.13.27.02;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.01.10.17.34;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.10.06.48.18;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.03.29.03.32.24;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.09.22.11.46.02;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.06.01.05.03.14;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.08.00.00.40;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.15.44;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.16
log
@Reformat session summary by removing a few obsolete fields and
tightening a few others. Name field in session structure now
holds complete command line - show this on the end of the session line.
@
text
@/* NOS User Session control
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "ftpcli.h"
#include "icmp.h"
#include "telnet.h"
#include "tty.h"
#include "session.h"
#include "hardware.h"
#include "socket.h"
#include "cmdparse.h"
#include "commands.h"
#include "main.h"

struct session **Sessions;
struct session *Command;
struct session *Current;
struct session *Lastcurr;
char Notval[] = "Not a valid control block\n";
static char Badsess[] = "Invalid session\n";
char *Sestypes[] = {
	"",
	"Telnet",
	"FTP",
	"AX25",
	"Finger",
	"Ping",
	"NET/ROM",
	"Command",
	"More",
	"Hopcheck",
	"Tip",
	"PPP PAP",
	"Dial",
	"Query",
	"Cache",
	"Trace",
	"Repeat",
};

/* Convert a character string containing a decimal session index number
 * into a pointer. If the arg is NULLCHAR, use the current default session.
 * If the index is out of range or unused, return NULLSESSION.
 */
struct session *
sessptr(cp)
char *cp;
{
	unsigned int i;

	if(cp == NULLCHAR)
		return Lastcurr;

	i = (unsigned)atoi(cp);
	if(i >= Nsessions)
		return NULLSESSION;
	else
		return Sessions[i];
}

/* Select and display sessions */
int
dosession(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;
	struct sockaddr fsocket;
	int i,k,s,ses;
	int t;
	char *cp;

	sp = (struct session *)p;

	if(argc > 1){
		if((sp = sessptr(argv[1])) != NULLSESSION){
			go(0,NULL,sp);
		} else
			printf("Session %s not active\n",argv[1]);
		return 0;
	}
	printf(" #  S#  Snd-Q State     Remote socket         Command\n");
	for(ses=0;ses<Nsessions;ses++){
		sp = Sessions[ses];
		if(sp == NULLSESSION || sp->type == COMMAND)
			continue;

		t = 0;
		cp = NULLCHAR;
		if(sp->network != NULLFILE && (s = fileno(sp->network)) != -1){
			i = SOCKSIZE;
			k = getpeername(s,(char *)&fsocket,&i);
			t += socklen(s,1);
			cp = sockstate(s);
		} else {
			k = s = -1;
			t = 0;
			cp = NULLCHAR;
		}
		printf("%c", (Lastcurr == sp)? '*':' ');
		printf("%-3u",sp->index);
		printf("%-4d%5d %-10s",s,t,(cp != NULLCHAR) ? cp : "");
		printf("%-22s",(k == 0) ? psocket(&fsocket) : "");
		if(sp->name != NULLCHAR)
			printf("%s",sp->name);
		printf("\n");

		/* Display FTP data channel, if any */
		if(sp->type == FTP && (s = fileno(sp->cb.ftp->data)) != -1){
			i = SOCKSIZE;
			k = getpeername(s,(char *)&fsocket,&i);
			t += socklen(s,1);
			cp = sockstate(s);
			printf("    %-4d%5d %-10s",s,t,(cp != NULLCHAR) ? cp : "");
			printf("%-22s\n",(k == 0) ? psocket(&fsocket) : "");
		}
		if(sp->record != NULLFILE)
			printf("    Record: %s\n",fpname(sp->record));
		if(sp->upload != NULLFILE)
			printf("    Upload: %s\n",fpname(sp->upload));
	}
	return 0;
}
/* Resume current session, and wait for it */
int
go(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;

	sp = (struct session *)p;
	if(sp == NULLSESSION || sp->type == COMMAND)
		return 0;
	if(Current != Command)
		Lastcurr = Current;
	Current = sp;
	alert(Display,1);
	return 0;
}
int
doclose(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;

	sp = (struct session *)p;
	if(argc > 1)
		sp = sessptr(argv[1]);

	if(sp == NULLSESSION){
		printf(Badsess);
		return -1;
	}
	shutdown(fileno(sp->network),1);
	return 0;
}
int
doreset(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;

	sp = (struct session *)p;
	if(argc > 1)
		sp = sessptr(argv[1]);

	if(sp == NULLSESSION){
		printf(Badsess);
		return -1;
	}
	/* Unwedge anyone waiting for a domain resolution, etc */
	alert(sp->proc,EABORT);
	shutdown(fileno(sp->network),2);
	if(sp->type == FTP)
		shutdown(fileno(sp->cb.ftp->data),2);
	return 0;
}
int
dokick(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;

	sp = (struct session *)p;
	if(argc > 1)
		sp = sessptr(argv[1]);

	if(sp == NULLSESSION){
		printf(Badsess);
		return -1;
	}
	sockkick(fileno(sp->network));
	if(sp->type == FTP)
		sockkick(fileno(sp->cb.ftp->data));
	return 0;
}

int
dosfsize(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setlong(&Sfsize,"Scroll file size",argc,argv);	
}

struct session *
newsession(name,type,makecur)
char *name;
int type;
int makecur;
{
	register struct session *sp;
	int i;

	/* Search for a free slot in the session table */
	for(i=0;i < Nsessions;i++)
		if(Sessions[i] == NULLSESSION)
			break;
	if(i == Nsessions)
		return NULLSESSION;	/* All full */

	sp = Sessions[i] = (struct session *)calloc(1,sizeof(struct session));
	sp->index = i;
	sp->type = type;
	if(name != NULLCHAR)
		sp->name = strdup(name);
	sp->proc = Curproc;
	/* Create standard input and output sockets. Output is
	 * in text mode by default
	 */
	fclose(stdin);
	stdin =  sp->input = pipeopen();
	setvbuf(stdin,NULLCHAR,_IONBF,0);
	fclose(stdout);
	stdout = sp->output = displayopen("wt",0,Sfsize);

	/* on by default */
	sp->ttystate.crnl = sp->ttystate.edit = sp->ttystate.echo = 1;
	sp->parent = Current;
	if(makecur){
		Current = sp;
		alert(Display,1);
	}
	return sp;
}
void
freesession(sp)
struct session *sp;
{
	int i;

	if(sp == NULLSESSION || sp != Sessions[sp->index])
		return;	/* Not on session list */
	pwait(NULL);	/* Wait for any pending output to go */

	for(i=0;i<Nsessions;i++){
		if(Sessions[i]->parent == sp)
			Sessions[i]->parent = sp->parent;
	}
	Sessions[sp->index] = NULLSESSION;
	if(sp->proc1 != NULLPROC)
		killproc(sp->proc1);
	if(sp->proc2 != NULLPROC)
		killproc(sp->proc2);

	free(sp->ttystate.line);
	if(sp->network != NULLFILE)
		fclose(sp->network);

	if(sp->record != NULLFILE)
		fclose(sp->record);

	if(sp->upload != NULLFILE)
		fclose(sp->upload);

	free(sp->name);

	if(Lastcurr == sp)
		Lastcurr = sp->parent;
	if(Current == sp){
		Current = sp->parent;
		alert(Display,1);
	}
	free(sp);
}
/* Control session recording */
int
dorecord(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;
	char *mode;

	sp = (struct session *)p;
	if(sp == NULLSESSION){
		printf("No current session\n");
		return 1;
	}
	if(argc > 1){
		if(sp->record != NULLFILE){
			fclose(sp->record);
			sp->record = NULLFILE;
		}
		/* Open new record file, unless file name is "off", which means
		 * disable recording
		 */
		if(strcmp(argv[1],"off") != 0){
			if(fmode(sp->output,-1) == STREAM_ASCII)
				mode = APPEND_TEXT;
			else
				mode = APPEND_BINARY;

			if((sp->record = fopen(argv[1],mode)) == NULLFILE)
				printf("Can't open %s: %s\n",argv[1],sys_errlist[errno]);
		}
	}
	if(sp->record != NULLFILE)
		printf("Recording into %s\n",fpname(sp->record));
	else
		printf("Recording off\n");
	return 0;
}
/* Control file transmission */
int
doupload(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct session *sp;

	sp = (struct session *)p;
	if(sp == NULLSESSION){
		printf("No current session\n");
		return 1;
	}
	if(argc < 2){
		if(sp->upload != NULLFILE)
			printf("Uploading %s\n",fpname(sp->upload));
		else
			printf("Uploading off\n");
		return 0;
	}
	if(strcmp(argv[1],"stop") == 0 && sp->upload != NULLFILE){
		/* Abort upload */
		fclose(sp->upload);
		sp->upload = NULLFILE;
		killproc(sp->proc2);
		sp->proc2 = NULLPROC;
		return 0;
	}
	/* Open upload file */
	if((sp->upload = fopen(argv[1],READ_TEXT)) == NULLFILE){
		printf("Can't read %s: %s\n",argv[1],sys_errlist[errno]);
		return 1;
	}
	/* All set, invoke the upload process */
	sp->proc2 = newproc("upload",1024,upload,0,sp,NULL,0);
	return 0;
}
/* File uploading task */
void
upload(unused,sp1,p)
int unused;
void *sp1;
void *p;
{
	struct session *sp;
	char *buf;

	sp = (struct session *)sp1;

	buf = mallocw(BUFSIZ);
	while(fgets(buf,BUFSIZ,sp->upload) != NULLCHAR)
		if(fputs(buf,sp->network) == EOF)
			break;

	free(buf);
	fflush(sp->network);
	fclose(sp->upload);
	sp->upload = NULLFILE;
	sp->proc2 = NULLPROC;
}

/* Print prompt and read one character */
int
keywait(prompt,flush)
char *prompt;	/* Optional prompt */
int flush;	/* Flush queued input? */
{
	int c;
	int i;

	if(prompt == NULLCHAR)
		prompt = "Hit enter to continue"; 
	printf(prompt);
	fflush(stdout);
	c = _fgetc(stdin);
	/* Get rid of the prompt */
	for(i=strlen(prompt);i != 0;i--)
		putchar('\b');
	for(i=strlen(prompt);i != 0;i--)
		putchar(' ');
	for(i=strlen(prompt);i != 0;i--)
		putchar('\b');
	fflush(stdout);
	return (int)c;
}

/* Flush the current session's standard output. Called on every clock tick */
void
sesflush()
{
	if(Current != NULLSESSION)
		fflush(Current->output);
}
@


1.15
log
@Add dosfsize command to set scroll file size limit variable. Also
pass it to displayopen when creating a session
@
text
@d75 1
a75 1
	int r,t;
d87 1
a87 1
	printf(" #  S#  Type     Rcv-Q Snd-Q State        Remote socket\n");
a96 1
			s = fileno(sp->network);
a97 1
			r = socklen(s,0);
d101 2
a102 2
			s = -1;
			r = t = 0;
d107 2
a108 6
		printf("%-4d%-8s%6d%6d %-13s",
		 s,
		 Sestypes[sp->type],
		 r,
		 t,
		 (cp != NULLCHAR) ? cp : "");
d110 2
a111 3
			printf("%s ",sp->name);
		if(sp->network != NULLFILE && k == 0)
			printf("(%s)",psocket(&fsocket));
d113 1
a113 1
		printf("\n");
a114 1
			/* Display data channel, if any */
d117 1
a117 2
			r = socklen(s,0);
			t = socklen(s,1);
d119 2
a120 11
			printf("    %-4d%-8s%6d%6d %-13s%s",
			 s,
			 Sestypes[sp->type],
			 r,
			 t,
			 (cp != NULLCHAR) ? cp : "",
			 (sp->name != NULLCHAR) ? sp->name : "");
			if(k == 0)
				printf(" (%s)",psocket(&fsocket));
			if(printf("\n") == EOF)
				break;
@


1.14
log
@Add repeat session type
@
text
@d229 9
d267 1
a267 1
	stdout = sp->output = displayopen("wt",0);
@


1.13
log
@s920612
@
text
@d41 2
a42 1
	"Trace"
@


1.12
log
@s920603
@
text
@d261 1
a262 2
		if(Current != Command)
			Lastcurr = Current;
d272 2
d278 4
d301 1
a301 1
		Lastcurr = NULLSESSION;
d303 1
a303 4
		if(Lastcurr != NULLSESSION)
			Current = Lastcurr;
		else
			Current = Command;
@


1.11
log
@src0518
@
text
@d254 1
a254 1
	stdin =  sp->input = loopopen();
@


1.10
log
@src0514
@
text
@a22 3
int Row;
int Morewait;

d139 4
a142 4
		if(sp->rfile != NULLCHAR)
			printf("    Record: %s\n",sp->rfile);
		if(sp->ufile != NULLCHAR)
			printf("    Upload: %s\n",sp->ufile);
d158 2
d262 2
d284 1
a284 1
	if(sp->network != NULLFILE){
d286 2
a287 2
	}
	if(sp->record != NULLFILE){
d289 2
a290 3
	}
	free(sp->rfile);
	if(sp->upload != NULLFILE){
d292 1
a292 2
	}
	free(sp->ufile);
d295 2
d298 4
a301 1
		Current = Command;
a303 2
	if(Lastcurr == sp)
		Lastcurr = NULLSESSION;
d322 1
a322 1
		if(sp->rfile != NULLCHAR){
a323 1
			free(sp->rfile);
a324 1
			sp->rfile = NULLCHAR;
a336 2
			else
				sp->rfile = strdup(argv[1]);
d339 2
a340 2
	if(sp->rfile != NULLCHAR)
		printf("Recording into %s\n",sp->rfile);
d360 2
a361 2
		if(sp->ufile != NULLCHAR)
			printf("Uploading %s\n",sp->ufile);
a369 2
		free(sp->ufile);
		sp->ufile = NULLCHAR;
a378 1
	sp->ufile = strdup(argv[1]);
a403 2
	free(sp->ufile);
	sp->ufile = NULLCHAR;
@


1.9
log
@src0505
@
text
@d19 1
a19 1
struct session *Sessions;
a54 1
	register struct session *sp;
d57 2
a58 11
	if(cp == NULLCHAR){
		sp = Lastcurr;
	} else {
		i = (unsigned)atoi(cp);
		if(i >= Nsessions)
			sp = NULLSESSION;
		else
			sp = &Sessions[i];
	}
	if(sp == NULLSESSION || sp->type == FREE)
		sp = NULLSESSION;
d60 5
a64 1
	return sp;
d76 1
a76 1
	int i,k,s;
d90 3
a92 2
	for(sp=Sessions; sp < &Sessions[Nsessions];sp++){
		if(sp->type == FREE || sp->type == COMMAND)
d110 1
a110 1
		printf("%-3u", (unsigned)(sp - Sessions));
d159 1
a159 1
	if(sp == NULLSESSION || sp->type == FREE || sp->type == COMMAND)
d238 3
a240 2
	for(i=0,sp=Sessions;i < Nsessions;sp++,i++)
		if(sp->type == FREE)
d243 1
a243 1
		return NULLSESSION;
d245 2
a247 1
	sp->network = NULLFILE;
d255 2
a256 2
	i = socket(AF_LOCAL,SOCK_STREAM,0);
	stdin =  sp->input = fdopen(i,"r+t");
a261 3
	sp->flowmode = 1;	/* On by default */
	sp->row = MOREROWS;
	sp->morewait = 0;
d272 2
a273 2
	if(sp == NULLSESSION)
		return;
d276 1
a278 1
	sp->proc1 = NULLPROC;
a280 1
	sp->proc2 = NULLPROC;
d282 1
a282 2
	free_p(sp->ttystate.line);
	sp->ttystate.line = NULLBUF;
a284 1
		sp->network = NULLFILE;
a287 1
		sp->record = NULLFILE;
a289 1
	sp->rfile = NULLCHAR;
a291 1
		sp->upload = NULLFILE;
a293 1
	sp->ufile = NULLCHAR;
a294 5
	sp->name = NULLCHAR;
	sp->type = FREE;

	sp->input = NULLFILE;
	sp->output = NULLFILE;
d302 1
d439 7
@


1.8
log
@src0503
@
text
@d43 2
a44 1
	"Cache"
a99 2
		/* Rcv-Q includes output pending at the screen driver */
		r = socklen(fileno(sp->output),1);
d102 1
a102 1
		if((s = fileno(sp->network)) != -1){
d106 1
a106 1
			r += socklen(s,0);
d109 4
d167 1
a167 2
	swapscreen(Command,sp);
	psignal(sp,0);
d255 1
a255 1
	 * translated to local end-of-line by default
d261 1
a261 2
	i = socket(AF_LOCAL,SOCK_STREAM,0);
	stdout = sp->output = fdopen(i,"r+t");
a267 1
	newscreen(sp);
a268 1
		swapscreen(Current,sp);
d270 1
a280 1
	rflush();
a313 1
	freescreen(sp);
a315 1
		swapscreen(NULLSESSION,Command);
@


1.7
log
@src0501
@
text
@d255 1
d257 2
a258 3
	stdin =  sp->input = fdopen(i,"r+");
	seteol(stdin,Eol);
	fmode(stdin,STREAM_ASCII);
d260 1
a260 3
	stdout = sp->output = fdopen(i,"r+");
	seteol(stdout,Eol);
	fmode(stdout,STREAM_ASCII);
d292 1
a292 1
	if(sp->network != NULLFILE)
d294 2
a311 1
	fclose(sp->input);
a312 2
	sp->proc->input = NULLFILE;
	fclose(sp->output);
a313 1
	sp->proc->output = NULLFILE;
a415 1
	int oldf;
a419 3
	/* Disable newline buffering for the duration */
	oldf = fmode(sp->network,STREAM_BINARY);

a426 1
	fmode(sp->network,oldf);
d432 25
@


1.6
log
@src0410
@
text
@d91 1
a91 1
			tprintf("Session %s not active\n",argv[1]);
d94 1
a94 1
	tprintf(" #  S#  Type     Rcv-Q Snd-Q State        Remote socket\n");
d100 1
a100 1
		r = socklen(sp->output,1);
d103 1
a103 1
		if((s = sp->s) != -1){
d105 1
a105 1
			s = sp->s;
d111 3
a113 3
		tprintf("%c", (Lastcurr == sp)? '*':' ');
		tprintf("%-3u", (unsigned)(sp - Sessions));
		tprintf("%-4d%-8s%6d%6d %-13s",
d120 3
a122 3
			tprintf("%s ",sp->name);
		if(sp->s != -1 && k == 0)
			tprintf("(%s)",psocket(&fsocket));
d124 2
a125 2
		tprintf("\n");
		if(sp->type == FTP && (s = sp->cb.ftp->data) != -1){
d132 1
a132 1
			tprintf("    %-4d%-8s%6d%6d %-13s%s",
d140 2
a141 2
				tprintf(" (%s)",psocket(&fsocket));
			if(tprintf("\n") == EOF)
d145 1
a145 1
			tprintf("    Record: %s\n",sp->rfile);
d147 1
a147 1
			tprintf("    Upload: %s\n",sp->ufile);
d181 1
a181 1
		tprintf(Badsess);
d184 1
a184 1
	shutdown(sp->s,1);
d200 1
a200 1
		tprintf(Badsess);
d205 1
a205 1
	shutdown(sp->s,2);
d207 1
a207 1
		shutdown(sp->cb.ftp->data,2);
d223 1
a223 1
		tprintf(Badsess);
d226 1
a226 1
	sockkick(sp->s);
d228 1
a228 1
		sockkick(sp->cb.ftp->data);
d248 1
a248 1
	sp->s = -1;
d255 8
a262 6
	Curproc->input =  sp->input = socket(AF_LOCAL,SOCK_STREAM,0);
	seteol(Curproc->input,Eol);
	sockmode(Curproc->input,SOCK_BINARY);
	Curproc->output = sp->output = socket(AF_LOCAL,SOCK_STREAM,0);
	seteol(Curproc->output,Eol);
	sockmode(Curproc->output,SOCK_ASCII);
d294 2
a295 2
	if(sp->s != -1)
		close_s(sp->s);
d312 6
a317 6
	close_s(sp->input);
	sp->input = -1;
	sp->proc->input = -1;
	close_s(sp->output);
	sp->output = -1;
	sp->proc->output = -1;
d340 1
a340 1
		tprintf("No current session\n");
d354 1
a354 1
			if(sockmode(sp->output,-1) == SOCK_ASCII)
d360 1
a360 1
				tprintf("Can't open %s: %s\n",argv[1],sys_errlist[errno]);
d366 1
a366 1
		tprintf("Recording into %s\n",sp->rfile);
d368 1
a368 1
		tprintf("Recording off\n");
d382 1
a382 1
		tprintf("No current session\n");
d387 1
a387 1
			tprintf("Uploading %s\n",sp->ufile);
d389 1
a389 1
			tprintf("Uploading off\n");
d404 1
a404 1
		tprintf("Can't read %s: %s\n",argv[1],sys_errlist[errno]);
d426 1
a426 1
	oldf = setflush(sp->s,-1);
d430 1
a430 1
		if(usputs(sp->s,buf) == EOF)
d434 2
a435 2
	usflush(sp->s);
	setflush(sp->s,oldf);
@


1.5
log
@src0331
@
text
@d264 1
a264 1
	sp->flowmode = 0;	/* Off by default */
@


1.4
log
@src0922
@
text
@d233 1
a233 1
newsession(name,type)
d236 1
d268 4
a271 2
	swapscreen(Current,sp);
	Current = sp;
@


1.3
log
@src0609
@
text
@d41 3
a43 1
	"Dial"
d306 1
d308 2
d311 3
@


1.2
log
@src0318
@
text
@a5 1
#include "config.h"
@


1.1
log
@Initial revision
@
text
@d8 1
a8 1
#include "socket.h"
d10 1
d12 1
a12 1
#include "icmp.h"
d14 2
a16 2
#include "proc.h"
#include "tty.h"
d18 1
a18 1
#include "hardware.h"
d21 1
a23 2
extern struct proc *Display;
extern struct session *Command;
d41 2
a42 1
	"PPP PAP"
d45 1
a45 1
/* Convert a character string containing a decimal session index number 
@
