head	1.8;
access;
symbols;
locks;
comment	@ * @;


1.8
date	93.05.06.10.10.13;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.01.08.23.00;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.29.11.37.56;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.09.18.14.35.38;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.06.05.10.40.50;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.08.11.20.10;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	90.12.10.13.15.10;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.8
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/*
 *  PPPCMD.C	-- PPP related user commands
 *
 *	This implementation of PPP is declared to be in the public domain.
 *
 *	Jan 91	Bill_Simpson@@um.cc.umich.edu
 *		Computer Systems Consulting Services
 *
 *	Acknowledgements and correction history may be found in PPP.C
 */

#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "pktdrvr.h"
#include "ppp.h"
#include "pppfsm.h"
#include "ppplcp.h"
#include "ppppap.h"
#include "pppipcp.h"
#include "cmdparse.h"

static struct iface *ppp_lookup(char *ifname);

static int doppp_quick(int argc, char *argv[], void *p);
static int doppp_trace(int argc, char *argv[], void *p);

static int spot(uint16 work,uint16 want,uint16 will,uint16 mask);
static void genstat(struct ppp_s *ppp_p);
static void lcpstat(struct fsm_s *fsm_p);
static void papstat(struct fsm_s *fsm_p);
static void ipcpstat(struct fsm_s *fsm_p);

static int dotry_nak(int argc, char *argv[], void *p);
static int dotry_req(int argc, char *argv[], void *p);
static int dotry_terminate(int argc, char *argv[], void *p);


/* "ppp" subcommands */
static struct cmds Pppcmds[] = {
	"ipcp",		doppp_ipcp,	0,	0,	NULLCHAR,
	"lcp",		doppp_lcp,	0,	0,	NULLCHAR,
	"pap",		doppp_pap,	0,	0,	NULLCHAR,
	"quick",	doppp_quick,	0,	0,	NULLCHAR,
	"trace",	doppp_trace,	0,	0,	NULLCHAR,
	NULLCHAR,
};

/* "ppp <iface> <ncp> try" subcommands */
static struct cmds PppTrycmds[] = {
	"configure",	dotry_req,	0,	0,	NULLCHAR,
	"failure",	dotry_nak,	0,	0,	NULLCHAR,
	"terminate",	dotry_terminate,	0,	0,	NULLCHAR,
	NULLCHAR,
};

static char *PPPStatus[] = {
	"Physical Line Dead",
	"Establishment Phase",
	"Authentication Phase",
	"Network Protocol Phase",
	"Termination Phase"
};

static char *NCPStatus[] = {
	"Closed",
	"Listening -- waiting for remote host to attempt open",
	"Starting configuration exchange",
	"Remote host accepted our request; waiting for remote request",
	"We accepted remote request; waiting for reply to our request",
	"Opened",
	"Terminate request sent to remote host"
};

int PPPtrace;
struct iface *PPPiface;  /* iface for trace */


/****************************************************************************/

static struct iface *
ppp_lookup(ifname)
char *ifname;
{
	register struct iface *ifp;

	if ((ifp = if_lookup(ifname)) == NULLIF) {
		printf("%s: Interface unknown\n",ifname);
		return(NULLIF);
	}
	if (ifp->iftype->type != CL_PPP) {
		printf("%s: not a PPP interface\n",ifp->name);
		return(NULLIF);
	}
	return(ifp);
}

/****************************************************************************/

int
doppp_commands(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp;

	if (argc < 2) {
		printf( "ppp <iface> required\n" );
		return -1;
	}
	if ((ifp = ppp_lookup(argv[1])) == NULLIF)
		return -1;

	if ( argc == 2 ) {
		ppp_show( ifp );
		return 0;
	}

	return subcmd(Pppcmds, argc - 1, &argv[1], ifp);
}


/* Close connection on PPP interface */
int
doppp_close(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct fsm_s *fsm_p = p;

	fsm_p->flags &= ~(FSM_ACTIVE | FSM_PASSIVE);

	fsm_close( fsm_p );
	return 0;
}


int
doppp_passive(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct fsm_s *fsm_p = p;

	fsm_p->flags &= ~FSM_ACTIVE;
	fsm_p->flags |= FSM_PASSIVE;

	fsm_start(fsm_p);
	return 0;
}


int
doppp_active(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct fsm_s *fsm_p = p;

	fsm_p->flags &= ~FSM_PASSIVE;
	fsm_p->flags |= FSM_ACTIVE;

	if ( fsm_p->state < fsmLISTEN ) {
		fsm_p->state = fsmLISTEN;
	}
	return 0;
}


static int
doppp_quick(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp = p;
	register struct ppp_s *ppp_p = ifp->edv;
	struct lcp_s *lcp_p = ppp_p->fsm[Lcp].pdv;
	struct ipcp_s *ipcp_p = ppp_p->fsm[IPcp].pdv;

	lcp_p->local.want.accm = 0L;
	lcp_p->local.want.negotiate |= LCP_N_ACCM;
	lcp_p->local.want.magic_number += (long)&lcp_p->local.want.magic_number;
	lcp_p->local.want.negotiate |= LCP_N_MAGIC;
	lcp_p->local.want.negotiate |= LCP_N_ACFC;
	lcp_p->local.want.negotiate |= LCP_N_PFC;

	ipcp_p->local.want.compression = PPP_COMPR_PROTOCOL;
	ipcp_p->local.want.slots = 16;
	ipcp_p->local.want.slot_compress = 1;
	ipcp_p->local.want.negotiate |= IPCP_N_COMPRESS;
	doppp_active( 0, NULL, &(ppp_p->fsm[IPcp]) );

	return 0;
}


/****************************************************************************/

void
ppp_show(ifp)
struct iface *ifp;
{
	register struct ppp_s *ppp_p = ifp->edv;

	genstat(ppp_p);
	if ( ppp_p->fsm[Lcp].pdv != NULL )
		lcpstat(&(ppp_p->fsm[Lcp]));
	if ( ppp_p->fsm[Pap].pdv != NULL )
		papstat(&(ppp_p->fsm[Pap]));
	if ( ppp_p->fsm[IPcp].pdv != NULL )
		ipcpstat(&(ppp_p->fsm[IPcp]));
}


static void
genstat(ppp_p)
register struct ppp_s *ppp_p;
{

	printf("%s", PPPStatus[ppp_p->phase]);

	if (ppp_p->phase == pppREADY) {
		printf("\t(open for %s)",
			tformat(secclock() - ppp_p->upsince));
	}
	printf("\n");

	printf("%10lu In,  %10lu Flags,%6u ME, %6u FE, %6u CSE, %6u other\n",
		ppp_p->InRxOctetCount,
		ppp_p->InOpenFlag,
		ppp_p->InMemory,
		ppp_p->InFrame,
		ppp_p->InChecksum,
		ppp_p->InError);
	printf("\t\t%6u Lcp,%6u Pap,%6u IPcp,%6u Unknown\n",
		ppp_p->InNCP[Lcp],
		ppp_p->InNCP[Pap],
		ppp_p->InNCP[IPcp],
		ppp_p->InUnknown);
	printf("%10lu Out, %10lu Flags,%6u ME, %6u Fail\n",
		ppp_p->OutTxOctetCount,
		ppp_p->OutOpenFlag,
		ppp_p->OutMemory,
		ppp_p->OutError);
	printf("\t\t%6u Lcp,%6u Pap,%6u IPcp\n",
		ppp_p->OutNCP[Lcp],
		ppp_p->OutNCP[Pap],
		ppp_p->OutNCP[IPcp]);
}


static int
spot(work,want,will,mask)
uint16 work;
uint16 want;
uint16 will;
uint16 mask;
{
	char blot = ' ';
	int result = (work & mask);

	if ( !(will & mask) ) {
		blot = '*';
	} else if ( (want ^ work) & mask ) {
		blot = (result ? '+' : '-');
	}
	printf( "%c", blot );
	return result;
}

static void
lcpstat(fsm_p)
struct fsm_s *fsm_p;
{
	struct lcp_s *lcp_p = fsm_p->pdv;
	struct lcp_value_s *localp = &(lcp_p->local.work);
	uint16  localwork = lcp_p->local.work.negotiate;
	uint16  localwant = lcp_p->local.want.negotiate;
	uint16  localwill = lcp_p->local.will_negotiate;
	struct lcp_value_s *remotep = &(lcp_p->remote.work);
	uint16  remotework = lcp_p->remote.work.negotiate;
	uint16  remotewant = lcp_p->remote.want.negotiate;
	uint16  remotewill = lcp_p->remote.will_negotiate;

	printf("LCP %s\n",
		NCPStatus[fsm_p->state]);

	printf("\t\t MRU\t ACCM\t\t AP\t PFC  ACFC Magic\n");

	printf("\tLocal:\t");

	spot( localwork, localwant, localwill, LCP_N_MRU );
	printf( "%4d\t", localp->mru );

	spot( localwork, localwant, localwill, LCP_N_ACCM );
	printf( "0x%08lx\t", localp->accm );

	if ( spot( localwork, localwant, localwill, LCP_N_AUTHENT ) ) {
		switch ( localp->authentication ) {
		case PPP_PAP_PROTOCOL:
			printf( "Pap\t" );
			break;
		default:
			printf( "0x%04x\t", localp->authentication);
			break;
		};
	} else {
		printf( "None\t" );
	}

	printf( spot( localwork, localwant, localwill, LCP_N_PFC )
		 ? "Yes " : "No  " );
	printf( spot( localwork, localwant, localwill, LCP_N_ACFC )
		 ? "Yes " : "No  " );

	spot( localwork, localwant, localwill, LCP_N_MAGIC );
	if ( localp->magic_number != 0L ) {
		printf( "0x%08lx\n", localp->magic_number );
	} else {
		printf( "unused\n" );
	}

	printf("\tRemote:\t");

	spot( remotework, remotewant, remotewill, LCP_N_MRU );
	printf( "%4d\t", remotep->mru );

	spot( remotework, remotewant, remotewill, LCP_N_ACCM );
	printf( "0x%08lx\t", remotep->accm );

	if ( spot( remotework, remotewant, remotewill, LCP_N_AUTHENT ) ) {
		switch ( remotep->authentication ) {
		case PPP_PAP_PROTOCOL:
			printf( "Pap\t" );
			break;
		default:
			printf( "0x%04x\t", remotep->authentication);
			break;
		};
	} else {
		printf( "None\t" );
	}

	printf( spot( remotework, remotewant, remotewill, LCP_N_PFC )
		 ? "Yes " : "No  " );
	printf( spot( remotework, remotewant, remotewill, LCP_N_ACFC )
		 ? "Yes " : "No  " );

	spot( remotework, remotewant, remotewill, LCP_N_MAGIC );
	if ( remotep->magic_number != 0L ) {
		printf( "0x%08lx\n", remotep->magic_number );
	} else {
		printf( "unused\n" );
	}
}


static void
papstat(fsm_p)
struct fsm_s *fsm_p;
{
	struct pap_s *pap_p = fsm_p->pdv;

	printf("PAP %s\n",
		NCPStatus[fsm_p->state]);

	printf( "\tMessage: '%s'\n", (pap_p->message == NULL) ?
		"none" : pap_p->message );
}


static void
ipcpstat(fsm_p)
struct fsm_s *fsm_p;
{
	struct ipcp_s *ipcp_p = fsm_p->pdv;
	struct ipcp_value_s *localp = &(ipcp_p->local.work);
	uint16  localwork = ipcp_p->local.work.negotiate;
	struct ipcp_value_s *remotep = &(ipcp_p->remote.work);
	uint16  remotework = ipcp_p->remote.work.negotiate;

	printf("IPCP %s\n",
		NCPStatus[fsm_p->state]);
	printf("\tlocal IP address: %s",
		inet_ntoa(localp->address));
	printf("  remote IP address: %s\n",
		inet_ntoa(localp->other));

	if (localwork & IPCP_N_COMPRESS) {
		printf("    In\tTCP header compression enabled:"
			" slots = %d, flag = 0x%02x\n",
			localp->slots,
			localp->slot_compress);
		slhc_i_status(ipcp_p->slhcp);
	}

	if (remotework & IPCP_N_COMPRESS) {
		printf("    Out\tTCP header compression enabled:"
			" slots = %d, flag = 0x%02x\n",
			remotep->slots,
			remotep->slot_compress);
		slhc_o_status(ipcp_p->slhcp);
	}
}


/****************************************************************************/
/* Set timeout interval when waiting for response from remote peer */
int
doppp_timeout(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;
	struct timer *t = &(fsm_p->timer);

	if (argc < 2) {
		printf("%d\n",dur_timer(t)/1000L);
	} else {
		int x = (int)strtol( argv[1], NULLCHARP, 0 );

		if (x <= 0) {
			printf("Timeout value %s (%d) must be > 0\n",
				argv[1], x);
			return -1;
		} else {
			set_timer(t, x * 1000L);
		}
	}
	return 0;
}


int
doppp_try(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(PppTrycmds, argc, argv, p);
}


static int
dotry_nak(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;

	if (argc < 2) {
		printf("%d\n",fsm_p->try_nak);
	} else {
		int x = (int)strtol( argv[1], NULLCHARP, 0 );

		if (x <= 0) {
			printf("Value %s (%d) must be > 0\n",
				argv[1], x);
			return -1;
		} else {
			fsm_p->try_nak = x;
		}
	}
	return 0;
}


static int
dotry_req(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;

	if (argc < 2) {
		printf("%d\n",fsm_p->try_req);
	} else {
		int x = (int)strtol( argv[1], NULLCHARP, 0 );

		if (x <= 0) {
			printf("Value %s (%d) must be > 0\n",
				argv[1], x);
			return -1;
		} else {
			fsm_p->try_req = x;
		}
	}
	return 0;
}


static int
dotry_terminate(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct fsm_s *fsm_p = p;

	if (argc < 2) {
		printf("%d\n",fsm_p->try_terminate);
	} else {
		int x = (int)strtol( argv[1], NULLCHARP, 0 );

		if (x <= 0) {
			printf("Value %s (%d) must be > 0\n",
				argv[1], x);
			return -1;
		} else {
			fsm_p->try_terminate = x;
		}
	}
	return 0;
}


static int
doppp_trace(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp = p;
	register struct ppp_s *ppp_p = ifp->edv;
	int tracing = ppp_p->trace;
	int result = setint(&tracing,"PPP tracing",argc,argv);

	ppp_p->trace = tracing;
	return result;
}


@


1.7
log
@src0501
@
text
@d24 1
a24 1
static struct iface *ppp_lookup __ARGS((char *ifname));
d26 2
a27 2
static int doppp_quick		__ARGS((int argc, char *argv[], void *p));
static int doppp_trace		__ARGS((int argc, char *argv[], void *p));
d29 9
a37 9
static int spot __ARGS((int16 work,int16 want,int16 will,int16 mask));
static void genstat		__ARGS((struct ppp_s *ppp_p));
static void lcpstat		__ARGS((struct fsm_s *fsm_p));
static void papstat		__ARGS((struct fsm_s *fsm_p));
static void ipcpstat		__ARGS((struct fsm_s *fsm_p));

static int dotry_nak		__ARGS((int argc, char *argv[], void *p));
static int dotry_req		__ARGS((int argc, char *argv[], void *p));
static int dotry_terminate	__ARGS((int argc, char *argv[], void *p));
d260 4
a263 4
int16 work;
int16 want;
int16 will;
int16 mask;
d283 3
a285 3
	int16  localwork = lcp_p->local.work.negotiate;
	int16  localwant = lcp_p->local.want.negotiate;
	int16  localwill = lcp_p->local.will_negotiate;
d287 3
a289 3
	int16  remotework = lcp_p->remote.work.negotiate;
	int16  remotewant = lcp_p->remote.want.negotiate;
	int16  remotewill = lcp_p->remote.will_negotiate;
d384 1
a384 1
	int16  localwork = ipcp_p->local.work.negotiate;
d386 1
a386 1
	int16  remotework = ipcp_p->remote.work.negotiate;
@


1.6
log
@src0429a
@
text
@d89 1
a89 1
		tprintf("%s: Interface unknown\n",ifname);
d93 1
a93 1
		tprintf("%s: not a PPP interface\n",ifp->name);
d110 1
a110 1
		tprintf( "ppp <iface> required\n" );
d226 1
a226 1
	tprintf("%s", PPPStatus[ppp_p->phase]);
d229 1
a229 1
		tprintf("\t(open for %s)",
d232 1
a232 1
	tprintf("\n");
d234 1
a234 1
	tprintf("%10lu In,  %10lu Flags,%6u ME, %6u FE, %6u CSE, %6u other\n",
d241 1
a241 1
	tprintf("\t\t%6u Lcp,%6u Pap,%6u IPcp,%6u Unknown\n",
d246 1
a246 1
	tprintf("%10lu Out, %10lu Flags,%6u ME, %6u Fail\n",
d251 1
a251 1
	tprintf("\t\t%6u Lcp,%6u Pap,%6u IPcp\n",
d273 1
a273 1
	tprintf( "%c", blot );
d291 1
a291 1
	tprintf("LCP %s\n",
d294 1
a294 1
	tprintf("\t\t MRU\t ACCM\t\t AP\t PFC  ACFC Magic\n");
d296 1
a296 1
	tprintf("\tLocal:\t");
d299 1
a299 1
	tprintf( "%4d\t", localp->mru );
d302 1
a302 1
	tprintf( "0x%08lx\t", localp->accm );
d307 1
a307 1
			tprintf( "Pap\t" );
d310 1
a310 1
			tprintf( "0x%04x\t", localp->authentication);
d314 1
a314 1
		tprintf( "None\t" );
d317 1
a317 1
	tprintf( spot( localwork, localwant, localwill, LCP_N_PFC )
d319 1
a319 1
	tprintf( spot( localwork, localwant, localwill, LCP_N_ACFC )
d324 1
a324 1
		tprintf( "0x%08lx\n", localp->magic_number );
d326 1
a326 1
		tprintf( "unused\n" );
d329 1
a329 1
	tprintf("\tRemote:\t");
d332 1
a332 1
	tprintf( "%4d\t", remotep->mru );
d335 1
a335 1
	tprintf( "0x%08lx\t", remotep->accm );
d340 1
a340 1
			tprintf( "Pap\t" );
d343 1
a343 1
			tprintf( "0x%04x\t", remotep->authentication);
d347 1
a347 1
		tprintf( "None\t" );
d350 1
a350 1
	tprintf( spot( remotework, remotewant, remotewill, LCP_N_PFC )
d352 1
a352 1
	tprintf( spot( remotework, remotewant, remotewill, LCP_N_ACFC )
d357 1
a357 1
		tprintf( "0x%08lx\n", remotep->magic_number );
d359 1
a359 1
		tprintf( "unused\n" );
d370 1
a370 1
	tprintf("PAP %s\n",
d373 1
a373 1
	tprintf( "\tMessage: '%s'\n", (pap_p->message == NULL) ?
d388 1
a388 1
	tprintf("IPCP %s\n",
d390 1
a390 1
	tprintf("\tlocal IP address: %s",
d392 1
a392 1
	tprintf("  remote IP address: %s\n",
d396 1
a396 1
		tprintf("    In\tTCP header compression enabled:"
d404 1
a404 1
		tprintf("    Out\tTCP header compression enabled:"
d425 1
a425 1
		tprintf("%d\n",dur_timer(t)/1000L);
d430 1
a430 1
			tprintf("Timeout value %s (%d) must be > 0\n",
d460 1
a460 1
		tprintf("%d\n",fsm_p->try_nak);
d465 1
a465 1
			tprintf("Value %s (%d) must be > 0\n",
d485 1
a485 1
		tprintf("%d\n",fsm_p->try_req);
d490 1
a490 1
			tprintf("Value %s (%d) must be > 0\n",
d510 1
a510 1
		tprintf("%d\n",fsm_p->try_terminate);
d515 1
a515 1
			tprintf("Value %s (%d) must be > 0\n",
@


1.5
log
@src0922
@
text
@d92 1
a92 1
	if (ifp->type != CL_PPP) {
@


1.4
log
@src0609
@
text
@a12 1
#include <time.h>
d19 2
a21 2
#include "ppppap.h"
#include "ppplcp.h"
d29 1
a38 2
static char *uptime		__ARGS((long first, long second));

d59 2
a60 2
	"Physical Line Down",
	"Link Control Phase",
d62 1
a62 1
	"Ready for traffic",
d68 1
a68 1
	"Listen -- waiting for remote host to attempt open",
d72 1
a72 1
	"Open",
d77 1
d116 4
a119 2
	if (argc == 2 )
		return ppp_status( ifp );
d182 1
a182 1
	register struct ppp_s *ppp_p = ifp->extension;
d188 1
a188 1
	lcp_p->local.want.magic_number = Clock | 0x80000000L;
d205 2
a206 24
int
ppp_discard(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	struct ppp_s *ppp_p = ifp->extension;

	return fsm_send(&(ppp_p->fsm[Lcp]), DISCARD_REQ, 0, bp);
}

int
ppp_echo(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	struct ppp_s *ppp_p = ifp->extension;

	return fsm_send(&(ppp_p->fsm[Lcp]), ECHO_REQ, 0, bp);
}

/****************************************************************************/

int
ppp_status(ifp)
d209 1
a209 1
	register struct ppp_s *ppp_p = ifp->extension;
a217 1
	return 0;
d226 1
a226 3
	tprintf("%s",
		ppp_p->iface->name,
		PPPStatus[ppp_p->phase]);
d230 1
a230 1
			uptime(ppp_p->upsince,time(0L)));
d234 2
a235 3
	tprintf("    In"
		"\t%10ld Pkts,%10ld Flag,%6d Err,%6d ChksumErr\n",
		ppp_p->InRxPacketCount,
d237 5
a241 4
		ppp_p->InError,
		ppp_p->InChecksum);
	tprintf("\t%10ld Ip,  %6d Lcp,%6d Pap,%6d IPcp,%6d Unknown\n",
		ppp_p->InIP,
d246 2
a247 3
	tprintf("    Out"
		"\t%10ld Pkts,%10ld Flag,%6d Err\n",
		ppp_p->OutTxPacketCount,
d249 1
d251 1
a251 2
	tprintf("\t%10ld Ip,  %6d Lcp,%6d Pap,%6d IPcp\n",
		ppp_p->OutIP,
d258 19
d283 3
d287 3
d294 1
a294 1
	tprintf("\t\tMRU\tACCM\t\tAP\tPFC ACFC Magic\n");
d298 5
a302 10
	if ( localp->negotiate & LCP_N_MRU ) {
		tprintf( "%4d\t", localp->mru );
	} else {
		tprintf( "default\t" );
	}
	if ( localp->negotiate & LCP_N_ACCM ) {
		tprintf( "0x%08lx\t", localp->accm );
	} else {
		tprintf( "default\t\t" );
	}
d304 1
a304 1
	if ( localp->negotiate & LCP_N_AUTHENT ) {
d307 1
a307 1
			tprintf("Pap\t");
d310 1
a310 1
			tprintf("0x%04x\t", localp->authentication);
d314 1
a314 1
		tprintf("None\t");
d317 4
a320 2
	tprintf((localp->negotiate & LCP_N_PFC) ? "Yes " : "No  ");
	tprintf((localp->negotiate & LCP_N_ACFC) ? "Yes " : "No  ");
d322 1
d324 1
a324 1
		tprintf( " 0x%08lx\n", localp->magic_number );
d326 1
a326 1
		tprintf( " unused\n" );
d331 5
a335 10
	if ( remotep->negotiate & LCP_N_MRU ) {
		tprintf( "%4d\t", remotep->mru );
	} else {
		tprintf( "default\t" );
	}
	if ( remotep->negotiate & LCP_N_ACCM ) {
		tprintf( "0x%08lx\t", remotep->accm );
	} else {
		tprintf( "default\t\t" );
	}
d337 1
a337 1
	if ( remotep->negotiate & LCP_N_AUTHENT ) {
d340 1
a340 1
			tprintf("Pap\t");
d343 1
a343 1
			tprintf("0x%04x\t", remotep->authentication);
d347 1
a347 1
		tprintf("None\t");
d350 4
a353 2
	tprintf((remotep->negotiate & LCP_N_PFC) ? "Yes " : "No  ");
	tprintf((remotep->negotiate & LCP_N_ACFC) ? "Yes " : "No  ");
d355 3
a357 2
	if ( remotep->negotiate & LCP_N_MAGIC ) {
		tprintf( " 0x%08lx\n", remotep->magic_number );
d359 1
a359 1
		tprintf( " unused\n" );
d384 1
d386 1
d392 1
a392 1
	tprintf("\tremote IP address: %s\n",
d395 1
a395 1
	if (localp->negotiate & IPCP_N_COMPRESS) {
d403 1
a403 1
	if (remotep->negotiate & IPCP_N_COMPRESS) {
d533 1
a533 1
	register struct ppp_s *ppp_p = ifp->extension;
a538 47
}


/****************************************************************************/
/* Break a time differential, measured in seconds, into weeks, days      */
/* hours, minutes, and seconds. Store ASCII description in static buffer */
#define SECS_MIN	60L
#define SECS_HR		3600L
#define SECS_DAY	86400L
#define SECS_WEEK	604800L

static char utbuf[128];

static char *
uptime(first, second)
long first;
long second;
{
	int found = 0;
	long diff;
	long part;

	utbuf[0] = '\0';
	diff = second - first;
	if ((diff > SECS_DAY)||(found)) {
		part = diff / SECS_DAY;
		sprintf(&(utbuf[strlen(utbuf)]),
			"%ld day%s ",part,((part==1)?",":"s,"));
		diff -= (part * SECS_DAY);
		found = 100;
	}
	if ((diff > SECS_HR)||(found)) {
		part = diff / SECS_HR;
		sprintf(&(utbuf[strlen(utbuf)]),
			"%ld hr%s ",part,((part==1)?",":"s,"));
		diff -= (part * SECS_HR);
		++found;
	}
	if ((diff > SECS_MIN)||(found)) {
		part = diff / SECS_MIN;
		sprintf(&(utbuf[strlen(utbuf)]),"%ld mi%s",part,
			((found < 100)?"n, ":"n"));
		diff -= (part * SECS_MIN);
	}
	if (found < 100)
		sprintf(&(utbuf[strlen(utbuf)]),"%ld sec",diff);
	return(utbuf);
@


1.3
log
@src0318
@
text
@d27 1
a29 3
static int doppp_active		__ARGS((int argc, char *argv[], void *p));
static int doppp_passive	__ARGS((int argc, char *argv[], void *p));

d47 1
a51 7
/* "ppp <iface> <ncp> open" subcommands */
static struct cmds Pppopencmds[] = {
	"active",	doppp_active,	0,	0,	NULLCHAR,
	"passive",	doppp_passive,	0,	0,	NULLCHAR,
	NULLCHAR,
};

a62 1
	"Link Quality Phase",
d133 3
a135 1
	fsm_close( fsm_p, TRUE );
a139 1
/* Initiate open on a PPP interface */
d141 1
a141 1
doppp_open(argc,argv,p)
d146 7
a152 1
	return subcmd(Pppopencmds, argc, argv, p);
d156 1
a156 1
static int
d166 4
d175 1
a175 1
doppp_passive(argc,argv,p)
d180 17
a196 1
	register struct fsm_s *fsm_p = p;
a197 2
	fsm_p->flags &= ~FSM_ACTIVE;
	fsm_p->flags |= FSM_PASSIVE;
d205 22
a251 1
#ifndef PPP_NO_STATS
a255 1
#endif
a257 1
#ifndef PPP_NO_STATS
d259 11
a269 11
		"\t%10ld Pkts, %10ld Flag, %6d Err, %6d ChksumErr\n",
		ppp_p->rcvpkt,
		ppp_p->rcvopenflag,
		ppp_p->rcverr,
		ppp_p->csumerr);
	tprintf("\t%10ld Ip,   %6d Lcp, %6d Pap, %6d IPcp, %6d Unknown\n",
		ppp_p->rcvip,
		ppp_p->rcv[Lcp],
		ppp_p->rcv[Pap],
		ppp_p->rcv[IPcp],
		ppp_p->rcvunk);
d271 9
a279 10
		"\t%10ld Pkts, %10ld Flag, %6d Err\n",
		ppp_p->sndpkt,
		ppp_p->sndopenflag,
		ppp_p->snderr);
	tprintf("\t%10ld Ip,   %6d Lcp, %6d Pap, %6d IPcp\n",
		ppp_p->sndip,
		ppp_p->snd[Lcp],
		ppp_p->snd[Pap],
		ppp_p->snd[IPcp]);
#endif
d325 2
a326 2
	if ( localp->negotiate & LCP_N_MAGIC ) {
		tprintf( " 0x%08lx\n", localp->accm );
d328 1
a328 1
		tprintf( " default\n" );
d361 1
a361 1
		tprintf( " 0x%08lx\n", remotep->accm );
d363 1
a363 1
		tprintf( " default\n" );
@


1.2
log
@src0308
@
text
@d4 6
a9 15
 *	12-89	-- Katie Stevens (dkstevens@@ucdavis.edu)
 *		   UC Davis, Computing Services
 *	PPP.07	04-90	[ks] new storage for peer addr for IPCP
 *	PPP.08  05-90	[ks] improve PPP trace reporting
 *	PPP.09	05-90	[ks] add commands to set PPP Auth protocol
 *			     (UPAP server) and UPAP peerID (UPAP client)
 *	PPP.10	6-90	[ks] improve keybd input of UPAP password
 *			     make ppp open/close/reset work properly
 *			     add peer IP lookup pool
 *	PPP.13	8-90	[ks] report PPP open timestamp with stats
 *	PPP.14	8-90	[ks] change UPAP to PAP for consistency with RFC1172
 *			     add RLSD physical link up/down handling
 *			     add autobaud handling to set link speed
 *			     make LCP/IPCP timeout configurable
 *	PPP.15	09-90	[ks] update to KA9Q NOS v900828
a16 1
#include "timer.h"
a17 2
#include "asy.h"
#include "slcomp.h"
d19 4
a22 4
#include "slip.h"
#include "commands.h"
#include "netuser.h"
/*#include "internet.h"*/
a23 1
#include "config.h"
d25 1
a25 1
extern char Badhost[];
d27 1
a27 2
int16 Ppptrace = 0;
int16 Npool = 0;		/* Number of pools for PPP interfaces */
d29 13
a41 5
#ifdef notdef /*MUXASY*/
struct ipcppool PPPpool[ASY_MAX*PORTS_PER_MUX];	/* For pooling peer IP addrs */
#else
struct ipcppool PPPpool[ASY_MAX];		/* For pooling peer IP addrs */
#endif
a42 24
static int dopppaccomp __ARGS((int argc, char *argv[], void *p));
static int dopppactive __ARGS((int argc, char *argv[], void *p));
static int dopppauth __ARGS((int argc, char *argv[], void *p));
static int dopppclose __ARGS((int argc, char *argv[], void *p));
static int dopppctlmap __ARGS((int argc, char *argv[], void *p));
static int dopppmru __ARGS((int argc, char *argv[], void *p));
static int dopppipcomp __ARGS((int argc, char *argv[], void *p));
static int doppppassive __ARGS((int argc, char *argv[], void *p));
static int doppppeer __ARGS((int argc, char *argv[], void *p));
static int doppppool __ARGS((int argc, char *argv[], void *p));
static int dopppprotcomp __ARGS((int argc, char *argv[], void *p));
static int dopppreset __ARGS((int argc, char *argv[], void *p));
static int dopppstat __ARGS((int argc, char *argv[], void *p));
static int doppptrace __ARGS((int argc, char *argv[], void *p));
static int doppptimeout __ARGS((int argc, char *argv[], void *p));
static int dopapuser __ARGS((int argc, char *argv[], void *p));

static void genstat __ARGS((struct slip *sp));
static void pppstat __ARGS((struct slip *sp));
static void lcpstat __ARGS((struct lcpctl *lcpiop));
static void ipcpstat __ARGS((struct ipcpctl *ipcpiop));
static struct iface *ppplookup __ARGS((char *ifname));
static void dumppool __ARGS((void));
static char *uptime __ARGS((long first, long second));
d46 19
a64 30
	"accompr",	dopppaccomp,	0,	2,
		"ppp accompr <iface> <int>",
	"activeopen",	dopppactive,	0,	2,
		"ppp activeopen <iface>",
	"authprot",	dopppauth,	0,	2,
		"ppp authprot <authtype>",
	"close",	dopppclose,	512,	2,
		"ppp close <iface>",
	"ctlmap",	dopppctlmap,	0,	2,
		"ppp ctlmap <iface> <int>",
	"ipcompr",	dopppipcomp,	0,	2,
		"ppp ipcompr <iface> <comprtype>",
	"mru",		dopppmru,	0,	2,
		"ppp mru <iface> <int>",
	"passiveopen",	doppppassive,	0,	2,
		"ppp passiveopen <iface>",
	"peeraddr",	doppppeer,	0,	2,
		"ppp peeraddr <iface> <addr>",
	"peerid",	dopapuser,	0,	2,
		"ppp peerid <iface> <peer ID code>",
	"pooladdr",	doppppool,	0,	1,
		"ppp pooladdr <addr>:<# addr in pool> [ <iface> ... ]",
	"protcompr",	dopppprotcomp,	0,	2,
		"ppp protcompr <iface> <int>",
	"reset",	dopppreset,	0,	2,
		"ppp reset <iface>",
	"status",	dopppstat,	0,	0,	NULLCHAR,
	"timeout",	doppptimeout,	0,	2,
		"ppp timeout <iface> <#sec>",
	"trace",	doppptrace,	0,	0,	NULLCHAR,
d69 6
a74 7
	"physical layer down",
	"waiting for link speed assignment message",
	"Closed",
	"waiting for LCP negotiation",
	"waiting for PAP verfication",
	"waiting for IPCP negotiation",
	"Open"
d76 2
a77 1
static char *LCPStatus[] = {
d79 5
a83 5
	"Listen; waiting for remote host to attempt open",
	"Req Sent: Attempting to start configuration exchange",
	"Ack Rcvd: Remote host accepted our request; waiting for remote request",
	"Ack Sent: Waiting for reply to our request; accepted remote request",
	"Open; configuration negotiation complete",
d87 3
d92 3
a94 5
int
dopppcontrol(argc,argv,p)
int argc;
char *argv[];
void *p;
d96 11
a106 1
	return subcmd(Pppcmds,argc,argv,p);
d111 2
a112 3
/* Initiate active open on a PPP interface */
static int
dopppactive(argc,argv,p)
d117 1
a117 3
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
d119 5
a123 2
	/* Look for the PPP interface */
	if ((ifp = ppplookup(argv[1])) == NULLIF)
d126 4
a129 8
	/* Start LCP configuration negotiation on interface */
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	lcpiop->active = 1;
	if ((pppiop->state == PPP_PL_DOWN) || (pppiop->state == PPP_AUTOBAUD))
		return 0;
	else
		return(lcp_start(&Slip[ifp->xdev]));
d132 1
d134 2
a135 2
static int
dopppclose(argc,argv,p)
d140 1
a140 1
	struct iface *ifp;
d142 4
a145 3
	/* Look for the PPP interface */
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
d147 8
a154 2
	/* Close PPP connection */
	return(ppp_close(&Slip[ifp->xdev],1));
d157 1
a157 1
/* Set PPP interface to passive open; will revert to LISTEN on next close */
d159 1
a159 1
doppppassive(argc,argv,p)
d164 1
a164 7
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	/* Look for the PPP interface */
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
d166 2
a167 4
	/* Start LCP configuration negotiation on interface */
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	lcpiop->active = 0;
d171 1
a171 1
/* Close and reopen connection on PPP interface */
d173 1
a173 1
dopppreset(argc,argv,p)
d178 26
a203 4
	struct iface *ifp;
	struct slip *sp;
	struct pppctl *pp;
	struct slcompress *slp;
d205 4
a208 5
	/* Look for the PPP interface */
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
	sp = &Slip[ifp->xdev];
	pp = sp->pppio;
d210 3
a212 2
	/* Close PPP connection */
	ppp_close(&Slip[ifp->xdev],0);
d215 4
a218 16
	/* Zero PPP packet counters */
	pp->sndpkt = 0L;		/* # packets sent on PPP interface */
	pp->snderr = 0;			/* # pkts with PPP error on send */
	pp->rcvpkt = 0L;		/* # packets rcvd on PPP interface */
	pp->rcverr = 0;			/* # pkts with error */
	pp->csumerr = 0;		/* # rcv pkts with bad PPP checksum */

	pp->sndlcp = 0;			/* # LCP packets sent */
	pp->sndpap = 0;			/* # PAP packets sent */
	pp->sndipcp = 0;		/* # IPCP packets sent */
	pp->sndip = 0L;			/* # IP packets sent */
	pp->rcvlcp = 0;			/* # LCP packets received */
	pp->rcvpap = 0;			/* # PAP packets received */
	pp->rcvipcp = 0;		/* # IPCP packets received */
	pp->rcvip = 0L;			/* # IP packets received */
	pp->rcvunk = 0;			/* # unknown packets received */
d220 1
d222 23
a244 14
#ifndef SL_NO_STATS
	slp = sp->slcomp;
	slp->sls_nontcp = 0L;		/* outbound non-TCP packets */
	slp->sls_asistcp = 0L;		/* outbound TCP packets */
	slp->sls_compressed = 0L;	/* outbound compressed packets */
	slp->sls_uncompressed = 0L;	/* outbound uncompressed packets */
	slp->sls_searches = 0L;		/* searches for connection state */
	slp->sls_misses = 0L;		/* times couldn't find conn. state */
	slp->sls_nontcpin = 0L;		/* inbound non-TCP packets */
	slp->sls_tcpin = 0L;		/* inbound TCP packets */
	slp->sls_uncompressedin = 0L;	/* inbound uncompressed packets */
	slp->sls_compressedin = 0L;	/* inbound compressed packets */
	slp->sls_errorin = 0L;		/* inbound unknown type packets */
	slp->sls_tossed = 0L;		/* inbound tossed because of error */
a245 5

	/* Always restart as active open when PPP reset */
	pp->lcpio.active = 1;
	tprintf("Attempting to reopen PPP interface  %s\n",ifp->name);
	return(lcp_start(&Slip[ifp->xdev]));
a247 1
/*******************************************/
d249 3
a251 6
/* Set Address/Control Compression for a PPP interface */
static int
dopppaccomp(argc,argv,p)
int argc;
char *argv[];
void *p;
d253 3
a255 4
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct lcpparm *localp;
d257 2
a258 3
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
	--argc;++argv;
d260 1
a260 7
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	localp = &(lcpiop->initparm);
	localp->neg_ac_compress = 1;
	return setbool(&(localp->ac_compress),
			"Addr/Ctl Field Compression",argc,argv);
}
d262 1
a262 11
/* Set authentication type for PPP interface */
static int
dopppauth(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct lcpparm *localp;
d264 10
a273 2
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
d275 9
a283 13
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	localp = &(lcpiop->initparm);
	if (argc < 3) {
		tprintf("%s\n",((localp->auth_type == PAP_AUTH_TYPE) ? "PAP" : "None"));
	} else if ((strnicmp("pap",argv[2],2) == 0)
		    || ((int16)strtol(argv[2],NULLCHARP,0)==PAP_AUTH_TYPE)) {
		localp->neg_auth_type = 1;
		localp->auth_type = PAP_AUTH_TYPE;
	} else if ((stricmp("none",argv[2]) == 0)
		    || ((int16)strtol(argv[2],NULLCHARP,0) == 0)) {
		localp->neg_auth_type = 0;
		localp->auth_type = DEF_AUTH_TYPE;
d285 1
a285 2
		tprintf("unknown Authentication Protocol type; command ignored\n");
		return 1;
d287 3
a289 2
	return 0;
}
d291 5
a295 12
/* Set Async Control Map for a PPP interface */
static int
dopppctlmap(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	long lx;
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct lcpparm *localp;
d297 1
a297 2
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
d299 9
a307 9
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	localp = &(lcpiop->initparm);
	if (argc < 3) {
		tprintf("0x%08lx\n",localp->ctl_map);
	} else {
		lx = strtol(argv[2], NULLCHARP, 0);
		localp->neg_ctl_map = 1;
		localp->ctl_map = lx;
a308 2
	return 0;
}
d310 12
a321 12
/* Set preferred Maximum Receive Unit for a PPP interface */
static int
dopppmru(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int x;
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct lcpparm *localp;
d323 2
a324 2
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
d326 4
a329 15
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	localp = &(lcpiop->initparm);
	if (argc < 3) {
		tprintf("%d\n",localp->mru);
	} else {
		x = atoi(argv[2]);
		if ((x < MIN_MRU)||(x > DEF_MRU)) {
			tprintf("Command rejected; MRU out of range: Min MRU: %d  Max MRU: %d\n",
				MIN_MRU,DEF_MRU);
			return -1;
		} else {
			localp->neg_mru = 1;
			localp->mru = x;
		}
a330 1
	return 0;
d333 4
a336 6
/* Set Protocol Compression for a PPP interface */
static int
dopppprotcomp(argc,argv,p)
int argc;
char *argv[];
void *p;
d338 8
a345 4
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct lcpparm *localp;
a346 3
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
	--argc;++argv;
d348 30
a377 6
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	localp = &(lcpiop->initparm);
	localp->neg_prot_compress = 1;
	return setbool(&(localp->prot_compress),
			"Protocol Field Compression",argc,argv);
d380 2
d383 2
a384 2
static int
doppptimeout(argc,argv,p)
d389 2
a390 6
	int x;
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;
	struct ipcpctl *ipcpiop;
	struct timer *t;
d392 4
a395 2
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
a396 7
	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	t = &(lcpiop->lcp_tm);
	if (argc < 3) {
		tprintf("%d\n",(dur_timer(t)/1000L));
	} else {
		x = atoi(argv[2]);
d398 2
a399 1
			tprintf("Command rejected; timeout value must be > 0\n");
d402 1
a402 4
			set_timer(t,x*1000L);
			ipcpiop = &(pppiop->ipcpio);
			t = &(ipcpiop->ipcp_tm);
			set_timer(t,x*1000L);
d408 3
a410 3
/* Set peer ID string to send with PAP AUTH_REQ */
static int
dopapuser(argc,argv,p)
d415 1
a415 24
	struct iface *ifp;
	struct pppctl *pppiop;
	struct lcpctl *lcpiop;

	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;

	pppiop = Slip[ifp->xdev].pppio;
	lcpiop = &(pppiop->lcpio);
	if (argc < 3) {
		tprintf("%s\n",((lcpiop->pap_user==NULLCHAR)?"None":lcpiop->pap_user));
	} else if (strnicmp("none",argv[2],2) == 0) {
		if (lcpiop->pap_user != NULLCHAR)
			free(lcpiop->pap_user);
	} else {
		if (lcpiop->pap_user != NULLCHAR)
			free(lcpiop->pap_user);
		if (lcpiop->pap_pass != NULLCHAR)
			free(lcpiop->pap_pass);
		lcpiop->pap_user = mallocw(strlen(argv[2])+1);
		strcpy(lcpiop->pap_user,argv[2]);
		pap_getpass(&Slip[ifp->xdev],0);
	}
	return 0;
a418 3
/*******************************************/

/* Set IP compression type for PPP interface */
d420 1
a420 1
dopppipcomp(argc,argv,p)
d425 1
a425 3
	struct iface *ifp;
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d427 4
a430 2
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
d432 7
a438 17
	pppiop = Slip[ifp->xdev].pppio;
	ipcpiop = &(pppiop->ipcpio);
	if (argc < 3) {
		if (ipcpiop->ip_compr_type == IPCP_VJCOMPR)
			tprintf("Van Jacobson TCP header compression enabled\n");
		else
			tprintf("IP compression disabled\n");
	} else if ((strnicmp("vj",argv[2],2) == 0)
		    || ((int16)strtol(argv[2],NULLCHARP,0) == IPCP_VJCOMPR)) {
		ipcpiop->neg_ip_compr = 1;
		ipcpiop->ip_compr_type = IPCP_VJCOMPR;
	} else if ((int16)strtol(argv[2],NULLCHARP,0) == 0) {
		ipcpiop->neg_ip_compr = 1;
		ipcpiop->ip_compr_type = 0;
	} else {
		tprintf("unknown IP compression type; command ignored\n");
		return 1;
d443 1
a443 1
/* Set peer address for PPP interface */
d445 1
a445 1
doppppeer(argc,argv,p)
d450 1
a450 4
	int32 x32;
	struct iface *ifp;
	struct pppctl *pppiop;
	struct ipcpctl *ipcpiop;
d452 4
a455 2
	if ((ifp = ppplookup(argv[1])) == NULLIF)
		return -1;
d457 7
a463 9
	pppiop = Slip[ifp->xdev].pppio;
	ipcpiop = &(pppiop->ipcpio);
	if (argc < 3) {
		tprintf("%s\n",inet_ntoa(ipcpiop->peer_addr));
	} else if ((x32 = resolve(argv[2])) == 0L) {
		tprintf(Badhost,argv[2]);
		return 1;
	} else {
		ipcpiop->peer_addr = x32;
d468 1
a468 1
/* Set a pool of peer addresses for PPP interface */
d470 1
a470 1
doppppool(argc,argv,p)
d475 1
a475 7
	int pool;
	int pool_cnt;
	char *bitp;
	int32 pool_addr;
	struct ipcppool *poolp;
	struct iface *ifp;
	struct pppctl *pppiop;
d478 3
a480 3
		dumppool();
		return 0;
	}
d482 7
a488 39
	if (Npool > ASY_MAX) {
		tprintf("Too many PPP address pools -- command rejected\n");
		return -1;
	}

	/* Need at least one IP address for the pool */
	if((pool_addr = resolve(argv[1])) == 0){
		tprintf("Must specify an IP address pool\n");
		return -1;
	}
	/* May specify a consecutive range of addresses; otherwise assume 1 */
	if((bitp = strchr(argv[1],':')) != NULLCHAR){
		bitp++;
		pool_cnt = atoi(bitp);
	} else
		pool_cnt = 1;
	if (pool_cnt < 0) {
		tprintf("Unreasonable address range  --  command rejected\n");
		return -1;
	}

	if (argc < 3) {
		printf("Must specify a PPP interface\n");
		return -1;
	}

	pool = Npool++;
	poolp = &(PPPpool[pool]);
	poolp->peer_min = pool_addr;
	poolp->peer_max = pool_addr + pool_cnt - 1;
	poolp->peer_next = pool_addr;

	argc -= 2;argv++;
	while (argc--) {
		argv++;
		if ((ifp = ppplookup(*argv)) == NULLIF)
			continue;
		pppiop = Slip[ifp->xdev].pppio;
		pppiop->ipcpio.peer_pool = &(PPPpool[pool]);
a492 12
/****************************************************************************/

static int
doppptrace(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Ppptrace,"PPP tracing",argc,argv);
}

/****************************************************************************/
d495 1
a495 1
dopppstat(argc,argv,p)
d500 4
a503 75
	register struct slip *sp;
	struct iface *ifp;

	if (argc < 2) {
		for (sp = Slip;sp < &Slip[ASY_MAX];sp++) {
			if (sp->type != CL_PPP)
				continue;
			genstat(sp);
		}
	} else {
		if ((ifp = ppplookup(argv[1])) == NULLIF)
			return -1;
		sp = &Slip[ifp->xdev];
		genstat(sp);
		pppstat(sp);
		lcpstat(&(sp->pppio->lcpio));
		ipcpstat(&(sp->pppio->ipcpio));
	}
	return 0;
}

static void
genstat(sp)
struct slip *sp;
{
	register struct pppctl *pp;

	pp = sp->pppio;
	tprintf("%s:\t",sp->iface->name);
	tprintf("SndPkt: %ld  SndErr: %d  RcvPkt: %ld  RcvErr: %d  ChksumErr: %d\n",
		pp->sndpkt,pp->snderr,pp->rcvpkt,pp->rcverr,pp->csumerr);
	return;
}

static void
pppstat(sp)
struct slip *sp;
{
	register struct pppctl *pp;
	register struct slcompress *scp;

	pp = sp->pppio;
	scp = sp->slcomp;
	tprintf("\tOverall PPP state: %s",
		PPPStatus[pp->state]);
	if (pp->state == PPP_OPEN) {
		tprintf("   (open for %s)\n",uptime(pp->upsince,time(0L)));
	} else {
		tprintf("\n");
	}
	tprintf("\t    SndIP: %ld  SndLCP: %d  SndPAP: %d  SndIPCP: %d\n",
		pp->sndip,pp->sndlcp,pp->sndpap,pp->sndipcp);
	if (sp->escaped & PPP_XMT_VJCOMPR) {
		tprintf("\t      (IP) NotTCP: %ld  AsIsTCP: %ld  CmpTCP: %ld  UncmpTCP: %ld\n",
			scp->sls_nontcp,scp->sls_asistcp,scp->sls_compressed,scp->sls_uncompressed);
	}
	tprintf("\t    RcvIP: %ld  RcvLCP: %d  RcvPAP: %d  RcvIPCP: %d  RcvUnknown: %d\n",
		pp->rcvip,pp->rcvlcp,pp->rcvpap,pp->rcvipcp,pp->rcvunk);
	if (sp->escaped & PPP_RCV_VJCOMPR) {
		tprintf("\t      (IP) NotTCP: %ld  AsIsTCP: %ld  CmpTCP: %ld  UncmpTCP: %ld\n",
			scp->sls_nontcpin,scp->sls_tcpin,scp->sls_compressedin,scp->sls_uncompressedin);
		tprintf("\t           Unknown: %ld  CmpError: %ld\n",
			scp->sls_errorin,scp->sls_tossed);
	}
	return;
}

static void
lcpstat(lcpiop)
struct lcpctl *lcpiop;
{
	struct lcpparm *localp, *remotep;

	localp = &(lcpiop->lclparm);
	remotep = &(lcpiop->remparm);
d505 2
a506 15
	tprintf("\tLCP state: %s\n",LCPStatus[lcpiop->lcp_state]);
	tprintf("\t\t\t\tLocal options\tRemote options\n");
	tprintf("\t    MRU:\t\t%d\t\t%d\n",
		localp->mru,remotep->mru);
	tprintf("\t    Ctl Map:\t\t0x%08lx\t0x%08lx\n",
		localp->ctl_map,remotep->ctl_map);
	tprintf("\t    Auth Prot:\t\t%s\t\t%s\n",
		((localp->auth_type == PAP_AUTH_TYPE) ? "PAP" : "None"),
		((remotep->auth_type == PAP_AUTH_TYPE) ? "PAP" : "None"));
	tprintf("\t    Protocol Compr:\t%s\t\t%s\n",
		(localp->prot_compress ? "ON" : "OFF"),
		(remotep->prot_compress ? "ON" : "OFF"));
	tprintf("\t    Addr/Ctl Compr:\t%s\t\t%s\n",
		(localp->ac_compress ? "ON" : "OFF"),
		(remotep->ac_compress ? "ON" : "OFF"));
a508 20
static void
ipcpstat(ipcpiop)
struct ipcpctl *ipcpiop;
{
	tprintf("\tIPCP state: %s\n",LCPStatus[ipcpiop->ipcp_state]);
	tprintf("\t    IPCP local IP address:\t%s\n",
		inet_ntoa(ipcpiop->attempt_src));
	tprintf("\t    IPCP remote IP address:\t%s\n",
		inet_ntoa(ipcpiop->attempt_dest));
	if (ipcpiop->lcl_ip_compr == IPCP_VJCOMPR)
		tprintf("\t    Rcv: Van Jacobson TCP header compression enabled\n");
	else
		tprintf("\t    Rcv: IP compression disabled\n");
	if (ipcpiop->rem_ip_compr == IPCP_VJCOMPR)
		tprintf("\t    Snd: Van Jacobson TCP header compression enabled\n");
	else
		tprintf("\t    Snd: IP compression disabled\n");

	return;
}
a510 47

static void
dumppool()
{
	struct iface *ifp;
	struct pppctl *pppiop;
	struct ipcppool *poolp;

	tprintf("Interface        Pool Base/Count\tNext Address\n");
	for (ifp=Ifaces; ifp != NULLIF; ifp = ifp->next) {
		if ((Slip[ifp->xdev].iface == ifp) &&
		    (Slip[ifp->xdev].type == CL_PPP)) {
			pppiop = Slip[ifp->xdev].pppio;
			poolp = pppiop->ipcpio.peer_pool;
			if (poolp == NULLPOOL)
				continue;
			tprintf("%-11s%19s/%-2d",
				ifp->name,inet_ntoa(poolp->peer_min),
				(poolp->peer_max - poolp->peer_min + 1));
			tprintf("\t%s\n",inet_ntoa(poolp->peer_next));
		}
	}
	return;
}

static struct iface *
ppplookup(ifname)
char *ifname;
{
	struct iface *ifp;

	for (ifp=Ifaces;ifp != NULLIF;ifp = ifp->next) {
		if (!strcmp(ifname,ifp->name))
			break;
	}
	if (ifp == NULLIF) {
		tprintf("Interface %s unknown\n",ifname);
		return(NULLIF);
	} else if (ifp->type != CL_PPP) {
		tprintf("Interface %s not a PPP interface\n",ifp->name);
		return(NULLIF);
	} else {
		return(ifp);
	}
}


d555 2
@


1.1
log
@Initial revision
@
text
@d29 1
a29 1
#include "slcompre.h"
@
