head	1.13;
access;
symbols;
locks;
comment	@ * @;


1.13
date	93.05.06.10.09.04;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	93.01.15.06.29.12;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	93.01.10.23.21.31;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.06.07.08.58.32;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.15.02.17.16;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.05.12.01.28;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.03.10.17.08;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.01.12.32.16;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.30.04.29.56;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.04.28.22.55.48;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.03.27.12.55.02;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.11.04.04.29.36;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.02.01.15.20.34;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.13
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Non pre-empting synchronization kernel, machine-independent portion
 * Copyright 1992 Phil Karn, KA9Q
 */
#if	defined(PROCLOG) || defined(PROCTRACE)
#include <stdio.h>
#endif
#include <dos.h>
#include <setjmp.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "timer.h"
#include "socket.h"
#include "daemon.h"
#include "hardware.h"

#ifdef	PROCLOG
FILE *proclog;
FILE *proctrace;
#endif
int Stkchk = 0;
struct proc *Curproc;		/* Currently running process */
struct proc *Rdytab;		/* Processes ready to run (not including curproc) */
struct proc *Waittab[PHASH];	/* Waiting process list */
struct proc *Susptab;		/* Suspended processes */
static struct mbuf *Killq;
struct ksig Ksig;

static void addproc(struct proc *entry);
static void delproc(struct proc *entry);

static void psig(void *event,int n);
static int procsigs(void);

/* Create a process descriptor for the main function. Must be actually
 * called from the main function, and must be called before any other
 * tasking functions are called!
 *
 * Note that standard I/O is NOT set up here.
 */
struct proc *
mainproc(name)
char *name;
{
	register struct proc *pp;

	/* Create process descriptor */
	pp = (struct proc *)callocw(1,sizeof(struct proc));

	/* Create name */
	pp->name = strdup(name);
#ifndef	AMIGA
	pp->stksize = 0;
#else
	init_psetup(pp);
#endif
	/* Make current */
	pp->state = READY;
	Curproc = pp;

#ifdef	PROCLOG
	proclog = fopen("proclog",APPEND_TEXT);
	proctrace = fopen("proctrace",APPEND_TEXT);
#endif
	return pp;
}
/* Create a new, ready process and return pointer to descriptor.
 * The general registers are not initialized, but optional args are pushed
 * on the stack so they can be seen by a C function.
 */
struct proc *
newproc(name,stksize,pc,iarg,parg1,parg2,freeargs)
char *name;		/* Arbitrary user-assigned name string */
unsigned int stksize;	/* Stack size in words to allocate */
void (*pc)();		/* Initial execution address */
int iarg;		/* Integer argument (argc) */
void *parg1;		/* Generic pointer argument #1 (argv) */
void *parg2;		/* Generic pointer argument #2 (session ptr) */
int freeargs;		/* If set, free arg list on parg1 at termination */
{
	register struct proc *pp;
	int i;

	if(Stkchk)
		chkstk();

	/* Create process descriptor */
	pp = (struct proc *)callocw(1,sizeof(struct proc));

	/* Create name */
	pp->name = strdup(name);

	/* Allocate stack */
#ifdef	AMIGA
	stksize += SIGQSIZE0;	/* DOS overhead */
#endif
	pp->stksize = stksize;
	if((pp->stack = (uint16 *)malloc(sizeof(uint16)*stksize)) == NULL){
		free(pp->name);
		free((char *)pp);
		return NULLPROC;
	}
	/* Initialize stack for high-water check */
	for(i=0;i<stksize;i++)
		pp->stack[i] = STACKPAT;

	/* Do machine-dependent initialization of stack */
	psetup(pp,iarg,parg1,parg2,pc);

	if(freeargs)
		pp->flags |= P_FREEARGS;
	pp->iarg = iarg;
	pp->parg1 = parg1;
	pp->parg2 = parg2;
	
	/* Inherit creator's input and output sockets */
	pp->input = fdup(stdin);
	pp->output = fdup(stdout);

	/* Add to ready process table */
	pp->state = READY;
	addproc(pp);
	return pp;
}

/* Free resources allocated to specified process. If a process wants to kill
 * itself, the reaper is called to do the dirty work. This avoids some
 * messy situations that would otherwise occur, like freeing your own stack.
 */
void
killproc(pp)
register struct proc *pp;
{
	char **argv;

	if(pp == NULLPROC)
		return;
	/* Don't check the stack here! Will cause infinite recursion if
	 * called from a stack error
	 */
	if(pp == Curproc)
		killself();	/* Doesn't return */
	fclose(pp->input);
	fclose(pp->output);

	/* Stop alarm clock in case it's running */
	stop_timer(&pp->alarm);

	/* Alert everyone waiting for this proc to die */
	psignal(pp,0);

	/* Remove from appropriate table */
	delproc(pp);

#ifdef	PROCLOG
	fprintf(proclog,"id %lx name %s stack %u/%u\n",ptol(pp),
		pp->name,stkutil(pp),pp->stksize);
	fclose(proclog);
	proclog = fopen("proclog",APPEND_TEXT);
	proctrace = fopen("proctrace",APPEND_TEXT);
#endif
	/* Free allocated memory resources */
	if(pp->flags & P_FREEARGS){
		argv = pp->parg1;
		while(pp->iarg-- != 0)
			free(*argv++);
		free(pp->parg1);
	}
	free(pp->name);
	free(pp->stack);
	free((char *)pp);
}
/* Terminate current process by sending a request to the killer process.
 * Automatically called when a process function returns. Does not return.
 */
void
killself()
{
	register struct mbuf *bp;

	bp = pushdown(NULLBUF,sizeof(Curproc));
	memcpy(bp->data,(char *)&Curproc,sizeof(Curproc));
	enqueue(&Killq,bp);

	/* "Wait for me; I will be merciful and quick." */
	for(;;)
		pwait(NULL);
}
/* Process used by processes that want to kill themselves */
void
killer(i,v1,v2)
int i;
void *v1;
void *v2;
{
	struct proc *pp;
	struct mbuf *bp;

	for(;;){
		while(Killq == NULLBUF)
			pwait(&Killq);
		bp = dequeue(&Killq);
		pullup(&bp,(char *)&pp,sizeof(pp));
		free_p(bp);
		if(pp != Curproc)	/* We're immortal */
			killproc(pp);
	}						
}

/* Inhibit a process from running */
void
suspend(pp)
struct proc *pp;
{
	if(pp == NULLPROC)
		return;
	if(pp != Curproc)
		delproc(pp);	/* Running process isn't on any list */
	pp->state |= SUSPEND;
	if(pp != Curproc)
		addproc(pp);	/* pwait will do it for us */
	else
		pwait(NULL);
}
/* Restart suspended process */
void
resume(pp)
struct proc *pp;
{
	if(pp == NULLPROC)
		return;
	delproc(pp);	/* Can't be Curproc! */
	pp->state &= ~SUSPEND;
	addproc(pp);
}

/* Wakeup waiting process, regardless of event it's waiting for. The process
 * will see a return value of "val" from its pwait() call. Must not be
 * called from an interrupt handler.
 */
void
alert(pp,val)
struct proc *pp;
int val;
{
	if(pp == NULLPROC)
		return;
#ifdef	notdef
	if((pp->state & WAITING) == 0)
		return;
#endif
#ifdef	PROCTRACE
	log(-1,"alert(%lx,%u) [%s]",ptol(pp),val,pp->name);
#endif
	if(pp != Curproc)
		delproc(pp);
	pp->state &= ~WAITING;
	pp->retval = val;
	pp->event = NULL;
	if(pp != Curproc)
		addproc(pp);
}

/* Post a wait on a specified event and give up the CPU until it happens. The
 * null event is special: it means "I don't want to block on an event, but let
 * somebody else run for a while". It can also mean that the present process
 * is terminating; in this case the wait never returns.
 *
 * Pwait() returns 0 if the event was signaled; otherwise it returns the
 * arg in an alert() call. Pwait must not be called from interrupt level.
 *
 * Before waiting and after giving up the CPU, pwait() processes the signal
 * queue containing events signaled when interrupts were off. This means
 * the process queues are no longer modified by interrupt handlers,
 * so it is no longer necessary to run with interrupts disabled here. This
 * greatly improves interrupt latencies.
 */
int
pwait(event)
void *event;
{
	register struct proc *oldproc;
	int tmp;
	int i_state;

	if(!istate()){
		stktrace();
	}
	Ksig.pwaits++;
	if(intcontext() == 1){
		/* Pwait must not be called from interrupt context */
		Ksig.pwaitints++;
		return 0;
	}
	/* Enable interrupts, after saving the current state.
	 * This minimizes interrupt latency since we may have a lot
	 * of work to do. This seems safe, since care has been taken
	 * here to ensure that signals from interrupt level are not lost, e.g.,
	 * if we're waiting on an event, we post it before we scan the
	 * signal queue.
	 */
	i_state = istate();
	enable();
	if(Stkchk)
		chkstk();
	
	if(event != NULL){
		/* Post a wait for the specified event */
		Curproc->event = event;
		Curproc->state = WAITING;
		addproc(Curproc);	/* Put us on the wait list */
	}
	/* If the signal queue contains a signal for the event that we're
	 * waiting for, this will wake us back up
	 */
	procsigs();
	if(event == NULL){
		/* We remain runnable */
		if(Rdytab == NULLPROC){
			/* Nothing else is ready, so just return */
			Ksig.pwaitnops++;
			restore(i_state);
			return 0;
		}
		addproc(Curproc); /* Put us on the end of the ready list */
	}
	/* Look for a ready process and run it. If there are none,
	 * loop or halt until an interrupt makes something ready.
	 */
	while(Rdytab == NULLPROC){
		/* Give system back to upper-level multitasker, if any.
		 * Note that this function enables interrupts internally
		 * to prevent deadlock, but it restores our state
		 * before returning.
		 */
		giveup();
		/* Process signals that occurred during the giveup() */
		procsigs();
	}
	/* Remove first entry from ready list */
	oldproc = Curproc;
	Curproc = Rdytab;
	delproc(Curproc);

	/* Now do the context switch.
	 * This technique was inspired by Rob, PE1CHL, and is a bit tricky.
	 *
	 * First save the current process's state. Then if
	 * this is still the old process, load the new environment. Since the
	 * new task will "think" it's returning from the setjmp() with a return
	 * value of 1, the comparison with 0 will bypass the longjmp(), which
	 * would otherwise cause an infinite loop.
	 */
#ifdef	PROCTRACE
	if(strcmp(oldproc->name,Curproc->name) != 0){
		log(-1,"-> %s(%d)",Curproc->name,!!(Curproc->flags & P_ISTATE);
	}
#endif
	/* Save old state */
	oldproc->flags &= ~P_ISTATE;
	if(i_state)
		oldproc->flags |= P_ISTATE;
	if(setjmp(oldproc->env) == 0){
		/* We're still running in the old task; load new task context.
		 * The interrupt state is restored here in case longjmp
		 * doesn't do it (e.g., systems other than Turbo-C).
		 */
		restore(Curproc->flags & P_ISTATE);
		longjmp(Curproc->env,1);
	}
	/* At this point, we're running in the newly dispatched task */
	tmp = Curproc->retval;
	Curproc->retval = 0;

	/* Also restore the true interrupt state here, in case the longjmp
	 * DOES restore the interrupt state saved at the time of the setjmp().
	 * This is the case with Turbo-C's setjmp/longjmp.
	 */
	restore(Curproc->flags & P_ISTATE);

	/* If an exception signal was sent and we're prepared, take it */
	if((Curproc->flags & P_SSET) && tmp == Curproc->signo)
		longjmp(Curproc->sig,1);

	/* Otherwise return normally to the new task */
	return tmp;
}

void
psignal(event,n)
void *event;
int n;
{
	static void *lastevent;

	if(istate()){
		/* Interrupts are on, just call psig directly after
		 * processing the previously queued signals
		 */
		procsigs();
		psig(event,n);
		return;
	}
	/* Interrupts are off, so quickly queue event */
	Ksig.psigsqueued++;

 	/* Ignore duplicate signals to protect against a mad device driver
	 * overflowing the signal queue
	 */
	if(event == lastevent && Ksig.nentries != 0){
		Ksig.dupsigs++;
		return; 
	}
	if(Ksig.nentries == SIGQSIZE){
		/* It's hard to handle this gracefully */
		Ksig.lostsigs++;
		return;
	}
	lastevent = Ksig.wp->event = event;
	Ksig.wp->n = n;
	if(++Ksig.wp >= &Ksig.entry[SIGQSIZE])
		Ksig.wp = Ksig.entry;
	Ksig.nentries++;
}
static int
procsigs()
{
	int cnt = 0;
	int tmp;
	int i_state;

	for(;;){
		/* Atomic read and decrement of entry count */
		i_state = dirps();
		tmp = Ksig.nentries;
		if(tmp != 0)
			Ksig.nentries--;
		restore(i_state);
		if(tmp == 0)
			break;
		psig(Ksig.rp->event,Ksig.rp->n);
		if(++Ksig.rp >= &Ksig.entry[SIGQSIZE])
			Ksig.rp = Ksig.entry;
		cnt++;
	}
	if(cnt > Ksig.maxentries)
		Ksig.maxentries = cnt;	/* Record high water mark */
	return cnt;
}
/* Make ready the first 'n' processes waiting for a given event. The ready
 * processes will see a return value of 0 from pwait().  Note that they don't
 * actually get control until we explicitly give up the CPU ourselves through
 * a pwait(). psig is now called from pwait, which is never called at
 * interrupt time, so it is no longer necessary to protect the proc queues
 * against interrupts. This also helps interrupt latencies considerably.
 */
static void
psig(event,n)
void *event;	/* Event to signal */
int n;		/* Max number of processes to wake up */
{
	register struct proc *pp;
	struct proc *pnext;
	unsigned int hashval;
	int cnt = 0;

	Ksig.psigs++;
	if(Stkchk)
		chkstk();

	if(event == NULL){
		Ksig.psignops++;
		return;		/* Null events are invalid */
	}
	/* n == 0 means "signal everybody waiting for this event" */
	if(n == 0)
		n = 65535;

	hashval = phash(event);
	for(pp = Waittab[hashval];n != 0 && pp != NULLPROC;pp = pnext){
		pnext = pp->next;
		if(pp->event == event){
#ifdef	PROCTRACE
				log(-1,"psignal(%lx,%u) wake %lx [%s]",ptol(event),n,
				 ptol(pp),pp->name);
#endif
			delproc(pp);
			pp->state &= ~WAITING;
			pp->retval = 0;
			pp->event = NULL;
			addproc(pp);
			n--;
			cnt++;
		}
	}
	for(pp = Susptab;n != 0 && pp != NULLPROC;pp = pnext){
		pnext = pp->next;
		if(pp->event == event){
#ifdef	PROCTRACE
				log(-1,"psignal(%lx,%u) wake %lx [%s]",ptol(event),n,
				 ptol(pp),pp->name);
#endif /* PROCTRACE */
			delproc(pp);
			pp->state &= ~WAITING;
			pp->event = 0;
			pp->retval = 0;
			addproc(pp);
			n--;
			cnt++;
		}
	}
	if(cnt == 0)
		Ksig.psignops++;
	else
		Ksig.psigwakes += cnt;
}

/* Rename a process */
void
chname(pp,newname)
struct proc *pp;
char *newname;
{
	free(pp->name);
	pp->name = strdup(newname);
}
/* Remove a process entry from the appropriate table */
static void
delproc(entry)
register struct proc *entry;	/* Pointer to entry */
{
	if(entry == NULLPROC)
		return;

	if(entry->next != NULLPROC)
		entry->next->prev = entry->prev;
	if(entry->prev != NULLPROC){
		entry->prev->next = entry->next;
	} else {
		switch(entry->state){
		case READY:
			Rdytab = entry->next;
			break;
		case WAITING:
			Waittab[phash(entry->event)] = entry->next;
			break;
		case SUSPEND:
		case SUSPEND|WAITING:
			Susptab = entry->next;
			break;
		}
	}
}
/* Append proc entry to end of appropriate list */
static void
addproc(entry)
register struct proc *entry;	/* Pointer to entry */
{
	register struct proc *pp;
	struct proc **head;

	if(entry == NULLPROC)
		return;

	switch(entry->state){
	case READY:
		head = &Rdytab;
		break;
	case WAITING:
		head = &Waittab[phash(entry->event)];
		break;
	case SUSPEND:
	case SUSPEND|WAITING:
		head = &Susptab;
		break;
	}
	entry->next = NULLPROC;
	if(*head == NULLPROC){
		/* Empty list, stick at beginning */
		entry->prev = NULLPROC;
		*head = entry;
	} else {
		/* Find last entry on list */
		for(pp = *head;pp->next != NULLPROC;pp = pp->next)
			;
		pp->next = entry;
		entry->prev = pp;
	}
}
@


1.12
log
@Remove kbint() poll
@
text
@d29 2
a30 2
static void addproc __ARGS((struct proc *entry));
static void delproc __ARGS((struct proc *entry));
d32 2
a33 2
static void psig __ARGS((void *event,int n));
static int procsigs __ARGS((void));
d98 1
a98 1
	if((pp->stack = (int16 *)malloc(sizeof(int16)*stksize)) == NULL){
d356 1
a356 1
		log(-1,"-> %s(%d)",Curproc->name,!!(Curproc->flags & P_ISTATE));
@


1.11
log
@Go back to dirps/restore, remove pragma inline
@
text
@a335 1
		kbint();	/***/
@


1.10
log
@s920612
@
text
@a0 1
#pragma inline
d431 1
d435 1
a435 1
		DISABLE();
d439 1
a439 1
		RESTORE();
@


1.9
log
@src0514
@
text
@d1 1
d33 1
a33 1
static void _psignal __ARGS((void *event,int n));
d399 1
a399 1
		/* Interrupts are on, just call _psignal directly after
d403 1
a403 1
		_psignal(event,n);
d442 1
a442 1
		_psignal(Ksig.rp->event,Ksig.rp->n);
d454 1
a454 1
 * a pwait(). _psignal is now called from pwait, which is never called at
d459 1
a459 1
_psignal(event,n)
@


1.8
log
@src0505
@
text
@a3 1

a170 1
	free(pp->outbuf);
d253 1
a253 2
	printf("alert(%lx,%u) [%s]\n",ptol(pp),val,pp->name);
	fflush(stdout);
d286 3
d357 1
a357 2
	  	printf("-> %s(%d)\n",Curproc->name,!!(Curproc->flags & P_ISTATE));
		fflush(stdout);
d398 4
a401 1
		/* Interrupts are on, just call _psignal directly */
d475 1
a475 1
	/* n = 0 means "signal everybody waiting for this event" */
d484 1
a484 1
				printf("psignal(%lx,%u) wake %lx [%s]\n",ptol(event),n,
a485 1
				fflush(stdout);
d500 1
a500 1
				printf("psignal(%lx,%u) wake %lx [%s]\n",ptol(event),n,
a501 1
				fflush(stdout);
@


1.7
log
@src0503
@
text
@d2 1
a2 1
 * Copyright 1991 Phil Karn, KA9Q
a4 2
#define	SUSPEND_PROC	1

d37 3
a39 1
 * called from the main function!
d111 2
a112 1
	pp->freeargs = freeargs;
a141 1

a145 2
	/* Close any open sockets */
	freesock(pp);
d164 1
a164 1
	if(pp->freeargs){
d183 4
a186 5
	if(Curproc != NULLPROC){
		bp = pushdown(NULLBUF,sizeof(Curproc));
		memcpy(bp->data,(char *)&Curproc,sizeof(Curproc));
		enqueue(&Killq,bp);
	}
a211 1
#ifdef	SUSPEND_PROC
a237 1
#endif	/* SUSPEND_PROC */
d262 1
a262 1
	pp->event = 0;
d307 1
a307 1
	if(Curproc != NULLPROC && event != NULL){
d317 1
a317 1
	if(Curproc != NULLPROC && event == NULL){
d349 1
a349 2
	 * If the old process has gone away, simply load the new process's
	 * environment. Otherwise, save the current process's state. Then if
d357 1
a357 1
	  	printf("-> %s(%d)\n",Curproc->name,!!Curproc->i_state);
d361 5
a365 5
	/* Note use of comma operator to save old interrupt state only if
	 * oldproc is non-null
	 */
	if(oldproc == NULLPROC
	 || (oldproc->i_state = i_state, setjmp(oldproc->env) == 0)){
d370 1
a370 1
		restore(Curproc->i_state);
d381 7
a387 1
	restore(Curproc->i_state);
a494 1
#ifdef	SUSPEND_PROC
a511 1
#endif	/* SUSPEND_PROC */
a546 1
#ifdef	SUSPEND_PROC
a550 1
#endif
a571 1
#ifdef	SUSPEND_PROC
a575 1
#endif
@


1.6
log
@src0501
@
text
@d117 2
a118 4
	usesock(fileno(stdin));
	pp->input = stdin;
	usesock(fileno(stdout));
	pp->output = stdout;
d144 2
@


1.5
log
@src0429a
@
text
@d117 4
a120 4
	usesock(Curproc->input);
	pp->input = Curproc->input;
	usesock(Curproc->output);
	pp->output = Curproc->output;
@


1.4
log
@src0428
@
text
@d30 1
a30 2
struct kstat Kstat;
struct sigq Sigq;
d36 1
d292 1
d294 1
a294 1
	Kstat.pwaits++;
d297 1
a297 1
		Kstat.pwaitints++;
d300 29
a328 23
	while(Sigq.nentries != 0){
		_psignal(Sigq.rp->event,Sigq.rp->n);
		if(++Sigq.rp >= &Sigq.entry[SIGQSIZE])
			Sigq.rp = Sigq.entry;
		Sigq.nentries--;
	}
	if(Curproc != NULLPROC){	/* If process isn't terminating */
		if(Stkchk)
			chkstk();

		if(event == NULL){
			/* Special case; just give up the processor.
			 *
			 * Optimization: if nothing else is ready, just return.
			 */
			if(Rdytab == NULLPROC){
				Kstat.pwaitnops++;
				return 0;
			}
		} else {
			/* Post a wait for the specified event */
			Curproc->event = event;
			Curproc->state = WAITING;
d330 1
a330 1
		addproc(Curproc);
d343 2
a344 9
		/* Process the signal queue again, in case an interrupt
		 * occurred during the giveup()
		 */
		while(Sigq.nentries != 0){
			_psignal(Sigq.rp->event,Sigq.rp->n);
			if(++Sigq.rp >= &Sigq.entry[SIGQSIZE])
				Sigq.rp = Sigq.entry;
			Sigq.nentries--;
		}
d371 1
a371 1
	 || (oldproc->i_state = istate(), setjmp(oldproc->env) == 0)){
d396 2
d404 1
a404 1
	Kstat.psigsqueued++;
d406 1
a406 1
	/* Ignore duplicate signals to protect against a mad device driver
d409 2
a410 2
	if(Sigq.nentries != 0 && Sigq.wp->event == event){
		Sigq.dupsigs++;
d413 1
a413 1
	if(Sigq.nentries == SIGQSIZE){
d415 1
a415 1
		Sigq.lostsigs++;
d418 29
a446 6
	Sigq.wp->event = event;
	Sigq.wp->n = n;
	if(++Sigq.wp >= &Sigq.entry[SIGQSIZE])
		Sigq.wp = Sigq.entry;
	if(++Sigq.nentries > Sigq.maxentries)
		Sigq.maxentries = Sigq.nentries;
d465 1
a465 1
	Kstat.psigs++;
d470 1
a470 1
		Kstat.psignops++;
d515 3
a517 1
		Kstat.psignops++;
@


1.3
log
@src0327
@
text
@d30 2
d36 2
d96 1
a96 1
	stksize += 2000;	/* DOS overhead */
d245 2
a246 1
 * will see a return value of "val" from its pwait() call.
d280 5
a284 3
 * Note that pwait can run with interrupts enabled even though it examines
 * a few global variables that can be modified by psignal at interrupt time.
 * These *seem* safe.
d293 12
d315 1
d336 9
d391 32
d426 3
a428 2
 * a pwait(). Psignal may be called from interrupt level. It returns the
 * number of processes that were woken up.
d430 2
a431 2
int
psignal(event,n)
a436 1
	int i_state;
d440 1
d444 4
a447 3
	if(event == NULL)
		return 0;		/* Null events are invalid */

a452 1
	i_state = dirps();
a456 1
			if(i_state){
a459 1
			}
a474 1
			if(i_state){
a477 1
			}
d489 2
a490 2
	restore(i_state);
	return cnt;
a506 2
	int i_state;

a509 1
	i_state = dirps();
a529 1
	restore(i_state);
a537 1
	int i_state;
a556 1
	i_state = dirps();
a567 1
	restore(i_state);
@


1.2
log
@src1216
@
text
@a141 1

a143 3

	close_s(pp->input);
	close_s(pp->output);
@


1.1
log
@Initial revision
@
text
@d24 1
a24 1
int Stkchk = 1;
@
