head	1.24;
access;
symbols;
locks;
comment	@ * @;


1.24
date	93.05.06.10.08.50;	author karn;	state Exp;
branches;
next	1.23;

1.23
date	92.12.28.09.02.01;	author karn;	state Exp;
branches;
next	1.22;

1.22
date	92.12.03.08.14.38;	author karn;	state Exp;
branches;
next	1.21;

1.21
date	92.12.02.18.22.43;	author karn;	state Exp;
branches;
next	1.20;

1.20
date	92.10.07.19.39.49;	author karn;	state Exp;
branches;
next	1.19;

1.19
date	92.09.09.01.31.23;	author karn;	state Exp;
branches;
next	1.18;

1.18
date	92.09.01.19.46.51;	author karn;	state Exp;
branches;
next	1.17;

1.17
date	92.08.20.15.29.17;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	92.08.06.00.46.41;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.05.05.09.38.02;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.05.01.08.21.42;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.04.29.11.39.28;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.04.19.06.48.48;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.04.08.08.27.16;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.04.06.12.38.54;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.04.01.14.31.58;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.03.31.10.37.40;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.03.27.23.23.40;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	91.08.22.00.32.00;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.06.01.05.03.14;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.04.23.10.17.54;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.04.20.09.54.38;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.02.01.13.04.38;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.24
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* IP interface control and configuration routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "iface.h"
#include "ip.h"
#include "icmp.h"
#include "netuser.h"
#include "ax25.h"
#include "enet.h"
#include "pktdrvr.h"
#include "cmdparse.h"
#include "commands.h"
#include "trace.h"

static void showiface(struct iface *ifp);
static int mask2width(int32 mask);
static int ifipaddr(int argc,char *argv[],void *p);
static int iflinkadr(int argc,char *argv[],void *p);
static int ifbroad(int argc,char *argv[],void *p);
static int ifnetmsk(int argc,char *argv[],void *p);
static int ifrxbuf(int argc,char *argv[],void *p);
static int ifmtu(int argc,char *argv[],void *p);
static int ifforw(int argc,char *argv[],void *p);
static int ifencap(int argc,char *argv[],void *p);
static int iftxqlen(int argc,char *argv[],void *p);

/* Interface list header */
struct iface *Ifaces = &Loopback;

/* Loopback pseudo-interface */
struct iface Loopback = {
	&Encap,		/* Link to next entry */
	"loopback",	/* name		*/
	0x7f000001L,	/* addr		127.0.0.1 */
	0xffffffffL,	/* broadcast	255.255.255.255 */
	0xffffffffL,	/* netmask	255.255.255.255 */
	MAXINT16,	/* mtu		No limit */
	0,		/* trace	*/
	NULLFILE,	/* trfp		*/
	NULLIF,		/* forw		*/
	NULLPROC,	/* rxproc	*/
	NULLPROC,	/* txproc	*/
	NULLPROC,	/* supv		*/
	NULLBUF,	/* outq		*/
	0,		/* outlim	*/
	0,		/* txbusy	*/
	NULL,		/* dstate	*/
	NULL,		/* dtickle	*/
	NULL,		/* dstatus	*/
	0,		/* dev		*/
	NULL,		/* (*ioctl)	*/
	NULLFP,		/* (*iostatus)	*/
	NULLFP,		/* (*stop)	*/
	NULLCHAR,	/* hwaddr	*/
	NULL,		/* extension	*/
	0,		/* xdev		*/
	&Iftypes[0],	/* iftype	*/
	NULLFP,		/* (*send)	*/
	NULLFP,		/* (*output)	*/
	NULLFP,		/* (*raw)	*/
	NULLFP,		/* (*status)	*/
	NULLFP,		/* (*discard)	*/
	NULLFP,		/* (*echo)	*/
	0,		/* ipsndcnt	*/
	0,		/* rawsndcnt	*/
	0,		/* iprecvcnt	*/
	0,		/* rawrcvcnt	*/
	0,		/* lastsent	*/
	0,		/* lastrecv	*/
};
/* Encapsulation pseudo-interface */
struct iface Encap = {
	NULLIF,
	"encap",	/* name		*/
	INADDR_ANY,	/* addr		0.0.0.0 */
	0xffffffffL,	/* broadcast	255.255.255.255 */
	0xffffffffL,	/* netmask	255.255.255.255 */
	MAXINT16,	/* mtu		No limit */
	0,		/* trace	*/
	NULLFILE,	/* trfp		*/
	NULLIF,		/* forw		*/
	NULLPROC,	/* rxproc	*/
	NULLPROC,	/* txproc	*/
	NULLPROC,	/* supv		*/
	NULLBUF,	/* outq		*/
	0,		/* outlim	*/
	0,		/* txbusy	*/
	NULL,		/* dstate	*/
	NULL,		/* dtickle	*/
	NULL,		/* dstatus	*/
	0,		/* dev		*/
	NULL,		/* (*ioctl)	*/
	NULLFP,		/* (*iostatus)	*/
	NULLFP,		/* (*stop)	*/
	NULLCHAR,	/* hwaddr	*/
	NULL,		/* extension	*/
	0,		/* xdev		*/
	&Iftypes[0],	/* iftype	*/
	ip_encap,	/* (*send)	*/
	NULLFP,		/* (*output)	*/
	NULLFP,		/* (*raw)	*/
	NULLFP,		/* (*status)	*/
	NULLFP,		/* (*discard)	*/
	NULLFP,		/* (*echo)	*/
	0,		/* ipsndcnt	*/
	0,		/* rawsndcnt	*/
	0,		/* iprecvcnt	*/
	0,		/* rawrcvcnt	*/
	0,		/* lastsent	*/
	0,		/* lastrecv	*/
};

char Noipaddr[] = "IP address field missing, and ip address not set\n";

struct cmds Ifcmds[] = {
	"broadcast",		ifbroad,	0,	2,	NULLCHAR,
	"encapsulation",	ifencap,	0,	2,	NULLCHAR,
	"forward",		ifforw,		0,	2,	NULLCHAR,
	"ipaddress",		ifipaddr,	0,	2,	NULLCHAR,
	"linkaddress",		iflinkadr,	0,	2,	NULLCHAR,
	"mtu",			ifmtu,		0,	2,	NULLCHAR,
	"netmask",		ifnetmsk,	0,	2,	NULLCHAR,
	"txqlen",		iftxqlen,	0,	2,	NULLCHAR,
	"rxbuf",		ifrxbuf,	0,	2,	NULLCHAR,
	NULLCHAR,
};
/*
 * General purpose interface transmit task, one for each device that can
 * send IP datagrams. It waits on the interface's IP output queue (outq),
 * extracts IP datagrams placed there in priority order by ip_route(),
 * and sends them to the device's send routine.
 */
void
if_tx(dev,arg1,unused)
int dev;
void *arg1;
void *unused;
{
	struct mbuf *bp;	/* Buffer to send */
	struct iface *iface;	/* Pointer to interface control block */
	struct qhdr qhdr;

	iface = arg1;
	for(;;){
		while(iface->outq == NULLBUF)
			pwait(&iface->outq);

		iface->txbusy = 1;
		bp = dequeue(&iface->outq);
		pullup(&bp,(char *)&qhdr,sizeof(qhdr));
		if(iface->dtickle != NULL && (*iface->dtickle)(iface) == -1){
#ifdef	notdef	/* Confuses some non-compliant hosts */
			struct ip ip;

			/* Link redial failed; bounce with unreachable */
			ntohip(&ip,&bp);
			icmp_output(&ip,bp,ICMP_DEST_UNREACH,ICMP_HOST_UNREACH,
			 NULLICMP);
#endif
			free_p(bp);
		} else {
			(*iface->send)(bp,iface,qhdr.gateway,qhdr.tos);
		}
		iface->txbusy = 0;

		/* Let other tasks run, just in case send didn't block */
		pwait(NULL);
	}
}
/* Process packets in the Hopper */
void
network(i,v1,v2)
int i;
void *v1;
void *v2;
{
	struct mbuf *bp;
	char i_state;
	struct iftype *ift;
	struct iface *ifp;

loop:
	for(;;){
		i_state = dirps();
		bp = Hopper;
		if(bp != NULLBUF){
			bp = dequeue(&Hopper);
			restore(i_state);
			break;
		}
		restore(i_state);
		pwait(&Hopper);
	}
	/* Process the input packet */
	pullup(&bp,(char *)&ifp,sizeof(ifp));
	if(ifp != NULLIF){
		ifp->rawrecvcnt++;
		ifp->lastrecv = secclock();
		ift = ifp->iftype;
	} else {
		ift = &Iftypes[0];
	}
	dump(ifp,IF_TRACE_IN,bp);
	
	if(ift->rcvf != NULLVFP)
		(*ift->rcvf)(ifp,bp);
	else
		free_p(bp);	/* Nowhere to send it */
	/* Let everything else run - this keeps the system from wedging
	 * when we're hit by a big burst of packets
	 */
	pwait(NULL);
	goto loop;
}

/* put mbuf into Hopper for network task
 * returns 0 if OK
 */
int
net_route(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	bp = pushdown(bp,sizeof(ifp));
	memcpy(&bp->data[0],(char *)&ifp,sizeof(ifp));
	enqueue(&Hopper,bp);
	return 0;
}

/* Null send and output routines for interfaces without link level protocols */
int
nu_send(bp,ifp,gateway,tos)
struct mbuf *bp;
struct iface *ifp;
int32 gateway;
int tos;
{
	return (*ifp->raw)(ifp,bp);
}
int
nu_output(ifp,dest,src,type,bp)
struct iface *ifp;
char *dest;
char *src;
uint16 type;
struct mbuf *bp;
{
	return (*ifp->raw)(ifp,bp);
}

/* Set interface parameters */
int
doifconfig(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;
	int i;

	if(argc < 2){
		for(ifp = Ifaces;ifp != NULLIF;ifp = ifp->next)
			showiface(ifp);
		return 0;
	}
	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	if(argc == 2){
		showiface(ifp);
		if(ifp->show != NULLVFP){
			(*ifp->show)(ifp);
		}
		return 0;
	}
	if(argc == 3){
		printf("Argument missing\n");
		return 1;
	}
	for(i=2;i<argc-1;i+=2)
		subcmd(Ifcmds,3,&argv[i-1],ifp);

	return 0;
}

/* Set interface IP address */
static int
ifipaddr(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;

	ifp->addr = resolve(argv[1]);
	return 0;
}


/* Set link (hardware) address */
static int
iflinkadr(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;

	if(ifp->iftype == NULLIFT || ifp->iftype->scan == NULL){
		printf("Can't set link address\n");
		return 1;
	}
	if(ifp->hwaddr != NULLCHAR)
		free(ifp->hwaddr);
	ifp->hwaddr = mallocw(ifp->iftype->hwalen);
	(*ifp->iftype->scan)(ifp->hwaddr,argv[1]);
	return 0;
}

/* Set interface broadcast address. This is actually done
 * by installing a private entry in the routing table.
 */
static int
ifbroad(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;
	struct route *rp;

	rp = rt_blookup(ifp->broadcast,32);
	if(rp != NULLROUTE && rp->iface == ifp)
		rt_drop(ifp->broadcast,32);
	ifp->broadcast = resolve(argv[1]);
	rt_add(ifp->broadcast,32,0L,ifp,1L,0L,1);
	return 0;
}

/* Set the network mask. This is actually done by installing
 * a routing entry.
 */
static int
ifnetmsk(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;
	struct route *rp;

	/* Remove old entry if it exists */
	rp = rt_blookup(ifp->addr & ifp->netmask,mask2width(ifp->netmask));
	if(rp != NULLROUTE)
		rt_drop(rp->target,rp->bits);

	ifp->netmask = htol(argv[1]);
	rt_add(ifp->addr,mask2width(ifp->netmask),0L,ifp,0L,0L,0);
	return 0;
}

/* Command to set interface encapsulation mode */
static int
ifencap(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;

	if(setencap(ifp,argv[1]) != 0){
		printf("Encapsulation mode '%s' unknown\n",argv[1]);
		return 1;
	}
	return 0;
}
/* Function to set encapsulation mode */
int
setencap(ifp,mode)
struct iface *ifp;
char *mode;
{
	struct iftype *ift;

	for(ift = &Iftypes[0];ift->name != NULLCHAR;ift++)
		if(strnicmp(ift->name,mode,strlen(mode)) == 0)
			break;
	if(ift->name == NULLCHAR)
		return -1;

	if(ifp != NULLIF){
		ifp->iftype = ift;
		ifp->send = ift->send;
		ifp->output = ift->output;
	}
	return 0;
}
/* Set interface receive buffer size */
static int
ifrxbuf(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return 0;	/* To be written */
}

/* Set interface Maximum Transmission Unit */
static int
ifmtu(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;

	ifp->mtu = atoi(argv[1]);
	return 0;
}

/* Set interface forwarding */
static int
ifforw(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;

	ifp->forw = if_lookup(argv[1]);
	if(ifp->forw == ifp)
		ifp->forw = NULLIF;
	return 0;
}

/* Display the parameters for a specified interface */
static void
showiface(ifp)
register struct iface *ifp;
{
	char tmp[25];

	printf("%-10s IP addr %s MTU %u Link encap %s\n",ifp->name,
	 inet_ntoa(ifp->addr),(int)ifp->mtu,
	 ifp->iftype != NULL ? ifp->iftype->name : "not set");
	if(ifp->iftype != NULL && ifp->iftype->format != NULL && ifp->hwaddr != NULLCHAR){
		printf("           Link addr %s\n",
		 (*ifp->iftype->format)(tmp,ifp->hwaddr));
	}
	printf("           trace 0x%x netmask 0x%08lx broadcast %s\n",
		ifp->trace,ifp->netmask,inet_ntoa(ifp->broadcast));
	if(ifp->forw != NULLIF)
		printf("           output forward to %s\n",ifp->forw->name);
	printf("           sent: ip %lu tot %lu idle %s qlen %u",
	 ifp->ipsndcnt,ifp->rawsndcnt,tformat(secclock() - ifp->lastsent),
		len_q(ifp->outq));
	if(ifp->outlim != 0)
		printf("/%u",ifp->outlim);
	if(ifp->txbusy)
		printf(" BUSY");
	printf("\n");
	printf("           recv: ip %lu tot %lu idle %s\n",
	 ifp->iprecvcnt,ifp->rawrecvcnt,tformat(secclock() - ifp->lastrecv));
}

/* Command to detach an interface */
int
dodetach(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp;

	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	if(if_detach(ifp) == -1)
		printf("Can't detach loopback or encap interface\n");
	return 0;
}
/* Detach a specified interface */
int
if_detach(ifp)
register struct iface *ifp;
{
	struct iface *iftmp;
	struct route *rp,*rptmp;
	int i,j;

	if(ifp == &Loopback || ifp == &Encap)
		return -1;

	/* Drop all routes that point to this interface */
	if(R_default.iface == ifp)
		rt_drop(0L,0);	/* Drop default route */

	for(i=0;i<HASHMOD;i++){
		for(j=0;j<32;j++){
			for(rp = Routes[j][i];rp != NULLROUTE;rp = rptmp){
				/* Save next pointer in case we delete this entry */
				rptmp = rp->next;
				if(rp->iface == ifp)
					rt_drop(rp->target,rp->bits);
			}
		}
	}
	/* Unforward any other interfaces forwarding to this one */
	for(iftmp = Ifaces;iftmp != NULLIF;iftmp = iftmp->next){
		if(iftmp->forw == ifp)
			iftmp->forw = NULLIF;
	}
	/* Call device shutdown routine, if any */
	if(ifp->stop != NULLFP)
		(*ifp->stop)(ifp);

	killproc(ifp->rxproc);
	killproc(ifp->txproc);
	killproc(ifp->supv);

	/* Free allocated memory associated with this interface */
	if(ifp->name != NULLCHAR)
		free(ifp->name);
	if(ifp->hwaddr != NULLCHAR)
		free(ifp->hwaddr);
	/* Remove from interface list */
	if(ifp == Ifaces){
		Ifaces = ifp->next;
	} else {
		/* Search for entry just before this one
		 * (necessary because list is only singly-linked.)
		 */
		for(iftmp = Ifaces;iftmp != NULLIF ;iftmp = iftmp->next)
			if(iftmp->next == ifp)
				break;
		if(iftmp != NULLIF && iftmp->next == ifp)
			iftmp->next = ifp->next;
	}
	/* Finally free the structure itself */
	free((char *)ifp);
	return 0;
}
static int
iftxqlen(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;

	setint(&ifp->outlim,"TX queue limit",argc,argv);
	return 0;
}

/* Given the ascii name of an interface, return a pointer to the structure,
 * or NULLIF if it doesn't exist
 */
struct iface *
if_lookup(name)
char *name;
{
	register struct iface *ifp;

	for(ifp = Ifaces; ifp != NULLIF; ifp = ifp->next)
		if(strcmp(ifp->name,name) == 0)
			break;
	return ifp;
}

/* Return iface pointer if 'addr' belongs to one of our interfaces,
 * NULLIF otherwise.
 * This is used to tell if an incoming IP datagram is for us, or if it
 * has to be routed.
 */
struct iface *
ismyaddr(addr)
int32 addr;
{
	register struct iface *ifp;

	for(ifp = Ifaces; ifp != NULLIF; ifp = ifp->next)
		if(addr == ifp->addr)
			break;
	return ifp;
}

/* Given a network mask, return the number of contiguous 1-bits starting
 * from the most significant bit.
 */
static int
mask2width(mask)
int32 mask;
{
	int width,i;

	width = 0;
	for(i = 31;i >= 0;i--){
		if(!(mask & (1L << i)))
			break;
		width++;
	}
	return width;
}

/* return buffer with name + comment */
char *
if_name(ifp,comment)
struct iface *ifp;
char *comment;
{
	char *result;

	result = mallocw(strlen(ifp->name) + strlen(comment) + 1);
	strcpy(result,ifp->name);
	strcat(result,comment);
	return result;
}

/* Raw output routine that tosses all packets. Used by dialer, tip, etc */
int
bitbucket(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	free_p(bp);
	return 0;
}
/* 
 * dial <iface> <seconds> [device dependent args]	(begin autodialing)
 * dial <iface> 0	(stop autodialing) 
 * dial <iface>	(display status)
 */
int
dodialer(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;
	int32 timeout;

	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	if(argc < 3){
		if(ifp->iftype->dstat != NULLFP)
			(*ifp->iftype->dstat)(ifp);
		return 0;
	}
	if(ifp->iftype->dinit == NULLFP){
		printf("Dialing not supported on %s\n",argv[1]);
		return 1;
	}
	timeout = atol(argv[2]) * 1000L;
	return (*ifp->iftype->dinit)(ifp,timeout,argc-3,argv+3);
}

@


1.23
log
@Minor cosmetic change to if_tx to remove unused struct ip warning
@
text
@d19 11
a29 11
static void showiface __ARGS((struct iface *ifp));
static int mask2width __ARGS((int32 mask));
static int ifipaddr __ARGS((int argc,char *argv[],void *p));
static int iflinkadr __ARGS((int argc,char *argv[],void *p));
static int ifbroad __ARGS((int argc,char *argv[],void *p));
static int ifnetmsk __ARGS((int argc,char *argv[],void *p));
static int ifrxbuf __ARGS((int argc,char *argv[],void *p));
static int ifmtu __ARGS((int argc,char *argv[],void *p));
static int ifforw __ARGS((int argc,char *argv[],void *p));
static int ifencap __ARGS((int argc,char *argv[],void *p));
static int iftxqlen __ARGS((int argc,char *argv[],void *p));
d249 1
a249 1
int16 type;
@


1.22
log
@#ifdef out ICMP unreachable message when dialer attempt fails (they
cause some non-host-compliant systems to drop connections...argh!)
@
text
@a145 1
	struct ip ip;
d156 3
a159 1
#ifdef	notdef	/* Confuses some non-compliant hosts */
@


1.21
log
@Test interface tickle routine return value. If link redial attempt
fails, bounce packet with ICMP destination unreachable.
@
text
@d158 1
d160 1
a160 1
			icmp_output(&ip,bp,ICMP_DEST_UNREACH,ICMP_DEST_UNREACH,
d162 1
@


1.20
log
@Many changes to support new generic demand dialer stuff. "dialer"
top-level command moved here from dialer.c, changed to use functions
in iftype table, dialer "tickle" functions called from if_tx().
@
text
@d10 1
d146 1
d156 9
a164 3
		if(iface->dtickle != NULL)
			(*iface->dtickle)(iface);
		(*iface->send)(bp,iface,qhdr.gateway,qhdr.tos);
@


1.19
log
@Add txbusy flag to interface transmit routine
@
text
@a40 1
	0,		/* flags	*/
d50 3
a81 1
	0,		/* flags	*/
d91 3
d154 2
d382 1
a382 1
	if(ift->name == NULLCHAR){
d384 5
a389 3
	ifp->iftype = ift;
	ifp->send = ift->send;
	ifp->output = ift->output;
d444 2
a445 2
	printf("           flags %u trace 0x%x netmask 0x%08lx broadcast %s\n",
		ifp->flags,ifp->trace,ifp->netmask,inet_ntoa(ifp->broadcast));
d623 31
@


1.18
log
@Add output queue length limiting
@
text
@d50 1
d89 1
d147 1
d151 1
d445 2
@


1.17
log
@Get rid of refiq() call
@
text
@d28 1
d49 1
d87 1
d120 1
d425 6
a430 9
	printf("%-10s IP addr %s MTU %u Link encap ",ifp->name,
	 inet_ntoa(ifp->addr),(int)ifp->mtu);
	if(ifp->iftype == NULLIFT){
		printf("not set\n");
	} else {
		printf("%s\n",ifp->iftype->name);
		if(ifp->iftype->format != NULL && ifp->hwaddr != NULLCHAR)
			printf("           Link addr %s\n",
			 (*ifp->iftype->format)(tmp,ifp->hwaddr));
d436 1
a436 1
	printf("           sent: ip %lu tot %lu idle %s qlen %d\n",
d439 3
d522 11
@


1.16
log
@Added null send and output routines (nu_send, nu_output)
@
text
@a161 2
	refiq();	/* Replenish interrupt buffer pool */

d227 1
a227 1
	(*ifp->raw)(ifp,bp);
@


1.15
log
@src0505
@
text
@d211 21
@


1.14
log
@src0501
@
text
@a41 1
	NULLCHAR,	/* trfile	*/
a78 1
	NULLCHAR,	/* trfile	*/
d164 9
a172 2
	i_state = dirps();
	while(Hopper == NULLBUF)
d174 1
a174 2
	restore(i_state);

a175 1
	bp = dequeue(&Hopper);
@


1.13
log
@src0429a
@
text
@d224 1
a224 1
		tprintf("Interface %s unknown\n",argv[1]);
d235 1
a235 1
		tprintf("Argument missing\n");
d268 1
a268 1
		tprintf("Can't set link address\n");
d330 1
a330 1
		tprintf("Encapsulation mode '%s' unknown\n",argv[1]);
d399 1
a399 1
	tprintf("%-10s IP addr %s MTU %u Link encap ",ifp->name,
d402 1
a402 1
		tprintf("not set\n");
d404 1
a404 1
		tprintf("%s\n",ifp->iftype->name);
d406 1
a406 1
			tprintf("           Link addr %s\n",
d409 1
a409 1
	tprintf("           flags %u trace 0x%x netmask 0x%08lx broadcast %s\n",
d412 2
a413 2
		tprintf("           output forward to %s\n",ifp->forw->name);
	tprintf("           sent: ip %lu tot %lu idle %s qlen %d\n",
d416 1
a416 1
	tprintf("           recv: ip %lu tot %lu idle %s\n",
d430 1
a430 1
		tprintf("Interface %s unknown\n",argv[1]);
d434 1
a434 1
		tprintf("Can't detach loopback or encap interface\n");
@


1.12
log
@src0419
@
text
@a54 1
	CL_NONE,	/* type		*/
a92 1
	CL_NONE,	/* type		*/
a158 1
	struct phdr phdr;
d160 2
a161 1
	struct rfunc *rp;
d173 7
a179 4
	pullup(&bp,(char *)&phdr,sizeof(phdr));
	if(phdr.iface != NULLIF){
		phdr.iface->rawrecvcnt++;
		phdr.iface->lastrecv = secclock();
d181 6
a186 9
	dump(phdr.iface,IF_TRACE_IN,phdr.type,bp);
	for(rp = &Rfunc[0];rp->class != -1;rp++){
		if(phdr.type == rp->class){
			(*rp->rcvf)(phdr.iface,bp);
				break;
		}
	}					
	if(rp->class == -1)
		free_p(bp);
d198 1
a198 1
net_route(ifp, type, bp)
a199 1
int type;
d202 2
a203 7
	struct phdr phdr;

	phdr.iface = ifp;
	phdr.type = type;

	bp = pushdown(bp,sizeof(phdr));
	memcpy(&bp->data[0],(char *)&phdr,sizeof(phdr));
a351 1
	ifp->type = ift->type;
@


1.11
log
@src0410
@
text
@d564 6
a569 3
	char *result = mallocw( strlen(ifp->name) + strlen(comment) + 1 );
	strcpy( result, ifp->name );
	return strcat( result, comment );
@


1.10
log
@src0406
@
text
@a204 1
	struct mbuf *nbp;
d210 3
a212 6
	if((nbp = pushdown(bp,sizeof(phdr))) == NULLBUF ){
		free_p(bp);
		return -1;
	}
	memcpy(&nbp->data[0],(char *)&phdr,sizeof(phdr));
	enqueue(&Hopper,nbp);
@


1.9
log
@src0401
@
text
@d16 1
d153 54
d208 12
a480 1

a493 1

@


1.8
log
@src0331
@
text
@d137 1
a137 2
	int32 gateway;
	int tos;
d145 2
a146 3
		tos = pullchar(&bp) & 0xff;
		gateway = pull32(&bp);
		(*iface->send)(bp,iface,gateway,tos);
@


1.7
log
@src0327
@
text
@a44 1
	NULLPROC,	/* sendproc	*/
d47 1
a83 1
	NULLPROC,	/* sendproc	*/
d86 1
a101 1
	NULLBUF,	/* outq		*/
d144 1
d149 3
a422 1
	killproc(ifp->sendproc);
@


1.6
log
@src0922
@
text
@d45 1
d84 1
d102 1
d124 27
d173 1
a173 1
		if ( ifp->show != NULLFP ) {
d358 3
a360 2
	tprintf("           sent: ip %lu tot %lu idle %s\n",
	 ifp->ipsndcnt,ifp->rawsndcnt,tformat(secclock() - ifp->lastsent));
d420 1
@


1.5
log
@src0609
@
text
@a34 2
	CL_NONE,	/* type		*/
	&Iftypes[0],	/* iftype	*/
a37 7
	NULL,		/* (*ioctl)	*/
	NULLFP,		/* (*iostatus)	*/
	NULLFP,		/* (*send)	*/
	NULLFP,		/* (*output)	*/
	NULLFP,		/* (*raw)	*/
	NULLFP,		/* (*stop)	*/
	NULLFP,		/* (*status)	*/
a38 2
	0,		/* dev		*/
	0,		/* xdev		*/
a42 1
	NULLCHAR,	/* hwaddr	*/
a43 6
	0,		/* ipsndcnt	*/
	0,		/* rawsndcnt	*/
	0,		/* iprcvcnt	*/
	0,		/* rawrcvcnt	*/
	0,		/* lastsent	*/
	0,		/* lastrecv	*/
d47 5
d53 7
d62 6
a72 2
	CL_NONE,	/* type		*/
	&Iftypes[0],	/* iftype	*/
a75 7
	NULL,		/* (*ioctl)	*/
	NULLFP,		/* (*iostatus)	*/
	ip_encap,	/* (*send)	*/
	NULLFP,		/* (*output)	*/
	NULLFP,		/* (*raw)	*/
	NULLFP,		/* (*stop)	*/
	NULLFP,		/* (*status)	*/
a76 2
	0,		/* dev		*/
	0,		/* xdev		*/
a80 1
	NULLCHAR,	/* hwaddr	*/
a81 6
	0,		/* ipsndcnt	*/
	0,		/* rawsndcnt	*/
	0,		/* iprcvcnt	*/
	0,		/* rawrcvcnt	*/
	0,		/* lastsent	*/
	0,		/* lastrecv	*/
d85 5
d91 7
d100 6
d143 2
a144 2
		if ( ifp->status != NULLFP ) {
			(*ifp->status)(ifp);
@


1.4
log
@src0423
@
text
@d66 2
d104 2
@


1.3
log
@src0420
@
text
@d33 1
a33 1
	NULLIF,
d67 36
d204 1
a204 1
	rt_add(ifp->broadcast,32,0L,ifp,1L,0L,1,0);
d226 1
a226 1
	rt_add(ifp->addr,mask2width(ifp->netmask),0L,ifp,0L,0L,0,0);
d344 1
a344 1
		tprintf("Can't detach loopback interface\n");
d356 1
a356 1
	if(ifp == &Loopback)
@


1.2
log
@src0318
@
text
@d168 1
a168 1
	rt_add(ifp->broadcast,32,0L,ifp,1L,0L,1);
d190 1
a190 1
	rt_add(ifp->addr,mask2width(ifp->netmask),0L,ifp,0L,0L,0);
@


1.1
log
@Initial revision
@
text
@d6 2
a8 2
#include "mbuf.h"
#include "pktdrvr.h"
d11 3
a15 3
#include "enet.h"
#include "ax25.h"
#include "proc.h"
d34 32
a65 29
	"loopback",
	CL_NONE,
	&Iftypes[0],
	0x7f000001,	/* 127.0.0.1 */
	0xffffffff,	/* 255.255.255.255 */
	0xffffffff,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	MAXINT16,	/* No limit on MTU */
	0,
	0,
	0,
	0,
	NULLCHAR,
	NULLFILE,
	NULLCHAR,
	NULLIF,
	0,
	0,
	0,
	0,
	0,
	0,
	NULLPROC,
	NULLPROC,
	NULLPROC,
d103 3
d279 1
a279 1
	 	tprintf("%s\n",ifp->iftype->name);
d342 5
a349 3
	/* Call device shutdown routine, if any */
	if(ifp->stop != NULLFP)
		(*ifp->stop)(ifp);
d424 13
a436 1
/* Raw output routine that dumps all packets. Used by dialer,  tip, etc */
d438 1
a438 1
dumppkt(ifp,bp)
@
