head	1.14;
access;
symbols;
locks;
comment	@ * @;


1.14
date	93.05.06.10.08.46;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	93.01.04.10.19.10;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	93.01.02.08.26.03;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.09.08.08.35.30;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.08.28.20.39.23;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.08.28.20.18.43;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.30.11.27.26;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.02.08.35.56;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.01.08.21.36;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.03.29.03.31.38;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.08.04.11.30.56;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.14.09.19.30;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.09.10.28.14;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.54.28;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.14
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* ICMP-related user commands
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "icmp.h"
#include "ip.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "timer.h"
#include "socket.h"
#include "proc.h"
#include "session.h"
#include "cmdparse.h"
#include "commands.h"

static int doicmpec(int argc, char *argv[],void *p);
static int doicmpstat(int argc, char *argv[],void *p);
static int doicmptr(int argc, char *argv[],void *p);
static void pingtx(int s,void *ping1,void *p);
static void pinghdr(struct session *sp,struct ping *ping);
static int pingproc(int c);
static int keychar(int c);

static struct cmds Icmpcmds[] = {
	"echo",		doicmpec,	0, 0, NULLCHAR,
	"status",	doicmpstat,	0, 0, NULLCHAR,
	"trace",	doicmptr,	0, 0, NULLCHAR,
	NULLCHAR
};

int Icmp_trace;
static int Icmp_echo = 1;

int
doicmp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Icmpcmds,argc,argv,p);
}

static int
doicmpstat(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register int i;
	int lim;

	/* Note that the ICMP variables are shown in column order, because
	 * that lines up the In and Out variables on the same line
	 */
	lim = NUMICMPMIB/2;
	for(i=1;i<=lim;i++){
		printf("(%2u)%-20s%10lu",i,Icmp_mib[i].name,
		 Icmp_mib[i].value.integer);
		printf("     (%2u)%-20s%10lu\n",i+lim,Icmp_mib[i+lim].name,
		 Icmp_mib[i+lim].value.integer);
	}
	return 0;
}
static int
doicmptr(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setbool(&Icmp_trace,"ICMP tracing",argc,argv);
}
static int
doicmpec(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setbool(&Icmp_echo,"ICMP echo response accept",argc,argv);
}

/* Send ICMP Echo Request packets */
int
doping(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in from;
	struct icmp icmp;
	struct mbuf *bp;
	int32 timestamp,rtt,abserr;
	int s,fromlen;
	struct ping ping;
	struct session *sp;

	memset((char *)&ping,0,sizeof(ping));
	/* Allocate a session descriptor */
	if((sp = ping.sp = newsession(Cmdline,PING,1)) == NULLSESSION){
		printf("Too many sessions\n");
		return 1;
	}
	if((ping.s = s = socket(AF_INET,SOCK_RAW,ICMP_PTCL)) == -1){
		printf("Can't create socket\n");
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	sp->inproc = keychar;	/* Intercept ^C */
	if(SETSIG(EABORT)){
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	printf("Resolving %s...\n",argv[1]);
	if((ping.target = resolve(argv[1])) == 0){
		printf("unknown\n");
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	printf("Pinging %s\n",inet_ntoa(ping.target));
	sp->cb.p = &ping;
	if(argc > 2)
		ping.len = atoi(argv[2]);

	if(argc > 3)
		ping.interval = atol(argv[3]);

	/* Optionally ping a range of IP addresses */
	if(argc > 4)
		ping.incflag = 1;

	if(ping.interval != 0){
		sp->proc1 = newproc("pingtx",300,pingtx,s,&ping,NULL,0);
	} else {
		/* One shot ping; let echo_proc hook handle response.
		 * An ID of MAXINT16 will not be confused with a legal socket
		 * number, which is used to identify repeated pings
		 */
		pingem(s,ping.target,0,MAXINT16,ping.len);
		close(s);
		freesession(sp);
		return 0;
	}
	sp->inproc = pingproc;
	/* Now collect the replies */
	pinghdr(sp,&ping);
	for(;;){
		fromlen = sizeof(from);
		if(recv_mbuf(s,&bp,0,(char *)&from,&fromlen) == -1)
			break;
		ntohicmp(&icmp,&bp);
		if(icmp.type != ICMP_ECHO_REPLY || icmp.args.echo.id != s){
			/* Ignore other people's responses */
			free_p(bp);
			continue;
		}
		/* Get stamp */
		if(pullup(&bp,(char *)&timestamp,sizeof(timestamp))
		 != sizeof(timestamp)){
			/* The timestamp is missing! */
			free_p(bp);	/* Probably not necessary */
			continue;
		}
		free_p(bp);

		ping.responses++;

		/* Compute round trip time, update smoothed estimates */
		rtt = msclock() - timestamp;
		abserr = (rtt > ping.srtt) ? (rtt-ping.srtt) : (ping.srtt-rtt);

		if(ping.responses == 1){
			/* First response, base entire SRTT on it */
			ping.srtt = rtt;
			ping.mdev = 0;
			ping.maxrtt = ping.minrtt = rtt;
		} else {
			ping.srtt = (7*ping.srtt + rtt + 4) >> 3;
			ping.mdev = (3*ping.mdev + abserr + 2) >> 2;
			if(rtt > ping.maxrtt)
				ping.maxrtt = rtt;
			if(rtt < ping.minrtt)
				ping.minrtt = rtt;
		}
		if((ping.responses % 20) == 0)
			pinghdr(sp,&ping);
		printf("%10lu%10lu%5lu%8lu%8lu%8lu%8lu%8lu\n",
		 ping.sent,ping.responses,
		 (ping.responses*100 + ping.sent/2)/ping.sent,
		 rtt,ping.srtt,ping.mdev,ping.maxrtt,ping.minrtt);
	}
	if(sp->proc1 != NULLPROC){
		killproc(sp->proc1);
		sp->proc1 = NULLPROC;
	}
	close(s);
	keywait(NULLCHAR,1);
	freesession(sp);
	return 0;
}
static int
keychar(c)
int c;
{
	if(c != CTLC)
		return 1;	/* Ignore all but ^C */

	fprintf(Current->output,"^C\n");
	alert(Current->proc,EABORT);
	return 0;
}
static void
pinghdr(sp,ping)
struct session *sp;
struct ping *ping;
{
	printf("      sent      rcvd    %     rtt     avg    mdev     max     min\n");
}

void
echo_proc(source,dest,icmp,bp)
int32 source;
int32 dest;
struct icmp *icmp;
struct mbuf *bp;
{
	int32 timestamp,rtt;

	if(Icmp_echo && icmp->args.echo.id == MAXINT16
	 && pullup(&bp,(char *)&timestamp,sizeof(timestamp))
	 == sizeof(timestamp)){
		/* Compute round trip time */
		rtt = msclock() - timestamp;
		printf("%s: rtt %lu\n",inet_ntoa(source),rtt);
	}
	free_p(bp);
}
/* Ping transmit process. Runs until killed */
static void
pingtx(s,ping1,p)
int s;		/* Socket to use */
void *ping1;
void *p;
{
	struct ping *ping;

	ping = (struct ping *)ping1;
	if(ping->incflag){
		for(;;){
			pingem(s,ping->target++,0,MAXINT16,ping->len);
			ping->sent++;
			pause(ping->interval);
		}
	} else {
		for(;;){
			pingem(s,ping->target,(uint16)ping->sent++,(uint16)s,ping->len);
			pause(ping->interval);
		}
	}
}


/* Send ICMP Echo Request packet */
int
pingem(s,target,seq,id,len)
int s;		/* Raw socket on which to send ping */
int32 target;	/* Site to be pinged */
uint16 seq;	/* ICMP Echo Request sequence number */
uint16 id;	/* ICMP Echo Request ID */
uint16 len;	/* Length of optional data field */
{
	struct mbuf *data;
	struct mbuf *bp;
	struct icmp icmp;
	struct sockaddr_in to;
	int32 clock;

	clock = msclock();
	data = ambufw((uint16)(len+sizeof(clock)));
	data->cnt = len+sizeof(clock);
	/* Set optional data field, if any, to all 55's */
	if(len != 0)
		memset(data->data+sizeof(clock),0x55,len);

	/* Insert timestamp and build ICMP header */
	memcpy(data->data,(char *)&clock,sizeof(clock));
	icmpOutEchos++;
	icmpOutMsgs++;
	icmp.type = ICMP_ECHO;
	icmp.code = 0;
	icmp.args.echo.seq = seq;
	icmp.args.echo.id = id;
	if((bp = htonicmp(&icmp,data)) == NULLBUF){
		free_p(data);
		return 0;
	}
	to.sin_family = AF_INET;
	to.sin_addr.s_addr = target;
	send_mbuf(s,bp,0,(char *)&to,sizeof(to));
	return 0;
}
static int
pingproc(c)
int c;
{
	struct ping *p;
	struct session *sp;

	sp = Current;
	p = (struct ping *)sp->cb.p;
	
	if(p->s == -1)
		return 1;	/* Shutting down, let keywait have it */
	switch(c){
	case '\033':
	case 'Q':
	case 'q':
	case 3:	/* ctl-c - quit */
		alert(sp->proc,EABORT);
		if(Current->proc1 != NULLPROC){
			killproc(sp->proc1);
			sp->proc1 = NULLPROC;
		}
		shutdown(p->s,2);
		p->s = -1;
		break;
	case ' ':	/* Toggle pinger */
		if(sp->proc1 != NULLPROC){
			killproc(sp->proc1);
			sp->proc1 = NULLPROC;
			fprintf(sp->output,"Pinging suspended, %lu sent\n",p->sent);
		} else {
			p->sent = p->responses = 0;
			sp->proc1 = newproc("pingtx",300,pingtx,p->s,p,NULL,0);
			fprintf(sp->output,"Pinging resumed\n");
		}
		break;
	}
	return 0;
}
@


1.13
log
@Allow escape, Q and q to kill a ping session
@
text
@d18 7
a24 7
static int doicmpec __ARGS((int argc, char *argv[],void *p));
static int doicmpstat __ARGS((int argc, char *argv[],void *p));
static int doicmptr __ARGS((int argc, char *argv[],void *p));
static void pingtx __ARGS((int s,void *ping1,void *p));
static void pinghdr __ARGS((struct session *sp,struct ping *ping));
static int pingproc __ARGS((int c));
static int keychar __ARGS((int c));
d259 1
a259 1
			pingem(s,ping->target,(int16)ping->sent++,(int16)s,ping->len);
d271 3
a273 3
int16 seq;	/* ICMP Echo Request sequence number */
int16 id;	/* ICMP Echo Request ID */
int16 len;	/* Length of optional data field */
d282 1
a282 1
	data = ambufw((int16)(len+sizeof(clock)));
@


1.12
log
@Call newsession with Cmdbuf
Allow ^C abort during domain resolution
Tighten startup/banner messages
@
text
@d318 3
@


1.11
log
@Show number of pings when suspending
@
text
@d24 1
d100 1
a100 1
	if((sp = ping.sp = newsession(argv[1],PING,1)) == NULLSESSION){
d110 2
a111 3
	printf("Resolving %s... ",sp->name);
	if((ping.target = resolve(sp->name)) == 0){
		printf("Host %s unknown\n",sp->name);
d116 8
d204 11
a219 2
	printf("Pinging %s (%s); data %d interval %lu ms:\n",
	 sp->name,inet_ntoa(ping->target),ping->len,ping->interval);
d333 1
@


1.10
log
@Add max/min rtt, tighten up fields
@
text
@d314 1
a314 1
			fprintf(sp->output,"Pinging suspended\n");
@


1.9
log
@Add upcall control of pinging (suspend/kill with space/^C)
@
text
@d171 1
d175 4
d182 1
a182 1
		printf("%10lu%10lu%5lu%10lu%10lu%10lu\n",
d185 1
a185 1
		 rtt,ping.srtt,ping.mdev);
d203 1
a203 1
	printf("      sent      rcvd    %       rtt   avg rtt      mdev\n");
@


1.8
log
@s920601
@
text
@d23 1
a88 1
	struct proc *pinger = NULLPROC;	/* Transmit process */
d103 1
a103 1
	if((s = socket(AF_INET,SOCK_RAW,ICMP_PTCL)) == -1){
d116 1
a122 1

d128 1
a128 1
		pinger = newproc("pingtx",300,pingtx,s,&ping,NULL,0);
d139 1
d182 4
a185 2
	if(pinger != NULLPROC)
		killproc(pinger);
d187 1
a228 1
	ping->sent = 0;
d281 35
@


1.7
log
@src0503
@
text
@d135 1
d183 1
@


1.6
log
@src0501
@
text
@d103 1
a103 1
	if((sp->s = s = socket(AF_INET,SOCK_RAW,ICMP_PTCL)) == -1){
@


1.5
log
@src0331
@
text
@d57 1
a57 1
		tprintf("(%2u)%-20s%10lu",i,Icmp_mib[i].name,
d59 1
a59 1
		tprintf("     (%2u)%-20s%10lu\n",i+lim,Icmp_mib[i+lim].name,
d100 1
a100 1
		tprintf("Too many sessions\n");
d104 1
a104 1
		tprintf("Can't create socket\n");
d109 1
a109 1
	tprintf("Resolving %s... ",sp->name);
d111 1
a111 1
		tprintf("Host %s unknown\n",sp->name);
d175 1
a175 1
		tprintf("%10lu%10lu%5lu%10lu%10lu%10lu\n",
d190 1
a190 1
	tprintf("Pinging %s (%s); data %d interval %lu ms:\n",
d192 1
a192 1
	tprintf("      sent      rcvd    %       rtt   avg rtt      mdev\n");
d209 1
a209 1
		tprintf("%s: rtt %lu\n",inet_ntoa(source),rtt);
@


1.4
log
@src0922
@
text
@d99 1
a99 1
	if((sp = ping.sp = newsession(argv[1],PING)) == NULLSESSION){
@


1.3
log
@src0318
@
text
@d103 1
a103 1
	if((sp->s = s = socket(AF_INET,SOCK_RAW,IPPROTO_ICMP)) == -1){
@


1.2
log
@src0221
@
text
@d226 2
a227 1
			pingem(s,ping->target++,0,(int16)s,ping->len);
@


1.1
log
@Initial revision
@
text
@d176 2
a177 1
		 ping.sent,ping.responses,ping.responses*100/ping.sent,
@
