head	1.23;
access;
symbols;
locks;
comment	@ * @;


1.23
date	93.05.06.10.07.51;	author karn;	state Exp;
branches;
next	1.22;

1.22
date	93.01.10.23.22.49;	author karn;	state Exp;
branches;
next	1.21;

1.21
date	92.12.08.11.31.26;	author karn;	state Exp;
branches;
next	1.20;

1.20
date	92.12.02.18.24.07;	author karn;	state Exp;
branches;
next	1.19;

1.19
date	92.10.09.07.41.56;	author karn;	state Exp;
branches;
next	1.18;

1.18
date	92.10.07.19.42.24;	author karn;	state Exp;
branches;
next	1.17;

1.17
date	92.07.07.19.05.38;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	92.06.21.08.42.57;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.06.18.19.36.17;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.06.18.09.47.12;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.05.15.10.02.30;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.05.04.11.57.58;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.05.01.11.18.02;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.04.19.05.06.48;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.04.15.10.13.30;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.04.06.12.09.58;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.04.02.02.33.48;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.03.31.13.07.10;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.09.21.17.17.48;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.06.03.05.08.58;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.04.16.09.34.54;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.17.22.03.08;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.44.22;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.23
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Automatic line dialer for asynch ports running SLIP, PPP, etc.
 *
 * Copyright 1991 Phil Karn, KA9Q
 *
 *	Mar '91	Bill Simpson & Glenn McGregor
 *		completely re-written;
 *		human readable control file;
 *		includes wait for string, and speed sense;
 *		dials immediately when invoked.
 *	May '91 Bill Simpson
 *		re-ordered command line;
 *		allow dial only;
 *		allow inactivity timeout without ping.
 *	Sep '91 Bill Simpson
 *		Check known DTR & RSLD state for redial decision
 *	Mar '92	Phil Karn
 *		autosense modem control stuff removed
 *		Largely rewritten to do demand dialing
 */
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include "global.h"
#include "mbuf.h"
#include "timer.h"
#include "proc.h"
#include "iface.h"
#include "netuser.h"
#include "n8250.h"
#include "asy.h"
#include "tty.h"
#include "socket.h"
#include "cmdparse.h"
#include "devparam.h"
#include "files.h"
#include "main.h"
#include "trace.h"
#include "commands.h"
#include "dialer.h"

static int redial(struct iface *ifp,char *file);
static void dropline(void *);
static void dropit(int,void *,void *);
int dialer_kick(struct iface *ifp);
void sd_answer(int,void *,void *);

static int dodial_control(int argc,char *argv[],void *p);
static int dodial_send(int argc,char *argv[],void *p);
static int dodial_speed(int argc,char *argv[],void *p);
static int dodial_status(int argc,char *argv[],void *p);
static int dodial_wait(int argc,char *argv[],void *p);

static struct cmds Dial_cmds[] = {
	"",		donothing,	0, 0, "",
	"control",	dodial_control,	0, 2, "control up | down",
	"send",		dodial_send,	0, 2,
	"send \"string\" [<milliseconds>]",
	"speed",	dodial_speed,	0, 2, "speed <bps>",
	"status",	dodial_status, 0, 2, "status up | down",
	"wait",		dodial_wait,	0, 2,
	"wait <milliseconds> [ \"string\" [speed] ]",
	NULLCHAR,	NULLFP,		0, 0, "Unknown command",
};
/* Set up demand dialing on an asy link. Called from dodialer command
 * in iface.c.
 */
int
sd_init(ifp,timeout,argc,argv)
struct iface *ifp;
int32 timeout;
int argc;
char *argv[];
{
	struct asy *ap;
	struct asydialer *dialer;
	char *cp;

	if(ifp->dev >= ASY_MAX || Asy[ifp->dev].iface != ifp){
		/* "Can't happen" */
		printf("Interface %s not asy port\n",argv[1]);
		return 1;
	}
	ap = &Asy[ifp->dev];
	if(timeout != 0 && argc < 3){
		printf("Usage: dial <iface> <timeout> <raisefile> <dropfile> <ringfile>\n");
		printf("       dial <iface> 0\n");
		return 1;
	}
	if(!ap->rlsd){
		printf("Must set 'r' flag at attach time\n");
		return 1;
	}
	if(ifp->dstate != NULL){
		/* Get rid of the old dialer info */
		dialer = (struct asydialer *)ifp->dstate;
		stop_timer(&dialer->idle);
		if(dialer->actfile != NULLCHAR){
			free(dialer->actfile);
			dialer->actfile = NULLCHAR;
		}
		if(dialer->dropfile != NULLCHAR){
			free(dialer->dropfile);
			dialer->dropfile = NULLCHAR;
		}
		if(dialer->ansfile != NULLCHAR){
			free(dialer->ansfile);
			dialer->ansfile = NULLFILE;
		}
		free(ifp->dstate);
		ifp->dstate = NULL;
	}
	killproc(ifp->supv);
	ifp->supv = NULLPROC;

	dialer = (struct asydialer *)calloc(1,sizeof(struct asydialer));
	ifp->dstate = dialer;

	ifp->dtickle = dialer_kick;
	set_timer(&dialer->idle,timeout);
	dialer->idle.func = dropline;
	dialer->idle.arg = ifp;
	if(timeout != 0){
		dialer->actfile = strdup(argv[0]);
		dialer->dropfile = strdup(argv[1]);
		dialer->ansfile = strdup(argv[2]);
		cp = if_name(ifp," answerer");
		ifp->supv = newproc(cp,768,sd_answer,ifp->dev,ifp,NULL,0);
	}
	return 0;
}
/* Display status of asynch dialer. Called from dodialer command in
 * iface.c when invoked without full args
 */
int
sd_stat(ifp)
struct iface *ifp;
{
	struct asydialer *dialer = (struct asydialer *)ifp->dstate;
	struct asy *ap;

	if(dialer == NULL){
		printf("No dialer active on %s\n",ifp->name);
		return 1;
	}
	ap = &Asy[ifp->dev];
	printf("%s: %s,",ifp->name,(ap->msr & MSR_RLSD) ? "UP":"DOWN");
	printf(" idle timer %lu/%lu sec\n",read_timer(&dialer->idle)/1000L,
	  dur_timer(&dialer->idle)/1000L);
	if(dialer->actfile != NULLCHAR)
		printf("up script: %s\n",dialer->actfile);
	if(dialer->dropfile != NULLCHAR)
		printf("down script: %s\n",dialer->dropfile);
	if(dialer->ansfile != NULLCHAR)
		printf("answer script: %s\n",dialer->ansfile);
	printf("Calls originated %lu, Calls answered %lu\n",
		dialer->originates,dialer->answers);
	printf("Calls timed out %lu, carrier transitions %lu\n",
		dialer->localdrops,ap->cdchanges);
	return 0;
}
/* Called by interface output routine just before sending each packet */
int
dialer_kick(ifp)
struct iface *ifp;
{
	struct asy *asyp;
	struct asydialer *dialer;

	dialer = (struct asydialer *)ifp->dstate;
	asyp = &Asy[ifp->dev];
	stop_timer(&dialer->idle);
	if(asyp->rlsd && !(asyp->msr & MSR_RLSD)
	 && dialer->actfile != NULLCHAR){
		/* Line down, try a redial */
		dialer->originates++;
		if(redial(ifp,dialer->actfile) != 0 
		 || !(asyp->msr & MSR_RLSD)){
			/* Redial failed, drop line and return failure */
			dialer->localdrops++;
			redial(ifp,dialer->dropfile);
			return -1;
		}
	}
	start_timer(&dialer->idle);
	return 0;
}

/* Called when idle line timer expires -- executes script to drop line */
static void
dropline(p)
void *p;
{
	/* Fork this off to prevent wedging the timer task */
	newproc("dropit",1024,dropit,0,p,NULL,0);
}

static void
dropit(i,p,u)
int i;
void *p;
void *u;
{
	struct iface *ifp = p;
	struct asy *ap;
	struct asydialer *dialer;

	dialer = (struct asydialer *)ifp->dstate;
	ap = &Asy[ifp->dev];
	if(ap->msr & MSR_RLSD){
		dialer->localdrops++;
		redial(ifp,dialer->dropfile);	/* Drop only if still up */
	}
}

void
sd_answer(dev,p1,p2)
int dev;
void *p1,*p2;
{
	struct iface *ifp;
	struct asydialer *dialer;
	struct asy *asyp;

	ifp = (struct iface *)p1;
	asyp = &Asy[dev];
	dialer = (struct asydialer *)ifp->dstate;
	if(dialer == NULL)
		return;	/* Can't happen */
	for(;;){
		while((asyp->msr & MSR_TERI) == 0)
			pwait(&asyp->msr);
		asyp->msr &= ~MSR_TERI;
		dialer->answers++;
		redial(ifp,dialer->ansfile);
	}
}

/* execute dialer commands
 * returns: -1 fatal error, 0 OK, 1 try again
 */
static int
redial(ifp,file)
struct iface *ifp;
char *file;
{
	char *inbuf;
	FILE *fp;
	int (*rawsave)(struct iface *,struct mbuf *);
	int result = 0;

	if((fp = fopen(file,READ_TEXT)) == NULLFILE){
		if(ifp->trace & (IF_TRACE_IN|IF_TRACE_OUT))
			tprintf(ifp,"redial: can't read %s\n",file);
		return -1;
	}
	/* Save output handler and temporarily redirect output to null */
	if(ifp->raw == bitbucket){
		if(ifp->trace & (IF_TRACE_IN|IF_TRACE_OUT))
			tprintf(ifp,"redial: tip or dialer already active on %s\n",ifp->name);

		return -1;
	}

	if(ifp->trace & (IF_TRACE_IN|IF_TRACE_OUT))
		tprintf(ifp,"Commands to %s:\n",ifp->name);

	/* Save output handler and temporarily redirect output to null */
	rawsave = ifp->raw;
	ifp->raw = bitbucket;

	/* Suspend the packet input driver. Note that the transmit driver
	 * is left running since we use it to send buffers to the line.
	 */
	suspend(ifp->rxproc);

	inbuf = mallocw(BUFSIZ);
	while(fgets(inbuf,BUFSIZ,fp) != NULLCHAR){
		rip(inbuf);
		log(-1,"%s dialer: %s",ifp->name,inbuf);
		if(ifp->trace & (IF_TRACE_IN|IF_TRACE_OUT))
			tprintf(ifp,"%s\n",inbuf);
		if((result = cmdparse(Dial_cmds,inbuf,ifp)) != 0){
			break;
		}
	}
	free(inbuf);
	fclose(fp);

	if(result == 0){
		ifp->lastsent = ifp->lastrecv = secclock();
	}
	ifp->raw = rawsave;
	resume(ifp->rxproc);
	if(ifp->trace & (IF_TRACE_IN|IF_TRACE_OUT))
		tprintf(ifp,"\nDial %s complete\n",ifp->name);

	return result;
}


static int
dodial_control(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;
	int param;
	int32 arg = 0;

	if(ifp->ioctl == NULL)
		return -1;

	if((param = devparam(argv[1])) == -1) 
		return -1;

	if(argc > 2)
		arg = atol(argv[2]);
	(*ifp->ioctl)(ifp,param,TRUE,arg);
	return 0;
}


static int
dodial_send(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;
	struct mbuf *bp;

	if(argc > 2){
		/* Send characters with inter-character delay
		 * (for dealing with prehistoric Micom switches that
		 * can't take back-to-back characters...yes, they
		 * still exist.)
		 */
		char *cp;
		int32 cdelay = atol(argv[2]);

		for(cp = argv[1];*cp != '\0';cp++){
			asy_write(ifp->dev,cp,1);
			pause(cdelay);
		}
	} else {
		if (ifp->trace & IF_TRACE_RAW)
			raw_dump( ifp, IF_TRACE_OUT, bp );
		asy_write(ifp->dev,argv[1],strlen(argv[1]));
	}
	return 0;
}


static int
dodial_speed(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;

	if ( argc < 2 ) {
		if(ifp->trace & (IF_TRACE_IN|IF_TRACE_OUT))
			tprintf(ifp,"current speed = %u bps\n", Asy[ifp->dev].speed);
		return 0;
	}
	return asy_speed(ifp->dev,(uint16)atol(argv[1]));
}


static int
dodial_status(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;
	int param;

	if(ifp->iostatus == NULL)
		return -1;

	if((param = devparam(argv[1])) == -1)
		return -1;

	(*ifp->iostatus)(ifp,param,atol(argv[2]));
	return 0;
}


static int
dodial_wait(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp = p;
	register int c = -1;
	char *cp;

	alarm(atol(argv[1]));

	if(argc == 2){
		while((c = get_asy(ifp->dev)) != -1 && errno != EALARM){
			if(ifp->trace & IF_TRACE_IN){
				fputc(c,ifp->trfp);
				fflush(ifp->trfp);
			}
		}
		alarm(0L);
		return 0;
	}
	/* argc > 2 */
	cp = argv[2];

	while(*cp != '\0' && (c = get_asy(ifp->dev)) != -1){
		if(ifp->trace & IF_TRACE_IN){
			fputc(c,ifp->trfp);
			fflush(ifp->trfp);
		}
		if(*cp++ != c){
			cp = argv[2];
		}
	}
	if(argc > 3){
		uint16 speed = 0;

		if(stricmp(argv[3], "speed") != 0)
			return -1;

		while((c = get_asy(ifp->dev)) != -1){
			if(ifp->trace & IF_TRACE_IN){
				fputc(c,ifp->trfp);
				fflush(ifp->trfp);
			}
			if(isdigit(c)){
				speed *= 10;
				speed += c - '0';
			} else {
				alarm(0L);
				return asy_speed(ifp->dev,speed);
			}
		}
	}
	alarm(0L);
	return (c == -1);
}


@


1.22
log
@If redial fails, immediately drop line
General cleanup of redial function
@
text
@d41 2
a42 2
static int redial __ARGS((struct iface *ifp,char *file));
static void dropline __ARGS((void *));
d44 2
a45 2
int dialer_kick __ARGS((struct iface *ifp));
void sd_answer __ARGS((int,void *,void *));
d47 5
a51 5
static int dodial_control	__ARGS((int argc,char *argv[],void *p));
static int dodial_send		__ARGS((int argc,char *argv[],void *p));
static int dodial_speed		__ARGS((int argc,char *argv[],void *p));
static int dodial_status	__ARGS((int argc,char *argv[],void *p));
static int dodial_wait		__ARGS((int argc,char *argv[],void *p));
d248 1
a248 1
	int (*rawsave) __ARGS((struct iface *,struct mbuf *));
d368 1
a368 1
	return asy_speed(ifp->dev,(int16)atol(argv[1]));
d427 1
a427 1
		int16 speed = 0;
@


1.21
log
@remove null dotest() command
@
text
@d176 7
a182 3
		redial(ifp,dialer->actfile);
		if(!(asyp->msr & MSR_RLSD))
			return -1;	/* We tried */
d400 1
d413 18
a430 2
	} else {
		register char *cp = argv[2];
d432 1
a432 1
		while(*cp != '\0' && (c = get_asy(ifp->dev)) != -1){
d437 3
a439 21
			if(*cp++ != c){
				cp = argv[2];
			}
		}
		if(argc > 3){
			if(stricmp( argv[3], "speed") == 0){
				int16 speed = 0;

				while((c = get_asy(ifp->dev)) != -1){
					if(ifp->trace & IF_TRACE_IN){
						fputc(c,ifp->trfp);
						fflush(ifp->trfp);
					}
					if(isdigit(c)){
						speed *= 10;
						speed += c - '0';
					} else {
						alarm(0L);
						return asy_speed(ifp->dev,speed);
					}
				}
d441 2
a442 1
				return -1;
@


1.20
log
@Remove exponential backoff redialing code - rely on upper layer
retransmission and backoff to control redialing attempts
@
text
@a210 8
dotest(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return 0;
}

@


1.19
log
@minor cosmetic change
@
text
@d44 1
a44 1
void dialer_kick __ARGS((struct iface *ifp));
a146 2
	if(dialer->backoff != -1)
		printf(" backoff %u,",dialer->backoff);
d162 1
a162 1
void
a165 1
	int pw;
a170 1
	dialer->backoff = -1;
d172 1
a172 1
	while(asyp->rlsd && (asyp->msr & MSR_RLSD) == 0
d174 1
a174 12
		/* Line down, we need to redial
		 * But if it's failing, perform random binary
		 * exponential backoff
		 */
		if(dialer->backoff++ >= 0){
			dialer->bwait = 1000L*random(30L << dialer->backoff);
			alarm(dialer->bwait);
			pw = pwait(&asyp->rlsd);
			alarm(0L);
			if(pw == 0)
				continue; /* CD changed, maybe we got called */
		}
d177 2
a179 1
	dialer->backoff = -1;
d181 1
@


1.18
log
@Many changes to support generic demand-dialer stuff. This file now
contains the asy-specific support routines for demand dialing.
Also some cosmetic changes to existing code
@
text
@d139 1
a139 1
	struct asy *ap = &Asy[ifp->dev];
d145 1
@


1.17
log
@Move backoff count into asy struct so it can be read by dialer
status command
@
text
@d1 1
a1 1
/* Automatic SLIP/PPP line dialer.
d39 1
d44 2
d53 1
a53 1
static struct cmds dial_cmds[] = {
d64 2
a65 4
/* 
 * dial <iface> <seconds> <raisefile> <dropfile>
 * dial <iface>
 * dial <iface> 0
d68 3
a70 1
dodialer(argc,argv,p)
a72 1
void *p;
a73 1
	struct iface *ifp;
d75 2
a76 1
	int32 timeout;
a77 4
	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
		return 1;
	}
d79 1
d84 2
a85 21
	if(argc < 3){
		printf("%s: %s,",ifp->name,(ap->msr & MSR_RLSD) ? "UP":"DOWN");
		if(ap->backoff != -1)
			printf(" backoff %d,",ap->backoff);
		printf(" idle timer %ld/%ld sec",read_timer(&ap->idle)/1000L,
		  dur_timer(&ap->idle)/1000L);
		if(ap->actfile != NULLCHAR)
			printf(", up script: %s",ap->actfile);
		if(ap->dropfile != NULLCHAR)
			printf(", down script: %s",ap->dropfile);
		printf("\n");

		printf("Calls originated %ld, carrier up transitions %ld\n",
			ap->originates,ap->answers);
		printf("Calls timed out %ld, carrier down transitions %ld\n",
			ap->localdrops,ap->remdrops);
		return 0;
	}
	timeout = atol(argv[2]) * 1000L;
	if(timeout != 0 && argc < 5){
		printf("Usage: dial <iface> <timeout> <raisefile> <dropfile>\n");
d93 18
a110 11
	stop_timer(&ap->idle);
	set_timer(&ap->idle,timeout);
	ap->idle.func = dropline;
	ap->idle.arg = ifp;
	if(ap->actfile != NULLCHAR){
		free(ap->actfile);
		ap->actfile = NULLCHAR;
	}
	if(ap->dropfile != NULLCHAR){
		free(ap->dropfile);
		ap->dropfile = NULLCHAR;
d112 10
d123 21
a143 3
		ap->actfile = strdup(argv[3]);
		ap->dropfile = strdup(argv[4]);
		start_timer(&ap->idle);
d145 15
d162 1
d164 2
a165 2
dialer_kick(asyp)
struct asy *asyp;
d168 2
d171 4
a174 2
	asyp->backoff = -1;
	stop_timer(&asyp->idle);
d176 1
a176 1
	 && asyp->actfile != NULLCHAR){
d181 3
a183 2
		if(asyp->backoff++ >= 0){
			alarm(1000L*random(30L << asyp->backoff));
d189 2
a190 2
		asyp->originates++;
		redial(asyp->iface,asyp->actfile);
d192 2
a193 1
	asyp->backoff = -1;
d202 1
a202 1
	newproc("dropit",512,dropit,0,p,NULL,0);
d213 1
d215 1
d218 33
a250 2
		ap->localdrops++;
		redial(ifp,ap->dropfile);	/* Drop only if still up */
d262 1
a262 1
	char *inbuf, *intmp;
d281 1
a281 1
		tprintf(ifp,"Dialing on %s\n\n",ifp->name);
a292 1
	intmp = mallocw(BUFSIZ);
d294 5
a298 6
		strcpy(intmp,inbuf);
		rip(intmp);
		log(-1,"%s dialer: %s",ifp->name,intmp);
		if((result = cmdparse(dial_cmds,inbuf,ifp)) != 0){
			if(ifp->trace & (IF_TRACE_IN|IF_TRACE_OUT))
				tprintf(ifp,"input line: %s",intmp);
a302 1
	free(intmp);
d384 1
a384 1
	return asy_speed( ifp->dev, (int16)atol( argv[1] ) );
d397 1
a397 1
	if ( ifp->iostatus == NULL )
d400 1
a400 1
	if ( (param = devparam( argv[1] )) == -1 )
d403 1
a403 1
	(*ifp->iostatus)( ifp, param, atol( argv[2] ) );
@


1.16
log
@Remove parity stripping
@
text
@d86 4
a89 2
		printf("%s: %s",ifp->name,(ap->msr & MSR_RLSD) ? "UP":"DOWN");
		printf(", idle timer %ld/%ld",read_timer(&ap->idle)/1000L,
d94 2
a95 3
			printf(", down script: %s\n",ap->dropfile);
		else
			printf("\n");
a135 1
	int backoff = -1;
d138 1
d146 2
a147 2
		if(backoff++ >= 0){
			alarm(1000L*random(30L << backoff));
d156 1
a372 1

d387 1
a387 1
						return asy_speed( ifp->dev, speed );
@


1.15
log
@attempt to fix failures of script file timing
@
text
@a351 1
			c &= 0x7f;
a362 1
			c &= 0x7f;
a376 1
					c &= 0x7f;
@


1.14
log
@Fix bogus calls to atol when executing control up/down in scripts
@
text
@d351 1
a351 1
		while((c = get_asy(ifp->dev)) != -1 ){
@


1.13
log
@src0515
@
text
@d256 1
d258 1
a258 1
	if ( ifp->ioctl == NULL )
d261 1
a261 1
	if ( (param = devparam( argv[1] )) == -1 )
d264 3
a266 1
	(*ifp->ioctl)( ifp, param, TRUE, atol( argv[2] ) );
@


1.12
log
@src0505
@
text
@d29 1
a29 1
#include "8250.h"
@


1.11
log
@src0501
@
text
@d197 1
a197 1
			fprintf(ifp->trfp,"redial: can't read %s\n",file);
d203 1
a203 1
			fprintf(ifp->trfp,"redial: tip or dialer already active on %s\n",ifp->name);
d209 1
a209 1
		fprintf(ifp->trfp,"Dialing on %s\n\n",ifp->name);
d228 1
a228 1
				fprintf(ifp->trfp,"input line: %s",intmp);
d242 1
a242 1
		fprintf(ifp->trfp,"\nDial %s complete\n",ifp->name);
d309 1
a309 1
			fprintf(ifp->trfp,"current speed = %u bps\n", Asy[ifp->dev].speed);
@


1.10
log
@src0419
@
text
@d77 1
a77 1
		tprintf("Interface %s unknown\n",argv[1]);
d81 1
a81 1
		tprintf("Interface %s not asy port\n",argv[1]);
d86 2
a87 2
		tprintf("%s: %s",ifp->name,(ap->msr & MSR_RLSD) ? "UP":"DOWN");
		tprintf(", idle timer %ld/%ld",read_timer(&ap->idle)/1000L,
d90 1
a90 1
			tprintf(", up script: %s",ap->actfile);
d92 1
a92 1
			tprintf(", down script: %s\n",ap->dropfile);
d94 1
a94 1
			tprintf("\n");
d96 1
a96 1
		tprintf("Calls originated %ld, carrier up transitions %ld\n",
d98 1
a98 1
		tprintf("Calls timed out %ld, carrier down transitions %ld\n",
d104 2
a105 2
		tprintf("Usage: dial <iface> <timeout> <raisefile> <dropfile>\n");
		tprintf("       dial <iface> 0\n");
d109 1
a109 1
		tprintf("Must set 'r' flag at attach time\n");
a193 2
	int save_input = Curproc->input;
	int save_output = Curproc->output;
a243 2
	Curproc->input = save_input;
	Curproc->output = save_output;
@


1.9
log
@src0415
@
text
@d136 1
d145 7
a151 2
		if(backoff++ >= 0)
			pause(1000L*random(30L << backoff));
@


1.8
log
@src0406
@
text
@d22 1
d135 2
d140 6
a145 1
		/* Line down, need to redial it */
@


1.7
log
@src0401
@
text
@a22 1
#include "config.h"
d39 1
a39 2
int redial __ARGS((struct iface *ifp,char *file));

a48 1

a59 2


a99 2


d130 13
d171 2
a172 2
int
redial( ifp, file )
@


1.6
log
@src0331
@
text
@d90 3
a92 2
		tprintf("%s %s",ifp->name,(ap->msr & MSR_RLSD) ? "UP":"DOWN");
		tprintf(", timeout %ld",dur_timer(&ap->idle)/1000L);
d96 8
a103 2
			tprintf(", down script: %s",ap->dropfile);
		tprintf("\n");
d105 2
d156 4
a159 1
	redial(ifp,ap->dropfile);
d178 3
a180 4
#ifdef	notdef
		tprintf("redial: can't read %s\n",file);
#endif
		return -1;	/* Causes dialer proc to terminate */
d184 3
a186 3
#ifdef	notdef
		tprintf("redial: tip or dialer already active on %s\n",ifp->name);
#endif
d190 2
a191 3
#ifdef	notdef
	tprintf( "Dialing on %s\n\n", ifp->name );
#endif
a201 6
#ifdef notdef
tprintf("rlsd: 0x%02x, dtr: 0x%02x\n",
	Asy[ifp->dev].rlsd_line_control,
	Asy[ifp->dev].dtr_usage );
#endif

d204 1
a204 1
	while ( fgets( inbuf, BUFSIZ, fp ) != NULLCHAR ) {
d206 5
a210 4
		rip( intmp );
		log( -1, "%s dialer: %s", ifp->name, intmp );
		if( (result = cmdparse(dial_cmds,inbuf,ifp)) != 0 ){
			tprintf("input line: %s",intmp);
d218 1
a218 1
	if ( result == 0 ) {
a220 1

d223 2
a224 3
#ifdef	notdef
	tprintf( "\nDial %s complete\n", ifp->name );
#endif
d292 2
a293 1
		tprintf( "current speed = %u bps\n", Asy[ifp->dev].speed );
d329 1
a329 1
	alarm( atol( argv[1] ) );
d331 7
a337 6
	if ( argc == 2 ) {
		while ( (c = get_asy(ifp->dev)) != -1 ) {
#ifdef notdef
			tputc( c &= 0x7F );
			tflush();
#endif
d339 1
a339 1
		alarm( 0L );
d344 7
a350 6
		while ( *cp != '\0'  &&  (c = get_asy(ifp->dev)) != -1 ) {
#ifdef notdef
			tputc( c &= 0x7F );
			tflush();
#endif
			if (*cp++ != c) {
d355 2
a356 2
		if ( argc > 3 ) {
			if ( stricmp( argv[3], "speed" ) == 0 ){
d359 7
a365 6
				while ( (c = get_asy(ifp->dev)) != -1 ) {
#ifdef notdef
					tputc( c &= 0x7F );
					tflush();
#endif
					if ( isdigit(c) ) {
d369 1
a369 1
						alarm( 0L );
d378 2
a379 2
	alarm( 0L );
	return ( c == -1 );
@


1.5
log
@src0922
@
text
@d16 3
a31 1
#include "session.h"
a34 1
#include "icmp.h"
d38 1
d40 1
a40 1
#define MIN_INTERVAL	5L
d42 2
a43 1
static int redial __ARGS((struct iface *ifp,char *file));
d53 1
d65 4
a68 7
/* dial <iface> <filename> [ <seconds> [ <pings> [<hostid>] ] ]
 *	<iface>		must be asy type
 *	<filename>	contains commands which are executed.
 *			missing: kill outstanding dialer.
 *	<seconds>	interval to check for activity on <iface>.
 *	<pings> 	number of missed pings before redial.
 *	<hostid>	interface to ping.
d78 1
a78 9
	int32 interval = 0L;		/* in seconds */
	int32 last_wait = 0L;
	int32 target = 0L;
	int pings = 0;
	int countdown;
	char *filename;
	char *ifn;
	int result;
	int s;
d84 1
a84 1
	if( ifp->dev >= ASY_MAX || Asy[ifp->dev].iface != ifp ){
d88 9
a96 11

	if(ifp->supv != NULLPROC){
		while ( ifp->supv != NULLPROC ) {
			alert(ifp->supv, EABORT);
			pwait(NULL);
		}
		tprintf("dialer terminated on %s\n",argv[1]);
	}

	if ( argc < 3 ) {
		/* just terminating */
d99 4
a102 17

	chname( Curproc, ifn = if_name( ifp, " dialer" ) );
	free( ifn );
	filename = rootdircat(argv[2]);

	/* handle minimal command (just thru filename) */
	if ( argc < 4 ) {
		/* just dialing */
		result = redial(ifp, filename);

		if ( filename != argv[2] )
			free(filename);
		return result;

	/* get polling interval (arg 3) */
	} else if ( (interval = atol(argv[3])) <= MIN_INTERVAL ) {
		tprintf("interval must be > %d seconds\n", MIN_INTERVAL);
d105 2
a106 5

	/* get the number of pings before redialing (arg 4) */
	if ( argc < 5 ) {
	} else if ( (pings = atoi(argv[4])) <= 0 ){
		tprintf("pings must be > 0\n");
d109 16
a124 6

	/* retrieve the host name (arg 5) */
	if ( argc < 6 ) {
	} else if ( (target = resolve(argv[5])) == 0L ) {
		tprintf(Badhost,argv[5]);
		return 1;
d126 10
d137 8
a144 40
	countdown = pings;
	ifp->supv = Curproc;
	ap = &Asy[ ifp->dev ];

	while ( !main_exit ) {
		int32 wait_for = interval;

		if ( ap->dtr_usage == FOUND_DOWN
		 ||  ap->dtr_usage == MOVED_DOWN
		 ||  ap->rlsd_line_control == MOVED_DOWN ) {
			/* definitely down */
			if ( redial(ifp,filename) < 0 )
				break;
		} else if ( ifp->lastrecv >= last_wait ) {
			/* got something recently */
			wait_for -= secclock() - ifp->lastrecv;
			countdown = pings;
		} else if ( countdown < 1 ) {
			/* we're down, or host we ping is down */
			if ( redial(ifp,filename) < 0 )
				break;
			countdown = pings;
		} else if ( target != 0L
		   && (s = socket(AF_INET,SOCK_RAW,ICMP_PTCL)) != -1 ) {
			pingem(s,target,0,(int16)s,0);
			close_s(s);
			countdown--;
		} else if ( ifp->echo != NULLFP ) {
			(*ifp->echo)(ifp,NULLBUF);
			countdown--;
		}

		last_wait = secclock();
		if ( wait_for != 0L ) {
			alarm( wait_for * 1000L );
			if ( pwait( &(ifp->supv) ) == EABORT )
				break;
			alarm(0L);		/* clear alarm */
		}
	}
d146 2
a147 4
	if ( filename != argv[2] )
		free(filename);
	ifp->supv = NULLPROC;	/* We're being terminated */
	return 0;
a149 1

d153 1
a153 1
static int
a160 1
	struct session *sp;
d166 1
d168 1
d173 1
d175 1
d179 1
a179 5
	/* allocate a session descriptor */
	if ( (sp = newsession( ifp->name, DIAL )) == NULLSESSION ) {
		tprintf( "Too many sessions\n" );
		return 1;
	}
d181 1
d219 1
d221 1
a222 5
	/* Wait for awhile, so the user can read the screen,
	 * AND to give it time to send some packets on the new connection!
	 */
	pause( 10000L );
	freesession( sp );
d268 1
a268 2
			bp = qdata(cp,1);
			asy_send(ifp->dev,bp);
a271 2
		bp = qdata( argv[1], strlen(argv[1]) );

d274 1
a274 1
		asy_send( ifp->dev, bp );
d329 1
d332 1
d340 1
d343 1
a343 1

d354 1
d357 1
a357 1

@


1.4
log
@src0609
@
text
@d14 2
d45 1
d54 1
d76 1
d144 1
d149 3
a151 1
		if ( Asy[ ifp->dev ].rlsd_line_control == RLSD_DOWN ) {
d163 1
d165 1
a165 1
		   && (s = socket(AF_INET,SOCK_RAW,IPPROTO_ICMP)) != -1 ) {
d232 6
d242 2
d339 20
@


1.3
log
@src0420
@
text
@d1 1
a1 4
/* Automatic SLIP/PPP line redialer.
 * Very simpleminded - If a specified interval goes by without any
 * receiver activity, ping the other end. If this repeatedly fails,
 * spit a file containing modem commands at the line and try again.
d10 4
d18 1
d33 1
d36 1
a36 1
static int redial __ARGS((struct iface *ifp,char *file, int32 interval));
d38 2
d48 2
a49 1
	"send",		dodial_send,	0, 2, "send \"string\"",
d57 1
a57 1
/* dial <iface> <timeout> [ <filename> ] [ <hostid> ]
d59 2
d62 2
a63 5
 *			0: kill outstanding dialer.
 *	<hostid>	ping this host every interval.
 *	<pings>		number of pings before redial.
 *			0: no ping.
 *	<filename>	contains commands which are executed when line down
d72 1
a72 4
	int32 interval;
	int32 target;
	int32 pings;
	int32 countdown = 0L;
d74 3
d79 1
d99 21
a119 2
	if ( (interval = atol(argv[2]) * 1000L) < 0 ){
		tprintf("interval must be >= 0 seconds\n");
a120 3
	} else if ( interval == 0 ) {
		/* just killing process */
		return 0;
d123 4
a126 2
	if ( argc < 6 ) {
		tprintf("dial <iface> <seconds> <hostid> <pings> <filename>");
d130 5
a134 5
	if ( (pings = atol(argv[4])) > 0 ){
		if ( (target = resolve(argv[3])) == 0L ) {
			tprintf(Badhost,argv[3]);
			return 1;
		}
d137 1
a138 3
	chname( Curproc, ifn = if_name( ifp, " dialer" ) );
	free( ifn );
	filename = rootdircat(argv[5]);
d140 1
a140 1
	for ( ;; ) {
d145 1
a145 1
			if(redial(ifp,filename,interval) != 0)
d147 3
a150 5
		} else if ( ifp->lastrecv > last_wait ) {
			/* got something, wait interval from when we got it */
			if ( (wait_for -= (secclock() - ifp->lastrecv) * 1000L) < 1000L )
				wait_for = interval;
			countdown = pings;
d153 1
a153 1
			if(redial(ifp,filename,interval) != 0)
d155 2
a156 2
			countdown = pings;
		} else if ( (s = socket(AF_INET,SOCK_RAW,IPPROTO_ICMP)) != -1 ) {
d160 3
d165 7
a171 6
		last_wait = ifp->lastrecv;

		alarm( wait_for );
		if ( pwait( &(ifp->supv) ) == EABORT )
			break;
		alarm(0L);		/* clear alarm */
d174 1
a174 1
	if ( filename != argv[5] )
d181 3
d185 1
a185 1
redial( ifp, file, interval )
a187 1
int32 interval;
d193 3
d227 1
a227 1
		if(cmdparse(dial_cmds,inbuf,ifp) != 0){
d235 5
d247 1
a247 1
	pause( max( 10000L, interval ) );
d249 3
a251 1
	return 0;
a282 2
	int32 cdelay;
	char *cp;
d290 3
a292 1
		cdelay = atol(argv[2]);
d377 1
a377 1
	return (c == -1);
@


1.2
log
@src0318
@
text
@d247 2
d250 14
a263 1
	bp = qdata( argv[1], strlen(argv[1]) );
d265 4
a268 3
	if (ifp->trace & IF_TRACE_RAW)
		raw_dump( ifp, IF_TRACE_OUT, bp );
	asy_send( ifp->dev, bp );
@


1.1
log
@Initial revision
@
text
@d7 6
d15 1
d18 2
d21 1
d24 1
a25 2
#include "proc.h"
#include "tty.h"
d27 22
a48 3
#include "commands.h"
#include "netuser.h"
#include "timer.h"
a49 2
static int redial __ARGS((struct iface *ifp,char *file));
static void monitor __ARGS((int s,void *v1,void *v2));
d51 9
a65 1
	int s;
d67 1
d69 6
a74 3
	int32 interval;
	int dev;
	struct asy *ap;
d80 1
a80 4
	for(dev=0,ap = Asy;dev < ASY_MAX;dev++,ap++)
		if(ap->iface == ifp)
			break;
	if(dev == ASY_MAX){
d84 5
a88 6
	if((interval = atol(argv[2])) == 0){
		if(ifp->supv != NULLPROC){
			alert(ifp->supv,1);
			tprintf("dialer terminated on %s\n",argv[1]);
		} else {
			tprintf("no dialer active on %s\n",argv[1]);
d90 8
d100 3
a102 6
	if(argc < 5){
		tprintf("not enough args\n");
		return -1;
	}
	if(ifp->supv != NULLPROC){
		tprintf("dialer already active on %s\n",argv[1]);
d105 6
a110 3
	if((target = resolve(argv[3])) == 0){
		tprintf(Badhost,argv[3]);
		return 1;
d112 1
d114 3
d118 16
a133 9
	for(;;){
		if((s = pause(interval*1000)) != 0){	/* Wait a while */
			break;		/* We're being terminated */
		}
		if(secclock() - ifp->lastrecv > 4*interval){
			/* Receiver has remained idle after four pings;
			 * assume the connection has dropped.
			 */
			if(redial(ifp,argv[4]) != 0)
d135 2
a136 5
		}
		if(secclock() - ifp->lastrecv > interval){
			/* Receiver has been idle since last check */
			if((s = socket(AF_INET,SOCK_RAW,IPPROTO_ICMP)) == -1)
				continue;	/* Wait and try again */
d139 1
d141 7
d149 4
a152 1
	ifp->supv = NULLPROC;
d154 3
a156 1
} 
d158 1
a158 1
redial(ifp,file)
d161 1
d163 1
a164 3
	struct mbuf *bp;
	int32 delay;
	int c;
d166 1
a166 2
	struct proc *mon;
	int err_ret = 0;
d173 1
a173 1
	if(ifp->raw == dumppkt){
d177 9
d187 1
a187 1
	ifp->raw = dumppkt;
d194 7
a200 17
	/* Start up monitor so we can see what's happening */
	mon = newproc("dial monitor",300,monitor,0,(void *)ifp,NULL,0);

	while((c = getc(fp)) != EOF){
		if(c == '\\'){
			/* delay escape */
			delay = 0;
			while(c = getc(fp),c != EOF && c != 'd'){
				delay = delay * 10 + (c-'0');
			}
			if(c == EOF)
				break;
			if(pause(delay) != 0){
				err_ret = 1;
				break;
			}
			continue;
a201 7
		if(c == EOF)
			break;	/* Normal termination */
		if(c == '\n')
			c = '\r';
		bp = pushdown(NULLBUF,1);
		bp->data[0] = c;
		asy_send(ifp->dev,bp);
d203 2
a205 1
	killproc(mon);
d208 62
a269 1
	return err_ret;
d271 7
a277 5
static void
monitor(s,v1,v2)
int s;
void *v1;
void *v2;
d279 31
a309 2
	int c;
	struct iface *ifp;
d311 12
a322 4
	ifp = (struct iface *)v1;
	while((c = get_asy(ifp->dev)) != -1){
		if(ifp->trace & IF_TRACE_IN)
			putchar(c & 0x7f);
d324 2
d327 2
@
