head	1.11;
access;
symbols;
locks;
comment	@ * @;


1.11
date	93.05.06.10.07.17;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	93.01.02.08.25.41;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.28.10.25.10;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.13.02.30.14;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.02.08.42.30;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.01.08.19.46;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.10.07.54.06;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.03.29.03.30.54;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.04.08.59.46;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.20.14.52.52;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.36.16;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.11
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* AX25 control commands
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "timer.h"
#include "proc.h"
#include "iface.h"
#include "ax25.h"
#include "lapb.h"
#include "cmdparse.h"
#include "socket.h"
#include "mailbox.h"
#include "session.h"
#include "tty.h"
#include "nr4.h"
#include "commands.h"

static int axdest(struct iface *ifp);
static int axheard(struct iface *ifp);
static void axflush(struct iface *ifp);
static int doaxflush(int argc,char *argv[],void *p);
static int doaxirtt(int argc,char *argv[],void *p);
static int doaxkick(int argc,char *argv[],void *p);
static int doaxreset(int argc,char *argv[],void *p);
static int doaxroute(int argc,char *argv[],void *p);
static int doaxstat(int argc,char *argv[],void *p);
static int doaxwindow(int argc,char *argv[],void *p);
static int doblimit(int argc,char *argv[],void *p);
static int dodigipeat(int argc,char *argv[],void *p);
static int domaxframe(int argc,char *argv[],void *p);
static int domycall(int argc,char *argv[],void *p);
static int don2(int argc,char *argv[],void *p);
static int dopaclen(int argc,char *argv[],void *p);
static int dopthresh(int argc,char *argv[],void *p);
static int dot3(int argc,char *argv[],void *p);
static int doversion(int argc,char *argv[],void *p);

char *Ax25states[] = {
	"",
	"Disconn",
	"Listening",
	"Conn pend",
	"Disc pend",
	"Connected",
	"Recovery",
};

/* Ascii explanations for the disconnect reasons listed in lapb.h under
 * "reason" in ax25_cb
 */
char *Axreasons[] = {
	"Normal",
	"DM received",
	"Timeout"
};

static struct cmds Axcmds[] = {
	"blimit",	doblimit,	0, 0, NULLCHAR,
	"destlist",	doaxdest,	0, 0, NULLCHAR,
	"digipeat",	dodigipeat,	0, 0, NULLCHAR,
	"flush",	doaxflush,	0, 0, NULLCHAR,
	"heard",	doaxheard,	0, 0, NULLCHAR,
	"irtt",		doaxirtt,	0, 0, NULLCHAR,
	"kick",		doaxkick,	0, 2, "ax25 kick <axcb>",
	"maxframe",	domaxframe,	0, 0, NULLCHAR,
	"mycall",	domycall,	0, 0, NULLCHAR,
	"paclen",	dopaclen,	0, 0, NULLCHAR,
	"pthresh",	dopthresh,	0, 0, NULLCHAR,
	"reset",	doaxreset,	0, 2, "ax25 reset <axcb>",
	"retry",	don2,		0, 0, NULLCHAR,
	"route",	doaxroute,	0, 0, NULLCHAR,
	"status",	doaxstat,	0, 0, NULLCHAR,
	"t3",		dot3,		0, 0, NULLCHAR,
	"version",	doversion,	0, 0, NULLCHAR,
	"window",	doaxwindow,	0, 0, NULLCHAR,
	NULLCHAR,
};
/* Multiplexer for top-level ax25 command */
int
doax25(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Axcmds,argc,argv,p);
}

int
doaxheard(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;

	if(argc > 1){
		if((ifp = if_lookup(argv[1])) == NULLIF){
			printf("Interface %s unknown\n",argv[1]);
			return 1;
		}
		if(ifp->output != ax_output){
			printf("Interface %s not AX.25\n",argv[1]);
			return 1;
		}
		axheard(ifp);
		return 0;
	}
	for(ifp = Ifaces;ifp != NULLIF;ifp = ifp->next){
		if(ifp->output != ax_output)
			continue;	/* Not an ax.25 interface */
		if(axheard(ifp) == EOF)
			break;
	}
	return 0;
}
static int
axheard(ifp)
struct iface *ifp;
{
	struct lq *lp;
	char tmp[AXBUF];

	if(ifp->hwaddr == NULLCHAR)
		return 0;
	printf("%s:\n",ifp->name);
	printf("Station   Last heard           Pkts\n");
	for(lp = Lq;lp != NULLLQ;lp = lp->next){
		if(lp->iface != ifp)
			continue;
		if(printf("%-10s%-17s%8lu\n",pax25(tmp,lp->addr),
		 tformat(secclock() - lp->time),lp->currxcnt) == EOF)
			return EOF;
	}
	return 0;
}
int
doaxdest(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;

	if(argc > 1){
		if((ifp = if_lookup(argv[1])) == NULLIF){
			printf("Interface %s unknown\n",argv[1]);
			return 1;
		}
		if(ifp->output != ax_output){
			printf("Interface %s not AX.25\n",argv[1]);
			return 1;
		}
		axdest(ifp);
		return 0;
	}
	for(ifp = Ifaces;ifp != NULLIF;ifp = ifp->next){
		if(ifp->output != ax_output)
			continue;	/* Not an ax.25 interface */
		if(axdest(ifp) == EOF)
			break;
	}
	return 0;
}
static int
axdest(ifp)
struct iface *ifp;
{
	struct ld *lp;
	struct lq *lq;
	char tmp[AXBUF];

	if(ifp->hwaddr == NULLCHAR)
		return 0;
	printf("%s:\n",ifp->name);
	printf("Station   Last ref         Last heard           Pkts\n");
	for(lp = Ld;lp != NULLLD;lp = lp->next){
		if(lp->iface != ifp)
			continue;

		printf("%-10s%-17s",
		 pax25(tmp,lp->addr),tformat(secclock() - lp->time));

		if(addreq(lp->addr,ifp->hwaddr)){
			/* Special case; it's our address */
			printf("%-17s",tformat(secclock() - ifp->lastsent));
		} else if((lq = al_lookup(ifp,lp->addr,0)) == NULLLQ){
			printf("%-17s","");
		} else {
			printf("%-17s",tformat(secclock() - lq->time));
		}
		if(printf("%8lu\n",lp->currxcnt) == EOF)
			return EOF;
	}
	return 0;
}
static int
doaxflush(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;

	for(ifp = Ifaces;ifp != NULLIF;ifp = ifp->next){
		if(ifp->output != ax_output)
			continue;	/* Not an ax.25 interface */
		axflush(ifp);
	}
	return 0;
}
static void
axflush(ifp)
struct iface *ifp;
{
	struct lq *lp,*lp1;
	struct ld *ld,*ld1;

	ifp->rawsndcnt = 0;
	for(lp = Lq;lp != NULLLQ;lp = lp1){
		lp1 = lp->next;
		free((char *)lp);
	}
	Lq = NULLLQ;
	for(ld = Ld;ld != NULLLD;ld = ld1){
		ld1 = ld->next;
		free((char *)ld);
	}
	Ld = NULLLD;
}

static
doaxreset(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct ax25_cb *axp;

	axp = (struct ax25_cb *)ltop(htol(argv[1]));
	if(!ax25val(axp)){
		printf(Notval);
		return 1;
	}
	reset_ax25(axp);
	return 0;
}

/* Display AX.25 link level control blocks */
static
doaxstat(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ax25_cb *axp;
	char tmp[AXBUF];

	if(argc < 2){
		printf("    &AXB Snd-Q   Rcv-Q   Remote    State\n");
		for(axp = Ax25_cb;axp != NULLAX25; axp = axp->next){
			if(printf("%8lx %-8d%-8d%-10s%s\n",
				ptol(axp),
				len_q(axp->txq),len_p(axp->rxq),
				pax25(tmp,axp->remote),
				Ax25states[axp->state]) == EOF)
					return 0;
		}
		return 0;
	}
	axp = (struct ax25_cb *)ltop(htol(argv[1]));
	if(!ax25val(axp)){
		printf(Notval);
		return 1;
	}
	st_ax25(axp);
	return 0;
}
/* Dump one control block */
void
st_ax25(axp)
register struct ax25_cb *axp;
{
	char tmp[AXBUF];

	if(axp == NULLAX25)
		return;
	printf("    &AXB Remote   RB V(S) V(R) Unack P Retry State\n");

	printf("%8lx %-9s%c%c",ptol(axp),pax25(tmp,axp->remote),
	 axp->flags.rejsent ? 'R' : ' ',
	 axp->flags.remotebusy ? 'B' : ' ');
	printf(" %4d %4d",axp->vs,axp->vr);
	printf(" %02u/%02u %u",axp->unack,axp->maxframe,axp->proto);
	printf(" %02u/%02u",axp->retries,axp->n2);
	printf(" %s\n",Ax25states[axp->state]);

	printf("srtt = %lu mdev = %lu ",axp->srt,axp->mdev);
	printf("T1: ");
	if(run_timer(&axp->t1))
		printf("%lu",read_timer(&axp->t1));
	else
		printf("stop");
	printf("/%lu ms; ",dur_timer(&axp->t1));

	printf("T3: ");
	if(run_timer(&axp->t3))
		printf("%lu",read_timer(&axp->t3));
	else
		printf("stop");
	printf("/%lu ms\n",dur_timer(&axp->t3));

}

/* Display or change our AX.25 address */
static
domycall(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char tmp[AXBUF];

	if(argc < 2){
		printf("%s\n",pax25(tmp,Mycall));
		return 0;
	}
	if(setcall(Mycall,argv[1]) == -1)
		return -1;
	return 0;
}

/* Control AX.25 digipeating */
static
dodigipeat(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setbool(&Digipeat,"Digipeat",argc,argv);
}
/* Set limit on retransmission backoff */
static
doblimit(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setlong(&Blimit,"blimit",argc,argv);
}
static
doversion(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Axversion,"AX25 version",argc,argv);
}

static
doaxirtt(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setlong(&Axirtt,"Initial RTT (ms)",argc,argv);
}

/* Set idle timer */
static
dot3(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setlong(&T3init,"Idle poll timer (ms)",argc,argv);
}

/* Set retry limit count */
static
don2(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&N2,"Retry limit",argc,argv);
}
/* Force a retransmission */
static
doaxkick(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct ax25_cb *axp;

	axp = (struct ax25_cb *)ltop(htol(argv[1]));
	if(!ax25val(axp)){
		printf(Notval);
		return 1;
	}
	kick_ax25(axp);
	return 0;
}
/* Set maximum number of frames that will be allowed in flight */
static
domaxframe(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Maxframe,"Window size (frames)",argc,argv);
}

/* Set maximum length of I-frame data field */
static
dopaclen(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Paclen,"Max frame length (bytes)",argc,argv);
}
/* Set size of I-frame above which polls will be sent after a timeout */
static
dopthresh(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Pthresh,"Poll threshold (bytes)",argc,argv);
}

/* Set high water mark on receive queue that triggers RNR */
static
doaxwindow(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setshort(&Axwindow,"AX25 receive window (bytes)",argc,argv);
}
/* End of ax25 subcommands */

/* Initiate interactive AX.25 connect to remote station */
int
doconnect(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_ax fsocket;
	struct session *sp;
	int ndigis,i,s;
	char digis[MAXDIGIS][AXALEN];
	char target[AXALEN];

	/* If digipeaters are given, put them in the routing table */
	if(argc > 3){
		setcall(target,argv[2]);
		ndigis = argc - 3;
		if(ndigis > MAXDIGIS){
			printf("Too many digipeaters\n");
			return 1;
		}
		for(i=0;i<ndigis;i++){
			if(setcall(digis[i],argv[i+3]) == -1){
				printf("Bad digipeater %s\n",argv[i+3]);
				return 1;
			}
		}
		if(ax_add(target,AX_LOCAL,digis,ndigis) == NULLAXR){
			printf("Route add failed\n");
			return 1;
		}
	}
	/* Allocate a session descriptor */
	if((sp = newsession(Cmdline,AX25TNC,1)) == NULLSESSION){
		printf("Too many sessions\n");
		return 1;
	}
	if((s = socket(AF_AX25,SOCK_STREAM,0)) == -1){
		printf("Can't create socket\n");
		freesession(sp);
		keywait(NULLCHAR,1);
		return 1;
	}
	fsocket.sax_family = AF_AX25;
	setcall(fsocket.ax25_addr,argv[2]);
	strncpy(fsocket.iface,argv[1],ILEN);
	sp->network = fdopen(s,"r+t");
	setvbuf(sp->network,NULLCHAR,_IOLBF,BUFSIZ);
	return tel_connect(sp, (char *)&fsocket, sizeof(struct sockaddr_ax));
}

/* Display and modify AX.25 routing table */
static int
doaxroute(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char tmp[AXBUF];
	int i,ndigis;
	register struct ax_route *axr;
	char target[AXALEN],digis[MAXDIGIS][AXALEN];

	if(argc < 2){
		printf("Target    Type   Digipeaters\n");
		for(axr = Ax_routes;axr != NULLAXR;axr = axr->next){
			printf("%-10s%-6s",pax25(tmp,axr->target),
			 axr->type == AX_LOCAL ? "Local":"Auto");
			for(i=0;i<axr->ndigis;i++){
				printf(" %s",pax25(tmp,axr->digis[i]));
			}
			if(printf("\n") == EOF)
				return 0;
		}
		return 0;
	}
	if(argc < 3){
		printf("Usage: ax25 route add <target> [digis...]\n");
		printf("       ax25 route drop <target>\n");
		return 1;
	}
	if(setcall(target,argv[2]) == -1){
		printf("Bad target %s\n",argv[2]);
		return 1;
	}
	switch(argv[1][0]){
	case 'a':	/* Add route */
		if(argc < 3){
			printf("Usage: ax25 route add <target> [digis...]\n");
			return 1;
		}
		ndigis = argc - 3;
		if(ndigis > MAXDIGIS){
			printf("Too many digipeaters\n");
			return 1;
		}
		for(i=0;i<ndigis;i++){
			if(setcall(digis[i],argv[i+3]) == -1){
				printf("Bad digipeater %s\n",argv[i+3]);
				return 1;
			}
		}
		if(ax_add(target,AX_LOCAL,digis,ndigis) == NULLAXR){
			printf("Failed\n");
			return 1;
		}
		break;
	case 'd':	/* Drop route */
		if(ax_drop(target) == -1){
			printf("Not in table\n");
			return 1;
		}
		break;
	default:
		printf("Unknown command %s\n",argv[1]);
		return 1;
	}
	return 0;
}
@


1.10
log
@Call newsession with Cmdline
Tighten state strings
@
text
@d20 19
a38 19
static int axdest __ARGS((struct iface *ifp));
static int axheard __ARGS((struct iface *ifp));
static void axflush __ARGS((struct iface *ifp));
static int doaxflush __ARGS((int argc,char *argv[],void *p));
static int doaxirtt __ARGS((int argc,char *argv[],void *p));
static int doaxkick __ARGS((int argc,char *argv[],void *p));
static int doaxreset __ARGS((int argc,char *argv[],void *p));
static int doaxroute __ARGS((int argc,char *argv[],void *p));
static int doaxstat __ARGS((int argc,char *argv[],void *p));
static int doaxwindow __ARGS((int argc,char *argv[],void *p));
static int doblimit __ARGS((int argc,char *argv[],void *p));
static int dodigipeat __ARGS((int argc,char *argv[],void *p));
static int domaxframe __ARGS((int argc,char *argv[],void *p));
static int domycall __ARGS((int argc,char *argv[],void *p));
static int don2 __ARGS((int argc,char *argv[],void *p));
static int dopaclen __ARGS((int argc,char *argv[],void *p));
static int dopthresh __ARGS((int argc,char *argv[],void *p));
static int dot3 __ARGS((int argc,char *argv[],void *p));
static int doversion __ARGS((int argc,char *argv[],void *p));
@


1.9
log
@s920528
@
text
@d42 1
a42 1
	"Disconnected",
d44 2
a45 2
	"Conn pending",
	"Disc pending",
d479 1
a479 1
	if((sp = newsession(argv[2],AX25TNC,1)) == NULLSESSION){
@


1.8
log
@src0514
@
text
@d493 1
@


1.7
log
@src0503
@
text
@a482 1
	Current->flowmode = 0;
@


1.6
log
@src0501
@
text
@d455 1
a455 1
	int ndigis,i;
d484 1
a484 1
	if((sp->s = socket(AF_AX25,SOCK_STREAM,0)) == -1){
d493 1
@


1.5
log
@src0410
@
text
@d100 1
a100 1
			tprintf("Interface %s unknown\n",argv[1]);
d104 1
a104 1
			tprintf("Interface %s not AX.25\n",argv[1]);
d127 2
a128 2
	tprintf("%s:\n",ifp->name);
	tprintf("Station   Last heard           Pkts\n");
d132 1
a132 1
		if(tprintf("%-10s%-17s%8lu\n",pax25(tmp,lp->addr),
d148 1
a148 1
			tprintf("Interface %s unknown\n",argv[1]);
d152 1
a152 1
			tprintf("Interface %s not AX.25\n",argv[1]);
d176 2
a177 2
	tprintf("%s:\n",ifp->name);
	tprintf("Station   Last ref         Last heard           Pkts\n");
d182 1
a182 1
		tprintf("%-10s%-17s",
d187 1
a187 1
			tprintf("%-17s",tformat(secclock() - ifp->lastsent));
d189 1
a189 1
			tprintf("%-17s","");
d191 1
a191 1
			tprintf("%-17s",tformat(secclock() - lq->time));
d193 1
a193 1
		if(tprintf("%8lu\n",lp->currxcnt) == EOF)
d243 1
a243 1
		tprintf(Notval);
d261 1
a261 1
		tprintf("    &AXB Snd-Q   Rcv-Q   Remote    State\n");
d263 1
a263 1
			if(tprintf("%8lx %-8d%-8d%-10s%s\n",
d274 1
a274 1
		tprintf(Notval);
d289 1
a289 1
	tprintf("    &AXB Remote   RB V(S) V(R) Unack P Retry State\n");
d291 1
a291 1
	tprintf("%8lx %-9s%c%c",ptol(axp),pax25(tmp,axp->remote),
d294 4
a297 4
	tprintf(" %4d %4d",axp->vs,axp->vr);
	tprintf(" %02u/%02u %u",axp->unack,axp->maxframe,axp->proto);
	tprintf(" %02u/%02u",axp->retries,axp->n2);
	tprintf(" %s\n",Ax25states[axp->state]);
d299 2
a300 2
	tprintf("srtt = %lu mdev = %lu ",axp->srt,axp->mdev);
	tprintf("T1: ");
d302 1
a302 1
		tprintf("%lu",read_timer(&axp->t1));
d304 2
a305 2
		tprintf("stop");
	tprintf("/%lu ms; ",dur_timer(&axp->t1));
d307 1
a307 1
	tprintf("T3: ");
d309 1
a309 1
		tprintf("%lu",read_timer(&axp->t3));
d311 2
a312 2
		tprintf("stop");
	tprintf("/%lu ms\n",dur_timer(&axp->t3));
d326 1
a326 1
		tprintf("%s\n",pax25(tmp,Mycall));
d400 1
a400 1
		tprintf(Notval);
d464 1
a464 1
			tprintf("Too many digipeaters\n");
d469 1
a469 1
				tprintf("Bad digipeater %s\n",argv[i+3]);
d474 1
a474 1
			tprintf("Route add failed\n");
d480 1
a480 1
		tprintf("Too many sessions\n");
d485 1
a485 1
		tprintf("Can't create socket\n");
d509 1
a509 1
		tprintf("Target    Type   Digipeaters\n");
d511 1
a511 1
			tprintf("%-10s%-6s",pax25(tmp,axr->target),
d514 1
a514 1
				tprintf(" %s",pax25(tmp,axr->digis[i]));
d516 1
a516 1
			if(tprintf("\n") == EOF)
d522 2
a523 2
		tprintf("Usage: ax25 route add <target> [digis...]\n");
		tprintf("       ax25 route drop <target>\n");
d527 1
a527 1
		tprintf("Bad target %s\n",argv[2]);
d533 1
a533 1
			tprintf("Usage: ax25 route add <target> [digis...]\n");
d538 1
a538 1
			tprintf("Too many digipeaters\n");
d543 1
a543 1
				tprintf("Bad digipeater %s\n",argv[i+3]);
d548 1
a548 1
			tprintf("Failed\n");
d554 1
a554 1
			tprintf("Not in table\n");
d559 1
a559 1
		tprintf("Unknown command %s\n",argv[1]);
@


1.4
log
@src0331
@
text
@d483 1
@


1.3
log
@src0305
@
text
@d479 1
a479 1
	if((sp = newsession(argv[2],AX25TNC)) == NULLSESSION){
@


1.2
log
@src0221
@
text
@a128 2
	tprintf("%-10s%-17s%8lu\n",pax25(tmp,ifp->hwaddr),
	 tformat(secclock() - ifp->lastsent),ifp->rawsndcnt);
a222 1
		free(lp->addr);
a227 1
		free(ld->addr);
a256 1
	register int i;
d262 7
a268 10
		for(i=0;i<NHASH;i++){
			for(axp = Ax25_cb[i];axp != NULLAX25; axp = axp->next){

				if(tprintf("%8lx %-8d%-8d%-10s%s\n",
					ptol(axp),
					len_q(axp->txq),len_p(axp->rxq),
					pax25(tmp,axp->remote),
					Ax25states[axp->state]) == EOF)
						return 0;
			}
d503 1
a503 1
	int i,j,ndigis;
d509 5
a513 9
		for(i=0;i<NHASH;i++){
			for(axr = Ax_routes[i];axr != NULLAXR;axr = axr->next){
				tprintf("%-10s%-6s",pax25(tmp,axr->target),
				 axr->type == AX_LOCAL ? "Local":"Auto");
				for(j=0;j<axr->ndigis;j++){
					tprintf(" %s",pax25(tmp,axr->digis[j]));
				}
				if(tprintf("\n") == EOF)
					return 0;
d515 2
@


1.1
log
@Initial revision
@
text
@d20 1
d61 1
a121 1
	int i;
d128 2
a129 2
	tprintf("Station   Time since last heard   Pkts recvd\n");
	tprintf("%-9s %-21s   %lu\n",pax25(tmp,ifp->hwaddr),
d131 63
a193 7
	for(i=0;i<NHASH;i++){
		for(lp = Lq[i];lp != NULLLQ;lp = lp->next){
			if(lp->iface != ifp)
				continue;
			if(tprintf("%-9s %-21s   %lu\n",pax25(tmp,lp->addr),
			 tformat(secclock() - lp->time),lp->currxcnt) == EOF)
				return EOF;
d195 2
a218 1
	int i;
d220 1
d223 10
a232 7
	for(i=0;i<NHASH;i++){
		for(lp = Lq[i];lp != NULLLQ;lp = lp1){
			lp1 = lp->next;
			free(lp->addr);
			free((char *)lp);
		}
		Lq[i] = NULLLQ;
d234 1
@
