head	1.10;
access;
symbols;
locks;
comment	@ * @;


1.10
date	93.05.06.10.07.14;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.10.07.19.35.34;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.04.11.09.01.22;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.04.08.08.38.18;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.03.26.11.23.08;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.03.10.12.39.22;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.03.05.14.34.36;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.05.02.25.30;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.19.11.32.12;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.36.00;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.10
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Low level AX.25 code:
 *  incoming frame processing (including digipeating)
 *  IP encapsulation
 *  digipeater routing
 *
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "arp.h"
#include "slip.h"
#include "ax25.h"
#include "lapb.h"
#include "netrom.h"
#include "ip.h"
#include "devparam.h"
#include <ctype.h>

static int axsend(struct iface *iface,char *dest,char *source,
	int cmdrsp,int ctl,struct mbuf *data);

/* List of AX.25 multicast addresses in network format (shifted ascii).
 * Only the first entry is used for transmission, but an incoming
 * packet with any one of these destination addresses is recognized
 * as a multicast.
 */
char Ax25multi[][AXALEN] = {
	'Q'<<1, 'S'<<1, 'T'<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1,	/* QST */
	'M'<<1, 'A'<<1, 'I'<<1, 'L'<<1, ' '<<1, ' '<<1, '0'<<1,	/* MAIL */
	'N'<<1, 'O'<<1, 'D'<<1, 'E'<<1, 'S'<<1, ' '<<1, '0'<<1,	/* NODES */
	'I'<<1, 'D'<<1, ' '<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1,	/* ID */
	'O'<<1, 'P'<<1, 'E'<<1, 'N'<<1, ' '<<1, ' '<<1, '0'<<1,	/* OPEN */
	'C'<<1, 'Q'<<1, ' '<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1,	/* CQ */
	'B'<<1, 'E'<<1, 'A'<<1, 'C'<<1, 'O'<<1, 'N'<<1, '0'<<1,	/* BEACON */
	'R'<<1, 'M'<<1, 'N'<<1, 'C'<<1, ' '<<1, ' '<<1, '0'<<1,	/* RMNC */
	'A'<<1, 'L'<<1, 'L'<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1,	/* ALL */
	'\0',
};
char Mycall[AXALEN];
struct ax_route *Ax_routes;	/* Routing table header */
int Digipeat = 1;	/* Controls digipeating */

int
axi_send(bp,iface,gateway,tos)
struct mbuf *bp;
struct iface *iface;
int32 gateway;
int tos;
{
	return axui_send(bp,iface,gateway,tos);
}

/* Send IP datagrams across an AX.25 link */
int
axui_send(bp,iface,gateway,tos)
struct mbuf *bp;
struct iface *iface;
int32 gateway;
int tos;
{
	struct mbuf *tbp;
	char *hw_addr;
	struct ax25_cb *axp;

	if((hw_addr = res_arp(iface,ARP_AX25,gateway,bp)) == NULLCHAR)
		return 0;	/* Wait for address resolution */

	/* UI frames are used for any one of the following three conditions:
	 * 1. The "low delay" bit is set in the type-of-service field.
	 * 2. The "reliability" TOS bit is NOT set and the interface is in
	 *    datagram mode.
	 * 3. The destination is the broadcast address (this is helpful
	 *    when broadcasting on an interface that's in connected mode).
	 */
	if((tos & IP_COS) == DELAY
	 || ((tos & IP_COS) != RELIABILITY && (iface->send == axui_send))
	 || addreq(hw_addr,Ax25multi[0])){
		/* Use UI frame */
		return (*iface->output)(iface,hw_addr,iface->hwaddr,PID_IP,bp);
	}
	/* Reliability is needed; use I-frames in AX.25 connection */
	if((axp = find_ax25(hw_addr)) == NULLAX25){
		/* Open a new connection */
		axp = open_ax25(iface,iface->hwaddr,hw_addr,
		 AX_ACTIVE,Axwindow,s_arcall,s_atcall,s_ascall,-1);
		if(axp == NULLAX25){
			free_p(bp);
			return -1;
		}
	}
	if(axp->state == LAPB_DISCONNECTED){
		est_link(axp);
		lapbstate(axp,LAPB_SETUP);
	}
	/* Insert the PID */
	bp = pushdown(bp,1);
	bp->data[0] = PID_IP;
	if((tbp = segmenter(bp,axp->paclen)) == NULLBUF){
		free_p(bp);
		return -1;
	}
	return send_ax25(axp,tbp,-1);
}
/* Add header and send connectionless (UI) AX.25 packet.
 * Note that the calling order here must match enet_output
 * since ARP also uses it.
 */
int
ax_output(iface,dest,source,pid,bp)
struct iface *iface;	/* Interface to use; overrides routing table */
char *dest;		/* Destination AX.25 address (7 bytes, shifted) */
char *source;		/* Source AX.25 address (7 bytes, shifted) */
uint16 pid;		/* Protocol ID */
struct mbuf *bp;	/* Data field (follows PID) */
{
	/* Prepend pid to data */
	bp = pushdown(bp,1);
	bp->data[0] = (char)pid;
	return axsend(iface,dest,source,LAPB_COMMAND,UI,bp);
}
/* Common subroutine for sendframe() and ax_output() */
static int
axsend(iface,dest,source,cmdrsp,ctl,bp)
struct iface *iface;	/* Interface to use; overrides routing table */
char *dest;		/* Destination AX.25 address (7 bytes, shifted) */
char *source;		/* Source AX.25 address (7 bytes, shifted) */
int cmdrsp;		/* Command/response indication */
int ctl;		/* Control field */
struct mbuf *bp;	/* Data field (includes PID) */
{
	struct ax25 addr;
	struct ax_route *axr;
	char *idest;
	int rval;
	struct mbuf *data;

	/* If the source addr is unspecified, use the interface address */
	if(source[0] == '\0')
		source = iface->hwaddr;

	/* If there's a digipeater route, get it */
	axr = ax_lookup(dest);

	memcpy(addr.dest,dest,AXALEN);
	memcpy(addr.source,source,AXALEN);
	addr.cmdrsp = cmdrsp;

	if(axr != NULLAXR){
		memcpy(addr.digis,axr->digis,axr->ndigis*AXALEN);
		addr.ndigis = axr->ndigis;
		idest = addr.digis[0];
	} else {
		addr.ndigis = 0;
		idest = dest;
	}
	addr.nextdigi = 0;

	/* Allocate mbuf for control field, and fill in */
	bp = pushdown(bp,1);
	bp->data[0] = ctl;

	if((data = htonax25(&addr,bp)) == NULLBUF){
		free_p(bp);
		return -1;
	}
	/* This shouldn't be necessary because redirection has already been
	 * done at the IP router layer, but just to be safe...
	 */
	if(iface->forw != NULLIF){
		logsrc(iface->forw,iface->forw->hwaddr);
		logdest(iface->forw,idest);
		rval = (*iface->forw->raw)(iface->forw,data);
	} else {
		logsrc(iface,iface->hwaddr);
		logdest(iface,idest);
		rval = (*iface->raw)(iface,data);
	}
	return rval;
}
/* Process incoming AX.25 packets.
 * After optional tracing, the address field is examined. If it is
 * directed to us as a digipeater, repeat it.  If it is addressed to
 * us or to QST-0, kick it upstairs depending on the protocol ID.
 */
void
ax_recv(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	struct mbuf *hbp;
	char control;
	struct ax25 hdr;
	struct ax25_cb *axp;
	struct ax_route *axr;
	char (*mpp)[AXALEN];
	int mcast;
	char *isrc,*idest;	/* "immediate" source and destination */

	/* Pull header off packet and convert to host structure */
	if(ntohax25(&hdr,&bp) < 0){
		/* Something wrong with the header */
		free_p(bp);
		return;
	}
	/* If there were digis in this packet and at least one has
	 * been passed, then the last passed digi is the immediate source.
	 * Otherwise it is the original source.
	 */
	if(hdr.ndigis != 0 && hdr.nextdigi != 0)
		isrc = hdr.digis[hdr.nextdigi-1];
	else
		isrc = hdr.source;

	/* If there are digis in this packet and not all have been passed,
	 * then the immediate destination is the next digi. Otherwise it
	 * is the final destination.
	 */
	if(hdr.ndigis != 0 && hdr.nextdigi != hdr.ndigis)
		idest = hdr.digis[hdr.nextdigi];
	else
		idest = hdr.dest;

	/* Don't log our own packets if we overhear them, as they're
	 * already logged by axsend() and by the digipeater code.
	 */
	if(!addreq(isrc,iface->hwaddr)){
		logsrc(iface,isrc);
		logdest(iface,idest);
	}
	/* Examine immediate destination for a multicast address */
	mcast = 0;
	for(mpp = Ax25multi;(*mpp)[0] != '\0';mpp++){
		if(addreq(idest,*mpp)){
			mcast = 1;
			break;
		}
	}
	if(!mcast && !addreq(idest,iface->hwaddr)){
		/* Not a broadcast, and not addressed to us. Inhibit
		 * transmitter to avoid colliding with addressed station's
		 * response, and discard packet.
		 */
		if(iface->ioctl != NULL)
			(*iface->ioctl)(iface,PARAM_MUTE,1,-1);
		free_p(bp);
		return;
	}
	if(!mcast && iface->ioctl != NULL){
		/* Packet was sent to us; abort transmit inhibit */
		(*iface->ioctl)(iface,PARAM_MUTE,1,0);
	}
	/* At this point, packet is either addressed to us, or is
	 * a multicast.
	 */
	if(hdr.nextdigi < hdr.ndigis){
		/* Packet requests digipeating. See if we can repeat it. */
		if(Digipeat && !mcast){
			/* Yes, kick it back out. htonax25 will set the
			 * repeated bit.
			 */
			hdr.nextdigi++;
			if((hbp = htonax25(&hdr,bp)) != NULLBUF){
				if(iface->forw != NULLIF){
					logsrc(iface->forw,iface->forw->hwaddr);
					logdest(iface->forw,hdr.digis[hdr.nextdigi]);
					(*iface->forw->raw)(iface->forw,hbp);
				} else {
					logsrc(iface,iface->hwaddr);
					logdest(iface,hdr.digis[hdr.nextdigi]);
					(*iface->raw)(iface,hbp);
				}
				bp = NULLBUF;
			}
		}
		free_p(bp);	/* Dispose if not forwarded */
		return;
	}
	/* If we reach this point, then the packet has passed all digis,
	 * and is either addressed to us or is a multicast.
	 */
	if(bp == NULLBUF)
		return;		/* Nothing left */

	/* If there's no locally-set entry in the routing table and
	 * this packet has digipeaters, create or update it. Leave
	 * local routes alone.
	 */
	if(((axr = ax_lookup(hdr.source)) == NULLAXR || axr->type == AX_AUTO)
	 && hdr.ndigis > 0){
		char digis[MAXDIGIS][AXALEN];
		int i,j;

		/* Construct reverse digipeater path */
		for(i=hdr.ndigis-1,j=0;i >= 0;i--,j++){
			memcpy(digis[j],hdr.digis[i],AXALEN);
			digis[j][ALEN] &= ~(E|REPEATED);
		}
		ax_add(hdr.source,AX_AUTO,digis,hdr.ndigis);
	}
	/* Sneak a peek at the control field. This kludge is necessary because
	 * AX.25 lacks a proper protocol ID field between the address and LAPB
	 * sublayers; a control value of UI indicates that LAPB is to be
	 * bypassed.
	 */
	control = *bp->data & ~PF;

	if(uchar(control) == UI){
		int pid;
		struct axlink *ipp;

		(void) PULLCHAR(&bp);
		if((pid = PULLCHAR(&bp)) == -1)
			return;		/* No PID */
		/* Find network level protocol and hand it off */
		for(ipp = Axlink;ipp->funct != NULL;ipp++){
			if(ipp->pid == pid)
				break;
		}
		if(ipp->funct != NULL)
			(*ipp->funct)(iface,NULLAX25,hdr.source,hdr.dest,bp,mcast);
		else
			free_p(bp);
		return;
	}
	/* Everything from here down is connected-mode LAPB, so ignore
	 * multicasts
	 */
	if(mcast){
		free_p(bp);
		return;
	}
	/* Find the source address in hash table */
	if((axp = find_ax25(hdr.source)) == NULLAX25){
		/* Create a new ax25 entry for this guy,
		 * insert into hash table keyed on his address,
		 * and initialize table entries
		 */
		if((axp = cr_ax25(hdr.source)) == NULLAX25){
			free_p(bp);
			return;
		}
		/* Swap source and destination */
		memcpy(axp->remote,hdr.source,AXALEN);
		memcpy(axp->local,hdr.dest,AXALEN);
		axp->iface = iface;
	}
	if(hdr.cmdrsp == LAPB_UNKNOWN)
		axp->proto = V1;	/* Old protocol in use */

	lapb_input(axp,hdr.cmdrsp,bp);
}
/* General purpose AX.25 frame output */
int
sendframe(axp,cmdrsp,ctl,data)
struct ax25_cb *axp;
int cmdrsp;
int ctl;
struct mbuf *data;
{
	return axsend(axp->iface,axp->remote,axp->local,cmdrsp,ctl,data);
}
/* Find a route for an AX.25 address */
struct ax_route *
ax_lookup(target)
char *target;
{
	register struct ax_route *axr;
	struct ax_route *axlast = NULLAXR;

	for(axr = Ax_routes; axr != NULLAXR; axlast=axr,axr = axr->next){
		if(addreq(axr->target,target)){
			if(axr != Ax_routes){
				/* Move entry to top of list to speed
				 * future searches
				 */
				axlast->next = axr->next;
				axr->next = Ax_routes;
				Ax_routes = axr;

			}
			return axr;
		}
	}
	return axr;
}
/* Add an entry to the AX.25 routing table */
struct ax_route *
ax_add(target,type,digis,ndigis)
char *target;
int type;
char digis[][AXALEN];
int ndigis;
{
	register struct ax_route *axr;

	if(ndigis < 0 || ndigis > MAXDIGIS)
		return NULLAXR;

	if((axr = ax_lookup(target)) == NULLAXR){
		axr = (struct ax_route *)callocw(1,sizeof(struct ax_route));
		axr->next = Ax_routes;
		Ax_routes = axr;
		memcpy(axr->target,target,AXALEN);
		axr->ndigis = ndigis;
	}
	axr->type = type;
	if(axr->ndigis != ndigis)
		axr->ndigis = ndigis;

	memcpy(axr->digis,digis[0],ndigis*AXALEN);
	return axr;
}
int
ax_drop(target)
char *target;
{
	register struct ax_route *axr;
	struct ax_route *axlast = NULLAXR;

	for(axr = Ax_routes;axr != NULLAXR;axlast=axr,axr=axr->next)
		if(memcmp(axr->target,target,AXALEN) == 0)
			break;
	if(axr == NULLAXR)
		return -1;	/* Not in table! */
	if(axlast != NULLAXR)
		axlast->next = axr->next;
	else
		Ax_routes = axr->next;
	
	free((char *)axr);
	return 0;
}
/* Handle ordinary incoming data (no network protocol) */
void
axnl3(iface,axp,src,dest,bp,mcast)
struct iface *iface;
struct ax25_cb *axp;
char *src;
char *dest;
struct mbuf *bp;
int mcast;
{
	if(axp == NULLAX25){
		beac_input(iface,src,bp);
	} else {
		append(&axp->rxq,bp);
		if(axp->r_upcall != NULLVFP)
			(*axp->r_upcall)(axp,len_p(axp->rxq));
	}
}
@


1.9
log
@Split ax_send() function into axi_send() and axui_send()
@
text
@d21 2
a22 2
static int axsend __ARGS((struct iface *iface,char *dest,char *source,
	int cmdrsp,int ctl,struct mbuf *data));
d115 1
a115 1
int16 pid;		/* Protocol ID */
@


1.8
log
@src0411
@
text
@d45 10
d57 1
a57 1
ax_send(bp,iface,gateway,tos)
d78 1
a78 1
	 || ((tos & IP_COS) != RELIABILITY && (iface->flags == DATAGRAM_MODE))
@


1.7
log
@src0410
@
text
@d155 1
a155 1
		free_p(bp);	/* Also frees data */
@


1.6
log
@src0327
@
text
@d53 1
a55 1
	struct mbuf *tbp;
d88 1
a88 5
	if((tbp = pushdown(bp,1)) == NULLBUF){
		free_p(bp);
		return -1;
	}
	bp = tbp;
d101 1
a101 1
ax_output(iface,dest,source,pid,data)
d106 1
a106 1
struct mbuf *data;	/* Data field (follows PID) */
a107 2
	struct mbuf *bp;

d109 1
a109 5
	bp = pushdown(data,1);
	if(bp == NULLBUF){
		free_p(data);
		return -1;
	}
d115 1
a115 1
axsend(iface,dest,source,cmdrsp,ctl,data)
d121 1
a121 1
struct mbuf *data;	/* Data field (includes PID) */
a122 1
	struct mbuf *cbp;
d127 1
d151 2
a152 5
	if((cbp = pushdown(data,1)) == NULLBUF){
		free_p(data);
		return -1;
	}
	cbp->data[0] = ctl;
d154 2
a155 2
	if((data = htonax25(&addr,cbp)) == NULLBUF){
		free_p(cbp);	/* Also frees data */
@


1.5
log
@src0318
@
text
@d47 1
a47 1
ax_send(bp,iface,gateway,prec,del,tput,rel)
d51 1
a51 4
int prec;
int del;
int tput;
int rel;
d67 2
a68 1
	if(del || (!rel && (iface->flags == DATAGRAM_MODE))
@


1.4
log
@src0308
@
text
@d25 3
a27 2
 * The first entry is used for all transmissions, but any entry
 * is recognized on incoming packets.
d30 9
a38 7
	'Q'<<1, 'S'<<1, 'T'<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1,
	'M'<<1, 'A'<<1, 'I'<<1, 'L'<<1, ' '<<1, ' '<<1, '0'<<1,
	'N'<<1, 'O'<<1, 'D'<<1, 'E'<<1, 'S'<<1, ' '<<1, '0'<<1,
	'I'<<1, 'D'<<1, ' '<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1,
	'O'<<1, 'P'<<1, 'E'<<1, 'N'<<1, ' '<<1, ' '<<1, '0'<<1,
	'C'<<1, 'Q'<<1, ' '<<1, ' '<<1, ' '<<1, ' '<<1, '0'<<1,
	'B'<<1, 'E'<<1, 'A'<<1, 'C'<<1, 'O'<<1, 'N'<<1, '0'<<1,
@


1.3
log
@src0305
@
text
@d35 1
@


1.2
log
@src0221
@
text
@d24 5
a28 2
/* AX.25 broadcast address: "QST-0" in shifted ascii */
char Ax25_bdcst[AXALEN] = {
d30 6
d38 1
a38 1
struct ax_route *Ax_routes[NHASH];	/* Routing table header */
d67 1
a67 1
	 || addreq(hw_addr,Ax25_bdcst)){
d134 1
d151 2
a152 1
	} else
d154 2
a155 1

d173 2
d177 2
d198 1
a198 1
	char **mpp;
d200 1
d209 2
a210 2
	 * been passed, then log the last passed digi as the source.
	 * Otherwise log the original source.
d213 1
a213 1
		logsrc(iface,hdr.digis[hdr.nextdigi-1]);
d215 1
a215 1
		logsrc(iface,hdr.source);
d218 2
a219 2
	 * then log the next digi as the packet's destination. Otherwise log
	 * the final destination.
d222 1
a222 1
		logdest(iface,hdr.digis[hdr.nextdigi]);
d224 1
a224 1
		logdest(iface,hdr.dest);
d226 32
d259 2
a260 4
		/* Packet hasn't passed all digipeaters yet. See if
		 * we have to repeat it.
		 */
		if(Digipeat && addreq(hdr.digis[hdr.nextdigi],iface->hwaddr)){
d267 2
d271 2
d282 1
a282 1
	 * but it is not necessarily for us.
d284 3
a286 29
	if(bp == NULLBUF){
		/* Nothing left */
		return;
	}
	/* Examine destination to see if it's either addressed to us or
	 * a multicast.
	 */
	mcast = 0;
	for(mpp = Axmulti;*mpp != NULLCHAR;mpp++){
		if(addreq(hdr.dest,*mpp)){
			mcast = 1;
			break;
		}
	}
	if(!mcast && !addreq(hdr.dest,iface->hwaddr)){
		/* Not a broadcast, and not addressed to us. Inhibit
		 * transmitter to avoid colliding with addressed station's
		 * response.
		 */
		if(iface->ioctl != NULL)
			(*iface->ioctl)(iface,PARAM_MUTE,1,-1);
		free_p(bp);
		return;
	}
	if(!mcast){
		/* Packet sent to us; abort transmit inhibit */
		if(iface->ioctl != NULL)
			(*iface->ioctl)(iface,PARAM_MUTE,1,0);
	}
d371 11
d383 3
a385 3
	for(axr = Ax_routes[ax25hash(target)]; axr != NULLAXR; axr = axr->next){
		if(addreq(axr->target,target))
			break;
a396 1
	int16 hval;
d404 2
a405 6
		hval = ax25hash(target);
		axr->prev = NULLAXR;
		axr->next = Ax_routes[hval];
		if(axr->next != NULLAXR)
			axr->next->prev = axr;
		Ax_routes[hval] = axr;
d421 1
d423 7
a429 7
	if((axr = ax_lookup(target)) == NULLAXR)
		return -1;

	if(axr->next != NULLAXR)
		axr->next->prev = axr->prev;
	if(axr->prev != NULLAXR)
		axr->prev->next = axr->next;
d431 2
a432 1
		Ax_routes[ax25hash(target)] = axr->next;
@


1.1
log
@Initial revision
@
text
@d18 1
d191 3
a193 2
	/* If there were digis in this packet, then the last digi was the
	 * actual transmitter. Otherwise the source is the transmitter.
d195 2
a196 2
	if(hdr.ndigis != 0)
		logaddr(iface,hdr.digis[hdr.nextdigi-1]);
d198 1
a198 1
		logaddr(iface,hdr.source);
d200 9
d248 6
a253 1
		/* Not a broadcast, and not addressed to us; ignore */
d256 5
@
