/*
 * This is a mudlib file. Copy it to /obj/simul_efun.c, or
 * wherever the get_simul_efun() in master.c says.
 * The functions defined in this file should only be replacements of efuns
 * no longer supported. Don't use these functions any longer, use the
 * replacement instead.
 */

/*
 * The ls() function is no longer needed, as get_dir() can do the same
 * work.
 */
/* 
 * The if part of this is lars' ls function.  A -DR compatible LPC version
 * of ls is in the else part of the if statment.  This version is (close)
 * to the output of the old list_files efun.
 */
#ifndef COMPAT_FLAG
#pragma strict_types
#pragma save_types

void ls(string path) {
    int max, i, len, tmp;
    status trunc_flag;
    string *dir;
#ifndef COMPAT_FLAG
    seteuid(geteuid(previous_object()));
#endif
    dir = get_dir (path);
#if defined(COMPAT_FLAG) && 0
    if (path[0] == '/')
	path = extract(path, 1);
    if (path != "")
	path += "/";
#else
    if (path != "/")
	path += "/";
#endif
    if (!dir) {
        write("No such directory.\n");
        return;
    }
    if (sizeof(dir) > 999)
    {
        dir = dir[0..998];
        trunc_flag = 1;
    }
    max = (int)("/obj/master"->test_dir(dir,path));
    if (max > 79)
        max = 79;
    for (i=0; i < sizeof(dir); i++) {
	string name;
            name = dir[i];
	tmp = strlen(name);
	if (len + tmp > 79) {
	    len = 0;
	    write("\n");
	}
	write(name);
        if (len + max > 79) {
            write("\n");
            len = 0;
        } else {
            write(extract(
"                                                                                ",
                80-max+tmp));
            len += max;
        }
    }
    write("\n");
    if (trunc_flag) write("***TRUNCATED***\n");
}
#else
#if 0

#define WIDTH 79

void ls(string arg)
{
   string *f;
   int fsize;

   if (arg == "/") arg += ".";
   f = files(arg);
   fsize = sizeof(f);
   if (f && fsize)
   {
      int max, i, j, padlength, size, columns, num_per_column;
      string *out;
 
      max = 0;
      for (i=0; i<fsize; ++i)
         if ((j = strlen(f[i])) > max)
            max = j;
      max += 4; /* to compensate for the size... */
      i = WIDTH/max;
      j = i*max;
      if (j != WIDTH)
         padlength = max + (WIDTH-j)/max;
      else 
         padlength = max;
      size = 0;
      columns = WIDTH/padlength;
      num_per_column = fsize/columns + (((fsize/columns)*columns) != fsize);
      out = allocate(num_per_column);
      for (i = 0; i<columns; ++i)
         for (j=0; j<num_per_column; ++j)
            if ((i*num_per_column+j) < fsize) 
            {
               int s;

               s = file_size(arg+"/"+f[i*num_per_column+j]);
               s = s/1024 + (((s/1024)*1024) != s);
               if (out[j])
                  out[j] += pad(pad(s, -3)+
                                " "+ f[i*num_per_column+j], padlength);
               else
                  out[j] = pad(pad(s, -3)+
                                " "+ f[i*num_per_column+j], padlength);
               size += s;
            }
      write("Total "+size+"\n");
      for (i=0; i<sizeof(out); ++i)
         write(out[i]+"\n");
   }
   else write(arg+" not found.\n");
}
#endif
#endif

/*
 * The old 'slice_array' is no longer needed. Use range argument inside
 * a pair of brackets instead.
 */
mixed *slice_array(mixed *arr, int from, int to) {
    return arr[from..to];
}

/*
 * filter_objects() has been renamed to filter_array().
 */
mixed *filter_objects(mixed *list, string str, object ob, mixed extra) {
    return filter_array(list, str, ob, extra);
}

/*
 * Define functions to return the proper third person pronoun based on
 * gender.
 */
subjective(ob) {
    string gender;
    if (!ob) 
    {
       ob = this_player();
       if (!ob) return "it";
    }
    gender = ob->query_gender();
    if (gender == "male") return "he";
    else if (gender == "female") return "she";
    else return "it";
}

objective(ob) {
    string gender;
    if (!ob)
    {
       ob = this_player();
       if (!ob) return "it";
    }
    gender = ob->query_gender();
    if (gender == "male") return "him";
    else if (gender == "female") return "her";
    else return "it";
}

possessive(ob) {
    string gender;
    if (!ob) 
    {
       ob = this_player();
       if (!ob) return "its";
    }
    gender = ob->query_gender();
    if (gender == "male") return "his";
    else if (gender == "female") return "her";
    else return "its";
}
