
# line 2 "lang.y"
# line 3 "prelang.y"
/* The above line is to give proper line number references. Please mail me
 * if your compiler complains about it.
 */
/*
 * This is the grammar definition of LPC. The token table is built
 * automatically by make_func. The lang.y is constructed from this file,
 * the generated token list and post_lang.y. The reason of this is that there
 * is no #include-statment that yacc recognizes.
 */
#include <string.h>
#include <stdio.h>
#include <memory.h>
#if defined(sun)
#include <alloca.h>
#endif

#include "lint.h"
#include "interpret.h"
#include "object.h"
#include "exec.h"
#include "config.h"
#include "instrs.h"
#include "incralloc.h"
#include "switch.h"

#if defined(__GNUC__) && !defined(lint) && !defined(DEBUG)
#define INLINE inline
#else
#define INLINE
#endif

#define YYMAXDEPTH	600

/* NUMPAREAS areas are saved with the program code after compilation.
 */
#define A_PROGRAM		0
#define A_FUNCTIONS		1
#define A_STRINGS		2
#define A_VARIABLES		3
#define A_LINENUMBERS		4
#define A_INHERITS		5
#define A_ARGUMENT_TYPES	6
#define A_ARGUMENT_INDEX	7
#define NUMPAREAS		8
#define A_CASE_NUMBERS		8
#define A_CASE_STRINGS		9
#define A_CASE_LABELS	       10
#define NUMAREAS	       11

#define BREAK_ON_STACK		0x40000
#define BREAK_FROM_CASE		0x80000

/* make shure that this struct has a size that is a power of two */
struct case_heap_entry { int key; short addr; short line; };
#define CASE_HEAP_ENTRY_ALIGN(offset) offset &= -sizeof(struct case_heap_entry)

static struct mem_block mem_block[NUMAREAS];

/*
 * Some good macros to have.
 */

#define BASIC_TYPE(e,t) ((e) == TYPE_ANY ||\
			 (e) == (t) ||\
			 (t) == TYPE_ANY)

#define TYPE(e,t) (BASIC_TYPE((e) & TYPE_MOD_MASK, (t) & TYPE_MOD_MASK) ||\
		   (((e) & TYPE_MOD_POINTER) && ((t) & TYPE_MOD_POINTER) &&\
		    BASIC_TYPE((e) & (TYPE_MOD_MASK & ~TYPE_MOD_POINTER),\
			       (t) & (TYPE_MOD_MASK & ~TYPE_MOD_POINTER))))

#define FUNCTION(n) ((struct function *)mem_block[A_FUNCTIONS].block + (n))
#define VARIABLE(n) ((struct variable *)mem_block[A_VARIABLES].block + (n))

#define align(x) (((x) + 3) & ~3)

/*
 * If the type of the function is given, then strict types are
 * checked and required.
 */
static int exact_types;
extern int pragma_strict_types;	/* Maintained by lex.c */
extern int pragma_save_types;	/* Also maintained by lex.c */
int approved_object;		/* How I hate all these global variables */

extern int total_num_prog_blocks, total_prog_block_size;

extern int num_parse_error;
extern int d_flag;
static int heart_beat;		/* Number of the heart beat function */

static int current_break_address;
static int current_continue_address;
static int current_case_number_heap;
static int current_case_string_heap;
#define SOME_NUMERIC_CASE_LABELS 0x40000
#define NO_STRING_CASE_LABELS    0x80000
static int zero_case_label;
static int current_type;

static int last_push_indexed;
static int last_push_local;
static int last_push_identifier;

static struct program NULL_program; /* marion - clean neat empty struct */

static char *get_two_types PROT((int type1, int type2));
void free_all_local_names(),
    add_local_name PROT((char *, int)), smart_log PROT((char *, int, char *));
extern int yylex();
static int verify_declared PROT((char *));
static void copy_variables();
void type_error PROT((char *, int));

char *xalloc(), *string_copy();

extern int current_line;
/*
 * 'inherit_file' is used as a flag. If it is set to a string
 * after yyparse(), this string should be loaded as an object,
 * and the original object must be loaded again.
 */
extern char *current_file, *inherit_file;

/*
 * The names and types of arguments and auto variables.
 */
char *local_names[MAX_LOCAL];
unsigned short type_of_locals[MAX_LOCAL];
int current_number_of_locals = 0;
int current_break_stack_need = 0  ,max_break_stack_need = 0;

/*
 * The types of arguments when calling functions must be saved,
 * to be used afterwards for checking. And because function calls
 * can be done as an argument to a function calls,
 * a stack of argument types is needed. This stack does not need to
 * be freed between compilations, but will be reused.
 */
static struct mem_block type_of_arguments;

struct program *prog;	/* Is returned to the caller of yyparse */

/*
 * Compare two types, and return true if they are compatible.
 */
int compatible_types(t1, t2)
    int t1, t2;
{
    if (t1 == TYPE_UNKNOWN || t2 == TYPE_UNKNOWN)
	return 0;
    if (t1 == t2)
	return 1;
    if (t1 == TYPE_ANY || t2 == TYPE_ANY)
	return 1;
    if ((t1 & TYPE_MOD_POINTER) && (t2 & TYPE_MOD_POINTER)) {
	if ((t1 & TYPE_MOD_MASK) == (TYPE_ANY|TYPE_MOD_POINTER) ||
	    (t2 & TYPE_MOD_MASK) == (TYPE_ANY|TYPE_MOD_POINTER))
	    return 1;
    }
    return 0;
}

/*
 * Add another argument type to the argument type stack
 */
static void add_arg_type(type)
    unsigned short type;
{
    struct mem_block *mbp = &type_of_arguments;
    while (mbp->current_size + sizeof type > mbp->max_size) {
	mbp->max_size <<= 1;
	mbp->block = realloc((char *)mbp->block, mbp->max_size);
    }
    memcpy(mbp->block + mbp->current_size, &type, sizeof type);
    mbp->current_size += sizeof type;
}

/*
 * Pop the argument type stack 'n' elements.
 */
INLINE
static void pop_arg_stack(n)
    int n;
{
    type_of_arguments.current_size -= sizeof (unsigned short) * n;
}

/*
 * Get type of argument number 'arg', where there are
 * 'n' arguments in total in this function call. Argument
 * 0 is the first argument.
 */
INLINE
int get_argument_type(arg, n)
    int arg, n;
{
    return
	((unsigned short *)
	 (type_of_arguments.block + type_of_arguments.current_size))[arg - n];
}

INLINE
static void add_to_mem_block(n, data, size)
    int n, size;
    char *data;
{
    struct mem_block *mbp = &mem_block[n];
    while (mbp->current_size + size > mbp->max_size) {
	mbp->max_size <<= 1;
	mbp->block = realloc((char *)mbp->block, mbp->max_size);
    }
    memcpy(mbp->block + mbp->current_size, data, size);
    mbp->current_size += size;
}

static void ins_byte(b)
    char b;
{
    add_to_mem_block(A_PROGRAM, &b, 1);
}

/*
 * Store a 2 byte number. It is stored in such a way as to be sure
 * that correct byte order is used, regardless of machine architecture.
 * Also beware that some machines can't write a word to odd addresses.
 */
static void ins_short(l)
    short l;
{
    add_to_mem_block(A_PROGRAM, (char *)&l + 0, 1);
    add_to_mem_block(A_PROGRAM, (char *)&l + 1, 1);
}

static void upd_short(offset, l)
    int offset;
    short l;
{
    mem_block[A_PROGRAM].block[offset + 0] = ((char *)&l)[0];
    mem_block[A_PROGRAM].block[offset + 1] = ((char *)&l)[1];
}

static short read_short(offset)
    int offset;
{
    short l;

    ((char *)&l)[0] = mem_block[A_PROGRAM].block[offset + 0];
    ((char *)&l)[1] = mem_block[A_PROGRAM].block[offset + 1];
    return l;
}

/*
 * Store a 4 byte number. It is stored in such a way as to be sure
 * that correct byte order is used, regardless of machine architecture.
 */
static void ins_long(l)
    int l;
{
    add_to_mem_block(A_PROGRAM, (char *)&l+0, 1);
    add_to_mem_block(A_PROGRAM, (char *)&l+1, 1);
    add_to_mem_block(A_PROGRAM, (char *)&l+2, 1);
    add_to_mem_block(A_PROGRAM, (char *)&l+3, 1);
}

static void ins_f_byte(b)
    unsigned int b;
{
    ins_byte((char)(b - F_OFFSET));
}

/*
 * Return the index of the function found, otherwise -1.
 */
static int defined_function(s)
    char *s;
{
    int offset;
    struct function *funp;

    for (offset = 0; offset < mem_block[A_FUNCTIONS].current_size;
	 offset += sizeof (struct function)) {
	funp = (struct function *)&mem_block[A_FUNCTIONS].block[offset];
	if (funp->flags & NAME_HIDDEN)
	    continue;
        if (strcmp(funp->name, s) == 0)
	    return offset / sizeof (struct function);
    }
    return -1;
}

/*
 * A mechanism to remember addresses on a stack. The size of the stack is
 * defined in config.h.
 */
static int comp_stackp;
static int comp_stack[COMPILER_STACK_SIZE];

static void push_address() {
    if (comp_stackp >= COMPILER_STACK_SIZE) {
	yyerror("Compiler stack overflow");
	comp_stackp++;
	return;
    }
    comp_stack[comp_stackp++] = mem_block[A_PROGRAM].current_size;
}

static void push_explicit(address)
    int address;
{
    if (comp_stackp >= COMPILER_STACK_SIZE) {
	yyerror("Compiler stack overflow");
	comp_stackp++;
	return;
    }
    comp_stack[comp_stackp++] = address;
}

static int pop_address() {
    if (comp_stackp == 0)
	fatal("Compiler stack underflow.\n");
    if (comp_stackp > COMPILER_STACK_SIZE) {
	--comp_stackp;
	return 0;
    }
    return comp_stack[--comp_stackp];
}

/*
 * Initialize the environment that the compiler needs.
 */
static void prolog() {
    int i;

    if (type_of_arguments.block == 0) {
	type_of_arguments.max_size = 100;
	type_of_arguments.block = xalloc(type_of_arguments.max_size);
    }
    type_of_arguments.current_size = 0;
    approved_object = 0;
    last_push_indexed = -1;
    last_push_local = -1;
    last_push_identifier = -1;
    prog = 0;		/* 0 means fail to load. */
    heart_beat = -1;
    comp_stackp = 0;	/* Local temp stack used by compiler */
    current_continue_address = 0;
    current_break_address = 0;
    num_parse_error = 0;
    free_all_local_names();	/* In case of earlier error */
    /* Initialize memory blocks where the result of the compilation
     * will be stored.
     */
    for (i=0; i < NUMAREAS; i++) {
	mem_block[i].block = xalloc(START_BLOCK_SIZE);
	mem_block[i].current_size = 0;
	mem_block[i].max_size = START_BLOCK_SIZE;
    }
}

/*
 * Patch a function definition of an inherited function, to what it really
 * should be.
 * The name of the function can be one of:
 *    object::name
 *    ::name
 *    name
 * Where 'object' is the name of the superclass.
 */
static void find_inherited(funp)
    struct function *funp;
{
    int i;
    struct inherit *ip;
    int num_inherits, super_length;
    char *real_name, *super_name = 0, *p;

    real_name = funp->name;
    if (real_name[0] == ':')
	real_name = real_name + 2;	/* There will be exactly two ':' */
    else if (p = strchr(real_name, ':')) {
	real_name = p+2;
	super_name = funp->name;
	super_length = real_name - super_name - 2;
    }
    num_inherits = mem_block[A_INHERITS].current_size /
	sizeof (struct inherit);
    ip = (struct inherit *)mem_block[A_INHERITS].block;
    for (; num_inherits > 0; ip++, num_inherits--) {
	if (super_name) {
	    int l = strlen(ip->prog->name);	/* Including .c */
	    if (l - 2 < super_length)
		continue;
	    if (strncmp(super_name, ip->prog->name + l - 2 - super_length,
			super_length) != 0)
		continue;
	}
	for (i=0; i < ip->prog->num_functions; i++) {
	    if (strcmp(ip->prog->functions[i].name, real_name) != 0)
		continue;
	    if (ip->prog->functions[i].flags & NAME_UNDEFINED)
		continue;
	    funp->offset = ip - (struct inherit *)mem_block[A_INHERITS].block;
	    funp->flags = ip->prog->functions[i].flags | NAME_INHERITED;
	    funp->num_local = ip->prog->functions[i].num_local;
	    funp->num_arg = ip->prog->functions[i].num_arg;
	    funp->type = ip->prog->functions[i].type;
	    funp->function_index_offset = i;
	    return;
	}
    }
    return;
}
/*
 * The program has been compiled. Prepare a 'struct program' to be returned.
 */
void epilog() {
    int size, i;
    char *p;
    struct function *funp;
    static int current_id_number = 1;

#ifdef DEBUG
    if (num_parse_error == 0 && type_of_arguments.current_size != 0)
	fatal("Failed to deallocate argument type stack\n");
#endif
    /*
     * If functions are undefined, replace them by definitions done
     * by inheritance. All explicit "name::func" are already resolved.
     */
    for (i = 0; i < mem_block[A_FUNCTIONS].current_size; i += sizeof *funp) {
	funp = (struct function *)(mem_block[A_FUNCTIONS].block + i);
	if (!(funp->flags & NAME_UNDEFINED) || funp->name == 0)
	    continue;
	find_inherited(funp);
    }
    if (num_parse_error > 0) {
	prog = 0;
	for (i=0; i<NUMAREAS; i++)
	    free(mem_block[i].block);
	return;
    }
    size = align(sizeof (struct program));
    for (i=0; i<NUMPAREAS; i++)
	size += align(mem_block[i].current_size);
    p = (char *)xalloc(size);
    prog = (struct program *)p;
    *prog = NULL_program;
    prog->total_size = size;
    prog->ref = 0;
    prog->heart_beat = heart_beat;
    prog->name = string_copy(current_file);
    prog->id_number = current_id_number++;
    total_prog_block_size += prog->total_size;
    total_num_prog_blocks += 1;

    p += align(sizeof (struct program));
    prog->program = p;
    if (mem_block[A_PROGRAM].current_size)
	memcpy(p, mem_block[A_PROGRAM].block,
	       mem_block[A_PROGRAM].current_size);
    prog->program_size = mem_block[A_PROGRAM].current_size;

    p += align(mem_block[A_PROGRAM].current_size);
    prog->line_numbers = (unsigned short *)p;
    if (mem_block[A_LINENUMBERS].current_size)
	memcpy(p, mem_block[A_LINENUMBERS].block,
	       mem_block[A_LINENUMBERS].current_size);

    p += align(mem_block[A_LINENUMBERS].current_size);
    prog->functions = (struct function *)p;
    prog->num_functions = mem_block[A_FUNCTIONS].current_size /
	sizeof (struct function);
    if (mem_block[A_FUNCTIONS].current_size)
	memcpy(p, mem_block[A_FUNCTIONS].block,
	       mem_block[A_FUNCTIONS].current_size);

    p += align(mem_block[A_FUNCTIONS].current_size);
    prog->strings = (char **)p;
    prog->num_strings = mem_block[A_STRINGS].current_size /
	sizeof (char *);
    if (mem_block[A_STRINGS].current_size)
	memcpy(p, mem_block[A_STRINGS].block,
	       mem_block[A_STRINGS].current_size);

    p += align(mem_block[A_STRINGS].current_size);
    prog->variable_names = (struct variable *)p;
    prog->num_variables = mem_block[A_VARIABLES].current_size /
	sizeof (struct variable);
    if (mem_block[A_VARIABLES].current_size)
	memcpy(p, mem_block[A_VARIABLES].block,
	       mem_block[A_VARIABLES].current_size);

    p += align(mem_block[A_VARIABLES].current_size);
    prog->inherit = (struct inherit *)p;
    prog->num_inherited = mem_block[A_INHERITS].current_size /
	sizeof (struct inherit);
    if (prog->num_inherited)
	memcpy(p, mem_block[A_INHERITS].block,
	       mem_block[A_INHERITS].current_size);
    
    prog->argument_types = 0;	/* For now. Will be fixed someday */

    prog->type_start = 0;
    for (i=0; i<NUMAREAS; i++)
        free((char *)mem_block[i].block);

    /*  marion
	Do referencing here - avoid multiple referencing when an object
	inherits more than one object and one of the inherited is already
	loaded and not the last inherited
    */
    reference_prog (prog, "epilog");
    for (i = 0; i < prog->num_inherited; i++) {
	reference_prog (prog->inherit[i].prog, "inheritance");
    }
}

static int define_new_function(name, num_arg, num_local, offset, flags, type)
    char *name;
    int num_arg, num_local;
    int offset, flags, type;
{
    int num;
    struct function fun;
    unsigned short argument_start_index;

    num = defined_function(name);
    if (num >= 0) {
	struct function *funp;

	/*
	 * The function was already defined. It may be one of several reasons:
	 *
	 * 1.	There has been a prototype.
	 * 2.	There was the same function defined by inheritance.
	 * 3.	This function has been called, but not yet defined.
	 * 4.	The function is double defined.
	 * 5.	A "late" prototype has been encountered.
	 */
	funp = (struct function *)(mem_block[A_FUNCTIONS].block) + num;
	if (!(funp->flags & NAME_UNDEFINED) &&
	    !(flags & NAME_PROTOTYPE) &&
	    !(funp->flags & NAME_INHERITED))
	{
	    char buff[500];
	    sprintf(buff, "Redeclaration of function %s.", name);
	    yyerror(buff);
	    return num;
	}
	/*
	 * It was either an undefined but used funtion, or an inherited
	 * function. In both cases, we now consider this to be THE new
	 * definition. It might also have been a prototype to an already
	 * defined function.
	 *
	 * Check arguments only when types are supposed to be tested,
	 * and if this function really has been defined already.
	 */
	if (exact_types && funp->type != TYPE_UNKNOWN) {
	    int i;
	    if (funp->num_arg != num_arg && !(funp->type & TYPE_MOD_VARARGS))
		yyerror("Incorrect number of arguments.");
	    else if (!(funp->flags & NAME_STRICT_TYPES))
		yyerror("Called function not compiled with type testing.\n");
	    else {
		/* Now check that argument types wasn't changed. */
		for (i=0; i < num_arg; i++) {
		}
	    }
	}
	/* If it was yet another prototype, then simply return. */
	if (flags & NAME_PROTOTYPE)
	    return num;
	funp->num_arg = num_arg;
	funp->num_local = num_local;
	funp->flags = flags;
	funp->offset = offset;
	funp->function_index_offset = 0;
	funp->type = type;
	if (exact_types)
	    funp->flags |= NAME_STRICT_TYPES;
	return num;
    }
    if (strcmp(name, "heart_beat") == 0)
	heart_beat = mem_block[A_FUNCTIONS].current_size /
	    sizeof (struct function);
    fun.name = make_shared_string(name);
    fun.offset = offset;
    fun.flags = flags;
    fun.num_arg = num_arg;
    fun.num_local = num_local;
    fun.function_index_offset = 0;
    fun.type = type;
    if (exact_types)
	fun.flags |= NAME_STRICT_TYPES;
    num = mem_block[A_FUNCTIONS].current_size / sizeof fun;
    /* Number of local variables will be updated later */
    add_to_mem_block(A_FUNCTIONS, (char *)&fun, sizeof fun);

    if (exact_types == 0 || num_arg == 0) {
	argument_start_index = INDEX_START_NONE;
    } else {
	int i;

	/*
	 * Save the start of argument types.
	 */
	argument_start_index =
	    mem_block[A_ARGUMENT_TYPES].current_size /
		sizeof (unsigned short);
	for (i=0; i < num_arg; i++) {
	    add_to_mem_block(A_ARGUMENT_TYPES, &type_of_locals[i],
			     sizeof type_of_locals[i]);
	}
    }
    add_to_mem_block(A_ARGUMENT_INDEX, &argument_start_index,
		     sizeof argument_start_index);
    return num;
}

static void define_variable(name, type, flags)
    char *name;
    int type;
    int flags;
{
    struct variable dummy;

    dummy.name = make_shared_string(name);
    dummy.type = type;
    dummy.flags = flags;
    add_to_mem_block(A_VARIABLES, (char *)&dummy, sizeof dummy);
}

short store_prog_string(str)
    char *str;
{
    short i;
    char **p;

    p = (char **) mem_block[A_STRINGS].block;
    str = make_shared_string(str);
    for (i=mem_block[A_STRINGS].current_size / sizeof str -1; i>=0; --i)
	if (p[i] == str)  {
	    free_string(str); /* Needed as string is only free'ed once. */
	    return i;
	}

    add_to_mem_block(A_STRINGS, &str, sizeof str);
    return mem_block[A_STRINGS].current_size / sizeof str - 1;
}

void add_to_case_heap(block_index,entry)
    int block_index;
    struct case_heap_entry *entry;
{
    char *heap_start;
    int offset,parent;
    int current_heap;

    if ( block_index == A_CASE_NUMBERS )
        current_heap = current_case_number_heap;
    else
        current_heap = current_case_string_heap;
    offset = mem_block[block_index].current_size - current_heap;
    add_to_mem_block(block_index, (char*)entry, sizeof(*entry) );
    heap_start = mem_block[block_index].block + current_heap;
    for ( ; offset; offset = parent ) {
        parent = ( offset - sizeof(struct case_heap_entry) ) >> 1 ;
        CASE_HEAP_ENTRY_ALIGN(parent);
        if ( ((struct case_heap_entry*)(heap_start+offset))->key <
             ((struct case_heap_entry*)(heap_start+parent))->key )
        {
            *(struct case_heap_entry*)(heap_start+offset) =
            *(struct case_heap_entry*)(heap_start+parent);
            *(struct case_heap_entry*)(heap_start+parent) = *entry;
        }
    }
}


# line 874 "lang.y"
typedef union 
{
	int number;
	unsigned int address;	/* Address of an instruction */
	char *string;
	short type;
	struct { int key; char block; } case_label;
	struct function *funp;
} YYSTYPE;
# define F_JUMP 257
# define F_JUMP_WHEN_ZERO 258
# define F_JUMP_WHEN_NON_ZERO 259
# define F_POP_VALUE 260
# define F_DUP 261
# define F_STORE 262
# define F_CALL_FUNCTION_BY_ADDRESS 263
# define F_PUSH_IDENTIFIER_LVALUE 264
# define F_PUSH_LOCAL_VARIABLE_LVALUE 265
# define F_PUSH_INDEXED_LVALUE 266
# define F_INDIRECT 267
# define F_INDEX_INSTR 268
# define F_CONST0 269
# define F_CONST1 270
# define F_IF 271
# define F_IDENTIFIER 272
# define F_LAND 273
# define F_LOR 274
# define F_STATUS 275
# define F_RETURN 276
# define F_STRING 277
# define F_INC 278
# define F_DEC 279
# define F_POST_INC 280
# define F_POST_DEC 281
# define F_COMMA 282
# define F_NUMBER 283
# define F_ASSIGN 284
# define F_INT 285
# define F_ADD 286
# define F_SUBTRACT 287
# define F_MULTIPLY 288
# define F_DIVIDE 289
# define F_LT 290
# define F_GT 291
# define F_EQ 292
# define F_GE 293
# define F_LE 294
# define F_NE 295
# define F_ADD_EQ 296
# define F_SUB_EQ 297
# define F_DIV_EQ 298
# define F_MULT_EQ 299
# define F_NEGATE 300
# define F_SUBSCRIPT 301
# define F_WHILE 302
# define F_BREAK 303
# define F_DO 304
# define F_FOR 305
# define F_SWITCH 306
# define F_SSCANF 307
# define F_PARSE_COMMAND 308
# define F_STRING_DECL 309
# define F_LOCAL_NAME 310
# define F_ELSE 311
# define F_DESCRIBE 312
# define F_CONTINUE 313
# define F_MOD 314
# define F_MOD_EQ 315
# define F_INHERIT 316
# define F_COLON_COLON 317
# define F_STATIC 318
# define F_ARROW 319
# define F_AGGREGATE 320
# define F_COMPL 321
# define F_AND 322
# define F_AND_EQ 323
# define F_OR 324
# define F_OR_EQ 325
# define F_XOR 326
# define F_XOR_EQ 327
# define F_LSH 328
# define F_LSH_EQ 329
# define F_RSH 330
# define F_RSH_EQ 331
# define F_CATCH 332
# define F_OBJECT 333
# define F_VOID 334
# define F_MIXED 335
# define F_PRIVATE 336
# define F_NO_MASK 337
# define F_NOT 338
# define F_PROTECTED 339
# define F_PUBLIC 340
# define F_VARARGS 341
# define F_ADD_ACTION 342
# define F_ADD_ATTRIBUTE 343
# define F_ADD_PROT_ATTRIBUTE 344
# define F_ADD_VERB 345
# define F_ADD_WORTH 346
# define F_ADD_XVERB 347
# define F_ALL_INVENTORY 348
# define F_ALLOCATE 349
# define F_ASSOC 350
# define F_ATOI 351
# define F_BREAK_POINT 352
# define F_CALL_OTHER 353
# define F_CALL_OUT 354
# define F_CALL_OUT_INFO 355
# define F_CALLER 356
# define F_CAPITALIZE 357
# define F_CAT 358
# define F_CHECK_REF 359
# define F_CINDENT 360
# define F_CLEAR_BIT 361
# define F_CLONE_OBJECT 362
# define F_COMMAND 363
# define F_CONTENTS 364
# define F_CP 365
# define F_CREATE_WIZARD 366
# define F_CREATOR 367
# define F_CRYPT 368
# define F_CTIME 369
# define F_DEBUG_INFO 370
# define F_DEEP_INVENTORY 371
# define F_DELETE_ATTRIBUTE 372
# define F_DELETEA 373
# define F_DESTRUCT 374
# define F_DISABLE_COMMANDS 375
# define F_ED 376
# define F_ENABLE_COMMANDS 377
# define F_ENVIRONMENT 378
# define F_EXEC 379
# define F_EXISTS 380
# define F_EXPLODE 381
# define F_EXTRACT 382
# define F_FILE_NAME 383
# define F_FILE_SIZE 384
# define F_FILES 385
# define F_FILTER_ARRAY 386
# define F_FIND_CALL_OUT 387
# define F_FIND_LIVING 388
# define F_FIND_OBJECT 389
# define F_FIND_PLAYER 390
# define F_FIRST_INVENTORY 391
# define F_FORMAT 392
# define F_FUNCTION_EXISTS 393
# define F_GET_ATTRIBUTE 394
# define F_GET_DIR 395
# define F_GRAB_FILE 396
# define F_IMPLODE 397
# define F_IN_EDITOR 398
# define F_INDEX 399
# define F_INPUT_TO 400
# define F_INSERT_ALIST 401
# define F_INTERACTIVE 402
# define F_INTERSECT_ALIST 403
# define F_INTP 404
# define F_LIVING 405
# define F_LOCALCMD 406
# define F_LOG_FILE 407
# define F_LOWER_CASE 408
# define F_LS 409
# define F_MAP_ARRAY 410
# define F_MEMBER_ARRAY 411
# define F_MEMUSED 412
# define F_MKDIR 413
# define F_MOVE_OBJECT 414
# define F_NEXT_INVENTORY 415
# define F_NOTIFY_FAIL 416
# define F_OBJECTP 417
# define F_ORDER_ALIST 418
# define F_PAD 419
# define F_POINTERP 420
# define F_PRESENT 421
# define F_PREVIOUS_OBJECT 422
# define F_PRINT 423
# define F_PROCESS_STRING 424
# define F_QUERY_ARG 425
# define F_QUERY_ATTRIBUTE 426
# define F_QUERY_HOST_NAME 427
# define F_QUERY_IDLE 428
# define F_QUERY_IP_NAME 429
# define F_QUERY_IP_NUMBER 430
# define F_QUERY_LOAD_AVERAGE 431
# define F_QUERY_SNOOP 432
# define F_QUERY_VERB 433
# define F_RANDOM 434
# define F_READ_BYTES 435
# define F_READ_FILE 436
# define F_REALLOCATE 437
# define F_REGEXP 438
# define F_REMOTE_COMMAND 439
# define F_REMOVE_CALL_OUT 440
# define F_REMOVE_INTERACTIVE 441
# define F_REMOVE_SHADOW 442
# define F_RENAME 443
# define F_RESTORE_OBJECT 444
# define F_RM 445
# define F_RMDIR 446
# define F_ROOT 447
# define F_SAVE_OBJECT 448
# define F_SAY 449
# define F_SEARCHA 450
# define F_SET_BIT 451
# define F_SET_HEART_BEAT 452
# define F_SET_LIGHT 453
# define F_SET_LIVING_NAME 454
# define F_SHADOW 455
# define F_SHOUT 456
# define F_SHUTDOWN 457
# define F_SIZEOF 458
# define F_SNOOP 459
# define F_SORT_ARRAY 460
# define F_STRINGP 461
# define F_STRLEN 462
# define F_SWAP 463
# define F_TAIL 464
# define F_TELL_OBJECT 465
# define F_TELL_ROOM 466
# define F_TEST_BIT 467
# define F_THIS_ARG 468
# define F_THIS_OBJECT 469
# define F_THIS_PLAYER 470
# define F_THIS_VERB 471
# define F_THROW 472
# define F_TIME 473
# define F_TRACE 474
# define F_TRACEPREFIX 475
# define F_TRANSFER 476
# define F_TYPEOF 477
# define F_UNIQUE_ARRAY 478
# define F_USERS 479
# define F_VERSION 480
# define F_WIZLIST 481
# define F_WRITE 482
# define F_WRITE_BYTES 483
# define F_WRITE_FILE 484
# define F_CASE 485
# define F_DEFAULT 486
# define F_RANGE 487
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 2146 "lang.y"


void yyerror(str)
char *str;
{
    extern int num_parse_error;

    if (num_parse_error > 5)
	return;
    (void)fprintf(stderr, "%s: %s line %d\n", current_file, str,
		  current_line);
    fflush(stderr);
    smart_log(current_file, current_line, str);
    if (num_parse_error == 0)
	save_error(str, current_file, current_line);
    num_parse_error++;
}

int check_declared(str)
    char *str;
{
    struct variable *vp;
    int offset;

    for (offset=0;
	 offset < mem_block[A_VARIABLES].current_size;
	 offset += sizeof (struct variable)) {
	vp = (struct variable *)&mem_block[A_VARIABLES].block[offset];
	if (vp->flags & NAME_HIDDEN)
	    continue;
	if (strcmp(vp->name, str) == 0)
	    return offset / sizeof (struct variable);
    }
    return -1;
}

static int verify_declared(str)
    char *str;
{
    int r;

    r = check_declared(str);
    if (r < 0) {
	char buff[100];
        (void)sprintf(buff, "Variable %s not declared !", str);
        yyerror(buff);
	return -1;
    }
    return r;
}

void free_all_local_names()
{
    int i;

    for (i=0; i<current_number_of_locals; i++) {
	free(local_names[i]);
	local_names[i] = 0;
    }
    current_number_of_locals = 0;
    current_break_stack_need = 0;
    max_break_stack_need = 0;
}

void add_local_name(str, type)
    char *str;
    int type;
{
    if (current_number_of_locals == MAX_LOCAL)
	yyerror("Too many local variables\n");
    else {
	type_of_locals[current_number_of_locals] = type;
	local_names[current_number_of_locals++] = str;
    }
}

/*
 * Copy all function definitions from an inherited object. They are added
 * as undefined, so that they can be redefined by a local definition.
 * If they are not redefined, then they will be updated, so that they
 * point to the inherited definition. See epilog(). Types will be copied
 * at that moment (if available).
 */
static void copy_functions(from, type)
    struct program *from;
    int type;
{
    int i;
    unsigned short tmp_short;

    for (i=0; i < from->num_functions; i++) {
	/* Don't call define_new_function() from here, as duplicates would
	 * be removed.
	 */
	struct function fun;
	fun = from->functions[i];	/* Make a copy */
	/* Prepare some data to be used if this function will not be
	 * redefined.
	 */
	if (strchr(fun.name, ':'))
	    fun.flags |= NAME_HIDDEN;	/* Not to be used again ! */
	fun.name = make_shared_string(fun.name);	/* Incr ref count */
	fun.offset = mem_block[A_INHERITS].current_size /
	    sizeof (struct inherit) - 1;
	fun.function_index_offset = i;
	if (fun.type & TYPE_MOD_NO_MASK) {
	    int n;
	    if ((n = defined_function(fun.name)) != -1 &&
		!(((struct function *)mem_block[A_FUNCTIONS].block)[n].flags &
		  NAME_UNDEFINED))
	    {
		char *p = (char *)alloca(80 + strlen(fun.name));
		sprintf(p, "Illegal to redefine 'nomask' function \"%s\"\n",
			fun.name);
		yyerror(p);
	    }
	    fun.flags |= NAME_INHERITED;
	} else if (!(fun.flags & NAME_HIDDEN)) {
	    fun.flags |= NAME_UNDEFINED;
	}
	fun.type |= type;
	/* marion
	 * this should make possible to inherit a heart beat function, and
	 * thus to mask it if wanted.
	 */
	if ((heart_beat == -1) && (strcmp(fun.name, "heart_beat") == 0))
	    heart_beat = mem_block[A_FUNCTIONS].current_size /
		sizeof (struct function);
	add_to_mem_block(A_FUNCTIONS, (char *)&fun, sizeof fun);
	/*
	 * Copy information about the types of the arguments, if it is
	 * available.
	 */
	tmp_short = INDEX_START_NONE;	/* Presume not available. */
	if (from->type_start != 0 && from->type_start[i] != INDEX_START_NONE) {
	    int arg;
	    /*
	     * They are available for function number 'i'. Copy types of
	     * all arguments, and remember where they started.
	     */
	    tmp_short = mem_block[A_ARGUMENT_TYPES].current_size /
		sizeof from->argument_types[0];
	    for (arg = 0; arg < fun.num_arg; arg++) {
		add_to_mem_block(A_ARGUMENT_TYPES,
				 &from->argument_types[from->type_start[i]],
				 sizeof (unsigned short));
	    }
	}
	/*
	 * Save the index where they started. Every function will have an
	 * index where the type info of arguments starts.
	 */
	add_to_mem_block(A_ARGUMENT_INDEX, &tmp_short, sizeof tmp_short);
    }
}

/*
 * Copy all variabel names from the object that is inherited from.
 * It is very important that they are stored in the same order with the
 * same index.
 */
static void copy_variables(from, type)
    struct program *from;
    int type;
{
    int i;

    for (i=0; i<from->num_variables; i++) {
	define_variable(from->variable_names[i].name,
			from->variable_names[i].type | type,
			from->variable_names[i].type & TYPE_MOD_PRIVATE ?
			    NAME_HIDDEN : 0);
    }
}

/*
 * This function is called from lex.c for every new line read from the
 * "top" file (means not included files). Some new lines are missed,
 * as with #include statements, so it is compensated for.
 */
void store_line_number_info()
{
    unsigned short offset = mem_block[A_PROGRAM].current_size;

    while(mem_block[A_LINENUMBERS].current_size / sizeof (short) <
	  current_line)
    {
	add_to_mem_block(A_LINENUMBERS, (char *)&offset, sizeof offset);
    }
}

static char *get_type_name(type)
    int type;
{
    static char buff[100];
    static char *type_name[] = { "unknown", "int", "string",
				     "void", "object", "mixed", };
    int pointer = 0;

    buff[0] = 0;
    if (type & TYPE_MOD_STATIC)
	strcat(buff, "static ");
    if (type & TYPE_MOD_NO_MASK)
	strcat(buff, "nomask ");
    if (type & TYPE_MOD_PRIVATE)
	strcat(buff, "private ");
    if (type & TYPE_MOD_PROTECTED)
	strcat(buff, "protected ");
    if (type & TYPE_MOD_PUBLIC)
	strcat(buff, "public ");
    if (type & TYPE_MOD_VARARGS)
	strcat(buff, "varargs ");
    type &= TYPE_MOD_MASK;
    if (type & TYPE_MOD_POINTER) {
	pointer = 1;
	type &= ~TYPE_MOD_POINTER;
    }
    if (type >= sizeof type_name / sizeof type_name[0])
	fatal("Bad type\n");
    strcat(buff, type_name[type]);
    strcat(buff," ");
    if (pointer)
	strcat(buff, "* ");
    return buff;
}

void type_error(str, type)
    char *str;
    int type;
{
    static char buff[100];
    char *p;
    p = get_type_name(type);
    if (strlen(str) + strlen(p) + 5 >= sizeof buff) {
	yyerror(str);
    } else {
	strcpy(buff, str);
	strcat(buff, ": \"");
	strcat(buff, p);
	strcat(buff, "\"");
	yyerror(buff);
    }
}

/*
 * Compile an LPC file.
 */
void compile_file() {
    int yyparse();

    prolog();
    yyparse();
    epilog();
}

static char *get_two_types(type1, type2)
    int type1, type2;
{
    static char buff[100];

    strcpy(buff, "( ");
    strcat(buff, get_type_name(type1));
    strcat(buff, "vs ");
    strcat(buff, get_type_name(type2));
    strcat(buff, ")");
    return buff;
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 1,
	-2, 29,
-1, 30,
	40, 12,
	-2, 43,
-1, 38,
	41, 19,
	-2, 29,
-1, 56,
	304, 69,
	125, 50,
	-2, 66,
-1, 59,
	304, 69,
	125, 50,
	-2, 66,
-1, 75,
	304, 69,
	-2, 66,
-1, 87,
	40, 211,
	-2, 199,
-1, 148,
	304, 69,
	-2, 66,
-1, 171,
	44, 116,
	-2, 137,
-1, 209,
	319, 185,
	91, 185,
	-2, 176,
-1, 211,
	319, 185,
	91, 185,
	-2, 177,
-1, 285,
	304, 69,
	-2, 66,
-1, 289,
	44, 116,
	-2, 77,
-1, 328,
	304, 69,
	-2, 66,
-1, 339,
	304, 69,
	-2, 66,
-1, 355,
	41, 197,
	-2, 185,
-1, 365,
	304, 69,
	-2, 66,
	};
# define YYNPROD 219
# define YYLAST 725
short yyact[]={

  94, 313, 225,  59, 288, 121,   9, 165,  23, 237,
 254, 238, 167,  89, 346, 177,  23, 165,  24,  71,
 178,  83, 167, 258,  10,   8,  24,  13,  11,  12,
 285, 199,  61, 200,  18, 148, 287, 147, 231, 247,
 246, 232,  25,  94, 245, 173, 174, 294, 121,  20,
  25, 235,  33, 233, 185, 106, 180, 251, 217, 191,
  51,  39,  71,  30, 151,  90,  26,  27,  28, 158,
 107, 123,  86, 154,  26,  27,  28,  99, 108, 145,
 125, 162, 317,  55, 309,  16, 120,  94, 156, 152,
 105, 122, 121, 169, 227, 228,  54,  22, 190, 344,
 128, 176,  57, 169, 358, 357,  71, 327, 215, 144,
 161, 143, 142,  36, 140, 171,  37,  31,  15, 343,
 329, 170,  70, 242,  47, 204,  55, 182, 241, 120,
 203, 210, 210, 243,  42, 205, 347, 239, 163, 240,
 201, 229, 202, 159, 348, 323, 322, 318, 219, 216,
 218,  46, 222,  32,  58,  18, 364, 362, 354, 208,
  55, 353, 126, 350, 336, 335, 333, 227, 325, 316,
  55, 160,  53, 120, 310, 290, 257,  45,  74, 332,
 326,  50, 264, 224, 112, 172, 263, 221, 189, 188,
 175, 150, 181, 149,  38, 230, 192,  17,  44, 111,
 284,   6,  43, 184, 220,   4,  29,  75, 249, 314,
 186, 252, 187,  97,  96,  95,  60, 261,  84, 255,
 330, 250, 141, 328, 365, 361, 341, 223,  94,  77,
  35,  85,  87, 121, 339,  23,  82, 100, 117, 118,
  76, 182,  69, 101, 157,  24, 129,  68, 179,  67,
 166,  66,  65,  64, 286, 244, 289, 253,  63, 146,
 166, 267, 256,  72,  62,  78,  79, 103, 104,  25,
  88, 268, 311,  73,  85,  87, 262, 106, 124,  82,
 100, 117, 118,  56, 234, 236, 101, 320, 282, 324,
  19, 291, 102,  26,  27,  28,  49, 321, 119, 129,
 295, 292,  48,  60,  34, 168,  72,  94,  78,  79,
 103, 104, 121,  88, 120, 168,  73, 293,  85,  87,
 106, 304, 305,  82, 100, 117, 118, 319, 315,   5,
 101,  14, 342,   3, 207, 102, 209, 211, 207, 207,
 207, 119,   2, 349,   1, 331, 351, 207, 302, 303,
  72, 248,  78,  79, 103, 104, 345,  88,  93, 340,
  73, 210, 260, 116, 106, 352, 363, 265, 266, 366,
 359, 360,  94, 109, 289, 296, 297, 121,  98, 102,
 306, 307, 308, 113,  94, 119, 277, 278, 115, 121,
 183,  87, 208, 120, 289, 312, 100, 121, 283, 275,
 276,  92, 101,  91, 207, 298, 299, 300, 301, 207,
 153, 207, 207, 207, 207, 207, 207, 207, 207, 207,
 207, 207, 207, 207, 207, 155, 103, 104,  41,  88,
  52, 226,  21,   7, 259, 127, 106, 129,  40, 164,
   0,   0, 260,   0, 146,  80,  81,   0,   0, 110,
   0, 102,   0,   0, 197, 183, 195,   0, 120,   0,
  87,   0,   0, 173, 174, 100, 117, 118,   0, 207,
 120, 101,   0, 114, 207,   0,   0,   0, 120,   0,
 207, 135, 136, 139, 137,   0,   0,   0,  80,  81,
   0,   0,   0,   0,   0, 103, 104, 334,  88,   0,
 138, 337, 338,   0,   0, 106,   0,   0, 130,   0,
 131, 260, 132,   0, 133,   0, 134,   0,   0,   0,
 102,   0,   0, 146,   0,   0, 119, 356,   0,   0,
   0,   0,  80,  81, 135, 136, 139, 137,   0,  87,
   0,   0,  23,   0, 100, 117, 118,   0,   0,   0,
 101,   0,  24, 138,   0,   0,   0,   0,   0,   0,
   0, 130, 207, 131,   0, 132, 355, 133,   0, 134,
   0,   0,   0,   0, 103, 104,  25,  88,   0,   0,
   0,   0,   0,   0, 106,   0,   0,   0, 146, 206,
   0,   0,   0, 212, 213, 214,   0,   0,   0, 102,
  26,  27,  28,   0,  87, 119,   0,   0,   0, 100,
 117, 118,   0,   0,   0, 101,  87,   0,   0,   0,
   0, 100, 117, 118,  87,   0,   0, 101,   0, 100,
 117, 118,   0,   0,   0, 101,   0,   0,   0, 103,
 104,   0,  88, 269, 270, 271, 272, 273, 274, 106,
   0, 103, 104,   0,  88,   0,   0,   0,   0, 103,
 104, 106,  88,   0, 102,   0,   0,   0,   0, 106,
 119,   0, 135, 136, 139, 137, 102, 279, 280, 281,
   0,   0, 119,   0, 102,   0, 193, 196, 198, 194,
 119, 138,   0,   0,   0,   0,   0,   0,   0, 130,
   0, 131,   0, 132,   0, 133,   0, 134,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 199,   0, 200 };
short yypact[]={

-1000,-1000,-312,  59, 113,-1000,-267,-312,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-209,  58,-1000, 109,
-225,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000, 113,  57, 154,-1000,-211,-1000,-312,-1000,
 136, 107,-1000,  -8,-259,-1000,-312,-212,-1000,  37,
-1000,-1000,-1000,-1000,-1000,-1000, -40, -34, 113,  47,
 376,  55,-1000,-1000,-1000,-1000,-1000,-1000,-1000,  53,
-1000,-1000,  52,  50,-1000,   3,-265,-269, 153, 151,
 -33,  63, 188,-1000, 185, 150,  38,-302,-1000, -71,
-218,-1000,-1000,-1000, 267,-1000,-1000,-1000, -70,-1000,
-1000,-1000,-1000, 149, 148,   4,-213, 158,-1000,-1000,
 394,  97,  88,-1000,-1000, 352,-1000, 119, 119, 352,
 352, 352,-1000,  49, 105,-214,-1000,-1000, 344,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000, 104,-1000,-1000,-1000,-1000, 238, 147,   3,-1000,
 188, -56, -30,-1000,   1,  98, 157,-1000,-254,  -9,
-319,  94,  86,-1000,-1000, -23,-1000,-239,-243,-244,
-1000,-1000, 188,-1000,-1000, 188,-1000,-215, 188,-262,
-1000, 113, 135, 188,-1000, 344, 146, 142, 188, 188,
 344,-1000, 344, 344, 344, 344, 344, 344, 344, 344,
 344, 344, 344, 352, 352, 352,-1000,-233, 332,-1000,
 -71,-1000,-1000,-1000,-1000,-1000, 113,-1000,-1000, 188,
-281, 188,-266, 188, 134,-1000, -33, -23, -23,-230,
 -23, -23, -23, -23, -23, -23, -23, -23, -23, -23,
 -23, -23, -23, -23,  43,-1000,-1000,-1000,-1000, 133,
 344,-1000, -92,-1000,-302, 344, 128,-1000, -43, 103,
-1000, 344,   4, 188, 188, 102, 101, 158,-1000,-297,
-297,-297,-297,-297,-297,  97,  97,  88,  88,-1000,
-1000,-1000,-1000,-1000,-1000,   3, 127, 140,  48,-1000,
-1000,  62,   1, 157,-1000,-254,  -9,  -9,-319,-319,
-319,-319,  94,  94,  86,  86,-1000,-1000,-1000,-1000,
-1000,-1000, 188,-1000, 139,-1000,-1000, 125, 188,-1000,
 124, 123, 188, 188,-1000,-1000, 188,-1000,   3,-1000,
  61,   6, 188,-1000,-1000,-1000,-1000,  92, 100,   3,
 122, 188,-1000, 344,-1000, 120, 117, 119, 188,-1000,
  46,  45,-1000,-1000,-1000,  92,  92,-1000,-1000,-1000,
 116, 188,-1000, 115,-1000,   3,-1000 };
short yypgo[]={

   0, 100,  89,  23,  73,  88,  69, 143, 171, 110,
  81, 138, 439,  14, 438, 202,  97,  80, 434, 433,
 198, 432, 430, 428, 425, 410,  77,  64, 403, 218,
 401, 388, 383,  21,  32,  65, 378,  72,  90,  70,
 449,  78, 373, 199, 184, 473, 363,  13, 358, 178,
 344, 342, 333, 331, 329, 122, 304, 296, 197, 134,
 290, 283, 102,  71, 278,   3, 264, 258, 253, 252,
 251, 249, 247, 242, 240, 234, 229, 227,   4, 226,
 225, 224, 223, 222, 221, 220, 219, 217, 215, 214,
 213, 212, 210, 209, 207, 204, 200 };
short yyr1[]={

   0,  50,  51,  51,  53,  53,  54,  48,  17,  17,
  22,  22,  56,  57,  52,  52,  52,  59,  59,  14,
  14,  23,  23,  19,  19,  19,  19,  19,  19,  20,
  20,  15,  31,  21,  21,  16,  16,  16,  16,  16,
  16,  58,  58,  60,  55,  61,  61,  64,  63,  63,
  62,  62,  62,  65,  65,  65,  65,  65,  65,  65,
  65,  65,  65,  65,  65,  65,  74,  75,  67,  76,
  68,  77,  79,  80,  81,  69,  78,  78,  82,  70,
  71,  71,  27,  27,   2,   2,   4,   4,   5,   5,
   6,   6,   6,   7,   7,   7,   7,   7,   8,   8,
   8,   9,   9,   9,  10,  10,  10,  10,  11,  11,
  12,  12,  12,  12,  72,  34,  83,  34,  49,  49,
  49,  33,  84,  85,  33,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,  73,  73,   3,   3,
   3,  18,  18,  37,  86,  37,  35,  87,  35,  36,
  36,  38,  38,  39,  39,  41,  41,  41,  42,  42,
  42,  42,  42,  40,  40,  40,  43,  43,  43,  44,
  44,  44,  44,  32,  32,  45,  45,  45,  45,  45,
  45,  46,  46,  46,  47,  47,  47,  47,  47,  47,
  47,  47,  47,  91,  88,  89,  90,  13,  13,  29,
  29,  29,  29,  30,  25,  24,  24,  92,  28,  93,
  28,  26,  26,  26,  95,  66,  94,  96,  96 };
short yyr2[]={

   0,   1,   3,   0,   0,   1,   4,   1,   0,   1,
   1,   1,   0,   0,   9,   3,   1,   3,   2,   0,
   1,   1,   3,   1,   1,   1,   1,   1,   1,   0,
   2,   2,   4,   1,   0,   1,   1,   1,   1,   1,
   1,   1,   3,   2,   4,   0,   4,   2,   1,   3,
   0,   2,   2,   2,   1,   1,   1,   1,   1,   1,
   1,   2,   1,   1,   2,   2,   0,   0,   7,   0,
   8,   0,   0,   0,   0,  13,   0,   1,   0,   6,
   3,   5,   1,   1,   1,   3,   1,   3,   1,   3,
   1,   3,   3,   1,   3,   3,   3,   3,   1,   3,
   3,   1,   3,   3,   1,   3,   3,   3,   1,   3,
   1,   2,   2,   2,   2,   1,   0,   4,   1,   3,
   3,   1,   0,   0,   7,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   2,   0,   1,
   2,   1,   3,   1,   0,   4,   1,   0,   4,   1,
   3,   1,   3,   1,   3,   1,   3,   3,   1,   3,
   3,   3,   3,   1,   3,   3,   1,   3,   3,   1,
   3,   3,   3,   1,   2,   1,   2,   2,   2,   2,
   2,   1,   2,   2,   1,   1,   1,   1,   3,   1,
   1,   1,   5,   0,   5,   7,   9,   0,   3,   1,
   1,   6,   4,   1,   1,   1,   3,   0,   5,   0,
   7,   1,   2,   3,   0,   4,   4,   0,   2 };
short yychk[]={

-1000, -50, -51, -52, -15, -54, -20, -19, 337, 318,
 336, 340, 341, 339, -53,  59, -17, -58,  42, -60,
 316, -21, -16, 275, 285, 309, 333, 334, 335, -20,
 272,  59,  44, 277, -56, -58, -17,  59,  40, 272,
 -14, -23, -59, -15, -20,  41,  44, -17, 310, -57,
 -59, 272, -22, -55,  59, 123, -61, -62, -16, -65,
 256, -34, -66, -67, -68, -69, -70, -71, -72, -73,
 -55,  59, 303, 313, -49, -94, -74, -76, 305, 306,
 485, 486, 276, -33, -29, 271, -37, 272, 310, -47,
 -35, -28, -30, -48,  40, -88, -89, -90, -36, -26,
 277, 283, 332, 307, 308, -38, 317, -39, -41, -42,
 -40, -43, -44, -32, -45, -31, -46, 278, 279, 338,
 126,  45, 125, -63, -64, -17, -62,  59,  -1,  61,
 323, 325, 327, 329, 331, 296, 297, 299, 315, 298,
  59, -83,  59,  59,  59, -65, 256, 302, 304,  40,
  40, -27,  -2, -25,  -4, -24,  -5, 277,  -6,  -7,
  -8,  -9, -10, -11, -12,  40, 283,  45, 338, 126,
  58, -34,  -1, 278, 279,  40,  63, 317,  91, 319,
 274, -16, -34, 123, 273, 124, -92, -91,  40,  40,
  94, 272,  38, 292, 295,  62, 293,  60, 294, 328,
 330,  43,  45,  42,  37,  47, -45, -29,  40, -29,
 -47, -29, -45, -45, -45,  59,  44, 272, -33,  44,
 -95,  40, -65, -77, -34,  58, 487, 124,  94,  43,
  38, 292, 295,  62, 293,  60, 294, 328, 330,  43,
  45,  42,  37,  47,  -2, 283, 283, 283, -49, -34,
 -84, 272, -34, -26, 272, -86, -17,  41,  -3, -18,
 -49, -87, -38,  40,  40, -49, -49, -39, -41, -40,
 -40, -40, -40, -40, -40, -43, -43, -44, -44, -45,
 -45, -45, -63, -49, -96, 311, -34, 302, -78, -34,
  41, -27,  -4,  -5, 277,  -6,  -7,  -7,  -8,  -8,
  -8,  -8,  -9,  -9, -10, -10, -11, -11, -11,  41,
  41, -33, 487,  93, -93, -37,  41, 125,  44, -35,
  -3, -34,  44,  44, -65,  41,  40,  59, -82,  58,
 -85, -34,  40,  41, -49,  41,  41, -49, -49, -75,
 -34, -79, -65,  58,  93,  -3, -13,  44,  44, -65,
  41, -78, -33,  41,  41, -29, -49,  59,  59, -13,
 -13, -80,  41, -78,  41, -81, -65 };
short yydef[]={

   3,  -2,  -2,   4,   8,  16,  34,  29,  23,  24,
  25,  26,  27,  28,   2,   5,   0,   0,   9,  41,
   0,  31,  33,  35,  36,  37,  38,  39,  40,  30,
  -2,  15,   8,   0,   0,  42,   0,   6,  -2,  43,
   0,  20,  21,   8,  34,  13,  29,   0,  18,   0,
  22,  17,  14,  10,  11,  45,  -2,   0,   8,  -2,
   0, 116,  54,  55,  56,  57,  58,  59,  60,   0,
  62,  63,   0,   0, 115,  -2,   0,   0,   0,   0,
   0,   0, 136, 118, 185,   0, 121,  -2, 200, 181,
 143, 184, 186, 187,   0, 189, 190, 191, 146, 207,
 203,   7, 193,   0,   0, 149,   0, 151, 153, 155,
 158, 163, 166, 169, 173,   0, 175,   0,   0,   0,
   0,   0,  44,   0,  48,   0,  51,  52,   0, 125,
 126, 127, 128, 129, 130, 131, 132, 133, 134, 135,
  53,   0,  61,  64,  65, 214,   0,   0,  -2,  71,
   0,   0,  82,  83,  84, 204,  86, 205,  88,  90,
  93,  98, 101, 104, 108,   0, 110,   0,   0,   0,
 114,  -2,   0, 182, 183,   0, 122,   0,   0,   0,
 144,   8, 116, 138, 147,   0,   0,   0,   0,   0,
   0, 212,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 174, 185,   0,  -2,
   0,  -2, 178, 179, 180,  46,   8,  47, 120,   0,
 217,   0,   0,  76, 116,  80,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 111, 112, 113, 119, 116,
   0, 213, 116, 209, 211,   0,   0, 188,   0, 139,
 141,   0, 150, 138,   0,   0,   0, 152, 154, 156,
 157, 159, 160, 161, 162, 164, 165, 167, 168, 170,
 171, 172,  49, 117, 215,  -2, 116,   0,   0,  -2,
  78,   0,  85,  87, 206,  89,  91,  92,  94,  95,
  96,  97,  99, 100, 102, 103, 105, 106, 107, 109,
 216, 123,   0, 202,   0, 145,  32,   0, 140, 148,
   0, 116,   0,   0, 218,  67,   0,  72,  -2,  81,
   0, 116, 138, 192, 142, 208, 194, 197,   0,  -2,
 116,  76,  79,   0, 201,   0,   0,   0,   0,  68,
   0,   0, 124, 210, 195,  -2, 197,  70,  73, 198,
   0,  76, 196,   0,  74,  -2,  75 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif /* not lint */

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 5:
# line 906 "lang.y"
{ yyerror("Extra ';'. Ignored."); } break;
case 6:
# line 909 "lang.y"
{
		    struct object *ob;
		    struct inherit inherit;

		    ob = find_object2(yypvt[-1].string);
		    if (ob == 0) {
			inherit_file = yypvt[-1].string;
			/* Return back to load_object() */
			YYACCEPT;
		    }
		    free(yypvt[-1].string);
		    if (ob->flags & O_APPROVED)
			approved_object = 1;
		    inherit.prog = ob->prog;
		    inherit.function_index_offset =
			mem_block[A_FUNCTIONS].current_size /
			    sizeof (struct function);
		    inherit.variable_index_offset =
			mem_block[A_VARIABLES].current_size /
			    sizeof (struct variable);
		    add_to_mem_block(A_INHERITS, &inherit, sizeof inherit);
		    copy_variables(ob->prog, yypvt[-3].number);
		    copy_functions(ob->prog, yypvt[-3].number);
		} break;
case 7:
# line 935 "lang.y"
{
	    if ( yypvt[-0].number == 0 ) {
		ins_f_byte(F_CONST0); yyval.type = TYPE_ANY;
	    } else if ( yypvt[-0].number == 1 ) {
		ins_f_byte(F_CONST1); yyval.type = TYPE_NUMBER;
	    } else {
		ins_f_byte(F_NUMBER); ins_long(yypvt[-0].number); yyval.type = TYPE_NUMBER;
	    }
	} break;
case 8:
# line 945 "lang.y"
{ yyval.number = 0; } break;
case 9:
# line 945 "lang.y"
{ yyval.number = TYPE_MOD_POINTER; } break;
case 10:
# line 947 "lang.y"
{ yyval.number = 0; } break;
case 11:
# line 947 "lang.y"
{ yyval.number = ';'; } break;
case 12:
# line 950 "lang.y"
{
	    /* Save start of function. */
	    push_explicit(mem_block[A_PROGRAM].current_size);

	    if (yypvt[-2].number & TYPE_MOD_MASK) {
		exact_types = yypvt[-2].number | yypvt[-1].number;
	    } else {
		if (pragma_strict_types)
		    yyerror("\"#pragma strict_types\" requires type of function");
		exact_types = 0;
	    }
	} break;
case 13:
# line 963 "lang.y"
{
	    /*
	     * Define a prototype. If it is a real function, then the
	     * prototype will be replaced below.
	     */
	    define_new_function(yypvt[-4].string, yypvt[-1].number, 0, 0,
				NAME_UNDEFINED|NAME_PROTOTYPE, yypvt[-6].number | yypvt[-5].number);
	} break;
case 14:
# line 972 "lang.y"
{
	    /* Either a prototype or a block */
	    if (yypvt[-0].number == ';') {
		(void)pop_address(); /* Not used here */
	    } else {
                int num_locals = 0;
                if (!max_break_stack_need)
                   num_locals = current_number_of_locals - yypvt[-3].number + 1;
                else
                   num_locals = current_number_of_locals - yypvt[-3].number +
                        (max_break_stack_need - 1) / sizeof(struct svalue) + 1;
 
		define_new_function(yypvt[-6].string, yypvt[-3].number, num_locals,
			pop_address(), 0, yypvt[-8].number | yypvt[-7].number);
		ins_f_byte(F_CONST0); ins_f_byte(F_RETURN);
	    }
	    free_all_local_names();
	    free(yypvt[-6].string);		/* Value was copied above */
	} break;
case 15:
# line 991 "lang.y"
{ if (yypvt[-2].number == 0) yyerror("Missing type"); } break;
case 17:
# line 995 "lang.y"
{
	    if (exact_types && yypvt[-2].number == 0) {
		yyerror("Missing type for argument");
		add_local_name(yypvt[-0].string, TYPE_ANY);	/* Supress more errors */
	    } else {
		add_local_name(yypvt[-0].string, yypvt[-2].number | yypvt[-1].number);
	    }
	} break;
case 18:
# line 1004 "lang.y"
{yyerror("Illegal to redeclare local name"); } break;
case 19:
# line 1006 "lang.y"
{ yyval.number = 0; } break;
case 21:
# line 1009 "lang.y"
{ yyval.number = 1; } break;
case 22:
# line 1010 "lang.y"
{ yyval.number = yypvt[-2].number + 1; } break;
case 23:
# line 1012 "lang.y"
{ yyval.number = TYPE_MOD_NO_MASK; } break;
case 24:
# line 1013 "lang.y"
{ yyval.number = TYPE_MOD_STATIC; } break;
case 25:
# line 1014 "lang.y"
{ yyval.number = TYPE_MOD_PRIVATE; } break;
case 26:
# line 1015 "lang.y"
{ yyval.number = TYPE_MOD_PUBLIC; } break;
case 27:
# line 1016 "lang.y"
{ yyval.number = TYPE_MOD_VARARGS; } break;
case 28:
# line 1017 "lang.y"
{ yyval.number = TYPE_MOD_PROTECTED; } break;
case 29:
# line 1019 "lang.y"
{ yyval.number = 0; } break;
case 30:
# line 1020 "lang.y"
{ yyval.number = yypvt[-1].number | yypvt[-0].number; } break;
case 31:
# line 1022 "lang.y"
{ yyval.number = yypvt[-1].number | yypvt[-0].number; current_type = yyval.number; } break;
case 32:
# line 1025 "lang.y"
{
	    yyval.type = yypvt[-2].number | yypvt[-1].number;
	} break;
case 34:
# line 1029 "lang.y"
{ yyval.number = TYPE_UNKNOWN; } break;
case 35:
# line 1031 "lang.y"
{ yyval.number = TYPE_NUMBER; current_type = yyval.number; } break;
case 36:
# line 1032 "lang.y"
{ yyval.number = TYPE_NUMBER; current_type = yyval.number; } break;
case 37:
# line 1033 "lang.y"
{ yyval.number = TYPE_STRING; current_type = yyval.number; } break;
case 38:
# line 1034 "lang.y"
{ yyval.number = TYPE_OBJECT; current_type = yyval.number; } break;
case 39:
# line 1035 "lang.y"
{yyval.number = TYPE_VOID; current_type = yyval.number; } break;
case 40:
# line 1036 "lang.y"
{ yyval.number = TYPE_ANY; current_type = yyval.number; } break;
case 43:
# line 1042 "lang.y"
{
	    define_variable(yypvt[-0].string, current_type | yypvt[-1].number, 0);
	    free(yypvt[-0].string);
	} break;
case 44:
# line 1048 "lang.y"
{ ; } break;
case 47:
# line 1054 "lang.y"
{
	    add_local_name(yypvt[-0].string, current_type | yypvt[-1].number);
	} break;
case 53:
# line 1066 "lang.y"
{
	    ins_f_byte(F_POP_VALUE);
	    if (d_flag)
		ins_f_byte(F_BREAK_POINT);
	    /* if (exact_types && !TYPE($1,TYPE_VOID))
		yyerror("Value thrown away"); */
	} break;
case 64:
# line 1077 "lang.y"
{
		    if (current_break_address == 0)
			yyerror("break statement outside loop");
		    if (current_break_address & BREAK_ON_STACK) {
			ins_f_byte(F_BREAK);
		    } else {
		        ins_f_byte(F_JUMP); ins_short(current_break_address);
		    }
		} break;
case 65:
# line 1087 "lang.y"
{
		    if (current_continue_address == 0)
			yyerror("continue statement outside loop");
		    ins_f_byte(F_JUMP); ins_short(current_continue_address);
		} break;
case 66:
# line 1094 "lang.y"
{   push_explicit(current_continue_address);
	    push_explicit(current_break_address);
	    current_continue_address = mem_block[A_PROGRAM].current_size;
	} break;
case 67:
# line 1098 "lang.y"
{
	    ins_f_byte(F_JUMP_WHEN_NON_ZERO); ins_short(0);	/* to block */
	    current_break_address = mem_block[A_PROGRAM].current_size;
	    ins_f_byte(F_JUMP); ins_short(0);	/* Exit loop */
	    upd_short(current_break_address-2,
		      mem_block[A_PROGRAM].current_size);
	} break;
case 68:
# line 1106 "lang.y"
{
	  ins_f_byte(F_JUMP); ins_short(current_continue_address);
	  upd_short(current_break_address+1,
		    mem_block[A_PROGRAM].current_size);
	  current_break_address = pop_address();
	  current_continue_address = pop_address();
        } break;
case 69:
# line 1114 "lang.y"
{
        int tmp_save;
        push_explicit(current_continue_address);
	push_explicit(current_break_address);
	/* Jump to start of loop. */
	ins_f_byte(F_JUMP); tmp_save = mem_block[A_PROGRAM].current_size;
	ins_short(0);
	current_break_address = mem_block[A_PROGRAM].current_size;
	/* Jump to end of loop. All breaks go through this one. */
	ins_f_byte(F_JUMP); push_address(); ins_short(0);
	current_continue_address = mem_block[A_PROGRAM].current_size;
	upd_short(tmp_save, current_continue_address);
        push_address();
	
    } break;
case 70:
# line 1129 "lang.y"
{
	ins_f_byte(F_JUMP_WHEN_NON_ZERO); ins_short(pop_address());
	/* Fill in the break jump address in the beginning of the loop. */
	upd_short(pop_address(), mem_block[A_PROGRAM].current_size);
	current_break_address = pop_address();
	current_continue_address = pop_address();
    } break;
case 71:
# line 1137 "lang.y"
{ push_explicit(current_continue_address);
		    push_explicit(current_break_address); } break;
case 72:
# line 1139 "lang.y"
{   ins_f_byte(F_POP_VALUE);
		      push_address();
		  } break;
case 73:
# line 1142 "lang.y"
{
		    ins_f_byte(F_JUMP_WHEN_NON_ZERO);
		    ins_short(0);	/* Jump to block of block */
		    current_break_address = mem_block[A_PROGRAM].current_size;
		    ins_f_byte(F_JUMP); ins_short(0);	/* Out of loop */
	 	    current_continue_address =
			mem_block[A_PROGRAM].current_size;
		  } break;
case 74:
# line 1150 "lang.y"
{
	 	    ins_f_byte(F_POP_VALUE);
		    ins_f_byte(F_JUMP); ins_short(pop_address());
		    /* Here starts the block. */
		    upd_short(current_break_address-2,
			      mem_block[A_PROGRAM].current_size);
		  } break;
case 75:
# line 1158 "lang.y"
{
       ins_f_byte(F_JUMP); ins_short(current_continue_address);
       /* Now, the address of the end of the block is known. */
       upd_short(current_break_address+1, mem_block[A_PROGRAM].current_size);
       current_break_address = pop_address();
       current_continue_address = pop_address();
   } break;
case 76:
# line 1166 "lang.y"
{ ins_f_byte(F_CONST1); } break;
case 78:
# line 1170 "lang.y"
{
        current_break_stack_need += sizeof(short);
        if ( current_break_stack_need > max_break_stack_need )
            max_break_stack_need = current_break_stack_need;
	push_explicit(current_case_number_heap);
	push_explicit(current_case_string_heap);
	push_explicit(zero_case_label);
	push_explicit(current_break_address);
	ins_f_byte(F_SWITCH);
	ins_byte(0xff); /* kind of table */
	current_case_number_heap = mem_block[A_CASE_NUMBERS].current_size;
	current_case_string_heap = mem_block[A_CASE_STRINGS].current_size;
	zero_case_label = NO_STRING_CASE_LABELS;
	ins_short(0); /* address of table */
	current_break_address = mem_block[A_PROGRAM].current_size |
				BREAK_ON_STACK | BREAK_FROM_CASE ;
	ins_short(0); /* break address to push, table is entered before */
	ins_short(0); /* default address */
    } break;
case 79:
# line 1190 "lang.y"
{
	char *heap_start;
	int heap_end_offs;
	int i,o;
	int current_key,last_key;
	/* int size_without_table; */
	int block_index;
	int current_case_heap;
	int lookup_start;
	int lookup_start_key;

	current_break_address &= ~(BREAK_ON_STACK|BREAK_FROM_CASE);

	if ( !read_short(current_break_address+2 ) )
	    upd_short(current_break_address+2,     /* no default given ->  */
	      mem_block[A_PROGRAM].current_size);  /* create one           */

	/* it isn't unusual that the last case/default has no break */
	ins_f_byte(F_BREAK);
	if(zero_case_label & (NO_STRING_CASE_LABELS|SOME_NUMERIC_CASE_LABELS)){
	    block_index = A_CASE_NUMBERS;
	    current_case_heap = current_case_number_heap;
	} else {
	    block_index = A_CASE_STRINGS;
	    current_case_heap = current_case_string_heap;
	    if (zero_case_label&0xffff) {
		struct case_heap_entry temp;

		temp.key = ZERO_AS_STR_CASE_LABEL;
		temp.addr = zero_case_label;
		temp.line = 0; /* if this is accessed later, something is
				* really wrong				  */
		add_to_case_heap(A_CASE_STRINGS,&temp);
	    }
	}
	heap_start = mem_block[block_index].block + current_case_heap ;
	heap_end_offs = mem_block[block_index].current_size -current_case_heap;
	if (!heap_end_offs) yyerror("switch without case not supported");

        /* add a dummy entry so that we can always
        * assume we have no or two childs
        */
        add_to_mem_block(block_index, "\0\0\0\0\0\0\0\0",
            sizeof(struct case_heap_entry) );

        /* read out the heap and build a sorted table */
	/* the table could be optimized better, but let's first see
	* how much switch is used at all when it is full-featured...
	*/
	mem_block[A_CASE_LABELS].current_size = 0;
	lookup_start = 0;
	lookup_start_key = ((struct case_heap_entry*)heap_start)->key;
        for( ; ((struct case_heap_entry*)heap_start)->addr; )
        {
            int offset;
	    int curr_line,last_line;
	    unsigned short current_addr,last_addr = 0xffff;
	    int range_start;

            current_key = ((struct case_heap_entry*)heap_start)->key ;
            curr_line = ((struct case_heap_entry*)heap_start)->line ;
            current_addr = ((struct case_heap_entry*)heap_start)->addr ;
            if ( current_key == last_key &&
              mem_block[A_CASE_LABELS].current_size )
            {
                char buf[90];

                sprintf(buf,"Duplicate case in line %d and %d",
		    last_line, curr_line);
                yyerror(buf);
            }
	    if (curr_line) {
		if (last_addr == 1) {
                    char buf[120];
    
		    sprintf(buf,
"Discontinued case label list range, line %d by line %d",
		      last_line, curr_line);
                    yyerror(buf);
		}
		  else if (current_key == last_key + 1
		    && current_addr == last_addr) {
		    if (mem_block[A_CASE_LABELS].current_size
		      != range_start + 6) {
		      *(short*)(mem_block[A_CASE_LABELS].block+range_start+4)
			=1;
		      mem_block[A_CASE_LABELS].current_size = range_start + 6;
		    }
		} else {
		    range_start = mem_block[A_CASE_LABELS].current_size;
		}
	    }
            last_key = current_key;
	    last_line = curr_line;
	    last_addr = current_addr;
	    add_to_mem_block(A_CASE_LABELS,
                (char *)&current_key, sizeof(long) );
	    add_to_mem_block(A_CASE_LABELS,
		(char *)&current_addr, sizeof(short) );
            for ( offset = 0; ; )
            {

                int child1,child2;

                child1 = ( offset << 1 ) + sizeof(struct case_heap_entry);
                child2 = child1 + sizeof(struct case_heap_entry);
                if ( child1 >= heap_end_offs ) break;
                if ( ((struct case_heap_entry*)(heap_start+child1))->addr &&
                  ( !((struct case_heap_entry*)(heap_start+child2))->addr ||
                   ((struct case_heap_entry*)(heap_start+child1))->key <=
                   ((struct case_heap_entry*)(heap_start+child2))->key  ) )
                {
                    *(struct case_heap_entry*)(heap_start+offset) =
                    *(struct case_heap_entry*)(heap_start+child1);
                    offset = child1;
                } else
                    if (((struct case_heap_entry*)(heap_start+child2))->addr ) {
                        *(struct case_heap_entry*)(heap_start+offset) =
                        *(struct case_heap_entry*)(heap_start+child2);
                        offset = child2;
                    } else break;
            }
            ((struct case_heap_entry*)(heap_start+offset))->addr = 0;
        }

	/* write start of table */
        upd_short(current_break_address-2,
            mem_block[A_PROGRAM].current_size);

	add_to_mem_block(A_PROGRAM, mem_block[A_CASE_LABELS].block,
            mem_block[A_CASE_LABELS].current_size );
        /* calculate starting index for itarative search at execution time */
        for(i=0xf0,o=6; o<<1 <= mem_block[A_CASE_LABELS].current_size; )
            i++,o<<=1;
        if (block_index == A_CASE_STRINGS) i = ( i << 4 ) | 0xf;
        /* and store it */
        mem_block[A_PROGRAM].block[current_break_address-3] &= i;
#if 0  /* neither the code for ordinary switch is fully debugged now,
	* nor is the code for packed switch tables complete */
	d = ((struct case_heap_entry*)heap_start)->key;
	if ( (r-d)*sizeof(short) < heap_end_offs ) {
	    mem_block[A_PROGRAM].block[current_break_address-3] &= 0xfe;
            upd_short(current_break_address-2, mem_block[A_PROGRAM].current_size);
            size_without_table = mem_block[A_PROGRAM].current_size;
	    r = heap_end_offs / sizeof(struct case_heap_entry);
	    add_to_mem_block(A_PROGRAM,mem_block[A_PROGRAM]->block,
		r * sizeof(short) );
	    memset(mem_block[A_PROGRAM]->block+size_without_table,
		'\0',r * sizeof(short) );
	    ins_long( d );
	    for(; --r; heap_start += sizeof(struct case_heap_entry) )
	    {
		upd_short(size_without_table + sizeof(short)*
                    ( ((struct case_heap_entry*)heap_start)->key - d )
		  , ((struct case_heap_entry*)heap_start)->addr );
	    }
        }
#endif /* 0 */
	upd_short(current_break_address, mem_block[A_PROGRAM].current_size);
	
	mem_block[A_CASE_NUMBERS].current_size = current_case_number_heap;
	mem_block[A_CASE_STRINGS].current_size = current_case_string_heap;
    	current_break_address = pop_address();
	zero_case_label = pop_address();
    	current_case_string_heap = pop_address();
    	current_case_number_heap = pop_address();
        current_break_stack_need -= sizeof(short);
    } break;
case 80:
# line 1360 "lang.y"
{
	struct case_heap_entry temp;

	if ( !( current_break_address & BREAK_FROM_CASE ) ) {
	    yyerror("Case outside switch");
	    break;
	}
	temp.key = yypvt[-1].case_label.key;
	temp.addr = mem_block[A_PROGRAM].current_size;
	temp.line = current_line;
	add_to_case_heap(yypvt[-1].case_label.block,&temp);
    } break;
case 81:
# line 1373 "lang.y"
{
	struct case_heap_entry temp;

	if ( yypvt[-3].case_label.block != A_CASE_NUMBERS || yypvt[-1].case_label.block != A_CASE_NUMBERS )
	    yyerror("String case labels not allowed as range bounds");
	if (yypvt[-3].case_label.key > yypvt[-1].case_label.key) break;
	temp.key = yypvt[-3].case_label.key;
	temp.addr = 1;
	temp.line = current_line;
	add_to_case_heap(A_CASE_NUMBERS,&temp);
	temp.key = yypvt[-1].case_label.key;
	temp.addr = mem_block[A_PROGRAM].current_size;
	temp.line = 0;
	add_to_case_heap(A_CASE_NUMBERS,&temp);
    } break;
case 82:
# line 1390 "lang.y"
{
	    if ( !(zero_case_label & NO_STRING_CASE_LABELS) )
		yyerror("Mixed case label list not allowed");
	    if ( yyval.case_label.key = yypvt[-0].number )
	        zero_case_label |= SOME_NUMERIC_CASE_LABELS;
	    else
		zero_case_label |= mem_block[A_PROGRAM].current_size;
	    yyval.case_label.block = A_CASE_NUMBERS;
	} break;
case 83:
# line 1400 "lang.y"
{
	    if ( zero_case_label & SOME_NUMERIC_CASE_LABELS )
		yyerror("Mixed case label list not allowed");
	    zero_case_label &= ~NO_STRING_CASE_LABELS;
            store_prog_string(yypvt[-0].string);
            yyval.case_label.key = (int)yypvt[-0].string;
	    yyval.case_label.block = A_CASE_STRINGS;
        } break;
case 85:
# line 1411 "lang.y"
{ yyval.number = yypvt[-2].number | yypvt[-0].number; } break;
case 87:
# line 1414 "lang.y"
{ yyval.number = yypvt[-2].number ^ yypvt[-0].number; } break;
case 89:
# line 1417 "lang.y"
{ yyval.number = yypvt[-2].number & yypvt[-0].number; } break;
case 91:
# line 1420 "lang.y"
{ yyval.number = yypvt[-2].number == yypvt[-0].number; } break;
case 92:
# line 1421 "lang.y"
{ yyval.number = yypvt[-2].number != yypvt[-0].number; } break;
case 94:
# line 1424 "lang.y"
{ yyval.number = yypvt[-2].number >  yypvt[-0].number; } break;
case 95:
# line 1425 "lang.y"
{ yyval.number = yypvt[-2].number >= yypvt[-0].number; } break;
case 96:
# line 1426 "lang.y"
{ yyval.number = yypvt[-2].number <  yypvt[-0].number; } break;
case 97:
# line 1427 "lang.y"
{ yyval.number = yypvt[-2].number <= yypvt[-0].number; } break;
case 99:
# line 1430 "lang.y"
{ yyval.number = yypvt[-2].number << yypvt[-0].number; } break;
case 100:
# line 1431 "lang.y"
{ yyval.number = yypvt[-2].number >> yypvt[-0].number; } break;
case 102:
# line 1434 "lang.y"
{ yyval.number = yypvt[-2].number + yypvt[-0].number; } break;
case 103:
# line 1435 "lang.y"
{ yyval.number = yypvt[-2].number - yypvt[-0].number; } break;
case 105:
# line 1438 "lang.y"
{ yyval.number = yypvt[-2].number * yypvt[-0].number; } break;
case 106:
# line 1439 "lang.y"
{ yyval.number = yypvt[-2].number % yypvt[-0].number; } break;
case 107:
# line 1440 "lang.y"
{ yyval.number = yypvt[-2].number / yypvt[-0].number; } break;
case 109:
# line 1443 "lang.y"
{ yyval.number = yypvt[-1].number; } break;
case 111:
# line 1446 "lang.y"
{ yyval.number = -yypvt[-0].number; } break;
case 112:
# line 1447 "lang.y"
{ yyval.number = !yypvt[-0].number; } break;
case 113:
# line 1448 "lang.y"
{ yyval.number = ~yypvt[-0].number; } break;
case 114:
# line 1451 "lang.y"
{
	if ( !( current_break_address & BREAK_FROM_CASE ) ) {
	    yyerror("Default outside switch");
	    break;
	}
	current_break_address &= ~(BREAK_ON_STACK|BREAK_FROM_CASE);
	if ( read_short(current_break_address+2 ) )
	    yyerror("Duplicate default");
	upd_short(current_break_address+2, mem_block[A_PROGRAM].current_size);
	current_break_address |= (BREAK_ON_STACK|BREAK_FROM_CASE);
    } break;
case 115:
# line 1464 "lang.y"
{ yyval.type = yypvt[-0].type; } break;
case 116:
# line 1465 "lang.y"
{ ins_f_byte(F_POP_VALUE); } break;
case 117:
# line 1467 "lang.y"
{ yyval.type = yypvt[-0].type; } break;
case 119:
# line 1471 "lang.y"
{
	    if (exact_types && !compatible_types(yypvt[-2].type, yypvt[-0].type) &&
		!(yypvt[-2].type == TYPE_STRING && yypvt[-0].type == TYPE_NUMBER && yypvt[-1].number == F_ADD_EQ))
	    {
		type_error("Bad assignment. Rhs", yypvt[-0].type);
	    }
	    ins_f_byte(yypvt[-1].number);
	    yyval.type = yypvt[-0].type;
	} break;
case 120:
# line 1480 "lang.y"
{ yyerror("Illegal LHS"); } break;
case 121:
# line 1482 "lang.y"
{ yyval.type = yypvt[-0].type; } break;
case 122:
# line 1484 "lang.y"
{
	    ins_f_byte(F_JUMP_WHEN_ZERO);
	    push_address();
	    ins_short(0);
	} break;
case 123:
# line 1490 "lang.y"
{
	    int i;
	    i = pop_address();
	    ins_f_byte(F_JUMP); push_address(); ins_short(0);
	    upd_short(i, mem_block[A_PROGRAM].current_size);
	} break;
case 124:
# line 1497 "lang.y"
{
	    upd_short(pop_address(), mem_block[A_PROGRAM].current_size);
	    if (exact_types && !compatible_types(yypvt[-3].type, yypvt[-0].type)) {
		type_error("Different types in ?: expr", yypvt[-3].type);
		type_error("                      and ", yypvt[-0].type);
	    }
	    if (yypvt[-3].type == TYPE_ANY) yyval.type = yypvt[-0].type;
	    else if (yypvt[-0].type == TYPE_ANY) yyval.type = yypvt[-3].type;
	    else if (TYPE(yypvt[-3].type, TYPE_MOD_POINTER|TYPE_ANY)) yyval.type = yypvt[-0].type;
	    else if (TYPE(yypvt[-0].type, TYPE_MOD_POINTER|TYPE_ANY)) yyval.type = yypvt[-3].type;
	    else yyval.type = yypvt[-3].type;
	} break;
case 125:
# line 1510 "lang.y"
{ yyval.number = F_ASSIGN; } break;
case 126:
# line 1511 "lang.y"
{ yyval.number = F_AND_EQ; } break;
case 127:
# line 1512 "lang.y"
{ yyval.number = F_OR_EQ; } break;
case 128:
# line 1513 "lang.y"
{ yyval.number = F_XOR_EQ; } break;
case 129:
# line 1514 "lang.y"
{ yyval.number = F_LSH_EQ; } break;
case 130:
# line 1515 "lang.y"
{ yyval.number = F_RSH_EQ; } break;
case 131:
# line 1516 "lang.y"
{ yyval.number = F_ADD_EQ; } break;
case 132:
# line 1517 "lang.y"
{ yyval.number = F_SUB_EQ; } break;
case 133:
# line 1518 "lang.y"
{ yyval.number = F_MULT_EQ; } break;
case 134:
# line 1519 "lang.y"
{ yyval.number = F_MOD_EQ; } break;
case 135:
# line 1520 "lang.y"
{ yyval.number = F_DIV_EQ; } break;
case 136:
# line 1523 "lang.y"
{
	    if (exact_types && !TYPE(exact_types, TYPE_VOID))
		type_error("Must return a value for a function declared",
			   exact_types);
	    ins_f_byte(F_CONST0);
	    ins_f_byte(F_RETURN);
	} break;
case 137:
# line 1531 "lang.y"
{
	    if (exact_types && !TYPE(yypvt[-0].type, exact_types & TYPE_MOD_MASK))
		type_error("Return type not matching", exact_types);
	    ins_f_byte(F_RETURN);
	} break;
case 138:
# line 1537 "lang.y"
{ yyval.number = 0; } break;
case 139:
# line 1538 "lang.y"
{ yyval.number = yypvt[-0].number; } break;
case 140:
# line 1539 "lang.y"
{ yyval.number = yypvt[-1].number; } break;
case 141:
# line 1541 "lang.y"
{ yyval.number = 1; add_arg_type(yypvt[-0].type); } break;
case 142:
# line 1542 "lang.y"
{ yyval.number = yypvt[-2].number + 1; add_arg_type(yypvt[-0].type); } break;
case 143:
# line 1544 "lang.y"
{ yyval.type = yypvt[-0].type; } break;
case 144:
# line 1546 "lang.y"
{
	    ins_f_byte(F_DUP); ins_f_byte(F_JUMP_WHEN_NON_ZERO);
	    push_address();
	    ins_short(0);
	    ins_f_byte(F_POP_VALUE);
	} break;
case 145:
# line 1553 "lang.y"
{
	    upd_short(pop_address(), mem_block[A_PROGRAM].current_size);
	    if (yypvt[-3].type == yypvt[-0].type)
		yyval.type = yypvt[-3].type;
	    else
		yyval.type = TYPE_ANY;	/* Return type can't be known */
	} break;
case 146:
# line 1561 "lang.y"
{ yyval.type = yypvt[-0].type; } break;
case 147:
# line 1563 "lang.y"
{
	    ins_f_byte(F_DUP); ins_f_byte(F_JUMP_WHEN_ZERO);
	    push_address();
	    ins_short(0);
	    ins_f_byte(F_POP_VALUE);
	} break;
case 148:
# line 1570 "lang.y"
{
	    upd_short(pop_address(), mem_block[A_PROGRAM].current_size);
	    if (yypvt[-3].type == yypvt[-0].type)
		yyval.type = yypvt[-3].type;
	    else
		yyval.type = TYPE_ANY;	/* Return type can't be known */
	} break;
case 150:
# line 1580 "lang.y"
{
	      if (exact_types && !TYPE(yypvt[-2].type,TYPE_NUMBER))
		  type_error("Bad argument 1 to |", yypvt[-2].type);
	      if (exact_types && !TYPE(yypvt[-0].type,TYPE_NUMBER))
		  type_error("Bad argument 2 to |", yypvt[-0].type);
	      yyval.type = TYPE_NUMBER;
	      ins_f_byte(F_OR);
	  } break;
case 152:
# line 1591 "lang.y"
{
	      if (exact_types && !TYPE(yypvt[-2].type,TYPE_NUMBER))
		  type_error("Bad argument 1 to ^", yypvt[-2].type);
	      if (exact_types && !TYPE(yypvt[-0].type,TYPE_NUMBER))
		  type_error("Bad argument 2 to ^", yypvt[-0].type);
	      yyval.type = TYPE_NUMBER;
	      ins_f_byte(F_XOR);
	  } break;
case 154:
# line 1602 "lang.y"
{
	      ins_f_byte(F_AND);
	      if ( !TYPE(yypvt[-2].type,TYPE_MOD_POINTER) || !TYPE(yypvt[-0].type,TYPE_MOD_POINTER) ) {
	          if (exact_types && !TYPE(yypvt[-2].type,TYPE_NUMBER))
		      type_error("Bad argument 1 to &", yypvt[-2].type);
	          if (exact_types && !TYPE(yypvt[-0].type,TYPE_NUMBER))
		      type_error("Bad argument 2 to &", yypvt[-0].type);
	      }
	      yyval.type = TYPE_NUMBER;
	  } break;
case 156:
# line 1615 "lang.y"
{
	    int t1 = yypvt[-2].type & TYPE_MOD_MASK, t2 = yypvt[-0].type & TYPE_MOD_MASK;
	    if (exact_types && t1 != t2 && t1 != TYPE_ANY && t2 != TYPE_ANY) {
		type_error("== always false because of different types", yypvt[-2].type);
		type_error("                               compared to", yypvt[-0].type);
	    }
	    ins_f_byte(F_EQ);
	    yyval.type = TYPE_NUMBER;
	} break;
case 157:
# line 1625 "lang.y"
{
	    int t1 = yypvt[-2].type & TYPE_MOD_MASK, t2 = yypvt[-0].type & TYPE_MOD_MASK;
	    if (exact_types && t1 != t2 && t1 != TYPE_ANY && t2 != TYPE_ANY) {
		type_error("!= always true because of different types", yypvt[-2].type);
		type_error("                               compared to", yypvt[-0].type);
	    }
	    ins_f_byte(F_NE);
	    yyval.type = TYPE_NUMBER;
	} break;
case 159:
# line 1637 "lang.y"
{ yyval.type = TYPE_NUMBER; ins_f_byte(F_GT); } break;
case 160:
# line 1639 "lang.y"
{ yyval.type = TYPE_NUMBER; ins_f_byte(F_GE); } break;
case 161:
# line 1641 "lang.y"
{ yyval.type = TYPE_NUMBER; ins_f_byte(F_LT); } break;
case 162:
# line 1643 "lang.y"
{ yyval.type = TYPE_NUMBER; ins_f_byte(F_LE); } break;
case 164:
# line 1647 "lang.y"
{
	    ins_f_byte(F_LSH);
	    yyval.type = TYPE_NUMBER;
	    if (exact_types && !TYPE(yypvt[-2].type, TYPE_NUMBER))
		type_error("Bad argument number 1 to '<<'", yypvt[-2].type);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument number 2 to '<<'", yypvt[-0].type);
	} break;
case 165:
# line 1656 "lang.y"
{
	    ins_f_byte(F_RSH);
	    yyval.type = TYPE_NUMBER;
	    if (exact_types && !TYPE(yypvt[-2].type, TYPE_NUMBER))
		type_error("Bad argument number 1 to '>>'", yypvt[-2].type);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument number 2 to '>>'", yypvt[-0].type);
	} break;
case 167:
# line 1667 "lang.y"
{ ins_f_byte(F_ADD); yyval.type = TYPE_ANY; } break;
case 168:
# line 1669 "lang.y"
{
	    int bad_arg = 0;

	    if (exact_types) {
		if (!TYPE(yypvt[-2].type, TYPE_NUMBER) && !(yypvt[-2].type & TYPE_MOD_POINTER) ) {
                    type_error("Bad argument number 1 to '-'", yypvt[-2].type);
		    bad_arg++;
		}
		if (!TYPE(yypvt[-0].type, TYPE_NUMBER) && !(yypvt[-0].type & TYPE_MOD_POINTER) ) {
                    type_error("Bad argument number 2 to '-'", yypvt[-0].type);
		    bad_arg++;
		}
	    }
	    yyval.type = TYPE_ANY;
	    if ((yypvt[-2].type & TYPE_MOD_POINTER) || (yypvt[-0].type & TYPE_MOD_POINTER))
		yyval.type = TYPE_MOD_POINTER | TYPE_ANY;
	    if (!(yypvt[-2].type & TYPE_MOD_POINTER) || !(yypvt[-0].type & TYPE_MOD_POINTER)) {
		if (exact_types && yyval.type != TYPE_ANY && !bad_arg)
		    yyerror("Arguments to '-' don't match");
		yyval.type = TYPE_NUMBER;
	    }
	    ins_f_byte(F_SUBTRACT);
	} break;
case 170:
# line 1695 "lang.y"
{
	    if (exact_types && !TYPE(yypvt[-2].type, TYPE_NUMBER))
		type_error("Bad argument number 1 to '*'", yypvt[-2].type);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument number 2 to '*'", yypvt[-0].type);
	    ins_f_byte(F_MULTIPLY);
	    yyval.type = TYPE_NUMBER;
	} break;
case 171:
# line 1704 "lang.y"
{
	    if (exact_types && !TYPE(yypvt[-2].type, TYPE_NUMBER))
		type_error("Bad argument number 1 to '%'", yypvt[-2].type);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument number 2 to '%'", yypvt[-0].type);
	    ins_f_byte(F_MOD);
	    yyval.type = TYPE_NUMBER;
	} break;
case 172:
# line 1713 "lang.y"
{
	    if (exact_types && !TYPE(yypvt[-2].type, TYPE_NUMBER))
		type_error("Bad argument number 1 to '/'", yypvt[-2].type);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument number 2 to '/'", yypvt[-0].type);
	    ins_f_byte(F_DIVIDE);
	    yyval.type = TYPE_NUMBER;
	} break;
case 174:
# line 1724 "lang.y"
{
		  yyval.type = yypvt[-1].type;
		  if (exact_types && yypvt[-0].type != TYPE_ANY && yypvt[-0].type != TYPE_UNKNOWN &&
		      yypvt[-1].type != TYPE_VOID)
		      type_error("Casts are only legal for type mixed, or when unknown", yypvt[-0].type);
	      } break;
case 176:
# line 1733 "lang.y"
{
	    ins_f_byte(F_INC);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument to ++", yypvt[-0].type);
	    yyval.type = TYPE_NUMBER;
	} break;
case 177:
# line 1740 "lang.y"
{
	    ins_f_byte(F_DEC);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument to --", yypvt[-0].type);
	    yyval.type = TYPE_NUMBER;
	} break;
case 178:
# line 1747 "lang.y"
{
	    ins_f_byte(F_NOT);	/* Any type is valid here. */
	    yyval.type = TYPE_NUMBER;
	} break;
case 179:
# line 1752 "lang.y"
{
	    ins_f_byte(F_COMPL);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument to ~", yypvt[-0].type);
	    yyval.type = TYPE_NUMBER;
	} break;
case 180:
# line 1759 "lang.y"
{
	    ins_f_byte(F_NEGATE);
	    if (exact_types && !TYPE(yypvt[-0].type, TYPE_NUMBER))
		type_error("Bad argument to unary '-'", yypvt[-0].type);
	    yyval.type = TYPE_NUMBER;
	} break;
case 182:
# line 1768 "lang.y"
{
	     ins_f_byte(F_POST_INC);
	     if (exact_types && !TYPE(yypvt[-1].type, TYPE_NUMBER))
		 type_error("Bad argument to ++", yypvt[-1].type);
	     yyval.type = TYPE_NUMBER;
	 } break;
case 183:
# line 1775 "lang.y"
{
	     ins_f_byte(F_POST_DEC);
	     if (exact_types && !TYPE(yypvt[-1].type, TYPE_NUMBER))
		 type_error("Bad argument to --", yypvt[-1].type);
	     yyval.type = TYPE_NUMBER;
	 } break;
case 185:
# line 1784 "lang.y"
{
	    int pos = mem_block[A_PROGRAM].current_size;
	    /* Some optimization. Replace the push-lvalue with push-value */
	    if (last_push_identifier == pos-2)
		mem_block[A_PROGRAM].block[last_push_identifier] =
		    F_IDENTIFIER - F_OFFSET;
	    else if (last_push_local == pos-2)
		mem_block[A_PROGRAM].block[last_push_local] =
		    F_LOCAL_NAME - F_OFFSET;
	    else if (last_push_indexed == pos-1)
		mem_block[A_PROGRAM].block[last_push_indexed] =
		    F_INDEX_INSTR - F_OFFSET;
	    else if (last_push_indexed != 0)
		fatal("Should be a push at this point !\n");
	    yyval.type = yypvt[-0].type;
	} break;
case 188:
# line 1801 "lang.y"
{ yyval.type = yypvt[-1].type; } break;
case 189:
# line 1802 "lang.y"
{ yyval.type = TYPE_ANY; } break;
case 190:
# line 1803 "lang.y"
{ yyval.type = TYPE_NUMBER; } break;
case 191:
# line 1804 "lang.y"
{ yyval.type = TYPE_NUMBER; } break;
case 192:
# line 1806 "lang.y"
{
	   pop_arg_stack(yypvt[-2].number);		/* We don't care about these types */
	   ins_f_byte(F_AGGREGATE);
	   ins_short(yypvt[-2].number);
	   yyval.type = TYPE_MOD_POINTER | TYPE_ANY;
       } break;
case 193:
# line 1813 "lang.y"
{ ins_f_byte(F_CATCH); push_address(); ins_short(0);} break;
case 194:
# line 1815 "lang.y"
{
		   ins_f_byte(F_POP_VALUE);
#if 1
		   ins_f_byte(F_CONST0);
		   ins_f_byte(F_THROW);
#else
		   ins_f_byte(F_RETURN);
#endif
		   upd_short(pop_address(),
			     mem_block[A_PROGRAM].current_size);
	       } break;
case 195:
# line 1828 "lang.y"
{
	    ins_f_byte(F_SSCANF); ins_byte(yypvt[-1].number + 2);
	} break;
case 196:
# line 1833 "lang.y"
{
	    ins_f_byte(F_PARSE_COMMAND); ins_byte(yypvt[-1].number + 3);
	} break;
case 197:
# line 1837 "lang.y"
{ yyval.number = 0; } break;
case 198:
# line 1838 "lang.y"
{ yyval.number = 1 + yypvt[-0].number; } break;
case 199:
# line 1841 "lang.y"
{
	    int i = verify_declared(yypvt[-0].string);
	    last_push_identifier = mem_block[A_PROGRAM].current_size;
	    ins_f_byte(F_PUSH_IDENTIFIER_LVALUE);
	    ins_byte(i);
	    free(yypvt[-0].string);
	    if (i == -1)
		yyval.type = TYPE_ANY;
	    else
		yyval.type = VARIABLE(i)->type & TYPE_MOD_MASK;
	} break;
case 200:
# line 1853 "lang.y"
{
	    last_push_local = mem_block[A_PROGRAM].current_size;
	    ins_f_byte(F_PUSH_LOCAL_VARIABLE_LVALUE);
	    ins_byte(yypvt[-0].number);
	    yyval.type = type_of_locals[yypvt[-0].number];
	} break;
case 201:
# line 1860 "lang.y"
{
	      ins_f_byte(F_RANGE);
	      last_push_indexed = 0;
	      if (exact_types) {
		  if ((yypvt[-5].type & TYPE_MOD_POINTER) == 0 && !TYPE(yypvt[-5].type, TYPE_STRING))
		      type_error("Bad type to indexed value", yypvt[-5].type);
		  if (!TYPE(yypvt[-3].type, TYPE_NUMBER))
		      type_error("Bad type of index", yypvt[-3].type);
		  if (!TYPE(yypvt[-1].type, TYPE_NUMBER))
		      type_error("Bad type of index", yypvt[-1].type);
	      }
	      if (yypvt[-5].type == TYPE_ANY)
		  yyval.type = TYPE_ANY;
	      else if (TYPE(yypvt[-5].type, TYPE_STRING))
		  yyval.type = TYPE_STRING;
	      else if (yypvt[-5].type & TYPE_MOD_POINTER)
		  yyval.type = yypvt[-5].type;
	      else if (exact_types)
		  type_error("Bad type of argument used for range", yypvt[-5].type);
	  } break;
case 202:
# line 1881 "lang.y"
{
	      last_push_indexed = mem_block[A_PROGRAM].current_size;
	      ins_f_byte(F_PUSH_INDEXED_LVALUE);
	      if (exact_types) {
		  if ((yypvt[-3].type & TYPE_MOD_POINTER) == 0 && !TYPE(yypvt[-3].type, TYPE_STRING))
		      type_error("Bad type to indexed value", yypvt[-3].type);
		  if (!TYPE(yypvt[-1].type, TYPE_NUMBER))
		      type_error("Bad type of index", yypvt[-1].type);
	      }
	      if (yypvt[-3].type == TYPE_ANY)
		  yyval.type = TYPE_ANY;
	      else if (TYPE(yypvt[-3].type, TYPE_STRING))
		  yyval.type = TYPE_NUMBER;
	      else
		  yyval.type = yypvt[-3].type & TYPE_MOD_MASK & ~TYPE_MOD_POINTER;
	  } break;
case 203:
# line 1899 "lang.y"
{
	    ins_f_byte(F_STRING);
	    ins_short(store_prog_string(yypvt[-0].string));
	    free(yypvt[-0].string);
	    yyval.type = TYPE_STRING;
	} break;
case 204:
# line 1907 "lang.y"
{
            char *p = make_shared_string(yypvt[-0].string);
            free(yypvt[-0].string);
            yyval.string = p;
        } break;
case 206:
# line 1915 "lang.y"
{
	    yyval.string = xalloc( strlen(yypvt[-2].string) + strlen(yypvt[-0].string) + 1 );
	    strcpy(yyval.string, yypvt[-2].string);
	    strcat(yyval.string, yypvt[-0].string);
	    free(yypvt[-2].string);
	    free(yypvt[-0].string);
	} break;
case 207:
# line 1924 "lang.y"
{
	/* This seems to be an ordinary function call. But, if the function
	 * is not defined, then it might be a call to a simul_efun.
	 * If it is, then we make it a call_other(), which requires the
	 * function name as argument.
	 * We have to remember until after parsing the arguments if it was
	 * a simulated efun or not, which means that the pointer has to be
	 * pushed on a stack. Use the internal yacc stack for this purpose.
	 */
	yyval.funp = 0;
	if (defined_function(yypvt[-0].string) == -1) {
	    char *p = make_shared_string(yypvt[-0].string);
	    yyval.funp = find_simul_efun(p);
	    if (yyval.funp && !(yyval.funp->type & TYPE_MOD_STATIC)) {
		ins_f_byte(F_STRING);
		ins_short(store_prog_string(
	              query_simul_efun_file_name()));
		ins_f_byte(F_STRING);
		ins_short(store_prog_string(p));
	    } else {
		yyval.funp = 0;
	    }
	    free_string(p);
	}
    } break;
case 208:
# line 1950 "lang.y"
{ 
	int f;
	int efun_override = strncmp(yypvt[-4].string, "efun::", 6) == 0;

	if (yypvt[-3].funp) {
	    ins_f_byte(F_CALL_OTHER);
	    ins_byte(yypvt[-1].number + 2);
	    yyval.type = yypvt[-3].funp->type;
	} else if (!efun_override && (f = defined_function(yypvt[-4].string)) >= 0) {
	    struct function *funp;
	    ins_f_byte(F_CALL_FUNCTION_BY_ADDRESS); ins_short(f);
	    ins_byte(yypvt[-1].number);	/* Actual number of arguments */
	    funp = FUNCTION(f);
	    if (funp->flags & NAME_UNDEFINED)
		find_inherited(funp);
	    /*
	     * Verify that the function has been defined already.
	     */
	    if ((funp->flags & NAME_UNDEFINED) &&
		!(funp->flags & NAME_PROTOTYPE) && exact_types)
	    {
		char buff[100];
		sprintf(buff, "Function %.50s undefined", funp->name);
		yyerror(buff);
	    }
	    yyval.type = funp->type & TYPE_MOD_MASK;
	    /*
	     * Check number of arguments.
	     */
	    if (funp->num_arg != yypvt[-1].number && !(funp->type & TYPE_MOD_VARARGS) &&
		(funp->flags & NAME_STRICT_TYPES) && exact_types)
	    {
		char buff[100];
		sprintf(buff, "Wrong number of arguments to %.60s", yypvt[-4].string);
		yyerror(buff);
	    }
	    /*
	     * Check the argument types.
	     */
	    if (exact_types && *(unsigned short *)&mem_block[A_ARGUMENT_INDEX].block[f * sizeof (unsigned short)] != INDEX_START_NONE)
	    {
		int i, first;
		unsigned short *arg_types;
		
		arg_types = (unsigned short *)
		    mem_block[A_ARGUMENT_TYPES].block;
		first = *(unsigned short *)&mem_block[A_ARGUMENT_INDEX].block[f * sizeof (unsigned short)];
		for (i=0; i < funp->num_arg && i < yypvt[-1].number; i++) {
		    int tmp = get_argument_type(i, yypvt[-1].number);
		    if (!TYPE(tmp, arg_types[first + i])) {
			char buff[100];
			sprintf(buff, "Bad type for argument %d %s", i+1,
				get_two_types(arg_types[first+i], tmp));
			yyerror(buff);
		    }
		}
	    }
	} else if (efun_override || (f = lookup_predef(yypvt[-4].string)) != -1) {
	    int min, max, def, *argp;
	    extern int efun_arg_types[];

	    if (efun_override) {
		f = lookup_predef(yypvt[-4].string+6);
	    }
	    if (f == -1) {	/* Only possible for efun_override */
		char buff[100];
		sprintf(buff, "Unknown efun: %s", yypvt[-4].string+6);
		yyerror(buff);
	    } else {
		min = instrs[f-F_OFFSET].min_arg;
		max = instrs[f-F_OFFSET].max_arg;
		def = instrs[f-F_OFFSET].Default;
		yyval.type = instrs[f-F_OFFSET].ret_type;
		argp = &efun_arg_types[instrs[f-F_OFFSET].arg_index];
		if (def && yypvt[-1].number == min-1) {
		    ins_f_byte(def);
		    max--;
		    min--;
		} else if (yypvt[-1].number < min) {
		    char bff[100];
		    sprintf(bff, "Too few arguments to %s",
			    instrs[f-F_OFFSET].name);
		    yyerror(bff);
		} else if (yypvt[-1].number > max && max != -1) {
		    char bff[100];
		    sprintf(bff, "Too many arguments to %s",
			    instrs[f-F_OFFSET].name);
		    yyerror(bff);
		} else if (max != -1 && exact_types) {
		    /*
		     * Now check all types of the arguments to efuns.
		     */
		    int i, argn;
		    char buff[100];
		    for (argn=0; argn < yypvt[-1].number; argn++) {
			int tmp = get_argument_type(argn, yypvt[-1].number);
			for(i=0; !TYPE(argp[i], tmp) && argp[i] != 0; i++)
			    ;
			if (argp[i] == 0) {
			    sprintf(buff, "Bad argument %d type to efun %s()",
				    argn+1, instrs[f-F_OFFSET].name);
			    yyerror(buff);
			}
			while(argp[i] != 0)
			    i++;
			argp += i + 1;
		    }
		}
		ins_f_byte(f);
		/* Only store number of arguments for instructions
		 * that allowed a variable number.
		 */
		if (max != min)
		    ins_byte(yypvt[-1].number);/* Number of actual arguments */
	    }
	} else {
	    struct function *funp;
	    f = define_new_function(yypvt[-4].string, 0, 0, 0, NAME_UNDEFINED, 0);
	    ins_f_byte(F_CALL_FUNCTION_BY_ADDRESS);
	    ins_short(f);
	    ins_byte(yypvt[-1].number);	/* Number of actual arguments */
	    funp = FUNCTION(f);
	    if (strchr(yypvt[-4].string, ':')) {
		/*
		 * A function defined by inheritance. Find
		 * real definition immediately.
		 */
		find_inherited(funp);
	    }
	    /*
	     * Check if this function has been defined.
	     * But, don't complain yet about functions defined
	     * by inheritance.
	     */
	    if (exact_types && (funp->flags & NAME_UNDEFINED)) {
		char buff[100];
		sprintf(buff, "Undefined function %.50s", yypvt[-4].string);
		yyerror(buff);
	    }
	    if (!(funp->flags & NAME_UNDEFINED))
		yyval.type = funp->type;
	    else
		yyval.type = TYPE_ANY;	/* Just a guess */
	}
	free(yypvt[-4].string);
	pop_arg_stack(yypvt[-1].number);	/* Argument types not needed more */
    } break;
case 209:
# line 2098 "lang.y"
{
	ins_f_byte(F_STRING);
	ins_short(store_prog_string(yypvt[-0].string));
	free(yypvt[-0].string);
    } break;
case 210:
# line 2104 "lang.y"
{
	ins_f_byte(F_CALL_OTHER);
	ins_byte(yypvt[-1].number + 2);
	yyval.type = TYPE_UNKNOWN;
	pop_arg_stack(yypvt[-1].number);	/* No good need of these arguments */
    } break;
case 212:
# line 2113 "lang.y"
{
		    char *p = xalloc(strlen(yypvt[-0].string) + 3);
		    strcpy(p, "::"); strcat(p, yypvt[-0].string); free(yypvt[-0].string);
		    yyval.string = p;
		} break;
case 213:
# line 2119 "lang.y"
{
		    char *p = xalloc(strlen(yypvt[-2].string) + strlen(yypvt[-0].string) + 3);
		    strcpy(p, yypvt[-2].string); strcat(p, "::"); strcat(p, yypvt[-0].string);
		    free(yypvt[-2].string); free(yypvt[-0].string);
		    yyval.string = p;
		} break;
case 214:
# line 2128 "lang.y"
{
	    int i;
	    i = pop_address();
	    ins_f_byte(F_JUMP); push_address(); ins_short(0);
	    upd_short(i, mem_block[A_PROGRAM].current_size);
	} break;
case 215:
# line 2135 "lang.y"
{ upd_short(pop_address(), mem_block[A_PROGRAM].current_size); } break;
case 216:
# line 2138 "lang.y"
{
	    ins_f_byte(F_JUMP_WHEN_ZERO);
	    push_address();
	    ins_short(0);
	} break;
		}
		goto yystack;  /* stack new state and value */

	}
