/*****************************************************************
 *  SMTP.C - 05/09/88 - SMTP/RLI interface code
 *    adapted from original code by NN2Z
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/

#include "mb.h"


#define smtphost thisHost
extern char *thisHost;

/*	OK for UNIX et al. -- but.... DV and NET barfola on the / to \ xlate!

char rqueue[]		= "/spool/rqueue";
char rqueuefiles[]	= "/spool/rqueue/*.wrk";
char mailqdir[]		= "/spool/mqueue";
char seqfname[]		= "/spool/mqueue/sequence.seq";
*/
char rqueue[]		= "\\spool\\rqueue";
char rqueuefiles[]	= "\\spool\\rqueue\\*.wrk";
char mailqdir[]		= "\\spool\\mqueue";
char seqfname[]		= "\\spool\\mqueue\\sequence.seq";
char tcpip_gw[]		= "TCPIP Gateway";

/* get mail from the smtp rqueue */
getrqueue()
{
	char wfilename[32];
	char dfile[128];
	char wfile[128];
	char buf[128];
	char from[10];
	char *at,*p, *q, *fst;
	FILE *fp, *dp, *dfp;

	printf("Checking for smtp mail\n");
	for (fil_dir(rqueuefiles,0,wfilename,0); *wfilename != '\0';
		 fil_dir(rqueuefiles,1,wfilename,0)) {
/*
		sprintf(dfile,"%s/%s",rqueue,wfilename);
		sprintf(wfile,"%s/%s",rqueue,wfilename);
*/
		sprintf(dfile,"%s\\%s",rqueue,wfilename);
		sprintf(wfile,"%s\\%s",rqueue,wfilename);
		strcpy(strrchr(dfile,'.'),".txt");

		printf("job: %s\n",dfile);

		if ((fp = fopen(wfile,"r")) == NULL) {
			perror(wfile);
			continue;
		}

		fgets(buf,sizeof(buf),fp);
		remnl(buf);

		DEBUG("read from '%s'\n",buf);

		if (strnicmp(buf,"From: ",6) == 0) {
			strnxcat(from, &buf[6],CALLLEN);
		} else {
			fclose(fp);
			DEBUG("Missing from line\n");
			continue;
		}
		if ((p = strchr(from,'@')) != NULL)
			*p = '\0';

		DEBUG("From: %s\n",from);

		while(!feof(fp)) {
			if ((fst = fgets(buf,sizeof(buf),fp)) == NULL) 
				continue;
			remnl(buf);			/* strip newline */
			
			if (strnicmp(buf,"To: ",4) != 0)
				continue;

			if ((at = strchr(buf,'@')) != NULL)	/* find the host */
				*at++ = '\0';
			else
				at = "";
			if (stricmp(at,smtphost) == 0) { /* match our domain name ??? */
				*at = '\0';
			} else {
				if (p = strchr(at,'.')) {
					*q = *p;
					*p = '\0';
					if (stricmp(at,ocall) == 0)
						*at = '\0';				 
					else
						*p = *q;
				}
			}

			if (*at == '\0') {	/* if using a % take that as host */
				if ((at = strchr(buf,'%')) != NULL)
					*at++ = '\0';
				else
					*at = '\0';
			}
			islocal = 0;
			strcpy(mto,&buf[4]);
			strcpy(mfrom,from);
			strcpy(mbbs,at);
			*mtitle = '\0';
			mtyp = ' ';
			mfprty = ' ';
							/* Find the subject from rfc822 header */
			if ((dfp = fopen(dfile,"r")) != NULL) {
				while (fgets(line,LINELEN,dfp) != NULL) {
					if (*line == '\n')
						break;
					if (strnicmp(line,"Subject: ",9) == 0) {
						strnxcat(mtitle,line+9,MHTITL);
						break;
					}
				}
				fclose(dfp);
			}
			resolv_msg(dfile, TRUE);
		}
		fclose(fp);
		unlink(dfile);
		unlink(wfile);
	}
	DEBUG("exit getrqueue\n");
}


/*
	tomqueue() - 'forwards' mail from RLI format to SMTP / BM Mailer
*/
tomqueue()
{
	int cmpn = CALLLEN;

	FILE *smtp_fl;
	char buf[128];
	char to[128];
	char from[128];
	char bbs[CALLLEN+1];
	char call[CALLLEN+1];
	char fromcall[CALLLEN+1];
	char frombbs[CALLLEN+1];
	char tocall[CALLLEN+1];
	char tline[LINELEN];
	char *tohost, *fst;
	extern char *fexcept;
	extern int fexcptn;
	
	int relay = 0;
	int c;
	long id, get_msgid();
	char *arpadate(), *fwd_name();
	FILE *fp;
	int lp_cnt = 0;
	int	ret = TRUE;		

	if ((smtp_fl = fopen(fwd_name("SMTP","FWD"),"rt")) != NULL) {
		while (!rd_parse(tline,smtp_fl)) {
			if (wildmatch(fld[0],mmhs->bbs)) {
				if ((id = get_msgid(seqfname)) == ERROR) {
					perror("tomqueue(SEQUENCE.SEQ):\n");
					ret = ERROR;
					break;
				}
				sprintf(buf,"%s\\%ld.txt",mailqdir,id);

				if ((fp = fopen(buf,"w")) == NULL) {
					perror(buf);
					ret = ERROR;
					break;
				}
				tohost = fld[1];
				if (flds > 2) {
					if (stricmp("bbs",fld[2]) == 0) {
						relay++;
					} else {
						tohost = fld[2];
					}
				}
				lc(tohost);
		
				strcpy(fromcall,mmhs->from);
				*frombbs = '\0';

				rline(msgname(mmhs->number),fromcall,frombbs,NULL,NULL,NULL,NULL);	
				if (*fromcall == '\0')
					strcpy(fromcall,mmhs->from);
	
				strcpy(from,lc(fromcall));

				if (*frombbs != '\0') {
					strcat(from,"%");
					strcat(from,lc(frombbs));
					strcat(from,"@");
					strcat(from,smtphost);
				}
		
				if (relay) 
					strcpy(tocall,"bbs");
				else 
					strcpy(tocall,mmhs->to);
		
				fprintf(fp,"Date: %s\nMessage-Id: <%ld@%s>\nFrom: %s\nTo: %s@%s\n",
					arpadate(), id, smtphost, from, lc(tocall), tohost);

				if (relay) {
					fclose(fp);  /* encode the rli style in the msg body */
					export_msg(buf);
				} else {
					fprintf(fp,"Subject: %s\n\n",mmhs->title);
					fclose(fp);
					copfil(msgname(mmhs->number),buf,'A');
				}
				tprintf("Sending To: %s From: %s\n",to,from);				

				sprintf(buf,"%s/%ld.wrk",mailqdir,id);
				if ((fp = fopen(buf,"w")) == NULL) {
					perror(buf);
					ret = ERROR;
					break;
				}
				fprintf(fp,"%s\n%s\n%s\n",fld[1],from,to);
				fclose(fp);

				break;
			}
		}			
	}
	fclose(smtp_fl);
	return (ret);
} 

/*
	get_msgid() - read sequence.seq
*/
long get_msgid(fname)
char *fname;
{
	FILE *seqfil;
	long idno = 0;
	
	if ((seqfil = fopen(fname,"r")) != NULL) {
		fgets(line,LINELEN,seqfil);
		sscanf(line,"%ld",&idno);
		fclose(seqfil);
	}
	if ((seqfil = fopen(fname,"w")) == NULL) 
		return(ERROR);
	fprintf(seqfil,"%ld\n",++idno);
	fclose(seqfil);
	return(idno);
}
