#include "mb.h"
#include <dos.h>
#include <search.h>
#include <varargs.h>

#include "rose_ver.c"

#define	FREE -1

#define KILL TRUE
#define EDIT FALSE
#define PARSE	TRUE
#define NOPARSE	FALSE

USER_HEADER *nufhs, *ufhs;
USER_RECORD *tuser;
MAIL_HDR *mfhs;
FILE  *nufl, *ufl;

USER_HEADER header;

FILE *userfile, *outfile;
char workfile[128];
int cmplog(), cmptime(), cmpcall();


int dump 		= 0;
int edit 		= 0;
int init 		= 0;
int sort		= 0;
int verbose 	= 0;
int pid			= 0;
int	extended_list = 1;

char *tmpdir = ".";

char *fld[MAXFLDS];

char opt1, opt2, opt3, opt4;

int flds;

unsigned next_msg = 1;

char l_time[5];
char l_date[7];
char *line;
char *cmd;
char *prtuser();
int mfl;

#define CALL	3
#define TIME	4
#define LOG		5
char *uheader = "   CALL  Log Created   Last Logged    LOG#  HiMsg L/P BCSLXP";

main(argc,argv)
int argc;
char *argv[];
{

	int	next;
	int i;
	char *s, *outfil, c;
	FILE *ofil;

		
	printf("\n  ROSErver/PRMBS  User File Utility\n");
	printf(" Create / Display / Print / Edit / Compress\n");
	printf("         ver %s, %s\n",version,mbdate);
	line = mballoc(LINELEN);
	cmd  = mballoc(LINELEN);
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s != '\0'; s++) {
			switch (*s) {
			case 'd':
				dump++;
				ofil = stdout;
				break; 
			case 'e':
				edit++;
				break;
			case 'f':
				dump++;
				extended_list = 0;
				ofil = NULL;
				break; 
			case 'i':
				init++;
				break;
			case 'p':
				dump++;
				extended_list = 0;
				ofil = stdprn;
				break; 
			case 'v':
				verbose++;
				break;
			case 'x':
				extended_list= 1;
				break;
			}
		}

	}	
	ufhs  = (USER_HEADER *) mballoc(USER_RECSIZE);
	nufhs = (USER_HEADER *) mballoc(USER_RECSIZE);
	tuser = (USER_RECORD *) mballoc(USER_RECSIZE);
	mfhs  = (MAIL_HDR *) mballoc(MAIL_RECSIZE);


	if (edit) {
	  if (argc) {
	    init = 0;
		printf("\tFile - %s has %d users.\n",argv[0],opn_user(argv[0]));
		eduser(argv[0], argv[1]);
		fclose(ufl);

		printf("\n\n\tDo you wish to compress	user file ? ");
		while (TRUE) {
			if (kbstat()) {
		  		c = bdos(7,0,0);
		  		bdos(2,c,0);
				if ( toupper(c) !='Y' )
					exit(0);
				break;
			}
		}
	  } else {
	    dump_inst(3);
	  }
	}
	if (dump) {
	  if (argc) {
	    init = 0;
		printf("\tFile - %s has %d users.\n",argv[0],opn_user(argv[0]));
		if ((ofil == NULL) && 
			((ofil = fopen("userfile.txt","w")) == NULL)) {
			printf("\n\t\7*** ERROR Opening User Dump File - %s\n",outfil);
			exit(2);
		}
		duser(ofil);
		fclose(ofil);
		fclose(ufl);
		exit(0);
	  } else {
	  	dump_inst(2);
	  }
	}				
	if ( argc < 1 ) {
		dump_inst(1);
	}
	 
/************** enter critical section ***********************/
	strncpy(workfile,argv[0],63);
	if ((s = strchr(workfile,'.')) != NULL)
		*s = '\0';
	strcat(workfile,".$$");
	

	if (init) {
		usrinit(argv[0],argv[1],argv[2],(argc == 4) ? argv[3] : "");
		exit(0);
	}

	printf("\n\t*** Compressing the user file\n");

	unlink(workfile);	/* erase USER.BAK, ignore error	*/
	if ( rename(argv[0],workfile)) {
		printf("Error: can't rename %s to %s\n",argv[0],workfile);
		return(0);
	}
	ufl = fopen(workfile, "rb");
	if ( ufl == NULL) {
		printf("Error: can't open %s\n",workfile);
		return(0);
	}
	geturec(ufl, 0, (char *)ufhs);	/*  Read the mail file header */
	curtim();
	nufl = fopen(argv[0], "wb");
	if ( nufl == NULL ) {
		printf("Error: can't create %s\n",argv[0]);
		return(0);
	}

	fill(nufhs,'\0',USER_RECSIZE); 
	if (ufhs->version != USFL_VERSN ) {
		printf ("Wrong version!\7\n");
		exit(2);
	}
	nufhs->version = USFL_VERSN;	
	nufhs->count = 0;
	
	if (ufhs->cr_date[0] == '\0')
		strcpy(nufhs->cr_date, ufhs->date);
	else
		strcpy(nufhs->cr_date, ufhs->cr_date);
	strcpy(nufhs->date, l_date);
	strcpy(nufhs->time, l_time);
	puturec(nufl, 0, (char *)nufhs);


	for (next = 1; (next <= ufhs->count) && (next <= MAXUSERS); next++) {
		geturec(ufl,next,(char *)tuser);
		if (tuser->call[0] == '*') {
			if (verbose)
				printf("%6.6s - DELETED\n", tuser->call);
		} else {
			nufhs->count++;		/* make sure record numbers match */
			tuser->rn = nufhs->count;
		
			puturec(nufl,nufhs->count,(char *)tuser);
			if (verbose)
				printf("%6.6s written - %3x\n", tuser->call,nufhs->count);
		}
	}
	puturec(nufl, 0, (char *)nufhs);
	fclose(nufl);
/****************** exit  critical section ****************/
	free(nufhs);
	printf("\7\t*** done\n");
}

/*------------------------------------------------------------------------*/



curtim()
{
 struct tm *cur_time;
 long ltime;
	time(&ltime);
	cur_time = localtime(&ltime);	
	(void) sprintf(l_time,"%02d%02d",cur_time->tm_hour,cur_time->tm_min);
	(void) sprintf(l_date,"%02d%02d%02d",cur_time->tm_year,cur_time->tm_mon+1,
			cur_time->tm_mday);
       		/* month returned by localtime is 0-11 */
}


/*
	dump_inst() - displays 'usage' instructions
*/
dump_inst(code)
int code;
{
	fprintf(stderr," usage: roseuser [-defipv] userfile [sysopcall name1 name2]\n");
	fprintf(stderr,"   userfile - prmbs user file name\n");
	fprintf(stderr,"   sysopcall- call of the control op\n");
	fprintf(stderr,"   name1    - first name of control op\n");
	fprintf(stderr,"   name2    - last name\n");
	fprintf(stderr,"   -d       - display user file to screen\n");
	fprintf(stderr,"   -e       - edit user file (optional compress)\n");
	fprintf(stderr,"   -f       - display user file to file USERLIST.TXT\n");
	fprintf(stderr,"   -i       - initialize new user file\n");
	fprintf(stderr,"   -p       - display user file to printer\n");
	fprintf(stderr,"   -v       - verbose mode (talking while you work!)\n");
	fprintf(stderr,"   -x       - extended list - shows passwords and priveleges\n");
	fprintf(stderr," *** DO NOT RUN while BBS online in Multi-User Mode (%d)\n",
		code);

	exit(code);
}


/*************************************************************
 * duser() - print user records, LU command
 *************************************************************/
duser(dest)
FILE *dest;
{
	register int i;
	int page = 1000;
	
	if (dest == stdout)
		page = 22;
	if (dest == stdprn)
		page = 55;
		
	for (i = 0 ; i  < ufhs->count; i++) {
		if ((i % page) == 0){
			if ((i != 0) && (dest == stdin)) {
				printf("\n\t*** Hit any key to go on\n");
				while (!kbstat());
			}
			if (dest != stdout)
				fputc(0x0c,dest);
			fputs(uheader,dest);
			if (dest == stdprn)
				fputc(0x0d,dest);
		}
		geturec(ufl, i+1, (char *)tuser);
		fputs(prtuser(tuser,extended_list),dest);
		if (dest == stdprn)
			fputc(0x0d,dest);
	}
	if (dest != stdout)
		fputc(0x0c,dest);
	return(0);
}

/*************************************************************
 * eduser() - edit user records, EU command
 ************************************************************/
eduser(fname, fname2)
char *fname, *fname2;
{
	int i= 1;
	char c, *q, call[CALLLEN+1];
	
      while (i <=  ufhs->count) { 
		  if (geturec(ufl,i,(char *)tuser)) {
		      printf("Unexpected EOF, run ROSEUSER %s %s with no options to fix \7",
		      	fname, fname2);
		      break;
		  }
		  fputs(prtuser(tuser,extended_list),stdout);
		  fputs("b,e,k,q,?,[cr] : ",stdout);
		  while (TRUE) {
			  if (kbstat()) {
		  		c = bdos(7,0,0);
		  		bdos(2,c,0);
				if ( c != '\n' && c != '\r') {
					bdos (2,'\r',0);
					bdos (2,'\n',0);
				}
				break;
			  }
		  }
		  switch(c) {
		  case 'q':
			i = MAXUSERS;
			break;
	
	      case 'b':
			if (--i < 2) 
				i = 1;
			continue;
	 
		  case 'e':
			post_user(tuser,EDIT);
			break;
		
		  case 'k':
			post_user(tuser,KILL);
			break;
				
		  case '\r':
		  case ' ':	
			if ( ++i <= ufhs->count)
				continue;
			getedit("Enter new user call, (return to loop back):",stdout);
			if (!flds) {
				i = 1;
				continue;
			}
			strnxcat(call,pcall(line),CALLLEN);
			if (lookup_usr(call,tuser)) {
				fputs("\n\t\7*** Call already in file\n",stdout);
			} else {
				fill(tuser, '\0', USER_RECSIZE);
				curtim();
				strnxcat(tuser->call,call,CALLLEN);
				strcpy(tuser->time,l_time);
				strcpy(tuser->date,l_date);
				strcpy(tuser->cr_date,l_date);
				tuser->lines = 23;
				ufhs->count++;
				tuser->rn = ufhs->count;
				puturec(ufl, ufhs->count, tuser);
				puturec(ufl, 0 , ufhs);
				eurec(tuser);
				wrt_user(tuser);
				i = ufhs->count;
			}
			break;					
		  case '?':
			puts("[B]ackup one, [E]dit , [K]ill, [Q]uit, [?] help");
			break;
		  }
      }
  return(0);
}



/**************************************************************
 * eurec(u) - edit a user record that is in buffer u
 *************************************************************/
eurec(u)
register USER_RECORD *u;
{
	
	getedit("Alter Call:");
	if (flds) {
		strncpy(u->call,pcall(fld[0]), CALLLEN);
		if (u->options & U_BBS)
			strcpy(u->home_bbs,u->call);
        else
			u->home_bbs[0] = '\0';
	}		
    if (!getedit("Is BBS    :")) return;
    if (flds) {
        if (*fld[0] == 'Y') {
			u->options |= U_BBS; 
			if (u->home_bbs[0] == '\0')
				strcpy(u->home_bbs,u->call);
        } else {
			u->options &= ~U_BBS;  /* clear flag */
		}
	}

	if (u->options & U_BBS) {
	    if (!getedit("PRIME Cnct:")) return;
		if (flds)
		    if (*fld[0] == 'Y')	u->options |= U_PRIM_CON;
	   	 	else			u->options &= ~U_PRIM_CON;  /* clear flag */
	}
	

    if (!getedit("Is SYSOP  :")) return;
	if (flds)
	    if (*fld[0] == 'Y')	u->options |= U_SYSOP; 
    	else			u->options &= ~U_SYSOP;  /* clear flag */

    if (!getedit("EXCLUDE   :")) return;
    if (flds)
        if (*fld[0] == 'Y')	u->options |= U_EXCL; 
        else			u->options &= ~U_EXCL;  /* clear flag */

    if (!getedit("PROFILE   :")) return;
    if (flds)
        if (*fld[0] == 'Y')	u->options |= U_PROFILE; 
        else			u->options &= ~U_PROFILE;  /* clear flag */

    if (!getedit("Local User:")) return;
    if (flds)
        if (*fld[0] == 'Y')	u->options |= U_LOCAL; 
        else			u->options &= ~U_LOCAL;  

	if (!getfield("Name     :",u->handle,NAMELEN,NOPARSE))	return;
	if (!getfield("Password :",u->pswd,12,PARSE))			return;
/*
	if (!getfield("Language :",u->msg_fl,1,PARSE))			return;
*/	
	if ( getfield("Home BBS :",u->home_bbs,MTOLEN,PARSE)) {
		check_BBS(u->home_bbs);
	} else 													return;
	
	if (!getfield("Address  :",u->address,ADDRLEN,NOPARSE))		return;
	if (!getfield("City     :",u->qth,QTHLEN,NOPARSE))		return;
	if (!getfield("ZIP      :",u->zip,ZIPLEN,PARSE))		return;
	if (!getfield("Telephone:",u->phone,PHONELEN,NOPARSE))		return;
	
    if ( !getedit("Lines/Pg :")) 							return;
    if (flds)
    	u->lines 		= atoi(fld[0]);
    	
    if ( !getedit("HiMsg    :")) 							return;
    if (flds)
    	u->msg_number 	= atou(fld[0]);
	

}


/***************************************
 * fatal - printf to console  and exit 
 ***************************************/
/* VARARGS1 */
void
fatal(va_alist)
va_dcl
{
	char *fmt;
	va_list arg_ptr;
	extern int Debug;

	va_start(arg_ptr);
	fmt = va_arg(arg_ptr, char *);
	vprintf(fmt,arg_ptr);
	va_end(arg_ptr);
	exit(1);
}



/********************************************************************
 * getedit() prompt and input for editing
 ********************************************************************/
getedit(cp)
char *cp;
{
  fputs(cp,stdout);
  gets(line);
  parse(cmd,line);
  return (TRUE);
}
/*
	getfield(cp,dest,len) - get a field to be entered or blanked
*/
getfield(cp,dest,len,pars)
char *cp, *dest;
int len,pars;
{
	int ret;
	char *p;
	
	if (ret = getedit(cp)) {
		if (flds) {
			if (pars)
				p = fld[0];
			else
				p = line;
			strnxcat(dest,p,len);
		} else {
			if (*line == ' ')
				*dest = '\0';
		}
	}
	return (ret);
}


/********************************************************************
 * geturec() - read a record from an USER file
 ********************************************************************/
geturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs;
	int ret;
	offs = (long)rec * (long)USER_RECSIZE;
	if ( fseek(fid, offs, SEEK_SET)) {
		perror("geturec: fseek");
		exit(1);
	}
	ret = fread(buffer, USER_RECSIZE, 1, fid);
	if ( ret != 1 ) {
		fatal("geturec: read err on $%04x\n",rec);
	}
  return(0);
}

/*************************************************************
 * lookup_user() - look up user in user file
 *	returns index which is user record number, or FALSE
 * assume mail file is open
 *************************************************************/
lookup_usr(call, buf)
char *call;
USER_RECORD *buf;
{
  int i;
  char ucall[CALLLEN+1];

	sprintf(ucall,"%-6.6s",uc(call));

	DEBUG("lookup user %s\n",call);
	for (i = 1; i <= ufhs->count; i++) {
		geturec(ufl, i, (char *)buf);
		if (strnicmp(ucall, buf->call, CALLLEN) == 0) { 
				DEBUG("found user %s\n",call);
				break;
		}
	}
	if ( i > ufhs->count ) i = 0;
	return (i);
}


/*************************************************************
 * opnusr() - open user file,create if not, get header values
 *************************************************************/
opn_user(fname)
char *fname;
{
	/* Open the user file. If it does not exist, get out */
	if ((ufl = fopen(fname, "r+b")) == NULL) {
  		printf("\n\7 *** CANNOT FIND userfile - %s\n",fname);
  		exit (2);
	}

	geturec(ufl, 0, (char *)ufhs);	/* Read the user file header.  */
		/* in case user header is corrupted, don't hang		*/
	if (ufhs->count > MAXUSERS) 
		ufhs->count = MAXUSERS;
	return (ufhs->count);
}


/******************************************************************
 * parse() - copy input line to cmd buffer then parse by white
 *  space setting pointers for fld's 0-12 and opt1,2,3
 ******************************************************************/


parse(out, in)
register char *out, *in;
{
	int bl;

	bl = FALSE;
	flds = 0;

	while ( flds < MAXFLDS ) {
		if ( *in == '\0' || *in == '\n') {
			*out = '\0';
			break;
		}
		*out = toupper(*in);
		if (bl) { 
			if (*in <= ' ') {
				*out = '\0';
				if ( *in == '\0' ) break;
				bl = FALSE; *out = '\0';
			}  
			out++;
		} else { 
			if (*in >  ' ') {
				bl = TRUE; fld[flds++] = out++;
			}
		}
		in++;
	}

	for (bl=flds ; bl < MAXFLDS ; bl++ ) fld[bl] = "";
}


/*
	post_user() - lock a userfile, edit rec, write him up, and unlock
*/
post_user(buf,action)
USER_RECORD *buf;
int action;
{
	if (action == EDIT) {
	    eurec(buf);
	} else {
		buf->call[0]  = '*';
	}
    wrt_user(buf);

}


/*************************************************************
 * prtuser() - return user record print line for EU and DU commands
 *************************************************************/
char *prtuser(p,secure)
USER_RECORD *p;
int secure;
{
	static char buf[LINELEN];
	char *bbs_date();

	sprintf(buf,"\n%c %-6s %s", 
		(p->options & U_CHANGE_BBS) ? '+' : ' ', 
		p->call, bbs_date(p->cr_date));
		
	sprintf(buf,"%s  %s @ %sz %4d  %5u %3d",
		buf, bbs_date(p->date), p->time, 
		p->log_count,p->msg_number, p->lines);
		
	if (secure) {
		sprintf(buf,"%s %c%c%c%c%c%c [%s]", buf,
			(p->options & U_BBS)	  ? 'B' : ' ',
			(p->options & U_PRIM_CON) ? 'C' : ' ',
			(p->options & U_SYSOP)	  ? 'S' : ' ',
			(p->options & U_LOCAL)	  ? 'L' : ' ',
			(p->options & U_EXCL)	  ? 'X' : ' ',
			(p->options & U_PROFILE)  ? 'P' : ' ',
			p->pswd);
	}
		
	sprintf(buf,"%s\n        %s\n        @%s\n        %s\n        %s %s\n        %s\n",
		buf, p->handle, lc(p->home_bbs), p->address,p->qth, p->zip, p->phone);

	return(buf);
}

/********************************************************************
 * puturec() - write a record to a MB file
 ********************************************************************/
puturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs, off_ret;
	int ret;

	offs = (long)rec * (long)USER_RECSIZE;
	if ( fseek(fid, offs, SEEK_SET)) {
		perror("putrec: fseek");
		exit(1);
	}
	ret = fwrite(buffer, USER_RECSIZE, 1, fid);
	if ( ret != 1 ) {
		perror("puturec: fwrite");
		exit(1);
	}
	return (ret);
}
/********************************************************************
 * read_rec() - read a record from an MB file
 ********************************************************************/
read_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
  long lseek();
  long offs;
  int ret;

  offs = (long)rec * (long)MAIL_RECSIZE;
  if ( lseek(fid, offs, 0) == -1 ) {
	perror("lseek");
	exit(1);
  }
  ret = read(fid, buffer, MAIL_RECSIZE);
  if ( ret != MAIL_RECSIZE ) {
	fatal("error read_rec 0x%x - expected %d bytes got %d bytes\n",
	rec,MAIL_RECSIZE,ret);
  }
  return(0);
}


/*********************************************************************
 *  uc() - Uppercase a string.
 *********************************************************************/

char *uc(p)
char *p;
{
	register char *q;

	for(q=p ; *q; q++)
		*q = toupper(*q);
	return (p);
}


/*
	usrinit() - create new user file if one does not exist
	
*/
usrinit(usname,ocall,name1,name2) 
char *usname,*ocall,*name1,*name2;
{
	char *q;
	FILE *newufl;

	uc(usname);
    printf("\n\t\7 creating new user file - %s\n",usname);
    curtim();

	if ((newufl = fopen(usname, "w+b")) == NULL ) {
		fatal("Error: Can't create %s",usname);
	}

		/* make header record */
    fill (ufhs, '\0',USER_RECSIZE); 
    ufhs->count = 1;
    ufhs->version = USFL_VERSN;
    strcpy(ufhs->date, l_date);
    strcpy(ufhs->time, l_time);

		/* make sysops record */
	fill(tuser,'\0',USER_RECSIZE);

	strnxcat(tuser->call,pcall(ocall),CALLLEN);
	q = line + sprintf(line,"%s",name1);
	if (*name2)
		sprintf(q," %s",name2);
	strnxcat(tuser->handle,line,20);
    strcpy(tuser->date, l_date);
    strcpy(tuser->cr_date, l_date);
    strcpy(tuser->time, l_time);
	tuser->lines	= 23;
	tuser->rn = 1;
	tuser->options = U_BBS + U_SYSOP + U_CHANGE_BBS;
	strcpy(tuser->pswd,"PRMBS");
    puturec(newufl, 1, (char *)tuser);


		/* make KA2BQE record */
	if (stricmp(ocall,"KA2BQE") != 0) {
		fill(tuser,'\0',USER_RECSIZE);
		strcpy(tuser->call,"KA2BQE");
		strcpy(tuser->handle,"Brian Riley");
		strcpy(tuser->home_bbs,"ka2bqe.#nwvt.vt.usa");
		strcpy(tuser->address,"P.O. Box 188, Harvey Road");
		strcpy(tuser->qth,"Underhill Center,VT");
		strcpy(tuser->zip,"05490");
		strcpy(tuser->phone,"802-899-9922");
   		strcpy(tuser->date, l_date);
    	strcpy(tuser->cr_date, l_date);
    	strcpy(tuser->time, l_time);
		tuser->lines	= 23;
		tuser->rn = 2;
		tuser->options = U_BBS+U_CHANGE_BBS;
		strcpy(tuser->pswd,"PRMBS");
	    puturec(newufl, 2, (char *)tuser);
	    ufhs->count = 2;
	}
    puturec(newufl, 0, (char *)ufhs);
	fclose(newufl);
}


/********************************************************************
 * write_rec() - write a record to a MB file
 ********************************************************************/
write_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
	long lseek();
	long offs, off_ret;

	offs = (long)rec * (long)MAIL_RECSIZE;
	off_ret = lseek(fid, offs, 0);
	if (offs != off_ret) {
		perror("lseek");
		fatal("\n\n\7WRITE_REC - offset[%ld][%03x]\n",offs, rec);
	}
  return (write(fid, buffer, MAIL_RECSIZE) == MAIL_RECSIZE);
}


/*************************************************************
 * wrt_user() - write user record 
 *************************************************************/
void
wrt_user(buf)
USER_RECORD *buf;
{
	if (buf->rn == 0) return;
	if (buf->rn > MAXUSERS) {
		printf("wrt_user: record %u out of range\n",buf->rn);
		return;
	}
	puturec(ufl, buf->rn, (char *)buf);

}

/*
	check_BBS() - checks for string in file, if no file or no match
	returns FALSE, if match returns TRUE
*/
check_BBS(cp)
char *cp;
{
	FILE *strngfl;
	char tline[LINELEN];
	char *p;

		/* 
		   if its not null and has no '.' in it, at least it gets u-cased
		   and pcall()'ed since pointer 'cp' is acted upon directly
		*/
		
	if (*cp && (strchr(cp,'.') == NULL)) {
		pcall(cp);
		if (strngfl = fopen("sys\h_list.rs","rt")) {
			while (!rdline(tline,LINELEN,strngfl)) {
				if (p = strchr(tline,'.')) {
					*p = '\0';
					if (stricmp(cp,tline) == 0) {
						*p = '.';
						strnxcat(cp,remnl(tline),MTOLEN);
						break;
					}
				}
			}
			fclose(strngfl);
		}
	}

}

/**********************************************************************
 * pcall() - Parse trailing ssid from call.
 * store sid as small number in a character
 **********************************************************************/
char *pcall(cp)
char *cp;
{
	char *p;
	
	p = uc(cp);
	while(*p) {
		if (!isalnum(*p)) {
			*p = '\0';
			break;
		}
		p++;
	}
	return(cp);
}

