 page	60,132
;--------------------------------------------------------------------------
;   RATS - The Radio Amateurs Telecommunications Society
;			presents
;    [ROSERVER] - RATS Open System Environment Mail Server Program
;    [PRMBOX]   - Packet Radio MailBOX System 
;    created and written by Brian B. Riley, KA2BQE and Dave Trulli, NN2Z
;
;  All code contained herein is copyrighted by Brian B. Riley,
;  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
;  given in the procedure and or module headers for materials
;  gained from other sources
;
;  This code is freely given into the public domain for any and
;  all uses by such persons as so desire, with the proviso that
;  this code and subsequent code based on large fragments of it
;  must be distributed freely with the same proviso and copies of
;  this copyright notice.
;
;  The only rights to compensation anyone shall have for providing
;  this code or major recognizeable fragments thereof is for 
;  reasonable reimbursement for expense of delivery, to include 
;  telephone charges, media/package costs and/or postage.
;
;					Brian B. Riley, ka2bqe
;                                       P.O. Box 308
;					Medford, New Jersey 08055
;
;-----------------------------------------------------------------
; BRK.ASM   10/27/86
; by David Toth, VE3GYQ
; modified by nn2z
; These are C callable routines, called by
; brkoff()  --	to set ctrl-brk interrupt 35 (23h)
;		so that it is ignored and execution
;		continues.



IGROUP	GROUP	_TEXT,PROG
_TEXT	SEGMENT BYTE PUBLIC 'CODE'
_TEXT	ENDS
PROG	SEGMENT BYTE PUBLIC 'CODE'
	PUBLIC
	ASSUME	CS:IGROUP

	PUBLIC	_brkoff

_brkoff     proc near
	    push ds	       ;move code segment over to
	    push cs	       ; the data segment
	    pop  ds
	    mov dx,offset IGROUP:do_it
	    mov ah,25h	       ;fn 37 -- set interrupt vector
	    mov al,23h	       ;vector to change is 23h (35)
	    int 21h	       ;ctrl-brk routine is now at do_it
	    pop  ds
;	    ret
_brkoff     endp
;
do_it	    proc near
;	    iret 	       ;allows program to continue execution
do_it	    endp

;-------------------------------------------
; return status of keyboard without allowing
; CTRL-C to signal break.


	PUBLIC	_kbstat
_kbstat proc	near
		mov	ah,1
		int	16h
		mov	ax,0
		jz	kbout		;zero means no character available
		not	ax
kbout:
		ret
_kbstat endp



;-------------------------------------------------------
; COMM routines for use with X00.SYS FOSSIL Driver lev 5
; created 11/30/88 by Brian Riley KA2BQE
;-------------------------------------------------------
;
; sndbrk - sends break to port desired FOSSIL define break off, so this
;          is done here in ASM. MBBIOS defines it as a single call, so it
;          is done as a single io_bios() call in C in the IO routine
; sndbrk(port);
;
;	PUBLIC	_sndbrk
;_sndbrk proc	near
;		push 	bp
;		mov	bp,sp
;		mov	ah,1ah
;                mov     al,01
;		mov	dx, [bp+4]
;		int 14h
;		mov	cx,0
;brklp:		loop	brklp
;		mov	al,00
;		int 14h
;		mov	sp,bp
;		pop	bp
;		ret
;_sndbrk		endp

;-----------------------------------------------
; COMM routines by Dave Trulli, NN2Z for RATS
; modified 3/11/87 by Dave Trulli NN2Z
; modified 3/3/87 by Brian Riley KA2BQE
;-----------------------------------------------
;
; comin - reads on character from the com port
; comin(port);

	PUBLIC	_comin
_comin proc	near
		push 	bp
		mov	bp,sp
		mov	ah,2
		mov	dx, [bp+4]
		int 14h
		cbw
		mov	sp,bp
		pop	bp
		ret
_comin		endp







;----------------------------------------------
; comout - send a character to com port
; comout(port,c)

	PUBLIC	_comout
_comout proc	near
		push 	bp
		mov	bp,sp
		mov	dx, [bp+4]
		mov	ax, [bp+6]
		mov	ah,1
		int 14h
		mov	sp,bp
		pop	bp
		ret
_comout 	endp


; checks for a character waiting

	PUBLIC	_comstat
_comstat proc	near
		push 	bp
		mov	bp,sp
		mov	ah,3
		mov	dx, [bp+4]
		int 14h
		and	ax, 0100h
		mov	sp,bp
		pop	bp
		ret
_comstat 	endp

;-----------------------------------------
; check for tx ready
; that is buffer empty and CTS high
; corrections 11/8/87 <dtr/nn2z>

	PUBLIC	_comtxrdy
_comtxrdy proc	near
		push	bp
		mov	bp,sp
		mov	ah,3
		mov	dx, [bp+4]
		int 14h
		and	ax, 2010h
		cmp	ax, 2010h
		je	txstat
		mov	ax, 0
txstat:
		mov	sp,bp
		pop	bp
		ret
_comtxrdy 	endp

;-------------------------------------------
; chekdcd check for dcd present
; call with port id number (0,1,2,3 ..)
; modified 8/3/88 by Brian Riley KA2BQE

	PUBLIC	_chekdcd
_chekdcd proc	near
		push 	bp
		mov	bp,sp
		mov	ah,3
		mov	dx, [bp+4]
		int 14h
		and	ax, 0080h
		mov	sp,bp
		pop	bp
		ret
_chekdcd 	endp


PROG		ENDS
		end
