/*****************************************************************
 * MBUSER.H - 11/11/86 - Definitions for user file.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *  
 *  All code contained herein is copyrighted by Brian B. Riley, 
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials 
 *  gained from other sources
 *
 *  This code in generic IBMPC form for external TNCs attached to
 *  COM ports is freely given into the public domain for non-commer-
 *  cial use.
 *****************************************************************/

extern char *usfile;

#define USFL_VERSN 10

#define MAXUSERS 512
#define ZIPLEN	6
#define QTHLEN	24

typedef struct
{
	char	version;
	char	date[6+1];
	char	time[4+1];
	char 	unused1[1];
	short	count; 
	char	wp_date[6+1];
	char	unused2[9];
	char	cr_date[6+1];
	char	unused3[9];
	char	users[(CALLLEN+2+1)*MAXPROCS];
} USER_HEADER;

typedef struct
{
	short  		rn;    				/* Record number */
	char 		call[CALLLEN+2+1];
	char 		date[6+1];
	char 		time[4+1];
	char		cr_date[6+1];
#ifdef UNSGN
	unsigned int 	msg_number;
	unsigned int	numb2;
#endif
	long int	msg_number;
	char 		handle[21];
	char 		pswd[13];
	char		msg_fl[2];
	unsigned int	log_count;
	char 		home_bbs[MTOLEN+1];
	char 		qth[QTHLEN+1];
	char 		zip[ZIPLEN+1];
	short  		options;
	char		phone[PHONELEN+1];
	char		address[ADDRLEN+1];
	char		wp_update_type;
	char		xwp_field[XWPLEN+1];
	int			lines;	
} USER_RECORD;

#define USER_RECSIZE	256

extern USER_RECORD *tuser;

#define U_DELETE		    1
#define U_LOCAL			    2
#define U_BBS			    4
#define U_EXCL			    8


#define U_SYSOP			   32
#define U_OLD			   64
#define U_PRIM_CON		  128

#define U_XPRT			  256
#define U_ANSIC			  512
#define U_ANSIM 		 1024
#define U_C64			 2048

#define U_SWITCH		 4096
#define U_MODEM			 8192
#define U_CHANGE_BBS	16384
#define U_PROFILE		32768

extern void wrt_user();


#define issysop()	((port->mode & (SYSOP+EVENT)))
#define isbbs()		((port->user->options & U_BBS))
