/*****************************************************************
 *  MBTERM.C - 11/9/86 - Terminal emulators and things.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/

#include "mb.h"

char *chatfl = "chat_log.rs";

/*****************************************************************
 * lterm() - Console used as terminal to tnc.
 *****************************************************************/
lterm(argc,argv)
int argc;
char **argv;
{
  FILE *sfl = NULL;
  PORTS *mport, *sport;
  
  char *fname = NULL;
  char *tcall = NULL;
  char *tpath = NULL;

  char tline[32];
  char	*p, prtid, scrno;
  int raw_term, i;

	mport	= port;
    raw_term = (*argv[0] == 'T');
	scrno = '1';  
	p     = argv[1];
	prtid = *p;
	if (*++p)
		scrno = *p;
  
	switch (argc) {
		case 3:
			if (raw_term)	fname = argv[2];
			else 			tcall = argv[2];
			break;

		case 4:	 
			fname	= argv[3];
			tcall	= argv[2];
			break;

		case 5:
		case 6:
			if (*argv[3] != 'V')
				return (FALSE);
			scrno = '\0';
			tcall	= argv[2];
			tpath	= argv[4];
			if (argc == 6)
				fname	= argv[5];
			break;
	}

	if ((sport = findport(prtid)) == NULL) {
		return(0);
	} else {
		if (sport == mport) {
			prtx_err(MCANT);
  			return (0);
  		}
  	}
	if (fname != NULL)	
		sfl = sys_open(fname, "at"); 
	if (tcall != NULL) { 
		ioport(sport);
		if (tpath != NULL) 
			(void) tprintf("C %s V %s\n", tcall, tpath);
		else 
			if (!find_script(tcall,scrno) || !doscript()) {
				distnc(sport,FORCE_DISC);
				ioport(cport);
				return (0);
			}						
	}
	
	ioport(mport);
	token_lin = fname;
	if (sfl != NULL) 
		prtx("\n\t Terminal capture file - $S");
	sendnl();

	term(mport, sport, sfl,raw_term);

	sport->mode = IDLE;
	ioport(mport);
	if (sfl != NULL) {
		fclose(sfl);
		prtx("\n\t[ Closing file $S ]\n");
	}
	return (0);
	
}

/****************************************************************
 *  otalk() - Console broke in on a user.
 *	when you come out, CONN state is tested, each possible state
 *	requires  little more than the last so they fall through
 *	to the next.
 ****************************************************************/

otalk(tport)
PORTS *tport;
{
	char *s;
	
    ioport(tport);
    prtx_err(MBREAKIN);
    term(cport, tport, (FILE *)NULL,FALSE);
    ioport(tport);
	if (tport->type & P_TNC) {
	  	device_cmds(tport,tport->outof_trm);
		if (tncstate(tport,NULL) == TRUE ) /* done, lets see where we are */
		   	convtnc(1);
		else
			distnc(tport,FORCE_DISC);
		
	}
    break_in = FALSE;
}

/*******************************************************************
 *  General "do terminal" things.
 *******************************************************************/

term(mport, sport, trfl,rawterm)
PORTS *mport, *sport;
FILE *trfl;
int rawterm;
{
	char ch, pgetchar();
	PORTS *m1, *s1;
	
	if (mport == sport)	
		return;	/* no sense talkin to yourelf!! */

  	if (sport->type & P_TNC) {
		device_cmds(sport,sport->into_trm);
		if (!rawterm)
			device_cmds(sport,"CONV\n");
	}
	if (rawterm && sport->type & P_MDM)
		DTR_ON(sport->idn);
		
	m1 = mport;
	s1 = sport;

	while(TRUE) {
		ioport(m1);
		if (!(mport->type & P_CONSOLE) && !havedcd(mport))
			break; 
		if (instat()) {
			if ((ch = pgetchar()) == '\r') {
				bdos(2, ch, 0);		/*  charout, doesn't touch console so put
										one there without fear of dupe
									*/
				ch = '\n';
			}
			if (ch == ESC) 
				break; 
			if (m1->type & P_ECHO)
				charout(ch);
			ioport(s1);
			charout(ch);
			bdos(2, ch, 0);		/*  charout, doesn't touch console so put
									one there without fear of dupe
								*/
			if (trfl != NULL) 
				putc(ch, trfl);
    	}
    	if (m1 == mport) {
    		s1 = mport;
    		m1 = sport;
    	} else {
    		m1 = mport;
    		s1 = sport;
    	}
	}
	break_in = FALSE;
}

/******************************************************************
 *  User wants to talk to the console.
 ******************************************************************/
utalk()
{
	long	l;
	PORTS *tport;
  	extern int chatmode;
  	
	if ( !chatmode ) {
		prtx_err(MCHAT1);
		return(0);
	}

	tport = port;
	prtx_err(MCHAT2);
	ioport(cport);
	settmr(60);
	tprintf("(%s) %s\n",tport->user->handle,err_string(MCHAT3));
	while (l=chktmr()) {
		if (instat()) { 
			if (inchar() == ESC) {
				otalk(tport);
				return(0);
			}
		} else {
#ifndef NEEDSPACE
			if (!(l % 5)) con_beep();
#else
			if (!(l % 5)) bdos(2,'\7',0);
#endif

		}
	}
	ioport(tport);
	prtx_err(MCHAT4);
	fappend(fmt_token("$D/$T $U"),chatfl);
	return(0);
}

