/* 
   This code is to provide multi-user capability. It is rather
   heavily dependent upon DOS and either DOUBLEDOS or DESQVIEW
   for its pointers, but should work under AmigaDOS or UNIX
   these routines were created by NN2Z and altered for PRMBS by 
   KA2BQE.

*/

char *writelock;
char *userlock;
/*
** muinit() init the multiuser info
*/
void
muinit()
{
	extern int ismultitask();
	extern char *tmpdir;
	extern char *mak_alloc();
	
	char *which_tasker = "NO recognized";
	char *isactive = "not ";
	char tline[LINELEN];
	
	switch(MultiTasker = ismultitask()) {
	case	DOUBLEDOS:
		which_tasker = "DoubleDos";
		break;
	case	DESQVIEW:
		which_tasker = "DesqView";
		break;
	default:
		MultiTasker = NONE; /* force it to 'none' overide presence of prg */
	
	}

	printf("\n\t%s multitasking present",which_tasker);

	if ( multiuser ) {
		isactive = "";
		sprintf(tline,"%s\\mwrite.lck",tmpdir);
		writelock = mak_alloc(tline);
		sprintf(tline,"%s\\ufile.lck",tmpdir);
		userlock	= mak_alloc(tline);
	}

	printf("\n\tMultiuser is %sactivated  ProcessID = %d\n",isactive,pid);
	
}

/* obtain write lock  for mail file 
** exists with tsoff and file locked
*/
void
mwlock()
{
	int fd;
	int i = 512;
	if (multiuser) {
		while(--i ) {
			DEBUG("WRITE LOCK\n");
			tsoff();
			fd = open(WRITER, O_WRONLY|O_CREAT|O_EXCL, S_IWRITE|S_IREAD);
			if (fd == -1 && errno == EEXIST) {
				printf("mwlock: (%03d) %s busy\n", i, mbfile);
				tson();
				giveaway(5);
			} else {
				close(fd);
				break;
			}
		}
		if ( i == 0 )
			printf("mwlock: overriding lock\n");
	}
}

/*
	mulock() - remove write lock on mail file, resynchronize the mail header,
               and turns time-sharing back on
*/
void
mulock()
{
	if (multiuser) {
		DEBUG("WRITE UNLOCK\n");
		if ( unlink(WRITER))
			printf("non-fatal Error unlocking %s\n",WRITER);
		tson();
	}
}

/*
** create a read status lock for port a
*/
void 
rlock()
{
	int fd;

	open_mail();

	if (multiuser) {
		mwlock();
		mfhs->lock[pid] = 1;
		write_rec(mfl, 0, (char *)mfhs);
		resync();
		mulock();
	}
}

/*
** rulock - remove a read status lock for port a
*/
void
rulock()
{
	int ret;

	DEBUG("READ UNLOCK\n");
	if (multiuser) {
		mwlock();
		resync();
		mfhs->lock[pid] = 0;
		write_rec(mfl, 0, (char *)mfhs);
	}
	close_mail();
	mulock();

}

/* 
	resync() - get current header from mail file whle updating 
			   the dos file sizes
*/
void
resync()
{

	if (multiuser) {
		close_mail();
		open_mail();
	}
}

/*
** isreader() - check to see if any users are reading mail
** assumes - the header in memory is current. Should be run
** only while mail file is locked.
*/
isreader()
{
	register int i;
	if (multiuser) {
		rlock();
		for (i = 0 ; i < MAXPROCS; i++) {
			if ( i == pid )		/* skip my pid */
				continue;	

			if ( mfhs->lock[i] ) {
				return(TRUE);
			}
		}
		rulock();
	}
	return (FALSE);

}

	
