
/*****************************************************************
 *  MBMAIL4.H - 11/8/86
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *  
 *  All code contained herein is copyrighted by Brian B. Riley, 
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials 
 *  gained from other sources
 *
 *  This code in generic IBMPC form for external TNCs attached to
 *  COM ports is freely given into the public domain for non-commer-
 *  cial use.
 *****************************************************************/

/* Mail file header */
typedef struct
{
  short  next;     /* Next record to allocate */
  short  first;    /* First message header record */
  short  last;     /* Last message header record */
  short  ffree;    /* First record in free chain */
  short  lfree;    /* Last record in free chain */
  unsigned short  next_msg; /* Next message number */
  char version;
  short  free;     /* Number of records in free chain */
  short  count;    /* Number of messages */
  char date[6];
  char time[4];
  short  unt_msg;  /* next_msg at last untangle */
  unsigned short  fmsgno;  /* number of first active message in file */
  char lock[MAXPROCS];	   /* locking for multi-user */
  char unused[217];
} MAIL_HDR4;


/* Message hdr sector. */

typedef struct
{
  short  alt_ptr;   
  short  rn;    
  short  next;    /* Next message header record */
  unsigned short  number;  /* Message number */
  char	msgID[IDLEN+1];
  unsigned int size;
  char type;
  char stat;
  char to[CALLLEN+2+1];
  char bbs[MTOLEN+1];
  char unused2[32];
  char from[CALLLEN+2+1];
  char date[6+1];
  char time[4+1];
  char  fprty;	  /* forwarding priority and type	*/
  short  read;
  short  prev;    /* Previous message header record */
  short  flags;
  char distrib[16];
  char title[MHTITL+1];
  char route[9];
  char arrived[6+1];
  char unused[16];
} MSG_HDR4;




extern MAIL_HDR *mfhs;
extern MSG_HDR  *mmhs;

/*****************************************************************
 * numbers of relative messages for mail prompts in config file
 *****************************************************************/

#define MSG_TITL	0
#define MSG_TXT		1
#define MSG_UNRD	2

extern  int cremsg();
extern  int dist_lst();
extern  int dump_msg();
extern  void fil_req();
extern  int getrec();
extern  int kmsg();
extern  int msg2fil();
extern  int prtmsg();
extern  int parse_hdr();
extern  int untmsg();
extern  void write_hdr();
extern  void muinit();
extern  void mwlock();
extern  void mulock();
extern  void rlock();
extern  void rulock();
extern  void resync();
extern  char *arpadate();
extern  void preamble();
extern  char *ftos();
extern  void list_hdr();
extern  void read_hdr();

