/*************************************************************
 * MBMAIL1.C  07/01/87 - message creation procedures
 *************************************************************
 * PRMBS - Packet Radio Mailbox System  Copyright 1987
 *   by  Brian B. Riley (ka2bqe)
 *       Dave Trulli    (nn2z)
 * This code was initially based on a pre-release of the CBBS
 * code by W0RLI and VE3GYQ. It has been re-worked to the point
 * that only some structural resemblance remains. It is for the
 * most part orginal work of the authors, where other code has 
 * been incorporated appropriate credit is given.
 *    This code is hereby freely placed into the public domain
 * for use by any and all with the stipulations that (1) credit
 * line must be retained, both ours and in the case of other
 * code the appropriate authors and (2) no fee may be charged
 * for this code beyond simple expenses in transfer of the code
 * to another person to include postage, phone charges, media 
 * costs, mailers, etc)
 *************************************************************
 *
 * the function rline() is an important function in message creation
 * when responding to another message. (source for rline() is in header.c)
 *
 *  rline(message-file,fromcall,frombbs,tocall,subject,date, msgID)
 *  
 * the variables after the file name will have filled into them the
 * values stated. Most often it is used to find return path so the 
 * variable in position two is often a 'TO' variable which may seem
 * wrong, but we are taking the FROM value to be used as the TO of 
 * the returned message. IF the rline() call has a NULL for any field,
 * it will not be filled.
 *
 *************************************************************/ 

#include "mb.h"

#define MAIL	TRUE

#define USER		0
#define REQDIR		1
#define REQFIL		2
#define REQMSG  	3
#define REQUSR		4
#define	REQVER		5
#define RECHO		6
#define RMAIL_FUNC 	6
#define RMAIL   	7

#define	INT_FUNC	7		/* change this anytime something gets added */

#define REQWP		8	
#define REQLST  	9

#define	REQUNK	0
#define BINMSG	0
#define NOTPRM	0
#define REQBBS	0
#define REQDIG	0
#define REQFWD	0
#define REQQTH  0
#define REXEC	0

char *reqfuncs[] = {
	"NONSUP",	"REQDIR",	"REQFIL",	"REQMSG",	"REQUSR",
				"REQVER",	"ECHO",		"RMAIL",	"REXEC",
				"REQWP",	"REQLST",
				"" };

extern char ret_path[];

char *rt_edit[MAXEDIT];
char *rt_default;

char *EXstr			= "/EX\n";
char *EOMstr		= " <End of Message>\n";
char *sysop 		= "sysop";
char *BIDfile		= "msg_bid.rs";
char *rej_TO_file	= "rej_subj.rs";
char *rmlFIL		= "rmail.rs";	
char *reqFIL		= "remotreq.rs";	
char *zipFIL		= "zip_loc.rs";
char *hlFIL			= "h_list.rs";
char *hrFIL			= "hroutes.rs";
char *xltFIL		= "translate.rs";
char *holdFrom		= "holdfrom.rs";
char *holdTo		= "holdto.rs";
char *holdAt		= "holdat.rs";
char *fmt_token();

char xlat_fil[128];
char h_loc_fil[128];

char *add2date(), *get_addr();

int reqFilSiz = 0;

char *edit_route();
extern char *thisHost;
extern char msgID2[17];


char *chop_at();

/*
	check_for_call() - checks for FILE, returns ERROR if no file, returns
	TRUE for permission and false for no permission
*/
check_for_call(cp,fname)
char *fname, *cp;
{
	FILE	*prmsfl;
	char	bbscall[CALLLEN+1],	call1[16],	tline[LINELEN];
	char	*p;
	int		reject;
	
	strnxcat(bbscall,cp, CALLLEN);

	pcall(bbscall);
	
	if ((prmsfl = fopen(sys_name(fname,""),"rt")) == NULL)
		return (ERROR);

	while (!rd_parse(tline,prmsfl)) {
		p = fld[0];
		if (reject = (*p == '!')) 
			p++;
		if  (wildmatch(p,uc(bbscall))) {
			fclose(prmsfl);
			return (!reject);
		}
	}

	fclose(prmsfl);
	return (FALSE);
}

/*
	clean_address() - takes a full address, removes commas and places
	into the globals 'mto' and 'mbbs'
*/
clean_address(cp)
char *cp;
{
	char *p;
	
	remove_trail_char(cp, ',');
	strnxcat(mbbs,get_addr(cp),MTOLEN);
	
		/* 
			this cleans up for da dipshit who enters @wb2ibo-4.#nli.ny.usa 
			this cleans up the stray SSID and  ===>  @wb2ibo.#nli.ny.usa
			brute force, does it regardless whether '-4' is there or not
		*/
		
	if (p = chop_at(mbbs,'.')) 
		sprintf(mbbs,"%s.%s",pcall(mbbs),p);
	
	strnxcat(mto,cp,CALLLEN);
}

clear_msg_flds()
{
	mtyp		= ' ';
	mfprty		= ' ';
	*msgID		= '\0';
	*tobuf		= '\0';
	*mbbs		= '\0';
}

/*
	do_dist() - distribution
*/
do_dist(argc,argv)
int argc;
char **argv;
{
	char *fmt_token();
	
	unlink(msgtemp);
	
	parse_cmd(export,fmt_token("export $# distrb"));
	
	system(fmt_token("rmailer -r $# -w $! -d $< $5"));
	
	parse_cmd(import_msgs,fmt_token("import -i $!"));
	
	unlink(msgtmp2);

	return(0);		
}

/* 
	enter_make()
*/
enter_make(fname,ismail,local)
int ismail,local;
char *fname;
{
	char tbuf[2*CMDLEN];
	char *argv[16];
	int i, argc;
	int ret;
		
		/* tell the unwashed its time to send the text */
	if (smart_sys == ERROR) {
		prtx_err(MTXT);	
		outstr(mnend);
	}
		/* OK lets get the text file */
	if ((ret = uload(fname,local)) == TRUE ) {
		
		remove_trail_char(tobuf, ',');

		argc = parse_cpy(argv,tbuf,tobuf);	/* 	re-parse for additions since
												orginal entry and copy to 
												argv to preserve fields
											*/
		
		for (i=0 ; i<argc ; i++)  {
			clean_address(argv[i]);
			remove_trail_char(mbbs, '$');	/* in case of embedded BID
													in RMAIL message
											*/
			if (local)
				mak_loc_msg();
			if (ismail) {
				*msgID= '\0';
				mtyp = ' ';
			}
					
			resolv_msg(fname);

			if (ismail == RMAIL) 
				break;

					/* this kluge allows an SP REQVER @ ALLUSA */
			if ((stricmp(mto,"REQVER") == 0) && *mbbs) {
				*mbbs = '\0';
				resolv_msg(fname);
			}
				
		}
		unlink(fname);
	}
	return (ret);
	
}

/*
	get_addr() - extract call and bbs from a pointer to call@bbs string
				 modifies string presented, returns pointer to BBS call
				 or a NULL
*/

char *get_addr(cp)
char *cp;
{
	char *p, *q = "";
	
	if (p = strchr(cp,'@')) {
		*p = '\0';
		q = p+1;
	}

	if (strnicmp(cp,"***EOF",6) != 0	&& 
		strnicmp(cp,"*CONFI",6) != 0	){
		pcall(cp);
	}
	return (q);

}

/**********************************************************************
 * getmsgs() -  in reverse forwarding gets messages and checks for dis-
 *				connect and disk full
 **********************************************************************/
getmsgs(call)
char *call;
{
	int		msgcount = 0;
	char	tline[LINELEN];
	char	tcmd[LINELEN];
		
	rduser(call,port->user);
	
	while (port->mode & FORWARD) {

		disk_check(TRUE);

		if (getdat(tline,sizeof(tline)-1, port->timeout)) {
			parse(tcmd,tline);
			if (*fld[0] == 'S') {
				if (sndmsg(flds,fld) == ERROR) 
					break;
				msgcount++;
			} else {
				return(msgcount);
			}
			dsp_status();
			outstr("F>\n");
		} else {
			break;
		}

	}
	return (ERROR);
}


/*
	import_msgs() - get messages from plain ascii text file and
					insert into prmbs mail files. will 'eat' lines
					until it gets a 'S'end line. Then take 'S'end line
					then next line as title, then rest as message text
					looking for '/EX' to end. It will then resume looking
					for an 'S' line
*/
import_msgs(argc,argv)
int argc;
char **argv;
{
	FILE *imp_fil, *xfile;
	char *fst, *p;
	char tline[LINELEN];
	char tlin2[LINELEN];
	char tcmd[LINELEN];
	
	int  	i		=	1;
	short	distrib	= FALSE;
	short	ignore	= FALSE;

/*
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( p = argv[0]+1; *p != '\0'; p++) {
			switch(*p) {
			case 'I':
				ignore++;
				break;
			}
		}
	}
*/
	if (stricmp(argv[1],"-I") == 0) {
		i = 2;
		ignore++;
	}
			
	for (; i < argc ; i++) {

		if ((imp_fil = sys_open(argv[i],"rt")) == NULL)
			continue;
	
		while (!rdline(tline,LINELEN,imp_fil)) {
			if (toupper(tline[0]) != 'S') 
				continue;

			parse(tcmd,tline);
			islocal = pfld(flds,fld);

			if ((fst = fgets(tlin2,LINELEN,imp_fil)) == NULL) 
				continue;
			remnl(tlin2);
			strnxcat(mtitle,tlin2,MHTITL);

			xlat_addr(mto,mbbs,mtitle,mtyp,xlat_fil);
			
			if ((xfile = fopen(msgtemp,"wt")) == NULL) {
				fclose(imp_fil);
				return (ERROR);
			}
			while (!feof(imp_fil)) {
				if((fst = fgets(tline,sizeof(tline),imp_fil)) == NULL)
					continue;
				if (stricmp(tline,EXstr)  != 0) { 
					if (fputs(tline,xfile) == EOF) {
						token_lin = msgtemp;
						prtx_err(MSRVBLD);
						break;
					}
				} else {
					break;
				}
			}
			fclose(xfile);
		

			if ((*msgID == '\0')	|| strcmp(msgID,"$") == 0 		|| 
				ignore 				|| !check_string(msgID,BIDfile)	){
				resolv_msg(msgtemp);
					/* this kluge allows an SP REQVER @ ALLUSA */
				if (stricmp(mto,"REQVER") == 0 && *mbbs) {
					*mbbs = '\0';
					resolv_msg(msgtemp);
				}

			} else {
				token_lin = msgID;
				prtx_err(MIREJBID);
			}
			unlink(msgtemp);

			if (abort_dl()) 
				break;
		}			
		fclose(imp_fil);
	}
}					


/*******************************************************************
 * mail - send mail to multiple addresees
 ******************************************************************/
mail(argc,argv)
int argc;
char **argv;
{
	int i;
	char *p, *q, *arg1;
	char tbuf[LINELEN];
	int newonly = FALSE;
	int ismail = TRUE;


	*tobuf = '\0'; 	/* build 'tobuf' correcting sloppy addressing 		*/

	arg1 = argv[1];

	if (*argv[0] == 'M') {		/* MAIL command */
		if ( (argc == 1) || 
			 (argc == 2 && (newonly = (stricmp(arg1,"-n") == 0)))) {
			disp_edit("LM -m",newonly);
			return(0);
		}
	} else {					/* RMAIL command */
		if (*arg1 == '@')
			arg1++;
		ismail = RMAIL;
		sprintf(tbuf,"rmail@%s",(*arg1) ? arg1 : ocall);
		argv[1] = tbuf;
	}

		/* no point in going on if no space */

	if (!disk_full) {
	
		for ( i=1 ; i < argc; i++) {
			mak_to_at(mto,mbbs,argv[i]);
			mak_addr2(mto, mbbs);
		}
			/* prompt for title */
		prtx_err(MTTL);
	
			/* if we get it, go on with the rest */
		if (getdat(mtitle, sizeof(mtitle)-1, port->timeout)) 
			enter_make(msgtemp,ismail,TRUE);
	}	
	return(0);
}

/*
	mak_addr1() - make simple to address
*/
char *mak_addr1(to,at)
char *to, *at;
{
	static char tline[MTOLEN+CALLLEN+8+1];

	strcpy(tline,to);

	if (*at)
		(void) sprintf(tline,"%s@%s", tline, at);
	return(tline);
}



/*
	mak_addr2() - takes a string and makes a full address w/translation
	concatenates address string to 'tobuf'
	
*/
mak_addr2(to,at)
char *to, *at;
{
	int xlatd = FALSE;
	xlatd  =	xlat_addr(to,at,NULL,' ',usr_name(port->user->call,"XLT"));
	xlatd |=	xlat_addr(to,at,mtitle,mtyp,sys_name(xltFIL,""));

	
	strcat(tobuf,mak_addr1(to,at));
	strcat(tobuf,", ");
	return(xlatd);
}





/*
	mak_to_at() - 	takes a to@bbs string and sets it to the mto and 
					mbbs variables
*/
mak_to_at(to,at,cp)
char *to, *at, *cp;
{
		/*
			This will take          and make it
			   TO@BBS                 TO      BBS
			----------------------  --------------------
		 1)	N1XXX@W1YYY.XX.AAA      N1XXX   W1YYY.XX.AAA
			
		 2)	N1ZZZ-1@W1RRR.TT.BBB    N1ZZZ   W1RRR.TT.BBB
			
		 3)	N2AAA.BB.CCC            N2AAA   N2AAA.BB.CCC
			
		 4)	N3KKK                   N3KKK
		*/
	
	char *p;
	char *q = "";
	

	if (p = strchr(cp,'@')) {		/* if there is an @ mbbs is one past it */
		*p = '\0';
		q = p+1;
	} else {
		if (p = strchr(cp,'.')) /* no @, but a '.' so this case #3 above*/
			q = cp;	
	}
	strnxcat(at,q,MTOLEN);
	strnxcat(to,cp,CALLLEN);

}

/*
	mak_loc_msg() - make a local message, catchall, sets flags and does basic
					setup of standard form variables
*/
mak_loc_msg()
{
	islocal = TRUE;
	strcpy(handle,port->user->handle);
	strcpy(mfrom,port->user->call);
	mfprty	= ' ';
}



/*
	make_msg() - does setup and creation of message from file from command
				 line with no interaction (mostly for event processor)
*/ 
make_msg(argc,argv)
int argc;
char **argv;
{
	
	if (fil_xst(argv[1])) {

		clear_msg_flds();
		mak_loc_msg();
		
		if (*argv[0] == 'M') 
			strnxcat(mtitle,argv[3],MHTITL);
		else
			sprintf(mtitle,"FILE: %s",argv[1]);

		mak_to_at(mto,mbbs,argv[2]);
		mak_addr2(mto,mbbs);

		resolv_msg(argv[1]);
		
	}
}

/*
	make_reply() - build headers for reply to message
*/
make_reply(msgfname)
char *msgfname;
{

	clear_msg_flds();
	mak_loc_msg();

	strcpy(mto,mmhs->from);
	
	if (is_flood_route(mmhs->bbs) 						&& 
		get_yes_no(err_string(MREPLYBUL)) == TRUE		){
		strcpy(mto,mmhs->to);
		strcpy(mbbs,mmhs->bbs);
	} else {
		 /* figure how to send it back */
		(void) rline(msgfname,mto,mbbs,NULL,NULL);
	}	
	(void) tprintf("Reply to %s@%s\n",mto,mbbs);
}

/* 
	make_req() - setup a remote request message job for a remote system
*/
make_req(argc,argv)
int argc;
char **argv;
{
	char  c, *p;

	if (*argv[0] == 'F')
		argv[0] = "getusr";

	clear_msg_flds();
	mak_loc_msg();
	
	strnxcat(mto,argv[0],6);
	strncpy(mto,"req",3);
		

	if (stricmp(argv[0],"getver") == 0) {
		argv[2] = argv[1];
		argv[1] = "";
	}
	
	p = argv[2];
	
	while (*p == '@')	p++;
		
	strcpy(mbbs,p);

	strnxcat(mtitle,argv[1],MHTITL);
	mtyp = 'P';
	mak_addr2(mto,mbbs);
	unlink(msgtemp);
	fappend("",msgtemp);
	resolv_msg(msgtemp);
}


/*******************************************************************
 * msg2fil() - 'file' a message - lower level
 *******************************************************************/
msg2fil(fname,trlr_str)
char *fname, *trlr_str;
{
	token_lin = fname;
	prtx("Msg #$M filed to $S\n");

	token_lin = (port->mode & FORWARD) ? "DAEMON" : port->user->call;
	fappend(fmt_token("#--- Message #$M filed by $S, $3 ---"), fname);
	
	return(export_msg(fname,trlr_str));
	
} /* msg2fil */

/*************************************************************
 * pfld() - parse fields for message header from command line
 *          returns the value TRUE/FALSE for 'islocal'
 *************************************************************/
#define VALID TRUE
pfld(argc,argv)
int argc;
char **argv;
{
	register 	char *p;
	register	int i;
	char *get_addr(), typ;
 	int			local = TRUE;

	clear_msg_flds(); 	/* clear all the housekeeping parms */

	typ 		= argv[0][1];
	
	if (typ)
		mtyp	= typ;
		
	mak_to_at(mto,mbbs,argv[1]);
	pcall(mto);
	strcpy(mfrom, port->user->call);

	for (i = 2 ; i < argc ; i++) {
		p = argv[i];
		switch (*p++) {
			case '@':
				if (*mbbs)
					break;
				if (*p == '\0')
					p = argv[++i];
				strnxcat(mbbs, p, MTOLEN);
				break;
				
			case '<':
				if (*p == '\0')
					p = argv[++i];
				local = FALSE;
    			strnxcat(mfrom, pcall(p), CALLLEN);
				break;
				
			case '$':
				if (*p == '\0')
					p = "$";
				strnxcat(msgID,p,IDLEN);
				break;
				
		}	/* end switch */
	} /* end for */
	strcpy(handle,port->user->handle);	/* for headers */
	return (local);
}


#define APPEND_ID	TRUE
/*******************************************************************
 * resolv_msg() -  examine incoming message, detect and process remote
 * requests, resolve addresses and call the create message routine.
 *******************************************************************/
resolv_msg(infile)
char *infile;
{
	register char *p1, *p2;

	char	tline[2*LINELEN];
	char	tlin2[LINELEN];
	
	char 	*fname, *fnam2, *fst, *p, *q, *rfunc, savtyp;
	char 	*pruheader(), *prtuser();
	char 	*rstat;
	
	char	msg_id[IDLEN+1];
	char 	from_save[CALLLEN+1];
	char 	*argv[MAXFLDS];

	char 	*fmt_token();		

	int		argc;
	int		i,	ret;
	int		token	= USER;

	unsigned	nr;
	unsigned	filsiz;
		
	struct stat stbuf;
	

	fname = infile;

	/* check for a request to this system */

	
	if (strl2cmp(ocall,edit_route(mbbs,rt_edit)) == 0) {
		*mbbs =  '\0';

		for (i = RMAIL_FUNC ; i ; i--) {
			if (stricmp(mto,reqfuncs[i]) == 0) {
				token		= i;
				rfunc		= reqfuncs[i];
				break;
			}
		}

		if ( token > USER ) {

			tlin2[0]	= '\0';

			*tobuf = '\0';
			strcpy(msgID,"$");				/* want a new MID on message	*/

			strcpy(mto,mfrom);						/* over-ride from 822	*/
			rline(fname,mto,mbbs,NULL,NULL);	/* return path			*/

			strcpy(mfrom,ocall);
			strcpy(handle,"daemon"); 
			
			xlat_addr(mto,mbbs,NULL,' ',xlat_fil);
			unlink(fname);

			mtyp = 'P';
			
			islocal	= TRUE;

			rstat		= tline;
			token_lin	= tline;

			switch (token) {
						  	
			case REQDIR:
				if ((ret = mbDir_func(mtitle,FALSE,fname)) != 0)
					rstat = err_string(ret);
				else
					strcpy(rstat,mtitle);
				break;
	
			case REQFIL:
				if ( checkpath(fildir,mtitle,tline,0)) {
					rstat = err_string(MPERM);
				} else {
					if (filsiz = fil_xst(tline)) {
						if (reqFilSiz && filsiz > (unsigned) reqFilSiz) {
							rstat = err_string(MREQFSZ);
							fname = NULL;
						} else {
							sprintf(tlin2,"------ SOF : %s ------\n~GET %s\n------ EOF ------",
								tline,tline);
							fappend(tlin2,fname);
						}
					} else {
						rstat = err_string(MFILENF);
						fname = NULL;
					}
				}
				break;
	
			case REQUSR:
				strcpy(tline,mtitle);
				get_u_info(fname,pcall(tline));
				break;
	
			case REQVER:
			case RECHO:
				sprintf(tline,"Path: %s\n\n%s\n%s",
					ret_path, fmt_token("PRMBS ver $R $4"),
					prtuser(cport->user,FALSE));
				fappend(tline,fname);
				*tline = '\0';
					
				for (i=INT_FUNC; i; i--)
					sprintf(tline,"%s%s  ",tline,reqfuncs[i]);

				fappend(tline,fname);
				rstat = "System/Path Information";			
				break;
	
			case REQMSG:
				strnxcat(tline,uc(mtitle),IDLEN);
				if (find_MID(tline))
					msg2fil(fname,EOMstr);
				else
					fappend(err_string(MRQMSNF),fname);
				break;
					
/*				
				strcpy(tline,mtitle);
				flds = fsplit(tline,',',fld,12);
			  	for (i = 0 ; i < flds ; i++) {
					token_lin = fld[i];

					if (find_MID(token_lin))
						msg2fil(fname,EOMstr);
					else
						fappend(err_string(MRQMSNF),fname);
				} 
				strcpy(rstat,mtitle);
				break;
*/
				
	
			} /* end of case structure for 'token' */
	
			sprintf(mtitle,"%-.6s : %-.71s",rfunc,rstat);
			log('M','R','Q',mtitle);
			
		}
	}
	if (*tobuf == '\0')
		strcpy(tobuf,mak_addr1(mto,mbbs));
	cremsg(fname);
}

/****************************************
 * snd_reply() - send a reply to message 
 ****************************************/
snd_reply(argc,argv)
int argc;
char **argv;
{
	char tline[32];
	
	sprintf(tline,"sp #%s",argv[1]);
	parse_cmd(sndmsg,tline);
}


/******************************************************************
 * sndmsg() - send a message - either by hand or from other BBS
 *   returns ERROR for is disconnected or force disconnect
 *           TRUE  for ERROR message but no disconnect
 *           FALSE success condition
 ******************************************************************/
sndmsg(argc,argv)
int argc;
char **argv;
{
	unsigned msg;
	char *p;
	char *rep = "Re: ";
		
	if (disk_full) {
		if (port->mode != SYSOP) 
			port->mode = DISCON;
		return (ERROR);
	}

	p = argv[1];

	if (*p++ == '#') {				/* is it reply to message ? */
	
		if (*p) {
			msg = atou(p);
			if (getprev(msg+1) == 0) {
				message_stat(msg,mnfind);
				return (TRUE);
			}
		}


		make_reply(msgname(mmhs->number));	/* reply to message build headers */

		strcpy(mtitle,mmhs->title);
		if (strl2cmp(mmhs->title,rep) == 0) 
			rep = "";
		prepend(rep,mtitle,MHTITL);

	} else {
		
		islocal = pfld(argc,argv); 	/* parse fields to header variables and $BID */

		if (*mto == '\0')
			return(ERROR);

					/* check for TO fields to be rejected 	*/
		if (check_string(mto,sys_name(rej_TO_file,""))) {
			outstr(mtorej);
			return (FALSE);
		}

		if (*msgID) {
				/* check for duplicate BID				*/
			if ((*msgID != '$') && check_string(msgID,BIDfile)) {
				outstr(mdupe);
				return (FALSE);
			}
			
		}
		if (islocal) {
			if (strnicmp(mto,"ALL",3) == 0) {
				parse_cmd(readnews,"rn");
				token_lin = mto;
				if (!getedit(err_string(MBULSUBJ)))
					return(FALSE);
				if (flds)
					strnxcat(mto,pcall(fld[0]),CALLLEN);
			}
		}			
		if (smart_sys == ERROR)
			prtx_err(MTTL);
		else
			prtx("OK\n");

		if (getdat(mtitle, sizeof(mtitle)-1, port->timeout) == FALSE)
			return (ERROR);
	}
	
	mak_addr2(mto,mbbs);
	
	return (enter_make(msgtemp,FALSE,islocal));

}
/*
	is_sys_file() - test to see if sys file exists
*/

is_sys_file(cp,ext)
char *cp, *ext;
{
	return(fil_xst(sys_name(cp,ext)) > 0);
}

/*******************************
 * send message to the sysop 
 *******************************/
sysopmail(subject, msgtext)
char  *subject, *msgtext;
{
	
	unlink(msgtemp);
	fappend(msgtext,msgtemp);

	clear_msg_flds();
	mak_loc_msg();
	strcpy(mto,sysop);
	strcpy(tobuf,sysop);
	strcpy(mbbs,"");
	strcpy(handle,"daemon");
	strcpy(mtitle,subject);
	
	cremsg(msgtemp);
}

xlat_addr(tcall,tbbs,ttlstr,mmtype, fname)
char mmtype,*tcall, *tbbs, *ttlstr, *fname;
{
	FILE *trnsfl;

	int ret		= FALSE;
	int	found	= 0;
	int i;
	
	char *cp;
	char *tfcall, *ttcall, *tfbbs, *ttbbs;

		/* variables:  tc - compare value, tf - from value , tt - to value */

	char *strchr();
	char tline[LINELEN];
	char tlin2[LINELEN];

	check_BBS(tbbs);
	
	if (trnsfl = fopen(fname,"rt")) {
		while (!rd_parse(tline,trnsfl)) {
			tfbbs  = "";
			ttbbs  = "";
			tfcall = fld[0];
			ttcall = fld[1];
			
			if (cp = chop_at(tfcall,'@')) 
				tfbbs =	cp;

			if (cp = chop_at(ttcall,'@')) 
				ttbbs =	cp;

			if  (wildmatch(tfcall,tcall)) {

				if (wildmatch(tfbbs, tbbs)) {

					/* 
						if a third field specified in translate file the
						translation will occur only if it is found, case
						insensitive, in the title string
					*/
					
										
					if (flds > 2) {
						if (ttlstr == NULL || mmtype   != 'B')
							continue;

						strcpy(tlin2,ttlstr);
						uc(tlin2);

						found = 0;
						for (i=2 ; i<flds ; i++) {
							if (strstr(tlin2,uc(fld[i]))) {
								found++;
								break;
							}
						}
						if (!found)
							continue;
						
					}

					/* 
						if destination is "*" bring original across, if
						destination bbs is "*xxx.xxx.xxx" bring original
						and concatenate the remainder
					*/


					if (*ttcall != '*')			/* first do addressee	*/
						strcpy(tcall,ttcall);

					if (*ttbbs  == '*') { 		/* then do address		*/
						strcat(tbbs, ttbbs+1);
					} else {
						strcpy(tbbs, ttbbs);
					}
					
					ret = TRUE;			
				}
			}
		}
		fclose(trnsfl);
	}

	return(ret);
}

char *edit_route(bbs_route,editp)
char *bbs_route, **editp;
{
	int		h1count, i,j,k, done = FALSE;
	char	*h1ptr[16];
	static  char	buf[MTOLEN+1];

	strnxcat(buf,bbs_route, MTOLEN);
	h1count = ssplit(strupr(buf),'.',h1ptr);
	
	for (j = 0 ; !done && *editp[j]; j++ ) {
		for (i = h1count; i ; i-- ) {
			if (stricmp(h1ptr[i-1],editp[j]) == 0) {
				done = TRUE;
				*(h1ptr[i-1] - 1)  = '\0';
				h1count = i-1;
				break;
			}
		}
	}		
	return(buf);
}

char *set_route(bbs_route,editp)
char *bbs_route, **editp;
{
	int		h1count, h2count, i,j,k, found_match;
	int		done = FALSE;
	int		got_one = FALSE;
	FILE	*rfile;
	char	*h1ptr[16], *p, *match_point;
	char	*h2ptr[16];
	char	*edit_route();
	char	*e_route, tline[LINELEN];

	static char	route_name[CALLLEN+2+1];

	route_name[0] = '\0';

	if (*bbs_route) {
		e_route = edit_route(bbs_route,editp);
	
		h1count = ssplit(e_route,'.',h1ptr);
		j		= h1count - 1;
		strnxcat(route_name, rt_default,CALLLEN);
		if (rfile = sysdir_open(hrFIL,"rt")) {
			match_point = NULL;
			while (!rd_parse(tline,rfile)) {
				if (flds == 0)
					continue;
				h2count = ssplit(fld[0],'.',h2ptr);
				if (match_point == NULL) {
					k		= h2count - 1;
				} else {
					if ((p = strstr(fld[0],match_point)) == NULL)
						break;
					k = h2count - h1count + j;
				}
				while (j >= 0 && k >= 0) {
					if (stricmp(h1ptr[j],h2ptr[k]) == 0) {
						found_match = TRUE;
						strnxcat(route_name,fld[1],CALLLEN);
						match_point = h1ptr[j];
						j--;
						k--;
					} else {
						break;
					}
				}
			}			
			fclose(rfile);
		}
	}
	return(route_name);	
		
}


is_flood_route(cp)
char *cp;
{
	return(fil_xst(sys_name(cp,"FLD")));
}
