/*****************************************************************
 *  MBINIT.C - 11/12/86 - Read configuration file.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/

#include "mb.h"

char ocall[CALLLEN+1];
char ohandle[NAMELEN+1];
char oqth[QTHLEN+1];
char ozip[ZIPLEN+1];
char oreply[MTOLEN+1];
char *thisHost;
char *reply_to = NULL;
char *mwhat;
char *mdone;
char *mnfind;
char *mdupe;
char *mtxt;
char *mttl;
char *mnend;
char *mtorej;
char *tmpdir;
char *disp_stat;
char *mlogin;
char *mpasswd;
char *mkilld;
char *mperm;

extern char *rsys_pwd, *msgs_fil;
extern int rsysp_len;

char *mak_alloc(cp)
char *cp;
{
	char *t;
	
	t = (char *) mballoc (strlen(cp) + 1);
	strcpy (t, cp);
	return (t);

}
	
/*********************************************************************
 * rdmstr() - read a series of lines, terminated with "*** EOF"
 *********************************************************************/
char *getmstr(tfil)
FILE *tfil;
{
	short i;
	char *t;
	static char tcmd[4 * CMDLEN];	
	
	t = tcmd; 
	i = 4 * CMDLEN;
	while(i && !rdline (t, i, tfil)) {
		if(iseof(t))
			break;
		i -= strlen(t); 
		t += strlen(t);
	}
	*t = '\0';
	return(tcmd);
}

char *rdmstr(tfil)
FILE *tfil;
{
	return(mak_alloc(getmstr(tfil)));
}


/*********************************************************************
 * rdstr() - read in line from CONFIG, alloc space and set pointer
 *********************************************************************/

char *rdstr(tfil)
FILE *tfil;
{
	char *t;
	char tcmd[CMDLEN];
	rdline (tcmd, CMDLEN, tfil);
	return (mak_alloc(tcmd));
}


/*********************************************************************
 * rdstrnl() - same as rdstr() but strips new line from end
 *********************************************************************/
char *rdstrnl(tfil)
FILE *tfil;
{
	char *t;

	t = rdstr(tfil);
	remnl(t);
	return(t);
}

/*
	get_dirpath() gets and cleans up a directory path in CONFIG
*/

char *get_dirpath(tfil)
FILE *tfil;
{
	char *tdir, *p;
	
	tdir	 	= rdstrnl(tfil);
	
	if ((p = strrchr(tdir,'\\')) != NULL  && *(p+1) == '\0')
		*p = '\0';
	return (tdir);
	
}

/*
	get_filnam() - gets filename and removes any path
*/
char *get_filnam(tfil)
FILE *tfil;
{
	char *p, *q;
	
	p = rdstrnl(tfil);
	q = p;
	
	while (q = strchr(p,'\\')) 
		p = q+1;
	return(p);
}
		
/*
	get_table()	
*/

get_table(tfil,stbl,max)
FILE *tfil;
char **stbl;
int max;
{	
	char *p;
	int i;
	
	for (i = 0 ; i < max ; i++) {
		stbl[i]		= 	"";
		p			= 	rdstr(tfil);
		if (iseof(p))	
			break;
		stbl[i]		= 	remnl(p);
	}
	return(i);
}

/*********************************************************************
 * fget_yn() - (????) - reads a line - looks at char[0] for a 'Y'
 *********************************************************************/
fget_yn(tfil)
FILE *tfil;
{
	char tcmd[CMDLEN];
	rd_parse(tcmd,tfil);
	return(*fld[0] == 'Y');
}

/*********************************************************************
 * rdcnf() - read system message strings
 *********************************************************************/
rdcnf(tfil)
FILE *tfil;
{
	int i;
	
	char *p, *tail_ptr();
	char tline[LINELEN];
	char tcmd[CMDLEN];
		
	extern unsigned int reqfilSiz;
	extern char **hamcaltab, **servcaltab, *call_pats[];
			
	col_out	= rdstrnl(tfil);	/* ANSI Color string for MB output	*/
	stat_col= rdstrnl(tfil);	/* ANSI Color string for MB status Display	*/
	mbbusy	= rdmstr(tfil);	/* system busy banners */
	rmenus	= rdstr(tfil);	/* Menu for remote system, other bbs or user */
	symenu	= rdstr(tfil);	/* Remote sysop menu */
	disp_stat= rdstrnl(tfil);	/* local status display */
	tncsys	= rdmstr(tfil);	/* string to setup TNC for rem sysop	*/
	tncrem	= rdmstr(tfil);	/* string to restore normal remote	*/
	shutdown = rdmstr(tfil);	/* string to stop montor and conok off	*/

	thisHost	= rdstrnl(tfil);
	strnxcat(ocall,thisHost,CALLLEN);
	pcall(ocall);

	
	rt_default	= rdstrnl(tfil);	/* H-ROUTE default name	*/
	i = get_table(tfil,rt_edit,16);

	hamcaltab	= &call_pats[0];
	i			= get_table(tfil,hamcaltab,34);
	servcaltab	= &call_pats[i+1];
	i = get_table(tfil,servcaltab,34-i-1);
	
	/************************************************
	 * read in support directory pathes	
	 ************************************************/

	sysdir	= get_dirpath(tfil);	/* system file directory */
	usrdir	= get_dirpath(tfil);	/* user   file directory */
	fildir	= get_dirpath(tfil);	/* directory for files area */
	updir	= get_dirpath(tfil);	/* directory for file uploads */

	msgdir	= get_dirpath(tfil);
	/* temporary uploaded message text */
	tmpdir  = get_dirpath(tfil);

	i		= strlen(tmpdir)+10;
	msgtemp	= mballoc(i);
	msgtmp2	= mballoc(i);
	(void) sprintf(msgtemp,"%s\\RSXXXXXX",tmpdir);
	(void) sprintf(msgtmp2,"%s\\RYXXXXXX",tmpdir);
	mktemp(msgtemp);
	mktemp(msgtmp2);
		
	/************************************************
	 * read in support filenames, no paths, edited out	
	 ************************************************/

	helpfile	= get_filnam(tfil);	/* Mailbox help file	*/
	infofile	= get_filnam(tfil);	/* Information file		*/
	event_fil	= get_filnam(tfil);	/* event script file	*/
	callfil		= get_filnam(tfil);	/* call and script file */
	passwdf		= get_filnam(tfil);	/* password file		*/
	msgs_fil	= get_filnam(tfil); /* Messages.RS file		*/
	
	/************************************************
	 * read in support filenames with pathes allowed
	 ************************************************/

	lgfile		= rdstrnl(tfil);	/* ?????				*/
	mbfile		= rdstrnl(tfil);
	usfile		= rdstrnl(tfil);

}

/*********************************************************************
 * rdnumb () reads in a line, tales first string as a number
 *********************************************************************/
rdnumb(tfil)
FILE *tfil;
{
	char tcmd[LINELEN];
	
	rd_parse(tcmd,tfil);
	return (atoi (fld[0]));
}

/*********************************************************************
 * rdprts() read in CONFIG.MB and set up ports 
 *********************************************************************/
rdport(tfil)
FILE *tfil;
{
	char *lp, tline[LINELEN], tcmd[LINELEN];
	int start_port = FALSE;
	
	PORTS *p;


	while(!rdline (tline, LINELEN, tfil)) {
		if (iseof(tline))
    		break; 
    	parse(tcmd, tline);
		if (!start_port) {
			if (strcmp(fld[0],"PORT") != 0)
				continue;
		} else {
			if (strcmp(fld[0],"ENDPORT") == 0)
				return(TRUE);
			else
				continue;
		}

		start_port = TRUE;

		port = (PORTS *)	mballoc(sizeof(PORTS));
		fill(port,'\0',sizeof(PORTS));
		port->user = (USER_RECORD *) mballoc(USER_RECSIZE);


		port->id 	= *fld[1];
		port->idn	= (int) (port->id - 'A');

		lp = fld[2];

		while(*lp) {
			switch(*lp++) {
        	case 'B': 
        		port->type |= P_BBS;		break;
        	case 'C': 
        		port->type |= P_CONSOLE; 	
        		if (cport == NULL)
        			cport = port;	
        									break;
        	case 'H': 
        		port->type |= P_HAMCAL;		break;
	        case 'N': 
	        	port->type |= P_INACTIVE;	break;
        	case 'O': 
        		port->type |= P_OSRVCAL;	break;
        	case 'Z':
        		port->type |= P_BPQ_RET;
        	case 'Q': 
        		port->type |= P_BPQ;
        		if (qport == NULL)
        			qport = port;	
        									break;
        	case 'R': 
        		port->type |= P_REG;		break;
	        case 'T': 
	        	port->type |= P_TNC;		break;
	        	
					/* - by default a Modem port will 'echo'	*/
    	    case 'M': 
        		port->type |= P_MDM;
        	case 'E': 
        		port->type |= P_ECHO;		break;
      		}
    	}
		port->mode		= IDLE;
		port->timeout 	= 60 * atoi(fld[3]);
		port->baud		= atou(fld[4]);
		port->color 	= rdstrnl(tfil);

		if (port->type & P_TNC) {
			port->beacon	= fget_yn(tfil);
			rd_parse(tcmd,tfil);
			port->dl_size	= atoi(fld[0]);
			strcpy(port->dl_time,fld[1]);

			port->conn		= rdmstr(tfil);
			port->into_trm	= rdmstr(tfil);
			port->outof_trm	= rdmstr(tfil);
		}

		if (!(port->type & P_CONSOLE)) {
			passlst(tfil);					/* pass over the 'init' string */
			port->online	= rdmstr(tfil);
			rd_parse(tcmd,tfil);
			port->fwsize	= atoi(fld[0]);
			strncpy(port->fwtmr,fld[1],4);
		}

	}
	return(FALSE);
}

