
/*****************************************************************
 *  MBFILE.C - 11/8/86
 *****************************************************************
 * RATS - RLI - MAPRC  packet radio MailBox System (PRMBS)
 *	cotains updates by KA2BQE thru 12/23/86
 *****************************************************************/

#include "mb.h"

extern  char *EOMstr;
extern char *eat_white();

/*******************************************************************
 * exp_fil() - copy a text file in DOS directory
 *******************************************************************/

copfil(from_n,to_n,do_get)
int do_get;
char	*from_n, *to_n;
{
	FILE *in;  
	FILE *out;
	char buf[512], *fst;
	char tfname[128];
	extern char *mcreat;
	
	if ((in = sys_open(from_n,"rt")) == NULL) 
		return (FALSE);

	if ((out = sys_open(to_n, "at+" )) == NULL) {
		(void) fclose(in);
		return(ERROR);
	}
	while (!feof(in)) {
		if ((fst = fgets(buf,sizeof(buf),in)) == NULL) 
			continue;
		if ( do_get && (strnicmp(buf,"~GET",4) == 0)) {
			strcpy(tfname,eat_white(buf+4));
			fclose(out);
			if (!copfil(remnl(tfname),to_n,do_get)			||
				((out = sys_open(to_n, "at+")) == NULL)		){
				fclose(in);
				return(ERROR);
			}
			continue;
		} 
		if (fputs(buf,out) == EOF) {
			fclose(in);
			fclose(out);
			return (ERROR);
		}
	}
			
	fclose(in);
	fclose(out);
	return (TRUE);
}

/*******************************************************************
 * dnload() - dump a file to the active port, may be aborted from
 *		keyboard by CTRL-K
 *   The variables 'skip' and 'cut' are flags used to work up an
 *   ability for the user to select parts of the d/l to view. If
 *   he enters
 *      D FILE 400  will read 400 bytes and 'cut' off the rest
 *      D FILE -400 will 'skip' the first 400 bytes of the file and
 *                  read the rest
 *      D FILE 200 1300 will skip the first 200 bytes read the next
 *                  1100 bytes then 'cut' off the rest
 *-----------------------------------------------------------------
 * 02Sept87 |br| re-written completely 
 *******************************************************************/
dnload(argc,argv)
int argc;
char **argv;
{
	FILE *dlfl;
	char	*p, *fst, filname[132], *fname, *fmt_token();
	char tline[LINELEN];	

	int t;
	int	i = 1;
	long		int cnt	= 0;
	unsigned	int cut	= 0;
	int			lines	= 0;
	int			line_cnt= 0;

	p = argv[0];			
	if (*++p == '\0')
		*p = ' ';
	if (*argv[1] == '-') {
		cut = atou(argv[1]+1);
		i = 2;
	}
		
	if (port->mode == SYSOP)  {	 /* setup filename and/or validate path */
		strcpy(filname,argv[i]);
	} else {
		if ( checkpath(fildir,argv[i],filname,issysop())) {
			prtx_err(MILPATH);
			return(0);
		}
	}
	fname = filname;
	token_lin = fname;
	
	if (fil_xst(fname) == 0) { 		/* see if it even exists */
		prtx_err(MFILENF);
		return(FALSE);
	}

	log('F', 'D', *p, fname);

	switch (*p) {
	case 'A':
		unlink(msgtemp);
		system(fmt_token("rs_btoa $S $#"));
		fname = msgtemp;	/* re-assign name to file created by BTOA */
		break;
	case '_':
		break;
		
	case 'X':			
	case 'Y':			
	case 'Z':			
		do_modem(argv[0],fname);
		return (FALSE);
	}		


	lines = port->user->lines;
			

	if (dlfl = sys_open(fname, "rt"))  {

		setcolor(col_out);	/* if color, output color seq */
		while (!feof(dlfl)) {
			if ((fst = fgets(tline,LINELEN-1,dlfl)) == NULL)
				continue;	
			line_cnt++;
			if (cut && cut > line_cnt)
				continue;
			if (abort_dl() || paging(&lines,line_cnt,smart_sys==ERROR)) 
				break;
			outstr(tline);
			cnt	+= strlen(tline);
			if (port->dl_size && chktime(port->dl_time)) {
				if (cnt > port->dl_size) {
					prtx_err(MDNLWND);
					break;
				}
			}	
			
		}
	}
	(void) fclose (dlfl);
	setcolor(port->color); /* if color, output color seq */
	unlink(msgtemp);
	return (FALSE);
}

/*
	do_modem() - modem protocolled upload/download
*/
do_modem(comnd,fname)
char *comnd, *fname;
{	
	char mode, tline[LINELEN], *p;
	
	if (port->type & (P_CONSOLE|P_TNC)) {
		prtx_err(MNODSZ);
		return(ERROR);
	}
	sprintf(tline,"rsmdmxfr %s %d %s %s",
			comnd,port->idn+1,fname,port->user->call);
	system(tline);

	if ((mode == 'U') && fil_xst(fname) == 0)
		return (FALSE);
	return (TRUE);
}
	     	

/*******************************************************************
 * port_dump() - send a file to a port
 *******************************************************************/
 port_dump(argc,argv)
 int argc;
 char **argv;
 {
	PORTS *tp, *was;
	
	was = port;		/* save off a port 					*/
	
	if (tp = findport(*argv[1])) {
		ioport(tp);
		read_fil(argv[2],TRUE);
		eatChars();	/* clean out generated responses	*/
	}
	port = was;		/* restore port pointer 			*/
	return (0);
}

/*******************************************************************
 * read_fil() - dump a file to the active port, may be aborted from
 *		keyboard by ESC
 *******************************************************************/
read_fil(fname,show_hdr)
short show_hdr;
char *fname;
{
	FILE *rffl;
	char *fst;
	int t;
	int	ret = FALSE;
	char tline[LINELEN];
	char tfname[128];
	char *eat_white();
	int line_cnt = 0;
	int	lines;
	
	lines = port->user->lines;
		

	if (rffl = sys_open(fname, "rt"))  {

		if (show_hdr == 0)
			while (is_R_hdr(rffl,tline,LINELEN));
		else 
			fst = fgets(tline,LINELEN-1,rffl);

		setcolor(col_out);	/* if color, output color seq */

		ret = TRUE;

		while (!feof(rffl)) {
			if (strnicmp(tline,"~GET",4) == 0) {
				strcpy(tfname,eat_white(tline+4));
				if (!read_fil(remnl(tfname),show_hdr))
					outstr(tline);
			} else {
				if (strnicmp(tline,"/EX",3) == 0)
					outchar('\\');
				outstr(tline);
			}
			fst = fgets(tline,LINELEN-1,rffl);	
			if (abort_dl() || paging(&lines,++line_cnt,smart_sys==ERROR)) {
				ret = ERROR;
				break;
			}
		}
		(void) fclose (rffl);
		setcolor(port->color); /* if color, output color seq */
	}
	return (ret);
}

/*******************************************************************
 * uload() -  upload text into a file
 *		mail escape options if escape is set
 *	this is becoming more of a mail command
 *	should be moved to mbmail2.c and a dumb upload left here for files
 *******************************************************************/
uload(fname,escape)
char *fname;
int escape;
{
	register char *p;

	FILE *upfl, *infl;
	char tline[BUFLEN];
	char name[80];
	int ret = TRUE;
	char c;
	unsigned int msg_rec;
	unsigned int msgr_save;
	long 	msgn_save;
	long	filsiz = 0; 
	long	diskSpace();
	long	int fil_xst();
	
	if ( (upfl = sys_open(fname, "w+")) == NULL ) 
		return(FALSE);

	while (ret == TRUE) {
		if (!getdat(tline, sizeof(tline)-1, port->timeout)) {
			ret = ERROR;
			break;
		}
		if (stricmp(tline,"/ex") == 0
		|| (stricmp(tline,".") == 0 && escape)) /* disable '.' when ~local */
			break;
		
		if (stricmp(tline,"/abort") == 0) {
			ret = FALSE;
			break;
		}

		filsiz += strlen(tline);

		if ((port->id != 'L') 			&& 
			(filsiz % 4096 < 60)		&&
			(diskSpace(0) < (long) min_disk)	){
				port->mode = DISCON;
/*
				log('X','Z', ' ', "");
*/
				ret = ERROR;
				break;
			}
		/* catch a control z other than at the start of a line */
		if ( !escape || ( escape && tline[0] != '~')) {
			if ( (p = strchr(tline,CPMEOF)) != NULL) {
				*p = '\0';
				fprintf(upfl,"%s\n",tline);
				break;
			} else {
				fprintf(upfl,"%s\n",tline);
			}
		} else {
			strupr(tline);
			c = tline[1];
			p = eat_white(&tline[2]);	/* eat white space */
			msgr_save = mmhs->rn;     /* save where we were */
			msgn_save = mmhs->number; /* save where we were */
			switch(c) {
			case 'C':
				mak_to_at(mto,mbbs,p);
				mak_addr2(mto,mbbs);
				break;

			case 'M':
/*
				if ( *p == '\0') 
					prtx_err(MMNREQ);
				else {
*/
					msg_rec = atou(p);
					
					if (getprev(msg_rec+1)) {
						fclose(upfl);
						msg2fil(fname,EOMstr);
						if ((upfl = sys_open(fname, "at+")) == NULL ) 
							ret = FALSE;
					} else {
						message_stat(msg_rec,mnfind);
					}
					getprev(msgr_save+1); /* back where we started */
/*
				}
*/
				break;

			case 'Q':
				prtx_err(MCANCL);
				ret = FALSE;
				break;

			case 'R':
/*
				if ( *p == '\0') { 
					prtx_err(MNFNS);
					break;
				} else {
*/
					if (checkpath(updir,p,name,issysop()) || 
					    (infl = fopen(name,"rt")) == NULL) {
						token_lin = name;
						prtx_err(MFILENF);
						break;
					} 
/*
				}
*/
			case 'S':
				if (c == 'S') {
					if ((infl = fopen(usr_name(port->user->call,"SGN"),"rt")) == NULL) {
						prtx_err(MNSGNF);
						break;
					}
				}
				while( (c = getc(infl)) != EOF)
					putc(c,upfl);
				fclose(infl);
				break;

				/* these all require close file and re-open to append */
			case '!':				/* drop to DOS */
			case 'E':				/* drop to DOS Text EDitor */
				if ( port != cport ) {
					prtx_err(MMBCON);
					break;
				}
				fclose(upfl);
				if (c == '!') {		/* drop to DOS */
					dos_cmd(p);
					break;
				}

			case 'P':				/* display current file so far */
				if (c == 'P') {
					fclose(upfl);
					tprintf("------\nTo: %s\nSubject: %s\n", tobuf, mtitle);
					read_fil(fname,TRUE);
				} else {
					edit(fname);
				}
				if ((upfl = sys_open(fname, "at+")) == NULL ) 
					ret = FALSE;
				break;

			case 'O':				/* display message being replied to */
				read_fil(msgname(msgn_save),*p == 'V');
				break;
								
			case '?': 
				prtx_err(MTILMNU);
				break;

			case '~':
				fprintf(upfl,"%s\n",p-1);
				break;

			case 'G':
				if (port->mode & SYSOP) {
					fprintf(upfl,"%s\n",tline);
					break;
				}
			
			default:
				prtx_err(MINVESC);
			}

			if (ret)
				prtx_err(MMSGCONT);
		}
	}
	(void) fclose(upfl);
	if (ret != TRUE )
		unlink(fname);
	return (ret);
}


/*******************************************************************
 * upload() - file upload, top level routine
 *******************************************************************/
/* ARGSUSED */
upload(argc,argv)
int argc;
char **argv;
{
	char name[80];
	char name2[80];
	char tline1[LINELEN];
	char tline2[LINELEN];
	char *fname, *cp, *fpath, *p;
	char *rslt_str = "failed";
	
	int result;
		
	FILE *fp;
	name[0] = '\0';

	p = argv[0];
	if (*++p == '\0')
		*p = ' ';
		
	
	if (disk_full && (port->mode != SYSOP)) {
		port->mode = DISCON;
		return (FALSE);
	}

	if ( checkpath(updir,argv[1],name,issysop())) {
		prtx_err(MILPATH);
		return(FALSE);
	}

	if (access(name,0) == 0) {
		prtx_err(MEXST);
	} else {
		prtx_err(MEDESC);
		if (!getdat(tline1,sizeof(tline1)-1, port->timeout))
			return(FALSE);
		if (argv[0][1] != ' ') {
			result = do_modem(argv[0],name);
		} else {
			prtx_err(MFSEND);
			outstr(mnend);
			result = uload(name,0);
		}
		if (result) {
			rlock();			/* Lock Mail file for sysop message */
			sprintf(tline2,"File: %s uploaded by %6.6s\n\nDescription:\n %s\n",
					name,port->user->call,tline1);
			sysopmail("File upload",tline2);

				/* this places the description in a file */
			strcpy(name2,name);
			
			if (cp = strrchr(name2,'\\')) {
				*cp++ = '\0';
				fname = cp;
				fpath = name2;
			} else {
				fname = name2;
				fpath = ".";
			}

			rslt_str = name;

			sprintf(tline2,"%-12.12s : %7ld BYTES %-.50s\n",
				uc(fname),fil_xst(name),tline1);
			sprintf(name2,"%s\\FILEDIR.TXT",fpath);
			fappend(tline2,name2);
			if (strlen(tline1) > 50) {
				sprintf(tline2,"             : %-.64s",tline1+50);
				fappend(tline2,name2);
			}		
			rulock();			/* Un-Lock Mail file for sysop message */
		} else	{
			unlink(name);
		}
	}
	log('F','U',*p,rslt_str);
	return (FALSE);
}


/**********************************
 * check for valid path name
 **********************************/
checkpath(root,inpath,outpath,sysop)
char *root, *inpath, *outpath;
int sysop;
{
	register char *lptr;
	/* translate slashes to back slashes */
	lptr = inpath;
	while (*lptr) {
		if (*lptr == '/')
			*lptr = '\\';
		lptr++;
	}
	
	/* let sysop go anywhere */
	if (sysop) {
		strcpy(outpath,inpath);
	} else {
		(void) sprintf(outpath,"%s\\%s",root,inpath);
		if ( strstr(inpath,"..") != NULL 
			|| inpath[0] == '\\'
			|| inpath[1] == ':')    /* or other drives */
			return(1);
	}
	return(0);
}

edit(fname)
char *fname;
{
	char *ed;
	int ret= ERROR;
	char buf[80];
	
	ed = getenv("ED");
	if (ed == NULL || *ed == '\0') {
		prtx_err(MNOEDIT);
	} else {
		/* call editor */
		sprintf(buf,"%s %s",ed,fname);
		if (system(buf)) {
			perror(buf);
		} else
			ret = 0;
	}
	return(ret);

}


/*******************************************************************
 * fappend() - append a string to a text file
 *******************************************************************/
 fappend(cp,fname)
 char *cp, *fname;
 {
	FILE *sfl;

	if ((sfl = fopen(fname,"at+")) == NULL ) 
		return (FALSE);

 	fprintf(sfl, "%s\n",cp);
    (void) fclose(sfl);
	return (TRUE);
 }



/*
	fil_name() - generate a system file name with extension
*/
char *fil_name(dir,cp,ext)
char *cp, *ext;
{
	static char buf[128];

	(void) sprintf(buf,"%s\\%s",dir,cp);
	if (*ext) {
		strcat(buf,".");
		strcat(buf,ext);
	}
	return(buf);
}

char *sys_name(cp,ext)
char *cp, *ext;
{
	return(fil_name(sysdir,cp,ext));
	
}

FILE *sys_open(fname,md)
char *fname, *md;
{
	FILE *fptr;
	char c;

	if ((fptr = fopen(fname,md)) == NULL) {
		c = toupper(*md);
		token_lin = fname;
		if ( c == 'R')
			prtx_err(MFILENF);
		else
			prtx_err(MCREAT);
	}
	return (fptr);
}

FILE *sysdir_open(fname,md)
char *fname, *md;
{
	return(sys_open(sys_name(fname,""),md));
}

char *usr_name(cp,ext)
char *cp, *ext;
{
	
	return(fil_name(usrdir,cp,ext));
	
}

 
usys_file(argc,argv)
int argc;
char **argv;
{
	char *fname, *ext;
	int	msgno;
	
	switch (*argv[1]) {
	case 'S':
		ext 	= "SGN";
		msgno	= MUSGN;
		break;
	case 'T':
		ext 	= "XLT";
		msgno	= MUXLT;
		break;
	case 'F':
		ext 	= "FNG";
		msgno	= MUFNG;
		break;
	default:
		return(ERROR);
	}
	
/*	
	if (strl2cmp("signiture",argv[1]) == 0) {
		ext 	= "SGN";
		msgno	= MUSGN;
	} else {
		if (strl2cmp("translate",argv[1]) == 0) {
			ext 	= "XLT";
			msgno	= MUXLT;
		} else {
			if (strl2cmp("finger",argv[1]) == 0) {
				ext 	= "FNG";
				msgno	= MUFNG;
			} else {
				return(ERROR);
			}
		}
	}
*/
	
	prtx_err(msgno);
	outstr(mnend);
	
	if (uload(msgtemp,FALSE)) {
		fname = usr_name(port->user->call,ext);
		unlink(fname);						/* remove old file			*/
		copfil(msgtemp,fname,FALSE);	/* replace with new file	*/
	}
	return (0);
}
