/*****************************************************************
 *  MB.H - 11/16/86 - Definitions for MailBox.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/



			/*  General includes. */

#define CALLLEN 6
#define FWDLEN 80
#define NAMELEN		20
#define MHTITL		80
#define MTOLEN		32
#define IDLEN		12
#define KEYLEN		60
#define PHONELEN	12
#define ADDRLEN		32
#define XWPLEN		48
#define USRCONLEN	40

#define MAXPROCS	8
#define MAXEDIT		33
#define MAXFLDS 	16


#ifdef DEBUGON
#define DEBUG dbprintf
#else
#define DEBUG
#endif

#define lc strlwr
#define uc strupr

#include "mbuser.h"
#include "rosemsgs.h"
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>


extern void brkoff();
extern void brkon();
extern char *chop_at();
extern void ctos();
extern long diskSpace();
extern char *doDir();
extern char *eat_white();
extern char *err_string();
extern void fatal();
extern char *fgets();
extern long fil_xst();
extern void flow_on();
extern void flow_off();
extern char inchar();
extern char *islink();
extern char *lc();
extern int  kbstat();
extern void log();
extern int  logout();
extern char *mballoc();
extern char *msgname();
extern char *sys_name();
extern char *usr_name();
extern void outchar();
extern char *pcall();
extern char *remnl();
extern void sendbreak();
extern char *tail_ptr();
extern char *uc();
extern void waitcon();
extern FILE *sys_open();
extern FILE *sysdir_open();


extern int bye_bye();
extern int chk_usr();
extern int ch_baud();
extern int cmdlist();
extern int cleankilled();
extern int debugmode();
extern int dofwd();
extern int done();
extern int d_vers();
extern int dist_lst();
extern int disp_subj();
extern int dnload();
extern int doDoors();
extern int dos_cmd();
extern int do_dist();
extern int do_help();
extern int delfiles();
extern int duser();
extern int e1msg();
extern int edmsg();
extern int eduser();
extern int export();
extern int rs_event();
extern int file();
extern int fil_info();
extern int flood_all();
extern int get_msg();
extern int make_msg();
extern int make_req();
extern int multi_msg();
extern int multi_msgop();
extern int import_msgs();
extern int kill_trfc();
extern int krmsgm();
extern int kdmsg();
extern int kfmsg();
extern int logout();
extern int lstmsg();
extern int lstmsg1();
extern int mail();
extern int lterm();
extern int mbDir();
extern int mb_exit();
extern int mkstring();
extern int home();
extern int mksys();
extern int port_dump();
extern int parm_chang();
extern int prthrd();
extern int put_file();
extern int readnews();
extern int reverse();
extern int scan_hdr();
extern int server();
extern int setmsg();
extern int smsg3();
extern int sndmsg();
extern int snd_reply();
extern int stats();
extern int swap();
extern int untmsg();
extern int untusr();
extern int upload();
extern int utalk();
extern int usys_file();



#define TCNET		 5
#define RLI_CODE	 4
#define PRMBS		 3
#define OTHER		 2
#define TRUE		 1
#define	FALSE		 0
#define ERROR		-1
#define RESETIME	-2
#define match !strcmp
#define matchn !strncmp

#define CMD    TRUE
#define NOCMD  FALSE
#define CONV	2
#define WAIT	TRUE
#define NOWAIT	FALSE

#define NONE		0
#define DOUBLEDOS	1
#define DESQVIEW	2


#define LKMSG	TRUE		/* command table flag for locking 	*/
#define NOLOK	FALSE		/* locking not needed				*/


#define	SET_HOME	TRUE	/* defines for home_space() and save_space() */
#define	GO_HOME		FALSE	/* used to move among directories			 */
#define SET_SP		TRUE
#define	GET_SP		FALSE

extern char *writelock;
extern char *userlock;

#define WRITER writelock
#define ULOCKF userlock

extern int doubledos;
extern int multiuser;
extern int MultiTasker;
extern int pid;
extern char *version;
extern char *mbdate;
extern unsigned atou();

extern void rlock();
extern void rulock();
extern void mwlock();
extern void mulock();
extern void muinit();
extern void ddsleep();
extern void tson();
extern void tsoff();
extern int isdoubledos();
extern void resync();
extern short mchange;
extern short bid_able;
extern short h_route;
extern short mid_able;

	/*  Some character values. */
#define BS	'\010'
#define CTL_C	'\03'
#define CTRLE	'\005'
#define CTRLF	'\006'
#define CTRLK	'\013'
#define CTRLL	'\014'
#define CTRLQ	'\021'
#define CTRLS	'\023'
#define CTRLW   '\027'
#define CPMEOF	'\032'
#define CR	'\015'
#define DEL	127
#define ESC	'\033'
#define LF	'\012'


#define ioport(p)	port = p

#define BUFLEN 2048
#define CMDLEN 384
#define LINELEN 256

/* G8BPQ MBBIOS extensions */

#define BPQVER		0x1f00
#define BPQCALL		0x1f01
#define BPQUNACK	0x1f02
#define BPQRETNODE	0x1f10



extern char *EOFstr;

extern char *cmd;
extern char *token_lin;
extern int flds;
extern char *fld[MAXFLDS], opt1, opt2, opt3, opt4;

extern char *line;

extern char l_date[7];
extern char l_time[5];
extern struct tm *ctim;

extern short err_max;
extern short event_min;
extern short event_cycle;
extern short event_ofset;

extern char ocall[CALLLEN+1];
extern char ohandle[NAMELEN+1];
extern char oqth[QTHLEN+1];
extern char ozip[ZIPLEN+1];
extern char *col_out;
extern char *stat_col;
extern int color;
extern char *mail_st;

extern	long int 	d_s;
extern	int	min_disk;
extern	short	disk_hyst;
extern	short	disk_full;
extern	short	smart_sys;
extern  short   prMBL;
extern	short	linked;
extern	short	break_in;
extern  short	strm_snd;
extern	short	rspace;
extern	short	rversion;
extern	int	fldopt;
extern	int	fld_no_bid;
extern	int	sendtype;
extern	int	kblok;

	/*  Logging options. */
#define LOG_ON 1
#define LOG_GATE 2
#define LOG_FILE 4
#define LOG_MSG 8
#define LOG_LOC 16

extern short logopt;

	/* Directory names */
extern char *fildir, *msgdir, *updir, *sysdir, *tmpdir, *usrdir;

extern char *rt_edit[MAXEDIT];
extern char *rt_default;

	/*  File names. */
extern char *infofile, *event_fil, *lgfile,  *msgflp;
extern char msgfile[128];
extern char *helpfile, *callfil,   *usfile,  *passwdf;
extern char *monfile,  *msgtemp,   *msgtmp2, *mbfile,  *oldmfile;

		/*  Error / status messages. */
extern char *mdone, *mwhat, *mtxt, *mnend, *mttl, *mdupe, *mtorej;
extern char *mfound, *mnfind, *mlogin, *mpasswd;
	/*  Misc text. */
extern char *talkm1, *mbbusy;
extern char *pmbmenu, *symenu, *rmenus, *lmenus;
extern char *mprmbs, *tncrem, *tncsys;
extern char *shutdown;

extern char achar, rchar, tchar, wchar;

	/*  Port stuff. */

	/*  Port type bits. */
#define P_BBS		1  /* BBS only */
#define P_HAMCAL	2  /* Illegal call allowed */
#define P_OSRVCAL	4  /* Illegal digi call allowed */
#define P_MDM		8  /* Serial connected thru landline modem */
#define P_REG		16  /* Port is for registered users only */
#define P_FILE		32  /* File transfers ok */
#define P_CONSOLE	64  /* The local machine console */
#define P_TNC		128  /* Is a tnc, TAPR commands */
#define P_SERIAL	256  /* Is a "raw" serial device */
#define P_ECHO		512  /* Need to echo input */
#define	P_INACTIVE	1024 /* Port that will not be monitored, no connects accepted */
#define P_BPQ		2048 /* This is a G8BPQ port - used for return to node  */
#define P_BPQ_RET	4096 /* BPQ Return to Node permitted Parameter			*/
typedef struct ports_s {
  struct ports_s *next;
  char  id;      	/* Identifies port to op sys 							*/
  int	idn;		/* port id number (speeds up MSDOS i/o) 				*/
  unsigned	baud;	/* port baud rate										*/
  short type;    	/* Port type 											*/
  short mode;    	/* Present state of the port 							*/
  USER_RECORD *user; /* Pointer to user record 								*/
  short timeout;	/* "Waiting for input" timeout			 				*/
  char  *name;		/* Name of the port 									*/
  short maxdigi;	/* max number of digis allowed on port					*/
  short hasDCD;		/* is there a DCD capable unit on port 					*/
  short isTNC2;		/* is a TNC2 or fully compatible						*/
  short	beacon;		/* send Mail For beacon on this channel					*/
  short	smartmodem;	/* does modem have Hayes command set ?					*/
  char	*color;		/* for color monitors ANSI color display string 		*/
  long	dl_size;	/* d/l limit size, if 0, no limit						*/
  char  dl_time[5];	/* d/l limit widow start/end hour 4 char string 		*/
  long	fwsize;		/* fwd limit size, if 0, no limit						*/
  char  fwtmr[5];	/* fwd limit widow start/end hour 4 char string 		*/
  char *init;		/* port TNC init string									*/	
  char *conn;		/* port TNC string to be sent at connect				*/
  char *shutdown;	/* shutdown string CONOK off, etc....					*/
  char *online;		/* port TNC string sent when back to waiting			*/
  char *into_trm;	/* port TNC strings sent went entering terminal mode	*/
  char *outof_trm;	/* port TNC strings sent when exiting of terminal mode	*/
  
} PORTS;

/**********************************************************
 *  porthd is list header.
 *  port is the currently active port.
 *  cport is the machine console.
 **********************************************************/

extern PORTS *porthd, *port, *cport, *qport;
extern PORTS *findport();

/* Mode values (bit settings) */

#define EVENT    	1
#define LOCAL    	2
#define SYSOP    	4
#define REMOTE   	8
#define BBSSYS		16
#define FORWARD  	32
#define IDLE    	64
#define DISCON  	128
#define TIMEOUT 	256
#define EXCLUDE 	512
#define FORCED  	1024
#define INPROCESS	2048
#define	SERVER		4096

#define BYE_DISC	60
#define EXCL_DISC	30
#define T_O_DISC 	30

#define FORCE_DISC	20


/* tnc state tokens used by tncstate */
#define DISCONNECTED	ERROR
/*
#define CONNECTED		1
#define DISCONNECTED	2
#define CINPROGRESS		3
#define DINPROGRESS		4
*/
extern int	iobios;

#define DTR_ON(x)		flow_off(x)
#define DTR_OFF(x)		flow_on(x)
#define ISCONNECTED(x)	havedcd(x)


typedef struct bbs_parms {
	char	ocall[17];
	char	ohandle[21];
	char	oqth[21];
	char	stat_col[5];
	char	col_out[5];
	short	err_max;
	short	color;		
	short	min_disk;
	short	disk_hist;
	short 	event_min;
	short 	event_cycle;
	short 	event_ofset;
	short	strm_snd;
	short	arc_tfc;
	short	arc_oldmail;
	short	rspace;
	short	rversion;
} BBSPRM;

extern BBSPRM	*bbs_sys;

#include "mbmail.h"
