Unit NPG;


Interface

uses dos;

Const NPGInt : Integer = 102;

Type
      FrameBlock = Record
                    framelength : word;
                    Buffer      : Array[0..256] of byte;
                  End;

      TncRec    = Record
                    Channel     : Byte;
                    TncCommand  : String[80];
                  End;

      UserRec   = Record
                    Channel     : Byte;
                    Mode        : Byte; (*  0 = Do Nothing with File    *)
                                        (*  1 = Kill File after execute *)
                                        (*  2 = Send 'FileName' as text *)
                                        (*  3 = Send Frame block        *)
		                        (*  4 = Show Frame block        *)
                    FileName    : String[80];
                  End;

      Channel_Rec  = Record
                       UserCall    : String [ 9]; {User Callsign   }
                       MyCall      : String [ 9]; {Sysop Callsign  }
                       ProgName    : String [12]; {Default Program }
                       PrgNme      : String [12]; {Active Program  }
                       ExecLevel   : Byte;        {Times Executed  }
                       ConnectMode : Byte;        {Channel-mode    }
                                                  {0 = not connected }
                                                  {1 = incoming      }
                                                  {2 = outgoing      }
                       Hours,
                       Minutes,
                       Seconds    : Word;         {Connection Time   }

                       initcall   : String [9]; {Initialization mycall }

                     End;

      MHeardRec = Record
                    Call : String [9];
                    Port : Byte;
                    Time : LongInt; {PackedTime}
                  End;

      MHeard      = Array[1..26] Of MHeardRec; {26 x MHeardRec}
      ChannelRec  = Array[0..20] Of Channel_Rec; {21 x Channel_Rec}

Var FB            : ^FrameBlock;
    UR            : UserRec;
    TR            : TncRec;
    MH            : ^Mheard;
    CR            : ^ChannelRec;
    Channels      : Byte;
    Sysopchannel  : Byte;
    Frame         : String;

Function  Makepointertoframe(T:String):Pointer;
Function  Makestringfromframe:String;
Function  NPG_check: Integer;
Procedure Writeuser;
Procedure WriteTnc;
function  NPG_Version:word;
function  NPG_ChannelRec:pointer;
function  NPG_SysopChannel:Byte;
function  NPG_Channels:Byte;
function  NPG_Mheard:pointer;


Implementation

function NPG_Version:word;
var regs : registers;
begin
  regs.ah := 0;
  intr(NPGInt,Regs);
  NPG_Version := regs.ax;
end;

function NPG_ChannelRec:pointer;
var regs : registers;
begin
  regs.ah := 1;
  intr(NPGInt,Regs);
  NPG_ChannelRec := Ptr(regs.es,regs.bx);
end;

function NPG_SysopChannel:Byte;
var regs : registers;
begin
  regs.ah := 2;
  intr(NPGInt,Regs);
  NPG_SysopChannel := regs.al;
end;

function NPG_Channels:Byte;
var regs : registers;
begin
  regs.ah := 3;
  intr(NPGInt,Regs);
  NPG_Channels := regs.al;
end;

function NPG_Mheard:pointer;
var regs : registers;
begin
  regs.ah := 4;
  intr(NPGInt,Regs);
  NPG_Mheard := Ptr(regs.es,regs.bx);
end;

Procedure Writeuser;
Var F : File;
Begin
 Assign(F,'USERS.NPU');
 {$i-} Reset(F,1); {$i+}
 if ioresult = 0 then seek(f,filesize(f))
                 else {$i-} Rewrite(F,1); {$i+}
 If IOresult = 0 then
 begin
   Blockwrite(F,Ur,Sizeof(Userrec));
   Close(F);
 end;
End;

Procedure WriteTnc;
Var F : File;
Begin
 Assign(F,'USERS.NPT');
 {$i-} Reset(F,1); {$i+}
 if ioresult = 0 then seek(f,filesize(f))
                 else {$i-} Rewrite(F,1); {$i+}
 If IOresult = 0 then
 begin
   Blockwrite(F,Tr,Sizeof(TncRec));
   Close(F);
 end;
End;

Function NPG_check: Integer;
Type ident = Record
               nop : Array [1..2] Of Char;
               id  : Array [1..6] Of Char;
             End;
Var
  i: Integer;
  ok: Boolean;
  SPtr: Pointer;
Begin
  i := 0; ok := False;
  While (i <= 255) And Not ok Do
  Begin
    GetIntVec (i, SPtr);
    If ident (SPtr^).id = 'NwPkGn' Then Ok := True;
    If Not Ok Then Inc (i);
  End;
  NPG_Check  := i;
End;


Function Makepointertoframe(T:String):Pointer;
Var Sgm,Offs : Word;
    Code     : Integer;
Begin
  Val(Copy(T,1,Pos(':',T)-1),Sgm,Code);
  Delete(T,1,Pos(':',T));
  Val(T,Offs,Code);
  Makepointertoframe := Ptr(Sgm,Offs);
End;

Function Makestringfromframe:String;
Var S : String; I : Word;
Begin
 if FB <> NIL then
 begin
  S[0] := Chr(Fb^.Framelength);
  For I := 1 To Fb^.Framelength Do S[i] := Chr(Fb^.Buffer[I-1]);
 end else s := '';
 Makestringfromframe := S;
End;

Begin
  NPGInt := NPG_Check;
  if NPGInt = 256 then halt(0);
  MH           := NPG_Mheard;
  CR           := NPG_ChannelRec;
  Channels     := NPG_Channels;
  SysopChannel := NPG_SysopChannel;
  If paramcount >= 7 then FB := Makepointertoframe(ParamStr(7))
                     else FB := Nil;
  Frame := Makestringfromframe;
End.