/*
 *-----------------------------------------------------------------------
 *
 * TFLINK - program to make TFPCX TSR running a Baycom modem on a
 * COM port appear as a serial (HOST mode) TNC on a second COM port.
 *
 * tnclink.h - include file for definitions and global variables
 *
 *-----------------------------------------------------------------------
 */

/* standard inclusion files */
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>


/* make any variables external if not in the main module */
#ifndef MAIN_MODULE
	#define	GLOBAL	extern
#else
	#define	GLOBAL
#endif

/* boolean types */
#define bool			int
#define FALSE			0
#define TRUE			(! FALSE)

/* shorthand types */
#define u_char			unsigned char
#define byte			unsigned char
#define u_int			unsigned int
#define u_long			unsigned long

/* global variables that hold port and TFPCX interrupt information, and
   also command line flags and options */
GLOBAL bool	nflag;
GLOBAL bool	rflag;
GLOBAL bool	uflag;
GLOBAL int	tfpcx_interrupt;
GLOBAL int	sio_port;
GLOBAL int	sio_baud;

/* redefinition of Turbo-C setvect and getvect to avoid calls into
   busy DOS.  These redefinitions are important -  calling Turbo-C
   getvect/setvect within interrupts tends to hang the system. */
#define getvect(V)   (	( (u_long) \
			(u_int)peek( 0, V * 4 + 2 ) << 16 | \
			(u_int)peek( 0, V * 4 ) ) )
#define setvect(V,A) {	poke( 0, V * 4, (u_long)A & 0xFFFF ); \
			poke( 0, V * 4 + 2, (u_long)A >> 16 ); }
