/*
    SETKISS.C

    Version 2.1  6/6/1993 - Marco Savegnago IW3FQG

    This simple program turn on and off kissmode in many TNC directly from
    DOS prompt.

    Use it in a startup batch before running any program which need kiss mode
    tnc/operation.

    SetKiss 2.1 - 1990/1993 Marco Savegnago IW3FQG

    Set/Reset Kiss mode utility for use with the most TNC's type

    This is am HAMWARE program, so it can be copied/modify freely but not for
    commercial purposes!

    Usage SetKiss [command] <options>

    command:

    Cx    specify com number 1,2,3 or 4.

    Ffilename specify filename to send

    In the file you can put any string or number or this command:

            -B          send BREAK
            -C          send CTRL-C
            -R          send CR
            -nn         send any ASCII char (es -9 send TAB)
            @filename   send filename (recoursing limited to 20 - 3 handle)

    Phhhh specify i/o port address in hex es: P03F8

    Sx    set COM speed (3)00 (1)200 (2)400 (4)800 (9)600
                              192(0)0 3(8)400 5(7)600 11(5)200 baud

    Tp    set TNC type  A = AEA PK88 PK232
                        O = Kantronics KPC's or KAM with old eprom
                        K = Kantronics KPC's or KAM with eprom >= 3.XX
                        T = TAPR TNC's and clone with std eprom
                        H = TAPR TNC's and clone with HOST eprom

    U|L  uninstall kiss using standard leave kiss sequence
                                (may not run in certain eprom)

    This program is part of IW3FQG's FOOT (FQG Own Original Tools)

    It was written for my personal use and for my personal needs!

    This is an HAMWARE software, no registration is required!

    To recompile this program use Turbo C/C++ 1.0 or later.


    ERROR_LEVEL:

           -1   - Show usage
            0   - OK, KISS (probably) set
            1   - Switch/Command error
            2   - TNC (probably) OFF
            3   - invalid com number
            4   - no filename specified
            5   - port address not valid
            6   - invalid TNC type
            7   - invalid speed

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <conio.h>
#include <dir.h>

#define KO 1
#define OK 0

#define NO  0
#define YES 1

#define OK_PORT     0x01
#define OK_SPEED    0x02

#define OK_TYPE     0x10
#define OK_FILE     0x20


int com_base;
char tnc_type;

char _send_filename[MAXPATH];

const char thisVersion[] = "2.1";
const int std_combase[] = { 0x3f8, 0x2f8, 0x3e8, 0x2e8 };

struct b_rate
{
        char speed; unsigned value;
}

baud_rate[] =
{
        {   '3',  0x0180 } ,
        {   '1',  0x0060 } ,
        {   '2',  0x0030 } ,
        {   '4',  0x0018 } ,
        {   '9',  0x000c } ,
        {   '0',  0x0006 } ,
        {   '8',  0x0003 } ,
        {   '7',  0x0002 } ,
        {   '5',  0x0001 }
};

struct kiss_c
{
    char type;
    char *string;
}

kiss_cmd[] =
{
{ 'N', "\xC0\xFF\xC0"     } ,  /* leave kiss string */
{ 'A', "CONMODE TRANS\r"
       "PP ON\r"
       "RAW ON\r"
       "HP OFF\r"
       "KISS ON\r"
       "HOST ON\r"        } ,  /* AEA */
{ 'T', "KISS ON\r"
       "RESTART\r"        } ,  /* TAPR TNC2 */
{ 'O', "KISSMODE ON\r"
       "RESET\r"          } ,  /* KANTRONICS 2.XX */
{ 'K', "INTFACE KISS\r"
       "RESET\r"          } ,  /* KANTRONICS 3.XX */

{ 'H', "\x11\x18\x1b@K\r" }    /* TF 2.1c (by Nord<>Link) for TNC2 */

};

int     _htoi           (char *);
void    close_com       (void);
int     open_com        (unsigned);
int     send_kiss       (char);
int     send_com        (char *);
void    usage           (void);
void    cmd_error_exit  (int);
void    parse_cmd       (char *);
void    send_file       (char *);
void    send_break      (void);

/*
** The main thing
*/

int main(int na,char **a)
{
        char *p;
        int narg,i,len;
        unsigned speed;
        char cmdline = 0;
        char cmderror = NO;

        printf("\nSetKiss %s - 1990/1993 Marco Savegnago IW3FQG  %s\n\n", thisVersion, __DATE__);

/*
**  See if command line is complete with argoment
*/

        for ( narg = 1; narg < na; narg++ )
        {
            p=a[narg];
            if ( *p == '-' || *p == '/')
            {
                p++;
                switch(toupper(*p))
                {
                    case '?':
                    case 'H':
                        usage();
                        return(-1);

                    case 'C': // com
                        if (!*++p || *(p+1) || !strpbrk ( p, "1234"))
                                                            cmd_error_exit(1);

                        com_base = std_combase[ *p - '1'];
                        cmdline |= OK_PORT;
                        break;

                    case 'F': // custom kiss send by file
                        if (!*(p+1))
                            cmd_error_exit(2);

                        strcpy(_send_filename,p);
                        cmdline |= OK_FILE;
                        break;

                    case 'P': // port
                        if (!*++p || (len=strlen(p),len < 3 || len > 4))
                                                            cmd_error_exit(3);

                        com_base = _htoi(p);
                        cmdline |= OK_PORT;
                        break;

                    case 'S': // speed
                        if (!*++p || *(p+1) || ! strpbrk (p, "312490875"))
                                                            cmd_error_exit(4);

                        cmdline |= OK_SPEED;

                        for (i = 0; *p != baud_rate[i].speed; i++)
                        ;
                        speed=baud_rate[i].value;
                        break;

                    case 'T': // type
                        if (!*++p || *(p+1))
                                cmd_error_exit(3);

                        tnc_type=*p=toupper(*p);
                        if (!strpbrk (p, "ATKOH"))
                                    cmd_error_exit(5);

                        cmdline |= OK_TYPE;
                        break;

                    case 'L':
                    case 'U': // unistall kiss
                        tnc_type = 'N';
                        cmdline |= OK_TYPE;
                        break;

                    default: // unknow switch
                        cmderror = YES;
                        printf("\aError! Invalid switch <%s>. Type /? for Help.\n",--p);
                        break;
                }
            }
            else
            {
                cmderror = YES;
                printf("\aError! Invalid command <%s>. Type /? for Help.\n",p);
            }
        }

        if (cmderror)
                return(1);

        if (! (cmdline & OK_PORT) || ! (cmdline & OK_SPEED) ||
                        ! (cmdline & OK_TYPE || cmdline & OK_FILE))
        {
                puts("\aError! Not enough operand! Type /? for help.\n");
                return(1);
        }

        if (KO == open_com(speed))
        {
                close_com();
                return(2);
        }


        if (cmdline & OK_TYPE)
                send_kiss(tnc_type);

        if (cmdline & OK_FILE)
                send_file(_send_filename);

        close_com();

        return(OK);
}


/*
**  HexString to int without use assembly ...
*/

int _htoi (char *p)
{
        register int i;
        int ret=0,mult=1;
        char ch;

        i=strlen(p);

        while(i--)
        {
            ch = toupper(*(p+i));

            if(isalpha(ch))
                    ch -= ('A' - 10);
            else
                    ch -= '0';

            ret += ch * mult;
            mult *= 16;
        }

        return (ret);
}


/*
**  Close COM (reset DTR e RTS)
*/

void close_com (void)
{
          outportb (com_base + 4,0);
}


/*
** Open COM
*/

int open_com (unsigned speed)
{
/*
**    Check if TNC is on
*/

      if (!(inport(com_base + 6) & 0x10))
      {
            puts("\aTNC (probably) OFF!");
            return(KO);
      }

/*
**    Set DLAB in the Line Control Register to set the speed
*/

      outportb ( com_base + 3 , 0x80 );

/*
**    Set serial speed
*/

      outport ( com_base, speed );

/*
**    Reset DLAB in the LCR and then set 8N1 as serial param
*/
      outportb ( com_base + 3 ,0x03 );

/*
**    Set RTS e DTR
*/

      outportb ( com_base + 4 ,0x03 );

      return (OK);
}


/*
**  Select and then send Kiss string
*/

int send_kiss(char tnc_type)
{
    register int i;

    for (i = 0;tnc_type!=kiss_cmd[i].type;i++)
    ;

    send_com(kiss_cmd[i].string);

    printf("Kissmode (probably) %sset!\n",(tnc_type!='N') ? "" : "un");

    return(OK);
}


/*
**  Send kiss string to comport
*/

int send_com(char *s)
{
    while(*s)
    {
        outportb(com_base,*s++);
        while (!(inportb (com_base + 5) & 0x20))
                                if(kbhit()) return(1); // Avoid dead loop
        delay(10);
    }

    return(0);
}


/*
**  Print usage
*/

void usage (void)
{

char usage_str[] =
     "Set/Reset Kiss mode utility for use with the most TNC's type\n\n"

     "This is am HAMWARE program, so it can be copied/modify freely but not for\n"
     "commercial purposes!\n\n"

     "Usage SetKiss [/|-command]\n\n"

     "command:\n"
     "Cx        specify com number 1,2,3 or 4.\n"
     "Ffilename specify filename to send.\n"
     "Phhhh     specify i/o port address in hex es: P03F8\n"
     "Sx        set COM speed (3)00 (1)200 (2)400 (4)800 (9)600\n"
     "\t\t\t\t192(0)0 3(8)400 5(7)600 11(5)200 baud\n\n"

     "Tp        set TNC type  A = AEA PK88 PK232\n"
     "\t\t\tO = Kantronics KPC's or KAM with old eprom\n"
     "\t\t\tK = Kantronics KPC's or KAM with eprom >= 3.XX\n"
     "\t\t\tT = TAPR TNC's and clone with std eprom\n"
     "\t\t\tH = TAPR TNC's and clone with HOST eprom\n\n"
     "U|L       uninstall kiss using standard leave kiss sequence"

     ;

     puts(usage_str);
}


/*
**  Print command error then exit with error level
*/

void cmd_error_exit (int num)
{
    char *str[] =
    {
        "invalid com number",
        "no filename specified",
        "port address specification is not valid",
        "invalid speed",
        "invalid TNC type"
    };


    printf ("\nError %s \a\n",str[num-1]);
    exit(num+2);
}


/*
**  Parse command in file
*/

void parse_cmd (char *str)
{
    char cmd[10];

    if (*str=='-')
    {
        switch(toupper(*++str))
        {
            case 'B':
                send_break();
                break;
            case 'C':
                send_com("\x03");
                break;
            case 'R':
                send_com("\r");
                break;
            default:
                if(isdigit(*str))
                {
                     sprintf(cmd,"%c",atoi(str));
                     send_com(cmd);
                }
                break;
        }
    }
    else if (*str == '@' && strlen(str) > 1)  // Max file handle is 20
                                    send_file(str);
    else
    {
            send_com(str); send_com(" ");
    }
}

/*
**  Send file to COM
*/

void send_file (char *str)
{
    FILE *f;
    char cmd[256];

    str++;

    if((f=fopen(str,"rt"))==NULL)
    {
        printf("\n\aError opening file %s\n",str);
        return;
    }

    while(!feof(f))
    {
        if(EOF==fscanf(f,"%255s",cmd)) break;
        parse_cmd(cmd);
    }

    fclose(f);
}

/*
**  Send BREAK
*/

void send_break(void)
{
        int state=inportb(com_base+3);
        outport(com_base+3,state|0x40);
        delay(300);
        outport(com_base+3,state^=0x40);
}

