#define VERSION "2.00f"
#define DATE "19991115"
#define AMIGADATE "(15.11.99)"
/*
 *      BS was originally published by Sigi Kluger DL1MEN/DK4NB and was
 *      heavily revised for portability and further developed by Axel Bauda
 *      DG1BBQ after Sigi deceased.
 *      It now compiles on MSDOS, OS/2, OS/9, UNIX (all flavours), Atari_ST
 *      and Amiga computers.
 *
 *      BS is HAMWARE. It may be used in Ham Radio to transfer data.
 *      If you make modifications, please send a copy of the source code
 *      to DG1BBQ @DB0VER.#NDS.DEU.EU so they can be included in the
 *      official version (if they make sense).
 *
 *      No commercial use! No sale! Pass on at no charge (not even for
 *      postage/packing/handling)! Either distribute from person to person,
 *      via BBS, internet or via disk + SASE.
 *
 *      I don't want anyone making money off this program in I don't care what
 *      way either directly or indirectly!!
 *
 *      This goes as well for any programm that actively incorporates routines
 *      that produce files in BS v2 format without calling on BS.
 *
 *
 *      Binary Splitter
 *      -      -
 *      splits binary files in multiple parts for transfer through
 *      TheBox 1.9b6+, BaycomBox and DP-Box using AUTOBIN upload
 *      or pure binary upload if #BIN# headers are already included.
 *
 *      Old file structure (before BS v2.0)
 *      -----------------------------------
 *
 *      Header at beginning of part part 1 through part x-1:
 *      Byte    Contents
 *      0-1     magic number 0x6569, big-endian
 *      2       total parts (2-255)
 *      3       this part   (1-255)
 *      4-5     CCITT-CRC (same CRC as used by 7PLUS, #BIN# etc.), big-endian,
 *              calculated from first to last byte of binary data in current
 *              part.
 *      6       remaining bytes in header (length of name incl null-char)
 *      7-n     File name, null terminated.
 *      n+1-m   Binary data (min 5000 bytes, max 2^31 -1)
 *
 *      Header at beginning of part x (last part):
 *      Byte    Contents
 *      0-1     magic number
 *      2       total parts
 *      3       this part
 *      4-5     CCITT-CRC
 *      6       remaining bytes in header (length of name incl null-char  + 4)
 *      7-n     File name, null terminated.
 *      n+1-n+5 file date and time, big-endian.
 *                Format: bit  0-4: secs/2, 5-10: mins, 11-15: hours,
 *                        16-20: days, 21-24: months, 25-31: year-1980
 *      n+6-m   Binary data
 *
 *
 *  New file structure (BS v2.0 and newer)
 *  --------------------------------------
 *
 *  The first 6 fields are standard:
 *  - ID string ">BS<" + LF.
 *  - ASCII representation of current part number (unsigned char) + LF
 *  - ASCII representation of overall part number (unsigned char) + LF
 *  - ASCII representation of splitsize (unsigned long) +LF
 *  - ASCII representation of original file's size (unsigned long) +LF
 *  - Filename of original unsplit file + LF
 *  - ASCCI date YYYYMMDDHHMMSS +LF
 *
 *  - Here additional fields may be added. To distinguish them, they should
 *    start with a token like A, B, C etc. and be terminated by a LF
 *
 *  - HEX-ASCII 16bit CRC over all previous bytes in header preceeded by a null
 *    byte and terminated by a LF
 *  - Datafield containing splitsize bytes of data for current part.
 *  - HEX-ASCII 32bit accumulated CRC of all datafields of current and
 *    previous parts +LF. In last part: represents overall CRC of original file.
 *  - HEX-ASCII 32bit CRC over current datafield including  HEX-ASCII of
 *    accumulated CRC +LF.
 *
 */

/** these includes should work anywhere **/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>

#define EOS '\0'
#define BINHEAD 1
#define JOIN 2
#define RECODE 4
#define SEND 8
#define DUMB_BIN 16
#define FORCE8_3 32
#define ADDCR 64
#define NODATE 128
#define DPBOX 256
#define GERMAN 512
#define W2ORG 1024

/** Microsoft's Quick C has some different makros and function names **/
#ifdef _QC
 #define __MSDOS__
 #define SHORTNAMES
 #define MAXDRIVE _MAX_DRIVE
 #define MAXDIR   _MAX_DIR
 #define MAXFILE  _MAX_FNAME
 #define MAXEXT   _MAX_EXT
 #define MAXPATH  _MAX_PATH
 #define fnsplit  _splitpath
#endif /* _QC */

#ifdef __MSDOS__
 #ifdef __TURBOC__
  #include <dir.h>
  #include <io.h>
 #endif
 #include <conio.h>
 #include <stdlib.h>
 #include <sys/types.h>
 #include <sys/stat.h>
 #define NULLDEV "NUL"
 #define SHORTNAMES
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #define _HAVE_FNSPLIT
 #define _HAVE_ICMP
 #define _HAVE_GMTIME
 #define _HAVE_MKTIME
 #define _FTIMEDEFINED
#endif /* __MSDOS__ */

#if (defined (__BORLANDC__) && defined (__WIN32__))
 #include <dir.h>
 #include <io.h>
 #include <conio.h>
 #include <stdlib.h>
 #include <sys/types.h>
 #include <sys/stat.h>
 #define NULLDEV "NUL"
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #define _HAVE_FNSPLIT
 #define _HAVE_ICMP
 #define _HAVE_GMTIME
 #define _HAVE_MKTIME
 #define _FTIMEDEFINED
 #endif /* __BORLANDC__ && __WIN32__ */

#ifdef __OS2__
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <io.h>
 #ifdef __BORLANDC__
  #define __IBMC__
 #endif
 #define NULLDEV "NUL"
 #define MAXPATH   80 /* I don't have HPFS installed! */
 #define MAXDRIVE  3
 #define MAXDIR    66
 #define MAXFILE   9
 #define MAXEXT    5
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #define _HAVE_ICMP
 #define _HAVE_GMTIME
 #define _HAVE_MKTIME
 #include <stdlib.h>
 #ifdef __EMX__
  #define chsize ftruncate
 #endif
#endif /* __OS2__ */

#ifdef _AMIGA_
 #define  _680X0_
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <stddef.h>
 #include <proto/dos.h>
 #include <libraries/dos.h>
 #include <libraries/dosextens.h>
 #include <exec/memory.h>
 #include <stdlib.h>
 #define NULLDEV "NIL:"
 #define SEEK_SET 0
 #define SEEK_CUR 1
 #define SEEK_END 2
 #define MAXPATH  300
 #define MAXDRIVE 31
 #define MAXDIR   220
 #define MAXFILE  31
 #define MAXEXT   31
 #define PATHSEP  "/"
 #define PATHCHAR '/'
 #define MAXFNAME MAXFILE
#endif /* _AMIGA_ */

#ifdef __TOS__
 #define SHORTNAMES
 /* Important! Don't know the null device's name. NUL is just a wild guess */
 #define NULLDEV "NUL:"
 /* Officially there's no null device, but this seems to work. (XAO) */
 #define MAXPATH   119
 #define MAXDRIVE  3
 #define MAXDIR    102
 #define MAXFILE   9
 #define MAXEXT    5
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #define _HAVE_ICMP
 #define _HAVE_GMTIME
 #define _HAVE_MKTIME
 #define _FTIMEDEFINED
 #include <stdlib.h>
 #include <ext.h>
 /* quick & dirty, swaps upper and lower word                      */
 unsigned long swapl(unsigned long l)0x4840; /* opcode for SWAP D0 */
 /* needed for timestamp-functions    (Odo,DL1XAO)                 */
 #define access(a,b) 0 /* the following open will show if there's  */
 /*                       access      (Odo,DL1XAO)                 */
#endif /* __TOS__ */


#ifdef __unix__
 #include <sys/types.h>
 #include <sys/stat.h>
 #ifdef __M_XENIX__
  #include <malloc.h>
  #define SEEK_CUR 1
  #define SEEK_END 2
  #define SEEK_SET 0
  typedef unsigned size_t;
 #endif
 #define NULLDEV "/dev/null"
 /* assumed limits (hope reasonable !!! DF6NL) */
 #define MAXPATH 256
 #define MAXDRIVE 16
 #define MAXDIR 256
 #define MAXFILE 32
 #define MAXEXT 32
 #define PATHSEP "/"
 #define PATHCHAR '/'
 #define MAXFNAME MAXFILE
 #ifdef SYSV
  #include <unistd.h> /* not sure, if this one is really necessary */
 #endif
 #ifdef __i386__
  #ifndef SYSV
   #define SYSV
  #endif
 #endif
#endif /* __unix__ */

#ifdef OSK
 /* Assumed limits */
 #include <types.h>
 #include <stat.h>
 #define _680X0_
 /* Important! Don't know the null device's name. 'null' is just a guess */
 #define NULLDEV "null"
 #define _IOFBF 0
 #define MAXPATH 256
 #define MAXDRIVE 16
 #define MAXDIR 256
 #define MAXFILE 32
 #define MAXEXT 256
 #define PATHSEP "/"
 #define PATHCHAR '/'
 #define MAXFNAME MAXFILE
 char *strsave(const char *);
 #define strdup  strsave
 #define SEEK_SET   0
 #define SEEK_CUR   1
 #define SEEK_END   2
 #include <stdlib.h>
#endif /* OSK */

#define MAXFPATH (MAXDRIVE+MAXDIR-1)

/* flags for fopen() */
#ifdef TWO_CHAR_SEP
 /* This is for systems that convert LF to CR/LF in textmode */
 #define OPEN_R_BIN "rb"
 #define OPEN_RR_BIN "r+b"
 #define OPEN_W_BIN "wb"
 #define OPEN_WR_BIN "w+b"
 #define OPEN_A_BIN "ab"
#else
 /* And this, if there is no conversion */
 #define OPEN_R_BIN "r"
 #define OPEN_RR_BIN "r+"
 #define OPEN_W_BIN "w"
 #define OPEN_WR_BIN "w+"
 #define OPEN_A_BIN "a"
#endif

/** shorthands for unsigned types **/
typedef unsigned char byte;  /* 8bit unsigned char */
#ifdef __unix__
 #ifdef __vax__
  typedef u_long ulong;
 #endif
 #ifdef __M_XENIX__
  typedef unsigned long ulong;
 #endif
#else
 typedef unsigned int  uint;  /* 16 or 32bit unsigned int */
 typedef unsigned long ulong; /* 32bit unsigned long      */
#endif

#ifdef __OS2__
 #ifdef __BORLANDC__
  #include <utime.h>
  #define _FTIMEDEFINED
 #else
  #include <sys/utime.h>
 #endif
#endif

#ifdef __unix__
 #ifdef __M_XENIX__
  struct utimbuf {
  time_t actime;
  time_t modtime;
  };
  extern time_t mktime (struct tm *utm);
 #else
  #include <utime.h>
 #endif
#endif

#ifdef _AMIGA_
 struct utimbuf {
  time_t actime;
  time_t modtime;
 };
 extern time_t mktime (struct tm *utm);
#endif

#ifndef _FTIMEDEFINED
 #ifdef _680X0_  /* use this struct on 680x0 systems (big endian)*/
 struct ftime
 {
   unsigned int ft_year  : 7; /* Year minus 1980 */
   unsigned int ft_month : 4;   /* 1..12 */
   unsigned int ft_day   : 5;   /* 1..31 */
   unsigned int ft_hour  : 5;   /* 0..23 */
   unsigned int ft_min   : 6;   /* 0..59 */
   unsigned int ft_tsec  : 5;   /* 0..59 /2 (!) */
 };
 #else  /* and this one on 80x86 systems (little endian) */
 struct ftime
 {
   unsigned  ft_tsec  : 5;   /* 0..59 /2 (!) */
   unsigned  ft_min   : 6;   /* 0..59 */
   unsigned  ft_hour  : 5;   /* 0..23 */
   unsigned  ft_day   : 5;   /* 1..31 */
   unsigned  ft_month : 4;   /* 1..12 */
   unsigned  ft_year  : 7; /* Year minus 1980 */
 };
 #endif
#endif /* _FTIMEDEFINED */

#define MINPART 5000L
#define NORPART 30000L
#define MAGIC   0x6569
#define MAGIC2   0x423e

static  void combine(char *filename);
static  void doit(char *filename, long nparts);
static  void usage(int err);
void make_compat (char *name);
void build_DOS_name (char *name, char *ext);
void lcfn (char *name);
int top (FILE *wfile, char *buffer, char *orgname, int part, int parts);
void get_range (char *rangestring);
int read_16 (FILE *in);
void write_16 (int val, FILE *out);
long read_32 (FILE *in);
void write_32 (long val, FILE *out);
ulong get_filetime (const char *filename, char *datestring);
void set_filetime (const char *filename, ulong ftimestamp, char *datestring);

#ifndef _HAVE_GMTIME
  struct tm *__offtime (const time_t *t, long int offset);
  struct tm *gmtime (const time_t *t);
#endif /* ifndef _HAVE_GMTIME */

#ifndef _HAVE_MKTIME
  time_t mktime (register struct tm *tp);
#endif /* ifndef _HAVE_MKTIME */

#ifndef _HAVE_FNSPLIT
  void fnsplit(char *pth, char *dr, char *pa, char *fn, char *ft);
#endif /** ifndef _HAVE_FNSPLIT **/

#ifndef _HAVE_ICMP
  char *strupr (char *string);
  char *strlwr (char *string);
  int stricmp (const char *s1, const char *s2);
  int strnicmp (const char *s1, const char *s2, size_t n);
#endif /** ifndef _HAVE_ICMP **/

#define STDSTRING 280 /* more than enough room, just to be safe */
/* globals */
struct  ftime   ft;
char drive[STDSTRING], dir[STDSTRING], name[STDSTRING], ext[STDSTRING];
char range[STDSTRING];
int flags, g, bigcrc;
char send[STDSTRING], sendhead[STDSTRING];
char uplname[STDSTRING];
char lsep[3];
FILE *o; /* required for redirecting screen output to null device */

#ifdef _AMIGA_
 /* Kennung fuer Versionstring auf dem Amiga */
 char vers[] = "$VER: BS "VERSION AMIGADATE;
#endif

/*
 *      crctab calculated by Mark G. Mendel, Network Systems Corporation
 */
static unsigned short crctab[256] = {
   0x0000,0x1021,0x2042,0x3063,0x4084,0x50a5,0x60c6,0x70e7,
   0x8108,0x9129,0xa14a,0xb16b,0xc18c,0xd1ad,0xe1ce,0xf1ef,
   0x1231,0x0210,0x3273,0x2252,0x52b5,0x4294,0x72f7,0x62d6,
   0x9339,0x8318,0xb37b,0xa35a,0xd3bd,0xc39c,0xf3ff,0xe3de,
   0x2462,0x3443,0x0420,0x1401,0x64e6,0x74c7,0x44a4,0x5485,
   0xa56a,0xb54b,0x8528,0x9509,0xe5ee,0xf5cf,0xc5ac,0xd58d,
   0x3653,0x2672,0x1611,0x0630,0x76d7,0x66f6,0x5695,0x46b4,
   0xb75b,0xa77a,0x9719,0x8738,0xf7df,0xe7fe,0xd79d,0xc7bc,
   0x48c4,0x58e5,0x6886,0x78a7,0x0840,0x1861,0x2802,0x3823,
   0xc9cc,0xd9ed,0xe98e,0xf9af,0x8948,0x9969,0xa90a,0xb92b,
   0x5af5,0x4ad4,0x7ab7,0x6a96,0x1a71,0x0a50,0x3a33,0x2a12,
   0xdbfd,0xcbdc,0xfbbf,0xeb9e,0x9b79,0x8b58,0xbb3b,0xab1a,
   0x6ca6,0x7c87,0x4ce4,0x5cc5,0x2c22,0x3c03,0x0c60,0x1c41,
   0xedae,0xfd8f,0xcdec,0xddcd,0xad2a,0xbd0b,0x8d68,0x9d49,
   0x7e97,0x6eb6,0x5ed5,0x4ef4,0x3e13,0x2e32,0x1e51,0x0e70,
   0xff9f,0xefbe,0xdfdd,0xcffc,0xbf1b,0xaf3a,0x9f59,0x8f78,
   0x9188,0x81a9,0xb1ca,0xa1eb,0xd10c,0xc12d,0xf14e,0xe16f,
   0x1080,0x00a1,0x30c2,0x20e3,0x5004,0x4025,0x7046,0x6067,
   0x83b9,0x9398,0xa3fb,0xb3da,0xc33d,0xd31c,0xe37f,0xf35e,
   0x02b1,0x1290,0x22f3,0x32d2,0x4235,0x5214,0x6277,0x7256,
   0xb5ea,0xa5cb,0x95a8,0x8589,0xf56e,0xe54f,0xd52c,0xc50d,
   0x34e2,0x24c3,0x14a0,0x0481,0x7466,0x6447,0x5424,0x4405,
   0xa7db,0xb7fa,0x8799,0x97b8,0xe75f,0xf77e,0xc71d,0xd73c,
   0x26d3,0x36f2,0x0691,0x16b0,0x6657,0x7676,0x4615,0x5634,
   0xd94c,0xc96d,0xf90e,0xe92f,0x99c8,0x89e9,0xb98a,0xa9ab,
   0x5844,0x4865,0x7806,0x6827,0x18c0,0x08e1,0x3882,0x28a3,
   0xcb7d,0xdb5c,0xeb3f,0xfb1e,0x8bf9,0x9bd8,0xabbb,0xbb9a,
   0x4a75,0x5a54,0x6a37,0x7a16,0x0af1,0x1ad0,0x2ab3,0x3a92,
   0xfd2e,0xed0f,0xdd6c,0xcd4d,0xbdaa,0xad8b,0x9de8,0x8dc9,
   0x7c26,0x6c07,0x5c64,0x4c45,0x3ca2,0x2c83,0x1ce0,0x0cc1,
   0xef1f,0xff3e,0xcf5d,0xdf7c,0xaf9b,0xbfba,0x8fd9,0x9ff8,
   0x6e17,0x7e36,0x4e55,0x5e74,0x2e93,0x3eb2,0x0ed1,0x1ef0
};

static unsigned long crc32tab[256] = {
  0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L,
  0x706af48fL, 0xe963a535L, 0x9e6495a3L, 0x0edb8832L, 0x79dcb8a4L,
  0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L,
  0x90bf1d91L, 0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL,
  0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L, 0x136c9856L,
  0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L,
  0xfa0f3d63L, 0x8d080df5L, 0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L,
  0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
  0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L,
  0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L, 0x26d930acL, 0x51de003aL,
  0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L,
  0xb8bda50fL, 0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L,
  0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL, 0x76dc4190L,
  0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL,
  0x9fbfe4a5L, 0xe8b8d433L, 0x7807c9a2L, 0x0f00f934L, 0x9609a88eL,
  0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
  0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL,
  0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L, 0x65b0d9c6L, 0x12b7e950L,
  0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L,
  0xfbd44c65L, 0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L,
  0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL, 0x4369e96aL,
  0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L,
  0xaa0a4c5fL, 0xdd0d7cc9L, 0x5005713cL, 0x270241aaL, 0xbe0b1010L,
  0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
  0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L,
  0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL, 0xedb88320L, 0x9abfb3b6L,
  0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L,
  0x73dc1683L, 0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L,
  0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L, 0xf00f9344L,
  0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL,
  0x196c3671L, 0x6e6b06e7L, 0xfed41b76L, 0x89d32be0L, 0x10da7a5aL,
  0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
  0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L,
  0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL, 0xd80d2bdaL, 0xaf0a1b4cL,
  0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL,
  0x4669be79L, 0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L,
  0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL, 0xc5ba3bbeL,
  0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L,
  0x2cd99e8bL, 0x5bdeae1dL, 0x9b64c2b0L, 0xec63f226L, 0x756aa39cL,
  0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
  0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL,
  0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L, 0x86d3d2d4L, 0xf1d4e242L,
  0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L,
  0x18b74777L, 0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL,
  0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L, 0xa00ae278L,
  0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L,
  0x4969474dL, 0x3e6e77dbL, 0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L,
  0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
  0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L,
  0xcdd70693L, 0x54de5729L, 0x23d967bfL, 0xb3667a2eL, 0xc4614ab8L,
  0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL,
  0x2d02ef8dL
};

/*
 * updcrc macro derived from article Copyright (C) 1986 Stephen Satchell.
 *  NOTE: First argument must be in range 0 to 255.
 *        Second argument is referenced twice.
 *
 * Programmers may incorporate any or all code into their programs,
 * giving proper credit within the source. Publication of the
 * source routines is permitted so long as proper credit is given
 * to Stephen Satchell, Satchell Evaluations and Chuck Forsberg,
 * Omen Technology.
 */
#define updcrc(ch,crc) (crc)=crctab[(crc)>>8]^((((crc)&255)<<8)|(byte)(ch))
#define upd32crc(ch,crc32) (crc32)=crc32tab[((int)(crc32)^(byte)(ch))&0xff]^((crc32)>>8)

int main (int ac, char **av)
{
  long nparts = 20000L;
  int  u = 0;
  int  i;
  flags = 0;

  bigcrc = 1;

  g = 1;
  if (getenv ("BS_G"))
   g = 0;

#ifdef SHORTNAMES
  flags |= FORCE8_3;
#endif

  o = stdout;
  *uplname = *sendhead = EOS;
  strcpy (lsep, "\x0d");

  get_range ("1-");

  if ((ac == 1) || (ac > 15))
  {
   u = 11;
   if (ac >15)
     u = 9;
   ac = 1;
  }
  if ((ac > 1) && (ac < 16))
  {
    for (i = 2; i < ac; i++)
    {
      if (av[i][0] != '-')
      {
        u = 10;
        break;
      }
      switch (av[i][1])
      {
        case '+':
          flags |= DUMB_BIN;
          break;
        case 'B':
        case 'b':
          flags |= BINHEAD;
          break;
        case 'D':
        case 'd':
          if (av[i][2] == 'P' || av[i][2] == 'p')
            flags |= (DPBOX + NODATE);
        case 'L':
        case 'l':
          if (av[i][2] == 'l' || av[i][2] == 'L')
            strcpy (lsep, "\x0a");
          if (av[i][2] == 'c' || av[i][2] == 'C')
            strcpy (lsep, "\x0d\x0a");
          break;
        case 'N':
        case 'n':
          if (av[i][2] == 'D' || av[i][2] == 'd')
            flags |= NODATE;
          break;
        case 'O':
        case 'o':
          bigcrc = 0;
          break;
        case 'Q':
        case 'q':
          if (o == stdout)
            o = fopen (NULLDEV, OPEN_WR_BIN);
            /*o = fopen (".bslog", "a+"); /* for testing purposes */
          break;
        case 'R':
        case 'r':
          i++;
          if (ac <= i)
          {
            i--;
            break;
          }
          flags |= RECODE;
          get_range (av[i]);
          break;
        case 'S':
        case 's':
          if (av[i][2] == EOS || av[i][2] == '2')
          {
            i++;
            if (ac <= i)
            {
              i--;
              break;
            }
            flags |= (SEND + BINHEAD);
            strcpy (send, av[i]);
            if (av[i-1][2] == '2')
              flags |= ADDCR;
            break;
          }
          else
          {
            if (av[i][2] == 'f' || av[i][2] == 'F')
            {
              i++;
              if (ac <= i)
              {
                i--;
                break;
              }

              if (av[i-1][3] == 'l' || av[i-1][3] == 'L')
                strcpy (lsep, "\x0a");
              if (av[i-1][3] == 'c' || av[i-1][3] == 'C')
                strcpy (lsep, "\x0d\x0a");

              flags |= (SEND + BINHEAD);
              strcpy (sendhead, av[i]);
              break;
            }
          }
        case 'T':
        case 't':
          flags |= (W2ORG);
          break;
        case 'U':
        case 'u':
          flags |= BINHEAD;
          if (av[i][2] != '2')
            flags |= JOIN;
          i++;
          if (ac <= i)
          {
            i--;
            break;
          }
          if (*av[i] != '-')
            strcpy (uplname, av[i]);
          else
            i--;
          break;
        case 'W':
        case 'w':
          flags |= (FORCE8_3);
          break;
        default:
          sscanf (&av[i][1], "%ld", &nparts);
          break;
      }
    }
  }
  fprintf (o,g?"\nBinaerer Dateisplitter V"VERSION:
               "\nBinary file splitter V"VERSION);
#if (defined (__WIN32__) && defined (__BORLANDC__))
  fprintf (o,g?"(Lange Dateinamen)":"(long filenames)");
#endif
#ifdef __MSDOS__
  fprintf (o, g?"(DOS_8.3_Dateinamen)":"(DOS_8.3_filenames)");
#endif
  fprintf (o,"/DG1BBQ ("DATE")\n\n");

  if (u)
    usage (u);

  doit (av[1], nparts);
  return (0);
}

void doit (char *fname, long nparts)
{
  FILE    *inf;
  FILE    *otf;
  FILE    *h;
  ulong   timestamp;
  ulong   curtime;
  long    ilen;
  long    len;
  long    orglen;
  long    plen;
  long    bsstartpos;
  long    bscrcpos;
  long    binstartpos;
  long    bincrcpos;
  char    fn[STDSTRING];
  char    ofn[STDSTRING];
  char    pfn[STDSTRING];
  char    s[1024];
  char    datestring[15];
  char    buffer[1025];
  char    _ext = 'b';
  int     ch, i, j;
  int     skipbshead = 0;
  uint    crc;
  ulong   crc32, crc32all;
  int     part;
  int first_part;
  int last_part;
  struct  ftime   current;
  struct tm *now;
  time_t _now;

  crc32all = 0xffffffffL;
  *datestring = EOS;

  strcpy (fn, fname);

#if defined (__WIN32__) || (__MSDOS__)
  {/* Since Win32 does not distinguish the case in filenames, findfirst
   ** is used to determine how the filename is really spelt casewise.
   ** It's usefull for DOS also.
   */
   struct ffblk ffblk; /* only needed locally */
   if (findfirst (fn, &ffblk, 0) == 0)
   {
     fnsplit (fn, drive, dir, NULL, NULL);
     sprintf (fn, "%s%s%s", drive, dir, ffblk.ff_name);
   }

   lcfn (fn);
  }
#endif

  fnsplit (fn, drive, dir, name, ext);

  /* if ext = .B01, combine files */
  if (!strnicmp (ext, ".B01", 4))
  {
    sprintf (ofn, "%s%s%s", drive, dir, name);
    combine (ofn);
  }

  timestamp = get_filetime (fn, datestring);

  if ((inf = fopen (fn, OPEN_R_BIN)) == NULL)
  {
    fprintf (o,g?"\nKann \"%s\" nicht finden.\n":"\nCannot find \"%s\"\n",fn);
    exit (1);
  }

  if (*sendhead)
  {
    memset (buffer, 0, 1025);
    if ((h = fopen (sendhead, OPEN_R_BIN)) == NULL)
    {
      fprintf (o,g?"\nKann Kopfdatei \"%s\" nicht finden.\n":
                   "\nCannot find headerfile \"%s\"\n",fn);
      exit (1);
    }
    fread(buffer, sizeof (char), 512, h);
    fclose (h);

    j = 0;
    for (i = 0; i < 512; i++)
    {
      if (buffer[j] == EOS)
        break;
      if (buffer[j] == 13 && buffer[j+1] == 10)
        j++;
      else
        if (buffer[j] == 13)
          buffer[j] = 10;

      buffer[i] = buffer[j++];
    }
    if (i)
      if (buffer[i-1] == 10)
        i--;
    buffer[i] = EOS;

  }
  setvbuf (inf, NULL, _IOFBF, 16384);

  sprintf (ofn, "%s%s", name, ext);

  if (flags & FORCE8_3)
  {
    build_DOS_name (name, ext);
    strlwr (name);
    strlwr (ext);
  }
  else
  {
    strcpy (name, ofn);

    for (i = 0; i < (int)strlen(name); i++)
      if (name[i] == 32)
        name[i] = '_';
  }

  fseek (inf, 0L, SEEK_END);
  len = orglen = ftell (inf);
  fseek (inf, 0L, SEEK_SET);

  if (nparts > 255L || nparts == 0L)
  {
    /* adjust splitsize according to the input filelength so that 255 parts are
       never exceeded */
    /* check, if part size is too small in relation to original filesize */
    plen = (len + 255L) / 255L;
    /* adjust part size in 10000 increments */
    if (plen > nparts)
    {
     nparts = (plen +9999L) / 10000L;
     nparts *= 10000L;
    }
  }

  if (nparts == 0L)
    nparts = NORPART;

  if (nparts > len)
    nparts = len;

  /* special case. If file is smaller than splitzise, or if user explicitely
     requests it, just add #BIN# header, don't split */
  if (len <= nparts || nparts == 1)
  {
    skipbshead = 1;
    nparts  = 1;
    ilen = len;
    flags |= (BINHEAD + JOIN);
    flags &= (255 - RECODE);
  }

  if (!skipbshead)
  {
    if (len < MINPART)
    {
      fprintf (o,g?"\nEs lohnt nicht, eine Datei von %ld aufzuteilen!\n":
                   "\nNot economical to split a file %ld bytes long!\n", len);
      exit (2);
    }

    if (nparts > len)
    {
      fprintf (o,g?"\nSplitgroesse uebersteigt Dateigroesse"
                    " der ungeteilten Datei!\n":
                   "\nSplitsize is larger than filelength!\n");
      exit (3);
    }

    /* if 1 < splitparm < 256, calculate part size;
       else splitparm == part size */
    ilen = (len + nparts -1)/ nparts;
    if (nparts > 255)
      ilen = nparts;

    /* calculate number of parts */
    nparts = (len + ilen -1) / ilen;

    for (i = 1; (i < 256) && !range[i]; i++);
    first_part = i;

    for (i = 255; (i > 0) && !range[i]; i--);
    last_part = i;

    if (first_part > nparts)
    {
      fprintf (o,g?"\nAngeforderte Teilnummer hoeher als Gesamtzahl Teile!":
                   "\nRequested part number is higher than total part count!");
      exit (8);
    }

    if (ilen < MINPART)
    {
      fprintf (o,g?"\nTeile waeren nur %ld Bytes gross -"
                    " das ist ein wenig klein!\n":
                   "\nParts would be %ld bytes - that's a bit small!\n",ilen);
      exit (6);
    }

    fprintf (o,g?"Zerteile \"%s\" ":"Splitting \"%s\" ", fn);
    if (strlen (fn) > 30)
      fprintf (o,"\n");
    fprintf (o,g?"in %02lX (dez %ld) Teile zu %ld Bytes\n\n":
                 "into %02lX (dec %ld) parts of %ld bytes\n\n",
                                     nparts,nparts,ilen);
  }
  /* get current timestamp for #BIN#-headers */
  if (flags & BINHEAD)
  {
    time (&_now);
    now = localtime (&_now);
    current.ft_tsec  = now->tm_sec /2;
    current.ft_min   = now->tm_min;
    current.ft_hour  = now->tm_hour;
    current.ft_day   = now->tm_mday;
    current.ft_month = now->tm_mon +1;
    current.ft_year  = now->tm_year - 80;
    curtime = *((unsigned long *) &current);
  }

  if (last_part > nparts)
    last_part = (int) nparts;

  if (flags & RECODE)
    fprintf (o, g?"\nErzeuge nur die gewuenschten Teile.":
                  "\nCreating only specified parts.");
  /* now, split */
  for (part = 1; part < nparts + 1; part++)
  {
    /* calculate part size (last part may be smaller than splitsize!) */
    if (part != nparts)
      plen = ilen;
    else
      plen = len;
    len -= ilen;

    /* skip parts, if required */
    if ((flags & RECODE) && !range[part])
    {
      if (bigcrc)
      {
        while (plen--)
          upd32crc (fgetc (inf), crc32all);
      }
      else
        fseek (inf, plen, SEEK_CUR);
      continue;
    }

    /* use u01-uff for seperate parts that contain #BIN#-headers */
    if (flags & BINHEAD)
      _ext = 'u';

    sprintf (pfn , "%s.%c%02x", name, _ext, part);

    if (*uplname)
    {
      if (flags & JOIN)
      {
        if (uplname[(int)strlen(uplname)-1] == PATHCHAR)
          sprintf (pfn, "%s%s.upl", uplname, name);
        else
          strcpy (pfn, uplname);
      }
      else
      {
        if (uplname[(int)strlen(uplname)-1] == PATHCHAR)
          sprintf (pfn, "%s%s.%c%02x", uplname, name, _ext, part);
        else
          sprintf (pfn, "%s.%c%02x", uplname, _ext, part);
      }
    }
    else
      if (flags & JOIN)
        sprintf (pfn , "%s.upl", name);

    if (!(flags & JOIN) ||
        ((flags & JOIN) && (part == 1 || part == first_part)))
      if ((otf = fopen (pfn, OPEN_WR_BIN)) == NULL)
      {
        fprintf (o, g?"\nKann \"%s\" nicht erzeugen.\n":
                      "\nCannot create \"%s\".\n", pfn);
        exit (7);
      }

    sprintf (pfn , "%s.%c%02x", name, _ext, part);

    setvbuf (otf, NULL, _IOFBF, 16384);

    if ((flags & SEND) && (flags & BINHEAD))
    {
      sprintf (s, "%s", name);
      if (!skipbshead)
        sprintf (s, "%s.b%02x/%02lx", name, part, nparts);
      else
        if (flags & FORCE8_3)
          sprintf (s, "%s.%s", name, ext);

      if (!*sendhead)
        fprintf (otf, "%s %s%s%s", send, (flags & ADDCR)?lsep:"", s, lsep);
      else
        top (otf, buffer, ofn, part, (int)nparts);
    }

	 sprintf (s, ">BS<\012%02X\012%02lX\012%ld\012%ld\012%s\012%s\012"
					 ".BS v"VERSION" (c) DG1BBQ\012",
					 part, nparts, ilen, orglen, ofn, datestring);
    /* Do not use pointer s from here to rem'd out copy of above command! */

    if (flags & BINHEAD)
    {
      long l;

      if (!skipbshead)
        fprintf (otf, "%s%sPart %02Xh of %02lXh of \"%s\" (splitsize %ld):%s%s",
                                                       lsep, lsep, part, nparts,
                                                       ofn, ilen, lsep, lsep);

      fprintf (otf, "<BS"VERSION"/"DATE" by DG1BBQ>\%s", lsep);

      if (part == 1 || ((flags & RECODE) && part == first_part))
        binstartpos = ftell (otf);

      fprintf (otf, "#BIN#");

      if (!skipbshead)
      {
        if (bigcrc)
          l = strlen (s) + 24L;
        else
          l = 8L + (long) strlen (ofn);

        if (part == nparts)
        {
          l += plen;
          if (!bigcrc)
            l += 4L;
        }
        else
          l += ilen;
      }
      else
        l = plen;

      fprintf (otf, "%ld#|", l);
      bincrcpos = ftell (otf);

      if (!skipbshead)
      {
        fprintf (otf, "00000#$%08lX#", curtime);
        sprintf (pfn, "%s.b%02x", name, part);
      }
      else
      {
        fprintf (otf, "00000#$%08lX#", timestamp);
        if (flags & FORCE8_3)
          sprintf (pfn, "%s%s%s", name, (*ext?".":""), ext);
        else
          strcpy (pfn, name);
      }
      fprintf (otf, "%s\x0d", pfn);
      bsstartpos = ftell (otf);
    }

    if (!skipbshead)
    {
      if (bigcrc)
      {
        crc = 0;
        i = 0;
        while (s[i])
          updcrc (s[i++], crc);
        updcrc (0, crc);

        fwrite (s, 1, i, otf);
        putc (0, otf);
        fprintf (otf, "%04X\012", crc);
      }
      else
      {
        write_16 (MAGIC, otf);
        fputc ((uint) nparts, otf);
        fputc (part, otf);
        bscrcpos = ftell (otf);
        write_16 (0, otf);

        if (part == nparts)
          fputc ((int) strlen (ofn) + 5, otf);
        else
          fputc ((int) strlen(ofn) + 1, otf);
        fwrite (ofn, (int)strlen (ofn) + 1, 1, otf);

        if (part == nparts)
          write_32 (timestamp, otf);
      }
    }

    crc = 0;
    crc32 = 0xffffffffL;
    while (plen--)
    {
      ch = fgetc (inf);
      if (bigcrc)
      {
        upd32crc (ch, crc32);
        upd32crc (ch, crc32all);
      }
      else
        updcrc (ch, crc);
      fputc (ch, otf);
    }

    if (!skipbshead)
    {
      if (bigcrc)
      {
        char dummy[10];
        sprintf (dummy, "%08lX\012", crc32all ^ 0xffffffffL);
        fprintf (otf, "%08lX\012", crc32all ^ 0xffffffffL);
        i = 0;
        while (i < 9)
          upd32crc (dummy[i++], crc32);

        fprintf (otf, "%08lX\012", crc32 ^ 0xffffffffL);
      }
      else
      {
        fseek (otf, bscrcpos, SEEK_SET);
        write_16 (crc, otf);
      }
    }

    if (flags & BINHEAD)
    {
      crc = 0;
      fseek (otf, bsstartpos, SEEK_SET);
      while ((ch = fgetc (otf)) != EOF)
        updcrc (ch, crc);
      fseek (otf, bincrcpos, SEEK_SET);
      fprintf (otf, "%05u", crc);
    }

    fseek (otf, 0L , SEEK_END);

    /* This is for terminals that can't handle back-to-back BIN files.
       Not very elegant, I admit */
    if ((flags & JOIN)     &&
        (flags & DUMB_BIN) &&
         binstartpos)
    {
      int i, j;
      long k;

      k = 256L - binstartpos;
      for (i = 0; i < 3; i++)
      {
        for (j = 79; j > 0; j--)
        {
          fputc (' ', otf);
          if (--k == 1)
            break;
        }
        fputc ('\x0d', otf);
        if (!--k)
          break;
      }
    }

    if (!(flags & JOIN) || part == last_part || part == nparts)
      fclose (otf);
  }

  if (flags & JOIN)
  {
    fprintf (o, g?"\nUpload-Datei \"":"\nCreated uploadfile \"");
    if (*uplname)
    {
      if (uplname[(int)strlen(uplname)-1] == PATHCHAR)
        sprintf (pfn, "%s%s.upl", uplname, name);
      else
        strcpy (pfn, uplname);
      fprintf (o, g?"%s\" erzeugt.\n":"%s\"\n", pfn);
    }
    else
      fprintf (o, g?"%s.upl\" erzeugt.\n":"%s.upl\"\n", name);
  }
  fprintf (o,g?"\n\nFertig.\n":"\n\nDone.\n");
  if (flags & BINHEAD)
    fprintf (o,g?"\nWichtiger Hinweis:\n\n"
                 "Die erzeugte(n) Datei(en) rein binaer einspielen (also ohne "
                 "AUTOBIN/BOXBIN),\nda die #BIN#-Header bereits enthalten sind!\n\n":
                 "\nImportant note:\n\n"
                 "Use pure binary send for these files, because #BIN# headers\n"
                 "are already included!\n\n");

  return;
}


void combine (char *fn)
{
  FILE    *inf;
  FILE    *otf = NULL;
  char    *p;
  char    *s;
  char    headbuffer[1024];
  char    name[STDSTRING];
  char    name2[STDSTRING];
  char    orig[STDSTRING];
  char    orgpath[STDSTRING];
  char    tmp_name[STDSTRING];
  char    missing[256];
  char    datestring[15];
  int     ch;
  uint    crc;
  uint    ocrc;
  ulong   crc32;
  ulong   crc32all;
  ulong   ocrc32all;
  ulong   timestamp;
  long    length;
  long    orgsize;
  long    split;
  int     i, j;
  int     n = 1;
  int     tot = 0;

  *orig = *orgpath = *tmp_name = *missing = *headbuffer = *datestring =  EOS;
  split = orgsize = 0L;
  crc32all = 0xffffffffL;

  sprintf (orgpath, "%s%s", drive, dir);

  strcpy (name, fn);
  s = name + strlen (name);


  for (;;)
  {
    missing[n] = (char) 0;

    sprintf (s, ".b%02x", n);

    inf = fopen (name, OPEN_R_BIN);

    if (inf == NULL)
    {
      sprintf (s, ".B%02X", n);
      inf = fopen (name, OPEN_R_BIN);
    }

    if (inf == NULL)
    {
      if (n == 1)
      {
          fprintf (o, g?"\nKann \"%s\" nicht finden.\n":
                        "\nCannot find \"%s\"\n", name);
        if (otf)
          fclose (otf);
        if (*tmp_name)
          unlink (tmp_name);
        exit (1);
      }
      else
      {
        missing[n] = missing[0] = (char) 1;
        if (++n > tot)
          break;
        continue;
      }
    }
    setvbuf (inf, NULL, _IOFBF, 16384);

    i = read_16 (inf);
    if (i != MAGIC && i != MAGIC2)
    {
      /* File contains wrong magic number. Probably not a BinSplit file*/
      missing[n] = missing[0] = (char) 1;
      fclose (inf);
      if (n != 1)
      {
        if (!(flags & DPBOX))
          unlink (name);
        if (++n > tot)
          break;
        continue;
      }
      fprintf (o, g?"\n'%s' ist keine BS-Datei. Verarbeitung abgebrochen!\n":
                    "\n'%s' is not a BS file. Can't continue!\n", name);
      exit (13);
    }
    /* Old style BS file */
    if (i == MAGIC)
    {
      bigcrc = 0;
      j = fgetc (inf);
      if (!tot)
        tot = j;
      else
      {
        if (j != tot)
        {
           /* Invalid total part count */
           missing[n] = missing[0] = (char) 1;
           fclose (inf);
           if (n != 1)
           {
             if (!(flags & DPBOX))
               unlink (name);
             if (++n > tot)
               break;
             continue;
           }
           fprintf (o, g?"\n'%s' ist keine BS-Datei. Verarbeitung abgebrochen!\n":
                         "\n'%s' is not a BS file. Can't continue!\n", name);
           exit (13);
        }
      }
      j = fgetc (inf);
      if (j != n)
      {
        /* Sequence error */
        missing[n] = missing[0] = (char) 1;
        fclose (inf);
        if (n != 1)
        {
          if (!(flags & DPBOX))
            unlink (name);
          if (++n > tot)
            break;
          continue;
        }
        fprintf (o, g?"\n'%s' ist keine BS-Datei. Verarbeitung abgebrochen!\n":
                      "\n'%s' is not a BS file. Can't continue!\n", name);
        exit (13);
      }
      ocrc = (uint) read_16 (inf);
    }
    else
    /* New style BS file */
    {
      static int tot2, n2;
      static long orgsize2, split2, split3;
      static char orig2[STDSTRING] = "";
      static char orig3[STDSTRING] = "";
      static char date2 [15] = "";
      static char date3 [15] = "";
      char *r, *t;

      bigcrc = 1;

      if (n == 1)
      {
        tot2 = n2 = 0;
        orgsize2 = split2 = split3 = 0L;
        *orig2 = *orig3 = *date2 = *date3 = EOS;
      }

      sprintf (headbuffer, ">B");
      crc = 0;
      updcrc ('>', crc);
      updcrc ('B', crc);
      j = 2;
      while ((i = fgetc (inf)) != EOF)
      {
        updcrc (i, crc);
        headbuffer[j] = (char) i;
        if (i == 0)
          break;
        if (j == 1023)
          break;
        j++;
      }
      headbuffer[j] = EOS;

      fscanf (inf, "%x", &i);
      fgetc (inf);

      if (strnicmp (headbuffer, ">BS<", 4))
      {
        fprintf (o, g?"\n'%s' ist wahrscheinlich keine BS-Datei. Verarbeitung abgebrochen!\n":
                      "\n'%s' is probably not a BS file. Can't continue!\n", name);
        exit (13);
      }

      if ((uint)i != crc)
      {
        fclose (inf);
        if (!(flags & DPBOX))
          unlink (name);

        if (n == 1)
        {
          fprintf (o, g?"\n'%s' hat einen defekten Header. Verarbeitung abgebrochen!\n":
                        "\n'%s' has a corrupted header. Can't continue!\n", name);
          exit (13);
        }

        missing[0] = (char) 1;
        missing[n] = (char) 2;
        if (++n > tot)
          break;
        continue;
      }

      /* Get information from header */
      r = headbuffer+3;
      j = 0;
      while (*r++)
      {
        if (!*r)
          break;

        if (*r == 10)
        {
          r++;
          j++;
          switch (j)
          {
            case 1: /* part number */
                    sscanf (r, "%x", &n2);
                    break;
            case 2: /* overall parts */
                    sscanf (r, "%x", &tot2);
                    break;
            case 3: /* splitsize */
                    sscanf (r, "%ld", &split2);
                    if (n == 1)
                     split3 = split2;
                    break;
            case 4: /* size of original file */
                    sscanf (r, "%ld", &orgsize2);
                    break;
            case 5: t = orig2;
                    while (*r != 10 && ((orig2 - t) < (STDSTRING-1)))
                      *t++ = *r++;
                    r--;
                    *t = EOS;
                    lcfn (orig2);
                    if (n == 1)
                      strcpy (orig3, orig2);
                    break;
            case 6: sscanf (r, "%14s", date2);
                    if (n == 1)
                      strcpy (date3, date2);
                    break;
            case 7: /* This is for future additions to the BS header */
                    switch (*r)
                    {
                      case 'A': break;
                      case 'B': break;
                      default:  break;
                    }
            default: break;
          }
        }
      }

      if (n == 1)
      {
        /* set total number of files etc., if this is first turn of loop */
        tot = tot2;
        strcpy (orig, orig2);
        strcpy (datestring, date2);
        split = split2;
        orgsize = orgsize2;
      }
      else
      {
        if (n2 != n || tot2 != tot || strcmp (orig2, orig3) || strcmp (date2, date3) ||
            split2 != split3 || orgsize2 != orgsize)
        {
          /* file sequence error / wrong file (who's trying to trick me here?) */
          missing[n] = missing[0] = (char) 1;
          fclose (inf);
          if (!(flags & DPBOX))
            unlink (name);
          if (++n > tot)
            break;
          continue;
        }
      }

      length = split;
      if (n == tot)
      {
        length = orgsize % split;
        if (!length)
          length = split;
      }
    }

    if (n == 1)
    {
      if (!bigcrc)
      {
        p = orig;
        fgetc (inf);            /* ignore length byte */
        while ((*p = (char) fgetc (inf)) != '\0')
          p++;
      }
      if (flags & FORCE8_3)
      {
        fnsplit (orig, NULL, NULL, name2, ext);
        build_DOS_name (name2, ext);
        sprintf (orig, "%s%s%s", name2, (*ext?".":""), ext);
      }

      if (*uplname)
        if (uplname[(int)strlen(uplname)-1] == PATHCHAR)
        {
          sprintf (name2, "%s%s", uplname, orig);
          strcpy (orig, name2);
        }
        else
          strcpy (orig, uplname);

      if (!(flags & FORCE8_3))
      {
        make_compat (orig);
        sprintf (tmp_name, "%s.tmp", orig);
      }
      else
      {
        strcpy (tmp_name, orig);
        if ((p = strrchr (tmp_name, '.')) != NULL)
          *++p = '$';
        else
          sprintf (tmp_name, "%s.$", orig);
      }

      if (flags & W2ORG) /* place temp file in same dir as input files */
      {
        char x[STDSTRING];
        sprintf (x, "%s%s", orgpath, tmp_name);
        strcpy (tmp_name, x);
      }

      if ((otf = fopen (tmp_name, OPEN_W_BIN)) == NULL)
      {
        fprintf (o, g?"\nKann temporaere Ausgabedatei \"%s\" nicht erzeugen.\n":
                      "\nCannot create temporary output file \"%s\"\n", tmp_name);
        exit (7);
      }
      setvbuf (otf, NULL, _IOFBF, 16384);

      fprintf (o, g?"Setze \"%s\" wieder zusammen.\n":"Recombining \"%s\"\n", name);
    }
    else
    {
      if (!bigcrc)
      {
        i = fgetc (inf);
        while (i--)
          fgetc (inf);        /* ignore file name */
      }
    }

    if (bigcrc)
    {
      long CRC32;
      char dummy[256];
      /* Read data and update CRC32 */
      crc32 = 0xffffffffL;
      while (length--)
      {
        if ((ch = fgetc (inf)) != EOF)
        {
          upd32crc (fputc (ch, otf), crc32);
          upd32crc (ch, crc32all);
        }
      }

      i = 0;
      while (i < 8)
        dummy[i++] = (char) fgetc(inf);
      fgetc (inf);
      dummy [8] = EOS;
      sscanf (dummy, "%lX", &ocrc32all);
      i = 0;
      while (i < 8)
        upd32crc (dummy[i++], crc32);
      upd32crc (10, crc32);

      i = 0;
      while (i < 8)
        dummy[i++] = (char) fgetc(inf);
      fgetc (inf);
      dummy [8] = EOS;
      sscanf (dummy, "%lX", &CRC32);

      crc32    ^= 0xffffffffL;
      if (crc32 != ((ulong) CRC32))
      {
        missing[0] = (char) 1;
        missing[n] = (char) 2;
        fclose (inf);
        if (!(flags & DPBOX))
          unlink (name);
        if (++n > tot)
          break;
        continue;
      }
    }
    else
    {
      /* Read data and update CRC */
      crc = 0;
      while ((ch = fgetc (inf)) != EOF)
        updcrc (fputc (ch, otf), crc);

      if (crc != ocrc)
      {
        missing[0] = (char) 1;
        missing[n] = (char) 2;
        fclose (inf);
        if (!(flags & DPBOX))
          unlink (name);
        if (++n > tot)
          break;
        continue;
      }
    }

    if (++n > tot)
    {
      if (!*missing)
      {
        if (bigcrc)
          timestamp = 0L;
        else
        {
          fseek (inf, 6L, SEEK_SET);
          i = fgetc (inf);
          i -= 4;
          fseek (inf, i, SEEK_CUR);
          timestamp = (ulong) read_32 (inf);
        }
      }
      fclose (inf);
      break;
    }
    fclose (inf);
  }

  length = ftell (otf);
  fclose (otf);

  if (!*missing)
  {
    if (flags & W2ORG)
    {
      char x[STDSTRING];

      sprintf (x, "%s%s", orgpath, orig);
      strcpy (orig, x);
    }

    inf = fopen (orig, OPEN_R_BIN); /* Is there already a file of the same name? */

    if (inf)
    { /* Yep, get rid of it. */
      fclose (inf);
      unlink (orig);
    }
    rename (tmp_name, orig); /* and replace it with the freshly processed one */

    if (!(flags & NODATE))
      set_filetime (orig, timestamp, datestring);

    if (flags & DPBOX)
    {
      fnsplit (name, drive, dir, send, NULL);
      sprintf (fn, "%s%s.%s.b01", drive, dir, send);
      fnsplit (orig, drive, dir, send, ext);
      sprintf (sendhead, "%s%s.%s%s", drive, dir, send, ext);
      rename (fn, sendhead);
    }

    for (i = 1; i < n; i++)
    {
      sprintf (s, ".b%02x", i);
      if (unlink (name))
      {
        sprintf (s, ".B%02X", i);
        unlink (name);
      }
      if (flags & DPBOX)
      {
        fnsplit (name, drive, dir, send, NULL);
        sprintf (fn, "%s%s.%s.b%02x", drive, dir, send, i);
        if (unlink (fn))
        {
          sprintf (fn, "%s%s.%s.B%02X", drive, dir, send, i);
          unlink (fn);
        }
      }

    }

    if (bigcrc)
    {
      crc32all ^= 0xffffffffL;
      if (crc32all != ocrc32all)
      {
        fprintf (o, g?"\nFataler Fehler! Gesamt-32Bit-CRC stimmt nicht!\n"
                      "Dieser Fehler wird wahrscheinlich durch BS selbst verursacht.\n"
                      "Bitte Meldung mit genauer Beschreibung an DG1BBQ. Danke!\n":
                      "\nFatal! Overall 32bit-CRC incorrect!\n"
                      "This error is likely to be caused by BS itself.\n"
                      "Please report this error with exact description to DG1BBQ. Tnx!\n");
        unlink (orig);
        exit (14);
      }

    }


    fprintf (o, g?"\n\n\"%s\" (%ld Bytes) erfolgreich zusammengesetzt!\n"
                "\nFertig.\n":
                "\n\n\"%s\" (%ld Bytes) successfully recombined!\n"
                "\nDone.\n", orig, length);
  }
  else
  {
    unlink (tmp_name);
    fprintf (o,
      g?"\n\n\"%s\" konnte nicht erstellt werden.\n"
        "\nDie folgenden Teile fehlen, oder haben eine falsche CRC (*):\n\n":
        "\n\nCouldn't create \"%s\"\n"
        "\nThe following parts are missing or have a bad CRC(*):\n\n", orig);
    for (i = 1; i <= tot; i++)
    {
      if (missing[i] == 1)
        fprintf (o," %02x ", i);
      if (missing[i] == 2)
        fprintf (o," %02x*", i);
    }
    fprintf (o, g?"\n\nDie Teile mit falschen CRCs wurden geloescht.\n"
                  "\nBitte die aufgefuehrten Teile neu besorgen und erneut versuchen!\n\n":
                  "\n\nThe files with bad CRCs have been erased.\n"
                  "\nGet the listed parts and try again!\n\n");
  }

  if (*missing)
   exit(12);

  exit (0);
}

/*
*** Create a MSDOS/ATARI compatible filename.
***
***
 */

void build_DOS_name (char *name, char *ext)
{

  make_compat (name);

  if (*ext)
    memmove (ext, ext +1, strlen (ext));

  make_compat (ext);

  /* truncate name and extension to 8/3 */
  name[8] = EOS;
  ext[3]  = EOS; /* no . in ext! */
}

/*
*** Add function body for your system to make filename compatible.
*** E.g. Unix does not allow spaces in filenames.
 */
void make_compat (char *name)
{
  int i;
#ifdef __unix__ /* for guess what */
  i = -1;
  /** swap space for _ **/
  while (name[++i])
    if (name[i] == ' ')
      name[i] = '_';
#endif

  if (flags & FORCE8_3) /** for DOS, OS/2 and Win before 95 **/
  {
    i = 0;

    strlwr (name);

    if (*name)
    {
      do
      {
        /** allow only alphanumeric chars + -_#!@$~ and no spaces **/
        if ((isalnum (name[i]) || strchr ("-_#!@$~", name[i]))
            && (name[i] != ' '))
          continue;
        name[i] = '_';
      }
      while (name[++i]);

      name[i] = EOS;
    }
  }
}

/* Special case. Filenames that were created by a DOS-program under
   Win95/NT always have upper case filenames. Not so good, when
   files are combined under Linux e.g... This section will convert the
   filename to lower case if it's name is max 8.3 AND uppercase.
   It's just a compromize. Since it is not distinguishable where a file
   was split, it may happen that some filename are converted, when they
   should not be.
*/
void lcfn (char *filename)
{
  char a[STDSTRING];
  char b[STDSTRING];
  int i, j;

  fnsplit (filename, NULL, NULL, a, b);

  if (strlen (a) < 9 && strlen (b) < 5)
  {
    j = 1;
    i = -1;
    /* Test, if name is upper case */
    while (filename[++i])
      if (isalpha (filename[i]))
        if (islower (filename[i]))
         j = 0;
    if (j)
      strlwr (filename); /* It is. Lower case it. */
  }
}
/*
*** output head from file. Expand variables.
***
***
 */

int top (FILE *wfile, char *top, char *orgname, int part, int parts)
{
  int i;
  char __file[STDSTRING], __ext[STDSTRING];
  char _file[STDSTRING],  _ext[STDSTRING];

  fnsplit (orgname, NULL, NULL, _file, _ext);
  strcpy (__file, _file);
  strcpy (__ext , _ext );
  if (flags & FORCE8_3)
  {
    build_DOS_name (__file, __ext);
    strlwr (__file);
    strlwr (__ext);
  }
  else
  {
    i = -1;
    while (_file[++i])
      if (_file[i] == ' ')
        _file[i] = '_';

    i = -1;
    while (_ext[++i])
      if (_ext[i] == ' ')
        _ext[i] = '_';
  }

  i = 0;
  while (top[i] != EOS)
  {
    if (top[i] == '%')
    {
      i++;
      if (!top[i])
        break;

      switch (top[i])
      {
        case 'o':
        case 'O': fprintf (wfile, "%s", orgname);
                  break;
        case 'n':
        case 'N': if (flags & FORCE8_3)
                    fprintf (wfile, "%s.b%02x", __file, part);
                  else
                    fprintf (wfile, "%s%s.b%02x", _file, *_ext?_ext:"", part);
                  break;
        case 'p': fprintf (wfile, "%d", part);
                  break;
        case 'P': fprintf (wfile, "%02X", part);
                  break;
        case 'q': fprintf (wfile, "%d", parts);
                  break;
        case 'Q': fprintf (wfile, "%02X", parts);
                  break;
        case '%': fprintf (wfile, "%s", "%");
                  break;

        default : fprintf (wfile, "%%%c", top[i]);
      }
      i++;
    }
    if (!top[i])
      break;

    if (top[i] == '\n')
      fprintf (wfile, "%s", lsep);
    else
      putc (top[i], wfile);

    i++;
  }

  return (0);
}

/*
*** Evaluate specified range. Be as tollerant as possible.
*** Syntax: '-5,1-2,5,1C-' means: parts 1,2,3,4,5 and 1C-FF.
*** Ranges not required to be in correct order.
*** Overlapping of ranges is allowed, but spaces are not.
 */
void get_range (char *rangestring)
{
  int i, start, end;
  char *p;
  char rstring[STDSTRING];

  strcpy (rstring, rangestring);

  for (i = 0; i < 256; i++)
    range[i] = 0;

  /* get first range */
  p = strtok (rstring, ",");

  do
  {
    start = end = 0;

    if (*p == '-')
    {
      sscanf (p+1, "%03x", &end);
      if (end > 0xb00 && end < 0xc00)
        end -= 0xb00;
      start = 1;
    }
    else
    {
      i = sscanf (p, "%03x-%03x", &start, &end);
      if (start > 0xb00 && start < 0xc00)
        start -= 0xb00;
      if (i == 2)
        if (end > 0xb00 && end < 0xc00)
          end -= 0xb00;
      if (i == 2 && !end)
        end = 1;

      if (p[(int)strlen(p)-1] == '-')
        end = 255;
    }

    if (start > 255)
      start = 255;

    if (end > 255)
      end = 255;

    if (start == 0)
      start = 1;

    if (!end)
       end = start;

    if (end < start)
    {
      /* End lower than beginning. Trade places */
      i = start;
      start = end;
      end = i;
    }
    /* add range to array */
    for (i = start ;i <= end; i++)
      range[i] = 1;
    range[0] = 1;
  }
  while((p = strtok (NULL, ",")) != NULL); /* get next range */

  /* No range was defined. Set range to 1-255 */
  if (!range[0])
    for (i = 1; i < 256; i++)
      range[i] = 1;
}

#ifdef __BORLANDC__
 #pragma warn -sig
#endif
/*
*** Reading/writing unsigned int (16bit)
***
***
 */
int read_16 (FILE *in)
{
  uint val;

  val =        (uint) fgetc (in);
  val = val + ((uint) fgetc (in) << 8);

  return ((int)val);
}

void write_16 (int val, FILE *out)
{
  putc ((int) ((uint)val    &0xffU), out);
  putc ((int)(((uint)val>>8)&0xffU), out);
}

long read_32 (FILE *in)
{
  ulong val;

  val =        (ulong) fgetc (in);
  val = val + ((ulong) fgetc (in) <<  8);
  val = val + ((ulong) fgetc (in) << 16);
  val = val + ((ulong) fgetc (in) << 24);

  return ((long)val);
}

void write_32 (long val, FILE *out)
{
  putc ((int) ((ulong)val     &0xffUL), out);
  putc ((int)(((ulong)val>>8 )&0xffUL), out);
  putc ((int)(((ulong)val>>16)&0xffUL), out);
  putc ((int)(((ulong)val>>24)&0xffUL), out);
}
#ifdef __BORLANDC__
 #pragma warn .sig
#endif

#if defined (__MSDOS__) || (__TOS__) || (__BORLANDC__)
 /*
 *** Get file's timestamp and package it into a 32-bit word (MS_DOS-format)
 ***
 ***
  */
 ulong get_filetime (const char *filename, char *datestring)
 {
   ulong    ftimestamp = 0;
   FILE *file;
   struct ftime *fti;

   /* convert MS/DOS ftimestamp to UNIX atime */
   fti = (struct ftime *) &ftimestamp;

   if ((file = fopen (filename, OPEN_R_BIN)) == NULL)
     return (0);

   if (getftime (fileno(file), (struct ftime *)&ftimestamp) == EOF)
   {
     fprintf (o,g?"\007\nDer Zeitstempel der Datei \"%s\" konnte nicht abgefragt werden!\n":
                  "\007\nCan't get timestamp of file \"%s\"!\n", filename);
     fclose (file);
     return (0);
   }

   sprintf (datestring   , "%04d", fti->ft_year +1980);
   sprintf (datestring+4 , "%02d", fti->ft_month);
   sprintf (datestring+6 , "%02d", fti->ft_day);
   sprintf (datestring+8 , "%02d", fti->ft_hour);
   sprintf (datestring+10, "%02d", fti->ft_min);
   sprintf (datestring+12, "%02d", fti->ft_tsec*2);

 #ifdef __TOS__
   ftimestamp = swapl(ftimestamp);
 #endif

   fclose (file);

   return (ftimestamp);
 }

 #define _SETFTIME_OK
 /*
 *** Set file's timestamp
 ***
 ***
  */
 void set_filetime (const char *filename, ulong ftimestamp, char *datestring)
 {
   FILE *file;
   int i;
   struct ftime *fti;

   fti = (struct ftime *) &ftimestamp;


   if ((file = fopen (filename, OPEN_A_BIN)) == NULL)
   {
     fprintf (o, g?"\007\nDer Zeitstempel der Datei \"%s\" konnte nicht gesetzt werden!\n":
                   "\007\nCan't set timestamp of file \"%s\"!\n", filename);
     return;
   }

   if (*datestring)
   {
     sscanf (datestring+12, "%d", &i);
     fti->ft_tsec = i/2;
     *(datestring+12) = EOS;
     sscanf (datestring+10, "%d", &i);
     fti->ft_min = i;
     *(datestring+10) = EOS;
     sscanf (datestring+8, "%d", &i);
     fti->ft_hour = i;
     *(datestring+8) = EOS;
     sscanf (datestring+6, "%d", &i);
     fti->ft_day = i;
     *(datestring+6) = EOS;
     sscanf (datestring+4, "%d", &i);
     fti->ft_month = i;
     *(datestring+4) = EOS;
     sscanf (datestring, "%d", &i);
     fti->ft_year = i - 1980;
   }

 #ifdef __TOS__
   ftimestamp = swapl(ftimestamp);
 #endif

   if (setftime (fileno(file), (struct ftime *)&ftimestamp) == EOF)
     fprintf (o, g?"\007\nDer Zeitstempel der Datei \"%s\" konnte nicht gesetzt werden!\n":
                   "\007\nCan't set timestamp of file \"%s\"!\n", filename);

   fclose (file);
 }

#else /* it's not an MSDOS or Atari system */
 #ifndef _HAVE_GMTIME
  /*
  * these functions are required for converting a MSDOS time to a UNIX time
  * and vice versa.
  */

  /*
  * mktime function from GNU C library V1.03; modified:
  * - expanded DEFUN and CONST macros from ansidecl.h
  * - inserted __isleap macro from time.h
  * - inserted __mon_lengths array and __offtime function from offtime.c
  * - inserted gmtime function from gmtime.c
  * - commented out call of localtime function
  * Be aware of the following copyright message for mktime !!!
  */

  /* Copyright (C) 1991 Free Software Foundation, Inc.
  This file is part of the GNU C Library.

  The GNU C Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  The GNU C Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with the GNU C Library; see the file COPYING.LIB.  If
  not, write to the Free Software Foundation, Inc., 675 Mass Ave,
  Cambridge, MA 02139, USA.  */


  /* How many days are in each month.  */
  const unsigned short int __mon_lengths[2][12] =
  {
    /* Normal years.  */
    { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
    /* Leap years.  */
    { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
  };

  #define  __isleap(year)  \
   ((year) % 4 == 0 && ((year) % 100 != 0 || (year) % 400 == 0))

  #define  invalid()  return (time_t) -1


  #define  SECS_PER_HOUR  (60 * 60)
  #define  SECS_PER_DAY  (SECS_PER_HOUR * 24)

  /* Returns the `struct tm' representation of *T,
     offset OFFSET seconds east of UCT.  */
  struct tm *
  __offtime (const time_t *t, long int offset)
  {
   static struct tm tbuf;
   register long int days, rem;
   register int y;
   register const unsigned short int *ip;

   if (t == NULL)
    return NULL;

   days = *t / SECS_PER_DAY;
   rem = *t % SECS_PER_DAY;
   rem += offset;
   while (rem < 0)
   {
    rem += SECS_PER_DAY;
    --days;
   }
   while (rem >= SECS_PER_DAY)
   {
    rem -= SECS_PER_DAY;
    ++days;
   }
   tbuf.tm_hour = rem / SECS_PER_HOUR;
   rem %= SECS_PER_HOUR;
   tbuf.tm_min = rem / 60;
   tbuf.tm_sec = rem % 60;
   /* January 1, 1970 was a Thursday.  */
   tbuf.tm_wday = (4 + days) % 7;
   if (tbuf.tm_wday < 0)
    tbuf.tm_wday += 7;
   y = 1970;
   while (days >= (rem = __isleap(y) ? 366 : 365))
   {
    ++y;
    days -= rem;
   }
   while (days < 0)
   {
    --y;
    days += __isleap(y) ? 366 : 365;
   }
   tbuf.tm_year = y - 1900;
   tbuf.tm_yday = days;
   ip = __mon_lengths[__isleap(y)];
   for (y = 0; days >= ip[y]; ++y)
    days -= ip[y];
   tbuf.tm_mon = y;
   tbuf.tm_mday = days + 1;
   tbuf.tm_isdst = -1;

   return &tbuf;
  }


  /* Return the `struct tm' representation of *T in UTC.  */
  struct tm *
  gmtime (const time_t *t)
  {
   return __offtime(t, 0L);
  }
 #endif /* ifndef _HAVE_GMTIME */

 #ifndef _HAVE_MKTIME

  /* Return the `time_t' representation of TP and normalizes TP.
     Return (time_t) -1 if TP is not representable as a `time_t'.
     Note that 31 Dec 1969 23:59:59 is not representable
     because it is represented as (time_t) -1.  */
  time_t mktime (register struct tm *tp)
  {
   static struct tm min, max;
   static char init = 0;

   register time_t result;
   register time_t t;
   register int i;
   register const unsigned short *l;
   register struct tm *new_;
   time_t end;

   if (tp == NULL)
   {
    errno = EINVAL;
    invalid();
   }

   if (!init)
   {
    init = 1;
    end = (time_t) LONG_MIN;
    new_ = gmtime(&end);
    if (new_ != NULL)
     min = *new_;
    else
     min.tm_sec = min.tm_min = min.tm_hour =
    min.tm_mday = min.tm_mon = min.tm_year = INT_MIN;

    end = (time_t) LONG_MAX;
    new_ = gmtime(&end);
    if (new_ != NULL)
     max = *new_;
    else
     max.tm_sec = max.tm_min = max.tm_hour =
    max.tm_mday = max.tm_mon = max.tm_year = INT_MAX;
   }

   /* Make all the elements of TP that we pay attention to
     be within the ranges of reasonable values for those things.  */
   #define  normalize(elt, min, max, nextelt)\
    while (tp->elt < min)                    \
    {                                        \
     --tp->nextelt;                          \
     tp->elt += max + 1;                     \
    }                                        \
    while (tp->elt > max)                    \
    {                                        \
     ++tp->nextelt;                          \
     tp->elt -= max + 1;                     \
    }

   normalize (tm_sec, 0, 59, tm_min);
   normalize (tm_min, 0, 59, tm_hour);
   normalize (tm_hour, 0, 24, tm_mday);

   /* Normalize the month first so we can use
      it to figure the range for the day.  */
   normalize (tm_mon, 0, 11, tm_year);
   normalize (tm_mday, 1, __mon_lengths[__isleap (tp->tm_year)][tp->tm_mon],
   tm_mon);

   /* Normalize the month again, since normalizing
      the day may have pushed it out of range.  */
   normalize (tm_mon, 0, 11, tm_year);

   /* Normalize the day again, because normalizing
      the month may have changed the range.  */
   normalize (tm_mday, 1, __mon_lengths[__isleap (tp->tm_year)][tp->tm_mon],
    tm_mon);

   /* Check for out-of-range values.  */
   #define  lowhigh(field, minmax, cmp)  (tp->field cmp minmax.field)
   #define  low(field)                  lowhigh(field, min, <)
   #define  high(field)                 lowhigh(field, max, >)
   #define  oor(field)                  (low(field) || high(field))
   #define  lowbound(field)             (tp->field == min.field)
   #define  highbound(field)            (tp->field == max.field)
   if (oor(tm_year))
    invalid();
   else
    if (lowbound(tm_year))
    {
     if (low(tm_mon))
      invalid();
     else
      if (lowbound(tm_mon))
      {
       if (low(tm_mday))
        invalid();
       else
        if (lowbound(tm_mday))
        {
         if (low(tm_hour))
          invalid();
         else
          if (lowbound(tm_hour))
          {
           if (low(tm_min))
            invalid();
           else
            if (lowbound(tm_min))
            {
             if (low(tm_sec))
             invalid();
            }
          }
        }
      }
    }
    else
     if (highbound(tm_year))
     {
      if (high(tm_mon))
       invalid();
      else
       if (highbound(tm_mon))
       {
        if (high(tm_mday))
         invalid();
        else
         if (highbound(tm_mday))
         {
          if (high(tm_hour))
           invalid();
          else
           if (highbound(tm_hour))
           {
            if (high(tm_min))
             invalid();
            else
             if (highbound(tm_min))
             {
              if (high(tm_sec))
               invalid();
             }
           }
         }
       }
     }
    t = 0;
    for (i = 1970; i > 1900 + tp->tm_year; --i)
     t -= __isleap(i) ? 366 : 365;
    for (i = 1970; i < 1900 + tp->tm_year; ++i)
     t += __isleap(i) ? 366 : 365;
    l = __mon_lengths[__isleap(1900 + tp->tm_year)];
    for (i = 0; i < tp->tm_mon; ++i)
     t += l[i];
    t += tp->tm_mday - 1;
    result = ((t * 60 * 60 * 24) +
              (tp->tm_hour * 60 * 60) +
              (tp->tm_min * 60) +
               tp->tm_sec);

    end = result;
   #if 0
   if (tp->tm_isdst < 0)
    new_ = localtime(&end);
   else
   #endif
    new_ = gmtime(&end);
   if (new_ == NULL)
    invalid();
   new_->tm_isdst = tp->tm_isdst;
   *tp = *new_;

   return result;
  }
 #endif /* ifndef _HAVE_MKTIME */

 /*
  * Get file's timestamp and package it into a 32-bit word (MS_DOS-format).
  * This function should work on any system (even on AMIGAs) :-)
  */
 ulong get_filetime (const char *filename, char *datestring)
 {
   struct ftime fti;
   ulong *retval = (ulong *) &fti;
   struct tm *utm;
   struct stat fst;

   *retval = 0UL;

   /* get file status */
   if (stat (filename, &fst) == 0)
   {
     /* get time of last modification and convert it to MS/DOS time */
     utm = localtime (&fst.st_mtime);

     if (utm)
     {
       datestring[14] = EOS;
       fti.ft_year  = utm->tm_year - 80;
       sprintf (datestring, "%04d", utm->tm_year + 1900);
       fti.ft_month = utm->tm_mon + 1;
       sprintf (datestring+4, "%02d", utm->tm_mon +1);
       fti.ft_day   = utm->tm_mday;
       sprintf (datestring+6, "%02d", utm->tm_mday);
       fti.ft_hour  = utm->tm_hour;
       sprintf (datestring+8, "%02d", utm->tm_hour);
       fti.ft_min   = utm->tm_min;
       sprintf (datestring+10, "%02d", utm->tm_min);
     #ifdef __EMX__
        /* The gmtime() implementation of EMX/GCC under OS2 already devides
        the seconds by 2.. strange!?  */
        fti.ft_tsec  = utm->tm_sec;
        sprintf (datestring+12, "%02d", utm->tm_sec *2);
     #else
        fti.ft_tsec  = utm->tm_sec / 2;
        sprintf (datestring+12, "%02d", utm->tm_sec);
     #endif

       return (*retval);
     }
   }

   /* error exit */
   fprintf (o,g?"\007\nDer Zeitstempel der Datei \"%s\" konnte nicht abgefragt werden!\n":
                "\007\nCan't get timestamp of file \"%s\"!\n", filename);
   return (*retval);
 }

 #ifdef _AMIGA_
  #define _SETFTIME_OK
  /*
  * Set file's timestamp
  * This function only works on AMIGA-systems
  */
  void set_filetime (const char *filename, ulong ftimestamp, char *datestring)
  {
   time_t atime;
   int i;
   struct ftime *fti;
   struct tm utm;
   struct DateStamp fdate;

   if (*datestring)
   {
     sscanf (datestring+12, "%d", &i);
     utm.tm_sec = i;
     *(datestring+12) = EOS;
     sscanf (datestring+10, "%d", &i);
     utm.tm_min = i;
     *(datestring+10) = EOS;
     sscanf (datestring+8, "%d", &i);
     utm.tm_hour = i;
     *(datestring+8) = EOS;
     sscanf (datestring+6, "%d", &i);
     utm.tm_mday = i;
     *(datestring+6) = EOS;
     sscanf (datestring+4, "%d", &i);
     utm.tm_mon = --i;
     *(datestring+4) = EOS;
     sscanf (datestring, "%d", &i);
     utm.tm_year = i - 1900;
     utm.tm_wday  = utm.tm_yday  =  utm.tm_isdst = 0;
   }
   else
   {
     struct ftime *fti;
     /* convert MS/DOS ftimestamp to UNIX atime */
     fti = (struct ftime *) &ftimestamp;
     utm.tm_sec   = fti->ft_tsec * 2;
     utm.tm_min   = fti->ft_min;
     utm.tm_hour  = fti->ft_hour;
     utm.tm_mday  = fti->ft_day;
     utm.tm_mon   = fti->ft_month - 1;
     utm.tm_year  = fti->ft_year +80;
     utm.tm_wday  = utm.tm_yday  =  utm.tm_isdst = 0;
   }
   atime = mktime (&utm);

   fdate.ds_Days = (atime/86400)-2922; /* 86400sec per Day + systimecorr.*/
   fdate.ds_Minute = (atime % 86400) / 60;
   fdate.ds_Tick = (atime % 60) * TICKS_PER_SECOND;

   SetFileDate((char*)filename,&fdate); /* (char*) eingefuegt (DG9BJA) */

   return; /* (1) nach return entfernt (DG9BJA) */
  }
 #endif /* _AMIGA_ */

 #if (defined (__unix__) || defined (OSK) || defined (__OS2__))
  #define _SETFTIME_OK

  /*
  * Set file's timestamp
  * This function only works on systems that have utime() available
  */
  void set_filetime (const char *filename, ulong ftimestamp, char *datestring)
  {
   int i;
   time_t atime;
   struct utimbuf utim;
   struct tm utm;

   if (*datestring)
   {
     sscanf (datestring+12, "%d", &i);
     utm.tm_sec = i;
     *(datestring+12) = EOS;
     sscanf (datestring+10, "%d", &i);
     utm.tm_min = i;
     *(datestring+10) = EOS;
     sscanf (datestring+8, "%d", &i);
     utm.tm_hour = i;
     *(datestring+8) = EOS;
     sscanf (datestring+6, "%d", &i);
     utm.tm_mday = i;
     *(datestring+6) = EOS;
     sscanf (datestring+4, "%d", &i);
     utm.tm_mon = --i;
     *(datestring+4) = EOS;
     sscanf (datestring, "%d", &i);
     utm.tm_year = i - 1900;
     utm.tm_wday  = utm.tm_yday  =  utm.tm_isdst = 0;
   }
   else
   {
     struct ftime *fti;
     /* convert MS/DOS ftimestamp to UNIX atime */
     fti = (struct ftime *) &ftimestamp;
     /* Now, setup struct utm with real data */
     utm.tm_sec   = fti->ft_tsec * 2;
     utm.tm_min   = fti->ft_min;
     utm.tm_hour  = fti->ft_hour;
     utm.tm_mday  = fti->ft_day;
     utm.tm_mon   = fti->ft_month - 1;
     utm.tm_year  = fti->ft_year + 80;
     utm.tm_wday  = utm.tm_yday  =  utm.tm_isdst = 0;
   }
   atime = mktime(&utm);

   if (atime != -1)
   {
    /* set access time and modification time */
    utim.actime = atime;
    utim.modtime = atime;

    if (utime (filename, &utim) >= 0)
      return;
   }

   /* error exit */
   fprintf (o, g?"\007\nDer Zeitstempel der Datei \"%s\" konnte nicht auf %s gesetzt werden!\n":
                   "\007\nCan't set timestamp of file \"%s\" to %s!\n", filename, ctime (&atime));
   return;
  }
 #endif /* __unix__/OSK/__OS2__ */

 #ifndef _SETFTIME_OK
  /*
  * Set file's timestamp
  *
  */
  void set_filetime (const char *filename, ulong ftimestamp)
  {
   /* error exit */
   fprintf (o,g?"\007\nset_filetime (noch) nicht auf diesem System implementiert!\n":
                "\007\nset_filetime not (yet) implemented on this system!\n");
   return;
  }
 #endif
#endif

#ifndef _HAVE_FNSPLIT
/*
***       filenamesplit
***       (by DL1MEN, taken from SP-ST, modified for portability)
***
***       split filename up into drive, path, name and extension.
***
 */

void fnsplit(char *pth, char *dr, char *pa, char *fn, char *ft)
{
  char drv[STDSTRING], pat[STDSTRING], fna[STDSTRING],
       fty[STDSTRING], tmp[STDSTRING];
  char *p;

  strcpy(tmp,pth);

#if (defined (__MWERKS__) || defined (__linux__))
    /* Ignore drive on Mac OS. Be aware that the file separator is the ":" */
    p = tmp;
    drv[0] = EOS;
#else
    if ((p = strchr(tmp,':')) != NULL)
    {
      *p++ = EOS;
      strcpy(drv,tmp);
    }
    else
    {
      p = tmp;
      drv[0] = EOS;
    }
#endif

  if ((pth = strrchr(p, PATHCHAR)) != NULL)
  {
    *pth++ = EOS;
    strcpy(pat,p);
  }
  else
  {
    pth = p;
    pat[0] = EOS;
  }
  if ((p = strrchr(pth,'.')) != NULL)
  {
    strcpy(fty,p);
    fty[MAXEXT-1] = EOS;
    *p = EOS;
  }
  else
    fty[0] = EOS;

  strcpy(fna,pth);
  fna[MAXFILE-1] = EOS;

  if (dr)
  {
    strcpy(dr,drv);
    if (drv[0])
      strcat(dr,":");
  }
  if (pa)
  {
    strcpy(pa,pat);
    if (pat[0])
      strcat(pa, PATHSEP);
  }
  if (fn)
    strcpy(fn,fna);
  if (ft)
   strcpy(ft,fty);
}
#endif /** ifndef _HAVE_FNSPLIT **/

#ifndef _HAVE_ICMP
/* The following functions are unfortunately not available with all compilers */

/*
*** strupr - convert string to upper case.
***
***
 */

char *strupr (char *string)
{
  char *strcnvt (char *string, int flag);

  return (strcnvt (string, 1));
}

/*
*** strlwr - convert string to lower case.
***
***
 */

char *strlwr (char *string)
{
  char *strcnvt (char *string, int flag);

  return (strcnvt (string, 0));
}

/*
*** strcnvt - convert string to upper (flag == 1) or lower (flag == 0) case.
***
***
 */

char *strcnvt (char *string, int flag)
{
  register i = 0;

  while (string[i])
  {
    string[i] = (flag)?toupper (string[i]):tolower (string[i]);
    i++;
  }
  return (string);
}

/*
*** stricmp - same as strcmp(), but ignores case.
*** s1 and s2 are not modified.
***
 */

int stricmp (const char *s1, const char *s2)
{
  return (strnicmp (s1, s2, (size_t) 80));
}

/*
*** strnicmp - same as strncmp(), but ignores case.
*** s1 and s2 are not modified.
***
 */

int strnicmp (const char *s1, const char *s2, size_t n)
{
  char _s1[81], _s2[81];

  strncpy (_s1, s1, 80);
  strncpy (_s2, s2, 80);
  strupr (_s1);
  strupr (_s2);

  return (strncmp (_s1, _s2, n));
}
#endif /** ifndef _HAVE_ICMP **/


void usage (int err)
{
  if (err == 9)
    fprintf (o, g?"Zuviele Kommandozeilenparameter!\n\n":
                  "Too many command line parms!\n\n");

  if (err == 10)
    fprintf (o, g?"Syntax Fehler!\n\n":"Syntax error!\n\n");


  fprintf (o, g?
/* German help */
    "Benutzung:  bs Dateiname [-Splitparameter] [Optionen]\n\n"
    "Beispiele:\n\n"
    "  bs test.exe         Datei in Teile von ungefaer %ld Bytes zerteilen.\n"
    "  bs test.exe -5      In 5 Teile gleicher Groesse zerteilen.\n"
    "  bs test.exe -50000  Teile von 50000 Bytes Laenge erzeugen.\n"
    "  bs test.exe -1      Garnicht aufteilen; nur #BIN#-Header hinzufuegen.\n"
    "  bs test.b01         BS-Teile wieder zu 'test.exe' zusammenfuegen.\n\n"
    "Optionen:\n\n"
    "  -b           #BIN#-Header zu jedem Teil hinzufuegen.\n"
/*  "  -dp          Beschreibungsdateien behandeln (DPBOX, schliesst -nd ein)\n"*/
    "  -ll          LF als Zeilentrenner bei Optionen b/s*/sf*/u* verwenden.\n"
    "  -lc          Wie -ll, aber CRLF verwenden.\n"
    "  -nd          Datei-Datum/Uhrzeit nicht wiederherstellen.\n"
    "  -o           Altes BS-Format beim Zerteilen verwenden (vor BS 2.0)\n"
    "  -q           Stiller Modus. Keine Bildschirmausgaben.\n"
    "  -r Bereich   Erzeuge nur Teile im angegebenen Bereich (hexadezimal!),\n"
    "               z.B. -r 9-f,3C-,-4,2 etc. Mehrfachbereiche zulaessig.\n"
    "  -s \"s ibm @dl #0\"  Sendekommando angeben (-s2: Befehl 2-zeilig senden).\n":

/* English help */
    "Usage:    bs filename [-splitparm] [options]\n\n"
    "Examples: bs test.exe         Split into parts of ROUGHLY %ld bytes.\n"
    "          bs test.exe -5      Split into 5 parts of equal size.\n"
    "          bs test.exe -50000  Split into parts of 50000 bytes.\n"
    "          bs test.exe -1      Don't split at all, just add #BIN# header.\n"
    "          bs test.b01         Combine parts of 'test'.\n\n"
    "Options:  -b           Add #BIN# headers to each part.\n"
/*  "          -dp          handle description files (DPBOX, includes -nd)\n"*/
    "          -ll          Use LF as line seperator with b/s*/sf*/u* options.\n"
    "          -lc          Same as -ll, but use CRLF.\n"
    "          -nd          Do not restore file date.\n"
    "          -o           Produce old style BS files (before v2.0).\n"
    "          -q           Quiet mode. No screen output.\n"
    "          -r range     Create only parts specified by range (HEX!),\n"
    "                       e.g. -r 9-f,3C-,-4,2 etc. Multiple ranges allowed.\n"
    "          -s \"s ibm @dl #0\"  Specify send command (-s2: two line send).\n"
      , NORPART);

#ifdef __TOS__
    fprintf(o, g?
    "Bitte RETURN um fortzusetzen...\r":
    "Press RETURN to continue....\r", NORPART);
    getch ();
#endif

  fprintf(o, g?

/* German help part 2 */

    "  -sf Datei    Wie -s, aber lese Sendebefehl aus 'Datei'. Max 512 Zeichen.\n"
    "               -sfl: Zeilentrenner = LF, -sfc: CRLF, Standard: CR\n"
    "  -t           Zusammengefuegte Datei in gleiches Dir wie Split-Teile.\n"
    "  -u           Alle erzeugten Dateien in gemeinsame Upload-Dateien schreiben.\n"
    "  -u name.ext  Name und/oder Pfad der Upload-Datei definieren.\n"
    "               Beim Zusammenfuegen: alternativen Namen und/oder Pfad fuer\n"
    "               fertig zusammengefuegte Datei definieren.\n"
    "  -u2          Separate Upload-Dateien pro Teil erzeugen.\n"
    "  -u2 name.ext Name und/oder Pfad separater Upload-Dateien definieren.\n"
#ifndef SHORTNAMES
    "  -w           Verwendung von 8.3-Namen fuer Teile/Upload-Dateien erzwingen.\n"
    "               Verwenden, wenn unklar, ob Empfaenger Langnamen beherrscht.\n"
#endif
    "  -+           Diese Option nur verwenden, wenn das empfangende Terminal\n"
    "               Probleme mit direkt aufeinanderfolgenden BIN-Dateien hat!\n"
    "\nHINWEIS: Bei Verwendung von -b, -u* or -s*, rein binaer einspielen,\n"
      "         nicht per AUTOBIN/BOXBIN!!!\n\n"
    "Grenzen:   00h < Teile < FFh    4999 < Teilegroesse < 2147483647 Bytes\n\n"
    "BS loescht nicht mehr benoetigte Dateien nach dem Zusammenfuegen!\n"
    "BS ueberschreibt immer gnadenlos!\n"
    "* Define environment variable BS_G to make BS speak English! *\n":

/* English help part 2 */

    "          -sf file     Same as -s, but read from 'file'. Max 512 chars.\n"
    "                       -sfl: Lineseperator = LF, -sfc: CRLF, default: CR\n"
    "          -t           Write combined file to same dir as split parts.\n"
    "          -u           Write output to single upload file.\n"
    "          -u name.ext  Define name and/or path of upload file.\n"
    "                       When combining, define alternate name and/or path\n"
    "                       of recombined file.\n"
    "          -u2          Write output to seperate upload files.\n"
    "          -u2 name.ext Define name and/or path of seperate upload files.\n"
#ifndef SHORTNAMES
    "          -w           Force use of 8.3 filenames for parts/uploadfile.\n"
    "                       Use if recipient can't handle long filenames.\n"
#endif
    "          -+           Use this option only when receiving terminal has\n"
    "                       problems with back-to-back BIN-files!\n"
    "\nNOTE: When using -b, -u* or -s*, use PURE binary upload, not AUTOBIN!\n"
    "Limits:   00h < parts < FFh    4999 < size of parts < 2147483647 Bytes\n"
    "BS will automatically erase the split parts after combining!\n"
    "BS always overwrites mercilessly!\n"
    "* Damit BS deutsch spricht, entferne Umgebungsvariable BS_G! *\n"
      , NORPART);

#ifdef __TOS__
    fprintf(o, g?
    "Bitte RETURN um fortzusetzen...\r":
    "Press RETURN to continue....\r", NORPART);
    getch ();
#endif
    
    exit (err);
}

/** List of return codes:

 0 - All's well.
 1 - File not found.
 2 - File smaller than minimun splitsize. (obsolete)
 3 - File smaller than specified splitsize. Choose smaller splitsize. (obsolete)
 4 - Splitsize too small. Would result in >255 parts. Choose bigger splitsize.
 5 - Can't split into 1 part. (obsolete)
 6 - Splitsize too small. Specify less parts to split into.
 7 - Can't write to file.
 8 - Requested part no. higher than total no. of parts or error in range.
 9 - Too many command line parms
10 - Syntax error
11 - Help displayed
12 - Parts missing or have bad CRC
13 - Not a BS file / Header corrupted
14 - Fatal error. Overall CRC failure.

**/
