#define VERSION "1.52"
#define DATE "971111"
/*
 *      This version on BS is slightly modified for compiling under
 *	Turbo C 2.03 on an Atari platform. I added waiting for key-
 *      stroke when running without arguments (e.a. showing helptext).
 *         
 *      Chris, DG6LAC 
 *
 *      BS was originally published by Sigi Kluger DL1MEN/DK4NB and was
 *      revised for portability by DG1BBQ. It should now compile on MSDOS,
 *      OS/2, OS/9, UNIX (all flavours), Atari_ST, Amiga.
 *
 *      BS is HAMWARE. It may be used in Ham Radio without restriction.
 *      If you make modifications, please send a copy of the source code
 *      to DG1BBQ @DB0VER.#NDS.DEU.EU so they can be included in the
 *      official version (if sensible).
 *
 *      No commercial use! No sale! Pass on freely!
 *
 *      Binary Splitter
 *      -      -
 *      splits binary files in multiple parts for transfer through
 *      TheBox 1.9b6+, BaycomBox and DP-Box using AUTOBIN upload
 *      or pure binary upload if #BIN# headers are already included.
 *
 *      Header at beginning of part part 1 through part x-1:
 *      Byte    Contents
 *      0-1     magic number 0x6569, big-endian
 *      2       total parts (2-255)
 *      3       this part   (1-255)
 *      4-5     CCITT-CRC (same CRC as used by 7PLUS, #BIN# etc.), big-endian,
 *              calculated from first to last byte of binary data in current
 *              part.
 *      6       remaining bytes in header (length of name incl null-char)
 *      7-n     File name, null terminated.
 *      n+1-m   Binary data (min 5000 bytes, max 2^31 -1)
 *
 *      Header at beginning of part x (last part):
 *      Byte    Contents
 *      0-1     magic number
 *      2       total parts
 *      3       this part
 *      4-5     CCITT-CRC
 *      6       remaining bytes in header (length of name incl null-char  + 4)
 *      7-n     File name, null terminated.
 *      n+1-n+5 file date and time, big-endian.
 *                Format: bit  0-4: secs/2, 5-10: mins, 11-15: hours,
 *                        16-20: days, 21-24: months, 25-31: year-1980
 *      n+6-m   Binary data
 *
 *
 */

/** these includes should work anywhere **/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>

#define EOS '\0'
#define BINHEAD 1
#define JOIN 2
#define RECODE 4
#define SEND 8
#define AUTOSPLIT 16
#define DUMB_BIN 32
#define FORCE8_3 64
#define ADDCR 128

/** Microsoft's Quick C has some different makros and function names **/
#ifdef _QC
 #define __MSDOS__
 #define SHORTNAMES
 #define MAXDRIVE _MAX_DRIVE
 #define MAXDIR   _MAX_DIR
 #define MAXFILE  _MAX_FNAME
 #define MAXEXT   _MAX_EXT
 #define MAXPATH  _MAX_PATH
 #define fnsplit  _splitpath
#endif /* _QC */

#ifdef __MSDOS__
 #ifdef __TURBOC__
  #include <dir.h>
  #include <io.h>
 #endif
 #include <conio.h>
 #include <stdlib.h>
 #include <sys/types.h>
 #include <sys/stat.h>
 #define NULLDEV "NUL"
 #define SHORTNAMES
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #define _HAVE_FNSPLIT
 #define _HAVE_ICMP
 #define _HAVE_GMTIME
 #define _HAVE_MKTIME
 #define _FTIMEDEFINED
#endif /* __MSDOS__ */

#if (defined (__BORLANDC__) && defined (__WIN32__))
 #include <dir.h>
 #include <io.h>
 #include <conio.h>
 #include <stdlib.h>
 #include <sys/types.h>
 #include <sys/stat.h>
 #define NULLDEV "NUL"
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #define _HAVE_FNSPLIT
 #define _HAVE_ICMP
 #define _HAVE_GMTIME
 #define _HAVE_MKTIME
 #define _FTIMEDEFINED
 #endif /* __BORLANDC__ && __WIN32__ */

#ifdef __OS2__
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <io.h>
 #ifdef __BORLANDC__
  #define __IBMC__
 #endif
 #define NULLDEV "NUL"
 #define MAXPATH   80 /* I don't have HPFS installed! */
 #define MAXDRIVE  3
 #define MAXDIR    66
 #define MAXFILE   9
 #define MAXEXT    5
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #define _HAVE_ICMP
 #define _HAVE_GMTIME
 #define _HAVE_MKTIME
 #include <stdlib.h>
 #ifdef __EMX__
  #define chsize ftruncate
 #endif
#endif /* __OS2__ */

#ifdef _AMIGA_
 #define  _680X0_
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <stddef.h>
 #include <proto/dos.h>
 #include <libraries/dos.h>
 #include <libraries/dosextens.h>
 #include <exec/memory.h>
 #include <stdlib.h>
 #define NULLDEV "NIL:"
 #define SEEK_SET 0
 #define SEEK_CUR 1
 #define SEEK_END 2
 #define MAXPATH  300
 #define MAXDRIVE 5
 #define MAXDIR   220
 #define MAXFILE  31
 #define MAXEXT   31
 #define PATHSEP  "/"
 #define PATHCHAR '/'
 #define MAXFNAME MAXFILE
 #define AMIGADATE "(11.11.97)"
#endif /* _AMIGA_ */

#ifdef __TOS__
 #define _680X0_
 #define SHORTNAMES
 /* Important! Don't know the null device's name. NUL is just a wild guess */
 #define NULLDEV "NUL"
 #define MAXPATH   119
 #define MAXDRIVE  3
 #define MAXDIR    102
 #define MAXFILE   9
 #define MAXEXT    5
 #define TWO_CHAR_SEP
 #define PATHSEP "\\"
 #define PATHCHAR '\\'
 #define MAXFNAME MAXFILE+MAXEXT-1
 #include <stdlib.h>
 #include <ext.h>
 /* quick & dirty, swaps upper and lower word                     */
 unsigned long swapl(unsigned long l)0x4840; /* opcode for SWAP D0 */
 /* needed for timestamp-functions    (Odo,DL1XAO)                */
#endif /* __TOS__ */


#ifdef __unix__
 #include <sys/types.h>
 #include <sys/stat.h>
 #ifdef __M_XENIX__
  #include <malloc.h>
  #define SEEK_CUR 1
  #define SEEK_END 2
  #define SEEK_SET 0
  typedef unsigned size_t;
 #endif
 #define NULLDEV "/dev/null"
 /* assumed limits (hope reasonable !!! DF6NL) */
 #define MAXPATH 256
 #define MAXDRIVE 16
 #define MAXDIR 256
 #define MAXFILE 32
 #define MAXEXT 32
 #define PATHSEP "/"
 #define PATHCHAR '/'
 #define MAXFNAME MAXFILE
 #ifdef SYSV
  #include <unistd.h> /* not sure, if this one is really necessary */
 #endif
 #ifdef __i386__
  #ifndef SYSV
   #define SYSV
  #endif
 #endif
#endif /* __unix__ */

#ifdef OSK
 /* Assumed limits */
 #include <types.h>
 #include <stat.h>
 #define _680X0_
 /* Important! Don't know the null device's name. 'null' is just a guess */
 #define NULLDEV "null"
 #define _IOFBF 0
 #define MAXPATH 256
 #define MAXDRIVE 16
 #define MAXDIR 256
 #define MAXFILE 32
 #define MAXEXT 256
 #define PATHSEP "/"
 #define PATHCHAR '/'
 #define MAXFNAME MAXFILE
 char *strsave(const char *);
 #define strdup  strsave
 #define SEEK_SET   0
 #define SEEK_CUR   1
 #define SEEK_END   2
 #include <stdlib.h>
#endif /* OSK */

#define MAXFPATH (MAXDRIVE+MAXDIR-1)

/* flags for fopen() */
#ifdef TWO_CHAR_SEP
 /* This is for systems that convert LF to CR/LF in textmode */
 #define OPEN_R_BIN "rb"
 #define OPEN_RR_BIN "r+b"
 #define OPEN_W_BIN "wb"
 #define OPEN_WR_BIN "w+b"
 #define OPEN_A_BIN "ab"
#else
 /* And this, if there is no conversion */
 #define OPEN_R_BIN "r"
 #define OPEN_RR_BIN "r+"
 #define OPEN_W_BIN "w"
 #define OPEN_WR_BIN "w+"
 #define OPEN_A_BIN "a"
#endif

/** shorthands for unsigned types **/
typedef unsigned char byte;  /* 8bit unsigned char */
#ifdef __unix__
 #ifdef __vax__
  typedef u_long ulong;
 #endif
 #ifdef __M_XENIX__
  typedef unsigned long ulong;
 #endif
#else
 typedef unsigned int  uint;  /* 16 or 32bit unsigned int */
 typedef unsigned long ulong; /* 32bit unsigned long      */
#endif

#ifdef __OS2__
 #ifdef __BORLANDC__
  #include <utime.h>
  #define _FTIMEDEFINED
 #else
  #include <sys/utime.h>
 #endif
#endif

#ifdef __unix__
 #ifdef __M_XENIX__
  struct utimbuf {
  time_t actime;
  time_t modtime;
  };
  extern time_t mktime (struct tm *utm);
 #else
  #include <utime.h>
 #endif
#endif

#ifdef _AMIGA_
 struct utimbuf {
  time_t actime;
  time_t modtime;
 };
 extern time_t mktime (struct tm *utm);
#endif

#ifndef _FTIMEDEFINED
 #ifndef _680X0_  /* use this struct on 680x0 systems (big endian)*/
 struct ftime
 {
   unsigned  ft_tsec  : 5;   /* 0..59 /2 (!) */
   unsigned  ft_min   : 6;   /* 0..59 */
   unsigned  ft_hour  : 5;   /* 0..23 */
   unsigned  ft_day   : 5;   /* 1..31 */
   unsigned  ft_month : 4;   /* 1..12 */
   unsigned  ft_year  : 7; /* Year minus 1980 */
 };
 #endif
#endif /* _FTIMEDEFINED */

#define MINPART 5000L
#define NORPART 20000L
#define MAGIC   0x6569

static  void combine(char *filename);
static  void doit(char *filename, long nparts);
static  void usage(int err);
void make_compat (char *name);
void build_DOS_name (char *name, char *ext);
int read_16 (FILE *in);
void write_16 (int val, FILE *out);
long read_32 (FILE *in);
void write_32 (long val, FILE *out);
ulong get_filetime (const char *filename);
void set_filetime (const char *filename, ulong ftimestamp);


#ifndef _HAVE_GMTIME
  struct tm *__offtime (const time_t *t, long int offset);
  struct tm *gmtime (const time_t *t);
#endif /* ifndef _HAVE_GMTIME */

#ifndef _HAVE_MKTIME
  time_t mktime (register struct tm *tp);
#endif /* ifndef _HAVE_MKTIME */

#ifndef _HAVE_FNSPLIT
  void fnsplit(char *pth, char *dr, char *pa, char *fn, char *ft);
#endif /** ifndef _HAVE_FNSPLIT **/

#ifndef _HAVE_ICMP
  char *strupr (char *string);
  char *strlwr (char *string);
  int stricmp (const char *s1, const char *s2);
  int strnicmp (const char *s1, const char *s2, size_t n);
#endif /** ifndef _HAVE_ICMP **/

#define STDSTRING 280 /* more than enough room, just to be safe */
/* globals */
struct  ftime   ft;
char drive[STDSTRING], dir[STDSTRING], name[STDSTRING], ext[STDSTRING];
int first_part, last_part;
int flags;
char send[STDSTRING];
char wfilename[STDSTRING];
char uplname[STDSTRING];
FILE *o; /* required for redirecting screen output to null device */

#ifdef _AMIGA_
 /* Kennung fuer Versionstring auf dem Amiga */
 char vers[] = "$VER: BS "VERSION AMIGADATE;
#endif

/*
 *      crctab calculated by Mark G. Mendel, Network Systems Corporation
 */
unsigned short crctab[256] = {
   0x0000,0x1021,0x2042,0x3063,0x4084,0x50a5,0x60c6,0x70e7,
   0x8108,0x9129,0xa14a,0xb16b,0xc18c,0xd1ad,0xe1ce,0xf1ef,
   0x1231,0x0210,0x3273,0x2252,0x52b5,0x4294,0x72f7,0x62d6,
   0x9339,0x8318,0xb37b,0xa35a,0xd3bd,0xc39c,0xf3ff,0xe3de,
   0x2462,0x3443,0x0420,0x1401,0x64e6,0x74c7,0x44a4,0x5485,
   0xa56a,0xb54b,0x8528,0x9509,0xe5ee,0xf5cf,0xc5ac,0xd58d,
   0x3653,0x2672,0x1611,0x0630,0x76d7,0x66f6,0x5695,0x46b4,
   0xb75b,0xa77a,0x9719,0x8738,0xf7df,0xe7fe,0xd79d,0xc7bc,
   0x48c4,0x58e5,0x6886,0x78a7,0x0840,0x1861,0x2802,0x3823,
   0xc9cc,0xd9ed,0xe98e,0xf9af,0x8948,0x9969,0xa90a,0xb92b,
   0x5af5,0x4ad4,0x7ab7,0x6a96,0x1a71,0x0a50,0x3a33,0x2a12,
   0xdbfd,0xcbdc,0xfbbf,0xeb9e,0x9b79,0x8b58,0xbb3b,0xab1a,
   0x6ca6,0x7c87,0x4ce4,0x5cc5,0x2c22,0x3c03,0x0c60,0x1c41,
   0xedae,0xfd8f,0xcdec,0xddcd,0xad2a,0xbd0b,0x8d68,0x9d49,
   0x7e97,0x6eb6,0x5ed5,0x4ef4,0x3e13,0x2e32,0x1e51,0x0e70,
   0xff9f,0xefbe,0xdfdd,0xcffc,0xbf1b,0xaf3a,0x9f59,0x8f78,
   0x9188,0x81a9,0xb1ca,0xa1eb,0xd10c,0xc12d,0xf14e,0xe16f,
   0x1080,0x00a1,0x30c2,0x20e3,0x5004,0x4025,0x7046,0x6067,
   0x83b9,0x9398,0xa3fb,0xb3da,0xc33d,0xd31c,0xe37f,0xf35e,
   0x02b1,0x1290,0x22f3,0x32d2,0x4235,0x5214,0x6277,0x7256,
   0xb5ea,0xa5cb,0x95a8,0x8589,0xf56e,0xe54f,0xd52c,0xc50d,
   0x34e2,0x24c3,0x14a0,0x0481,0x7466,0x6447,0x5424,0x4405,
   0xa7db,0xb7fa,0x8799,0x97b8,0xe75f,0xf77e,0xc71d,0xd73c,
   0x26d3,0x36f2,0x0691,0x16b0,0x6657,0x7676,0x4615,0x5634,
   0xd94c,0xc96d,0xf90e,0xe92f,0x99c8,0x89e9,0xb98a,0xa9ab,
   0x5844,0x4865,0x7806,0x6827,0x18c0,0x08e1,0x3882,0x28a3,
   0xcb7d,0xdb5c,0xeb3f,0xfb1e,0x8bf9,0x9bd8,0xabbb,0xbb9a,
   0x4a75,0x5a54,0x6a37,0x7a16,0x0af1,0x1ad0,0x2ab3,0x3a92,
   0xfd2e,0xed0f,0xdd6c,0xcd4d,0xbdaa,0xad8b,0x9de8,0x8dc9,
   0x7c26,0x6c07,0x5c64,0x4c45,0x3ca2,0x2c83,0x1ce0,0x0cc1,
   0xef1f,0xff3e,0xcf5d,0xdf7c,0xaf9b,0xbfba,0x8fd9,0x9ff8,
   0x6e17,0x7e36,0x4e55,0x5e74,0x2e93,0x3eb2,0x0ed1,0x1ef0
};


/*
 * updcrc macro derived from article Copyright (C) 1986 Stephen Satchell.
 *  NOTE: First argument must be in range 0 to 255.
 *        Second argument is referenced twice.
 *
 * Programmers may incorporate any or all code into their programs,
 * giving proper credit within the source. Publication of the
 * source routines is permitted so long as proper credit is given
 * to Stephen Satchell, Satchell Evaluations and Chuck Forsberg,
 * Omen Technology.
 */
#define updcrc(ch,crc) (crc)=crctab[(crc)>>8]^((((crc)&255)<<8)|(byte)(ch))

int main (int ac, char **av)
{
  long nparts = 0;
  int  u = 0;
  int  i, zz;
  char part_sep;
    
  flags = 0;

#ifdef SHORTNAMES
  flags |= FORCE8_3;
#endif

  o = stdout;
  *wfilename = *uplname = EOS;

  if ((ac == 1) || (ac > 15))
  {
   u = 11;
   if (ac >15)
     u = 9;
   ac = 1;
  }
  if ((ac > 1) && (ac < 16))
  {
    for (i = 2; i < ac; i++)
    {
      if (av[i][0] != '-')
      {
        u = 10;
        break;
      }
      switch (av[i][1])
      {
        case '+':
          flags |= DUMB_BIN;
          break;
        case 'A':
        case 'a':
          flags |= AUTOSPLIT;
          break;
        case 'B':
        case 'b':
          flags |= BINHEAD;
          break;
        case 'Q':
        case 'q':
          if (o == stdout)
            o = fopen (NULLDEV, OPEN_WR_BIN);
          break;
        case 'R':
        case 'r':
          i++;
          if (ac <= i)
          {
            i--;
            break;
          }
          flags |= RECODE;
          first_part = 1;
          if (*av[i] != '-')
          {
            zz = sscanf (av[i], "%02x%c%02x", &first_part,
                                              &part_sep,
                                              &last_part);
            if (zz == 1)
              last_part = first_part;
            if (zz == 2)
              last_part = 255;
          }
          else
            if (sscanf (av[i], "-%02x", &last_part) != 1)
              last_part = first_part;
          if (last_part < first_part)
            last_part = first_part;
          if (first_part == 1)
            first_part = 0;
          break;
        case 'S':
        case 's':
          i++;
          if (ac <= i)
          {
            i--;
            break;
          }
          flags |= (SEND + BINHEAD);
          strcpy (send, av[i]);
          if (av[i-1][2] == '2')
            flags |= ADDCR;
          break;
        case 'U':
        case 'u':
          flags |= (BINHEAD + JOIN);
          i++;
          if (ac <= i)
          {
            i--;
            break;
          }
          if (*av[i] != '-')
            strcpy (uplname, av[i]);
          else
            i--;
          break;
        case 'W':
        case 'w':
          i++;
          if (ac <= i)
          {
            flags |= (FORCE8_3);
            i--;
            break;
          }
          if (*av[i] != '-')
            strcpy (wfilename, av[i]);
          else
          {
            flags |= (FORCE8_3);
            i--;
          }
          break;
        default:
          sscanf (&av[i][1], "%ld", &nparts);
          break;
      }
    }
  }
  fprintf (o,"\nBinary file splitter V"VERSION);
#if (defined (__WIN32__) && defined (__BORLANDC__))
  fprintf (o,"(long filenames)");
#endif
  fprintf (o,"/DG1BBQ ("DATE")\n\n");

  if (u)
    {
    usage (u);
    }

  doit (av[1], nparts);
  return (0);
}

void doit (char *fname, long nparts)
{
  FILE    *inf;
  FILE    *otf;
  ulong   timestamp;
  ulong   curtime;
  long    ilen;
  long    len;
  long    plen;
  long    bsstartpos;
  long    bscrcpos;
  long    binstartpos;
  long    bincrcpos;
  char    fn[STDSTRING];
  char    ofn[STDSTRING];
  char    pfn[STDSTRING];
  char    _ext = 'b';
  int     ch;
  int     skipbshead = 0;
  uint    crc;
  int     part;
  struct  ftime   current;
  struct tm *now;
  time_t _now;


  strcpy (fn, fname);

#ifdef __WIN32__
  {/* Since Win32 does not distinguish the case in filenames, findfirst
   ** is used to determine how the filename is really spelt casewise.
   */
   struct ffblk ffblk; /* only needed locally */
   if (findfirst (fn, &ffblk, 0) == 0)
   {
     fnsplit (fn, drive, dir, NULL, NULL);
     sprintf (fn, "%s%s%s", drive, dir, ffblk.ff_name);
   }
  }
#endif

  fnsplit (fn, drive, dir, name, ext);

  /* if ext = .B01, combine files */
  if (!strnicmp (ext, ".B01", 4))
  {
    sprintf (ofn, "%s%s%s", drive, dir, name);
    combine (ofn);
  }

  timestamp = get_filetime (fn);

  if ((inf = fopen (fn, OPEN_R_BIN)) == NULL)
  {
    fprintf (o,"\nCannot find \"%s\"\n",fn);
    exit (1);
  }

  setvbuf (inf, NULL, _IOFBF, 16384);

  sprintf (ofn, "%s%s", name, ext);

  if (flags & FORCE8_3)
  {
    build_DOS_name (name, ext);
    strlwr (name);
    strlwr (ext);
    sprintf (ofn, "%s%s%s", name, *ext?".":"", ext);
  }
  else
  {
    strcpy (name, ofn);
    if (*wfilename)
      strcpy (name, wfilename);
  }

  fseek (inf, 0L, SEEK_END);
  len = ftell (inf);
  fseek (inf, 0L, SEEK_SET);

  /* adjust splitsize according to the input filelength so that 255 parts are
    never exceeded (server mode) */
  if (flags & AUTOSPLIT)
  {
    /* set standard part size for server mode */
    nparts = 10000L;
    /* check, if part size is too small in relation to original filesize */
    plen = (len + 255L) / 255L;
    /* adjust part size in 10000 increment */
    if (plen > nparts)
    {
     nparts = (plen +9999L) / 10000L;
     nparts *= 10000L;
    }
  }

  /* special case. If in autosplit mode and file is smaller than 10k,
    or if user explicitely requests it, just add #BIN# header, don't split */
  if (((len <= nparts) && (flags & AUTOSPLIT)) || nparts == 1)
  {
    skipbshead = 1;
    nparts  = 1;
    ilen = len;
    flags |= (BINHEAD + JOIN);
    flags &= (255 - RECODE);
  }

  if (!skipbshead)
  {
    if (nparts == 0L)
     nparts = NORPART;

    if (len < MINPART)
    {
      fprintf (o,"\nNot economical to split a file %ld bytes long!\n", len);
      exit (2);
    }

    if (nparts > len)
    {
      fprintf (o,"\nSplitsize is larger than filelength!\n");
      exit (3);
    }

    /* if 1 < splitparm < 256, calculate part size;
       else splitparm == part size */
    ilen = (len + nparts -1)/ nparts;
    if (nparts > 255)
      ilen = nparts;

    /* calculate number of parts */
    nparts = (len + ilen -1) / ilen;

    if (first_part > nparts)
    {
      fprintf (o,"\nRequested part number is higher than total part count!");
      exit (8);
    }

    if (nparts > 255)
    {
      fprintf (o,"\nExceeding design limit of FFh (dec 255) parts!"
                  " Choose bigger part size.\n");
      exit (4);
    }

    if (ilen < MINPART)
    {
      fprintf (o,"\nParts would be %ld bytes - that's a bit small!\n",ilen);
      exit (6);
    }

    fprintf (o,"Splitting \"%s\" ", fn);
    if (strlen (fn) > 30)
      fprintf (o,"\n");
    fprintf (o,"into %02lX (dec %ld) parts of %ld bytes\n\n",
                                     nparts,nparts,ilen);
  }
  /* get current timestamp for #BIN#-headers */
  if (flags & BINHEAD)
  {
    time (&_now);
    now = localtime (&_now);
    current.ft_tsec  = now->tm_sec /2;
    current.ft_min   = now->tm_min;
    current.ft_hour  = now->tm_hour;
    current.ft_day   = now->tm_mday;
    current.ft_month = now->tm_mon +1;
    current.ft_year  = now->tm_year - 80;
    curtime = *((unsigned long *) &current);
  }

  if (last_part > nparts)
    last_part = (int) nparts;

  /* now, split */
  for (part = 1; part < nparts + 1; part++)
  {
    /* calculate part size (last part may be smaller than splitsize!) */
    if (part != nparts)
      plen = ilen;
    else
      plen = len;
    len -= ilen;

    /* skip parts, if required */
    if ((flags & RECODE) && ((part < first_part) || (part > last_part)))
    {
      fseek (inf, plen, SEEK_CUR);
      continue;
    }

    /* use u01-uff for seperate parts that contain #BIN#-headers */
    if (flags & BINHEAD)
      _ext = 'u';

    sprintf (pfn , "%s.%c%02x", name, _ext, part);
    if ((flags & JOIN) && (part == 1 || part == first_part))
      if (*uplname)
      {
        if (uplname[(int)strlen(uplname)-1] == PATHCHAR)
          sprintf (pfn, "%s%s.upl", uplname, name);
        else
          strcpy (pfn, uplname);
      }
      else
        sprintf (pfn , "%s.upl", name);

    if (!(flags & JOIN) ||
        ((flags & JOIN) && (part == 1 || part == first_part)))
      if ((otf = fopen (pfn, OPEN_WR_BIN)) == NULL)
      {
        fprintf (o, "\nCannot create \"%s\".\n", pfn);
        exit (7);
      }

    sprintf (pfn , "%s.%c%02x", name, _ext, part);

    crc = 0;
    setvbuf (otf, NULL, _IOFBF, 16384);

    if ((flags & SEND) && (flags & BINHEAD))
    {
      if (!skipbshead)
        fprintf (otf, "%s%c%s.b%02x/%02lx\x0d", send, (flags & ADDCR)?'\x0d':' ',
                                                name, part, nparts);
      else
        if (flags & FORCE8_3)
          fprintf (otf, "%s%c%s.%s\x0d", send, (flags & ADDCR)?'\x0d':' ',
                                        name, ext);
        else
          fprintf (otf, "%s%c%s\x0d", send, (flags & ADDCR)?'\x0d':' ', name);
    }

    if (flags & BINHEAD)
    {
      long l;

      if (!skipbshead)
        fprintf (otf, "\x0d\x0dPart %02Xh of %02lXh of \"%s\" "
                                   "(splitsize %ld):\x0d\x0d"
                                      ,part, nparts, ofn, ilen);

      fprintf (otf, "<BS"VERSION"/"DATE" by DG1BBQ>\x0d");

      if (part == 1 || ((flags & RECODE) && part == first_part))
        binstartpos = ftell (otf);

      fprintf (otf, "#BIN#");

      if (!skipbshead)
      {
        l = 8L + (long) strlen (ofn);
        if (part == nparts)
          l = l + 4L + plen;
        else
          l += ilen;
      }
      else
        l = plen;

      fprintf (otf, "%ld#|", l);
      bincrcpos = ftell (otf);

      if (!skipbshead)
      {
        fprintf (otf, "00000#$%08lX#", curtime);
        sprintf (pfn, "%s.b%02x", name, part);
      }
      else
      {
        fprintf (otf, "00000#$%08lX#", timestamp);
        if (flags & FORCE8_3)
          sprintf (pfn, "%s%s%s", name, (*ext?".":""), ext);
        else
          strcpy (pfn, name);
      }
      fprintf (otf, "%s\x0d", pfn);
      bsstartpos = ftell (otf);
    }

    if (!skipbshead)
    {
      write_16 (MAGIC, otf);
      fputc ((uint) nparts, otf);
      fputc (part, otf);
      bscrcpos = ftell (otf);
      write_16 (0, otf);

      if (part == nparts)
        fputc ((int) strlen (ofn) + 5, otf);
      else
        fputc ((int) strlen(ofn) + 1, otf);
      fwrite (ofn, (int)strlen (ofn) + 1, 1, otf);

      if (part == nparts)
        write_32 (timestamp, otf);
    }

    while (plen--)
    {
      ch = fgetc (inf);
      updcrc (ch, crc);
      fputc (ch, otf);
    }

    if (!skipbshead)
    {
      fseek (otf, bscrcpos, SEEK_SET);
      write_16 (crc, otf);
    }

    if (flags & BINHEAD)
    {
      crc = 0;
      fseek (otf, bsstartpos, SEEK_SET);
      while ((ch = fgetc (otf)) != EOF)
        updcrc (ch, crc);
      fseek (otf, bincrcpos, SEEK_SET);
      fprintf (otf, "%05u", crc);
    }

    fseek (otf, 0L , SEEK_END);

    /* This is for terminals that can't handle back-to-back BIN files.
       Not very elegant, I admit */
    if ((flags & JOIN)     &&
        (flags & DUMB_BIN) &&
         binstartpos)
    {
      int i, j;
      long k;

      k = 256L - binstartpos;
      for (i = 0; i < 3; i++)
      {
        for (j = 79; j > 0; j--)
        {
          fputc (' ', otf);
          if (--k == 1)
            break;
        }
        fputc ('\x0d', otf);
        if (!--k)
          break;
      }
    }

    if (!(flags & JOIN) || part == last_part || part == nparts)
      fclose (otf);
  }

  if (flags & JOIN)
  {
    fprintf (o, "\nCreated uploadfile \"");
    if (*uplname)
    {
      if (uplname[(int)strlen(uplname)-1] == PATHCHAR)
        sprintf (pfn, "%s%s.upl", uplname, name);
      else
        strcpy (pfn, uplname);
      fprintf (o, "%s\"\n", pfn);
    }
    else
      fprintf (o, "%s.upl\"\n", name);
  }
  fprintf (o,"\n\nDone.\n");

  if (flags & BINHEAD)
    fprintf (o,"\nImportant note:\n"
                 "Use pure binary send for these files, because #BIN# headers\n"
                 "are already included!\n\n");

  return;
}


void combine (char *fn)
{
  FILE    *inf;
  FILE    *otf = NULL;
  char    *p;
  char    *s;
  char    name[STDSTRING];
  char    name2[STDSTRING];
  char    orig[STDSTRING];
  char    missing[256];
  int     ch;
  uint    crc;
  uint    ocrc;
  ulong   timestamp;
  long    length;
  int     i;
  int     n = 1;
  int     tot = 0;

  *orig = EOS;
  missing[0] = (char) 0;

  strcpy (name, fn);
  s = name + strlen (name);
  for (;;)
  {
    missing[n] = (char) 0;
    sprintf (s, ".b%02x", n);
    if ((inf = fopen (name, OPEN_R_BIN)) == NULL)
    {
      if (n == 1)
      {
        fprintf (o, "\nCannot find \"%s\"\n", name);
        fclose (otf);
        unlink (orig);
        exit (1);
      }
      else
      {
        missing[n] = missing[0] = (char) 1;
        if (++n > tot)
          break;
        continue;
      }
    }
    setvbuf (inf, NULL, _IOFBF, 16384);
    if (read_16 (inf) != MAGIC)
    {
      /* File contains wrong magic number*/
      missing[n] = missing[0] = (char) 1;
      fclose (inf);
      unlink (name);
      if (++n > tot)
        break;
      continue;
    }
    if (!tot)
      tot = fgetc (inf);
    else
      if (tot != fgetc (inf))
      {
         /* Invalid total part count */
         missing[n] = missing[0] = (char) 1;
         fclose (inf);
         unlink (name);
         if (++n > tot)
           break;
         continue;
      }
    if (n != fgetc (inf))
    {
      /* Sequence error */
      missing[n] = missing[0] = (char) 1;
      fclose (inf);
      unlink (name);
      if (++n > tot)
        break;
      continue;
    }
    ocrc = (uint) read_16 (inf);
    crc = 0;
    if (n == 1)
    {
      p = orig;
      fgetc (inf);            /* ignore length byte */
      while ((*p = (char) fgetc (inf)) != '\0')
        p++;

      if (flags & FORCE8_3)
      {
        fnsplit (orig, NULL, NULL, name2, ext);
        build_DOS_name (name2, ext);
        sprintf (orig, "%s%s%s", name2, (*ext?".":""), ext);
      }

      if (*uplname)
        if (uplname[(int)strlen(uplname)-1] == PATHCHAR)
        {
          sprintf (name2, "%s%s", uplname, orig);
          strcpy (orig, name2);
        }
        else
          strcpy (orig, uplname);

      if (!(flags & FORCE8_3))
        make_compat (orig);

      if ((otf = fopen (orig,OPEN_W_BIN)) == NULL)
      {
        fprintf (o, "\nCannot create output file \"%s\"\n", orig);
        exit (7);
      }
      setvbuf (otf, NULL, _IOFBF, 16384);

      fprintf (o, "Recombining \"%s\"\n", name);
    }
    else
    {
      i = fgetc (inf);
      while (i--)
        fgetc (inf);        /* ignore file name */
    }

    while ((ch = fgetc (inf)) != EOF)
      updcrc (fputc (ch, otf), crc);

    if (crc != ocrc)
    {
      missing[0] = (char) 1;
      missing[n] = (char) 2;
      fclose (inf);
      unlink (name);
      if (++n > tot)
        break;
      continue;
    }

    if (++n > tot)
    {
      if (!*missing)
      {
        fseek (inf, 6L, SEEK_SET);
        i = fgetc (inf);
        i -= 4;
        fseek (inf, i, SEEK_CUR);
        timestamp = (ulong) read_32 (inf);
      }
      fclose (inf);
      break;
    }
    fclose (inf);
  }

  length = ftell (otf);
  fclose (otf);

  if (!*missing)
  {
    set_filetime (orig, timestamp);

    for (i = 1; i < n; i++)
    {
      sprintf (s, ".b%02x", i);
      unlink (name);
    }

    fprintf (o, "\n\nCreated \"%s\" (%ld Bytes)\n"
                "\nDone.\n", orig, length);
  }
  else
  {
    unlink (orig);
    fprintf (o,
      "\n\nCouldn't create \"%s\"\n"
        "\nThe following parts are missing or have a bad CRC(*):\n\n", orig);
    for (i = 1; i <= tot; i++)
    {
      if (missing[i] == 1)
        fprintf (o," %02x ", i);
      if (missing[i] == 2)
        fprintf (o," %02x*", i);
    }
    fprintf (o, "\n\nThe files with bad CRCs have been erased.\n"
                  "\nGet the listed parts and try again!\n\n");
  }

  if (*missing)
   exit(12);

  exit(0);
}

/*
*** Create a MSDOS/ATARI compatible filename.
***
***
 */

void build_DOS_name (char *name, char *ext)
{

  make_compat (name);

  if (*ext)
    memmove (ext, ext +1, strlen (ext));

  make_compat (ext);

  /* truncate name and extension to 8/3 */
  name[8] = EOS;
  ext[3]  = EOS; /* no . in ext! */
}

/*
*** Add function body for your system to make filename compatible.
*** E.g. Unix does not allow spaces in filenames.
 */
void make_compat (char *name)
{
  int i;
#ifdef __unix__ /* for guess what */
  i = -1;
  /** swap space for _ **/
  while (name[++i])
    if (name[i] == ' ')
      name[i] = '_';
#endif

  if (flags & FORCE8_3) /** for DOS, OS/2 and Win before 95 **/
  {
    i = 0;

    strlwr (name);

    if (*name)
    {
      do
      {
        /** allow only alphanumeric chars + -_#!@$~ and no spaces **/
        if ((isalnum (name[i]) || strchr ("-_#!@$~", name[i]))
            && (name[i] != ' '))
          continue;
        name[i] = '_';
      }
      while (name[++i]);

      name[i] = EOS;
    }
  }
}

#ifdef __BORLANDC__
 #pragma warn -sig
#endif
/*
*** Reading/writing unsigned int (16bit)
***
***
 */
int read_16 (FILE *in)
{
  uint val;

  val =        (uint) fgetc (in);
  val = val + ((uint) fgetc (in) << 8);

  return ((int)val);
}

void write_16 (int val, FILE *out)
{
  putc ((int) ((uint)val    &0xffU), out);
  putc ((int)(((uint)val>>8)&0xffU), out);
}

long read_32 (FILE *in)
{
  ulong val;

  val =        (ulong) fgetc (in);
  val = val + ((ulong) fgetc (in) <<  8);
  val = val + ((ulong) fgetc (in) << 16);
  val = val + ((ulong) fgetc (in) << 24);

  return ((long)val);
}

void write_32 (long val, FILE *out)
{
  putc ((int) ((ulong)val     &0xffUL), out);
  putc ((int)(((ulong)val>>8 )&0xffUL), out);
  putc ((int)(((ulong)val>>16)&0xffUL), out);
  putc ((int)(((ulong)val>>24)&0xffUL), out);
}
#ifdef __BORLANDC__
 #pragma warn .sig
#endif

#if (defined(__MSDOS__) || defined(__TOS__) || defined (__BORLANDC__))
 /*
 *** Get file's timestamp and package it into a 32-bit word (MS_DOS-format)
 ***
 ***
  */
 ulong get_filetime (const char *filename)
 {
   ulong    ftimestamp = 0;
   FILE *file;

   if ((file = fopen (filename, OPEN_R_BIN)) == NULL)
     return (0);

   if (getftime (fileno(file), (struct ftime *)&ftimestamp) == EOF)
     fprintf (o,"\007\nCan't get file's timestamp!\n");

 #ifdef __TOS__
   ftimestamp = swapl(ftimestamp);
 #endif

   fclose (file);

   return (ftimestamp);
 }

 #define _SETFTIME_OK
 /*
 *** Set file's timestamp
 ***
 ***
  */
 void set_filetime (const char *filename, ulong ftimestamp)
 {
   char *a = "\007\nCan't set file's timestamp!";
   FILE *file;

   if ((file = fopen (filename, OPEN_A_BIN)) == NULL)
   {
     fprintf (o, a);
     return;
   }
 #ifdef __TOS__
   ftimestamp = swapl(ftimestamp);
 #endif

   if (setftime (fileno(file), (struct ftime *)&ftimestamp) == EOF)
     fprintf (o, a);

   fclose (file);
 }

#else /* it's not an MSDOS or Atari system */
 #ifndef _HAVE_GMTIME
  /*
  * these functions are required for converting a MSDOS time to a UNIX time
  * and vice versa.
  */

  /*
  * mktime function from GNU C library V1.03; modified:
  * - expanded DEFUN and CONST macros from ansidecl.h
  * - inserted __isleap macro from time.h
  * - inserted __mon_lengths array and __offtime function from offtime.c
  * - inserted gmtime function from gmtime.c
  * - commented out call of localtime function
  * Be aware of the following copyright message for mktime !!!
  */

  /* Copyright (C) 1991 Free Software Foundation, Inc.
  This file is part of the GNU C Library.

  The GNU C Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  The GNU C Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with the GNU C Library; see the file COPYING.LIB.  If
  not, write to the Free Software Foundation, Inc., 675 Mass Ave,
  Cambridge, MA 02139, USA.  */


  /* How many days are in each month.  */
  const unsigned short int __mon_lengths[2][12] =
  {
    /* Normal years.  */
    { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
    /* Leap years.  */
    { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
  };

  #define  __isleap(year)  \
   ((year) % 4 == 0 && ((year) % 100 != 0 || (year) % 400 == 0))

  #define  invalid()  return (time_t) -1


  #define  SECS_PER_HOUR  (60 * 60)
  #define  SECS_PER_DAY  (SECS_PER_HOUR * 24)

  /* Returns the `struct tm' representation of *T,
     offset OFFSET seconds east of UCT.  */
  struct tm *
  __offtime (const time_t *t, long int offset)
  {
   static struct tm tbuf;
   register long int days, rem;
   register int y;
   register const unsigned short int *ip;

   if (t == NULL)
    return NULL;

   days = *t / SECS_PER_DAY;
   rem = *t % SECS_PER_DAY;
   rem += offset;
   while (rem < 0)
   {
    rem += SECS_PER_DAY;
    --days;
   }
   while (rem >= SECS_PER_DAY)
   {
    rem -= SECS_PER_DAY;
    ++days;
   }
   tbuf.tm_hour = rem / SECS_PER_HOUR;
   rem %= SECS_PER_HOUR;
   tbuf.tm_min = rem / 60;
   tbuf.tm_sec = rem % 60;
   /* January 1, 1970 was a Thursday.  */
   tbuf.tm_wday = (4 + days) % 7;
   if (tbuf.tm_wday < 0)
    tbuf.tm_wday += 7;
   y = 1970;
   while (days >= (rem = __isleap(y) ? 366 : 365))
   {
    ++y;
    days -= rem;
   }
   while (days < 0)
   {
    --y;
    days += __isleap(y) ? 366 : 365;
   }
   tbuf.tm_year = y - 1900;
   tbuf.tm_yday = days;
   ip = __mon_lengths[__isleap(y)];
   for (y = 0; days >= ip[y]; ++y)
    days -= ip[y];
   tbuf.tm_mon = y;
   tbuf.tm_mday = days + 1;
   tbuf.tm_isdst = -1;

   return &tbuf;
  }


  /* Return the `struct tm' representation of *T in UTC.  */
  struct tm *
  gmtime (const time_t *t)
  {
   return __offtime(t, 0L);
  }
 #endif /* ifndef _HAVE_GMTIME */

 #ifndef _HAVE_MKTIME

  /* Return the `time_t' representation of TP and normalizes TP.
     Return (time_t) -1 if TP is not representable as a `time_t'.
     Note that 31 Dec 1969 23:59:59 is not representable
     because it is represented as (time_t) -1.  */
  time_t mktime (register struct tm *tp)
  {
   static struct tm min, max;
   static char init = 0;

   register time_t result;
   register time_t t;
   register int i;
   register const unsigned short *l;
   register struct tm *new;
   time_t end;

   if (tp == NULL)
   {
    errno = EINVAL;
    invalid();
   }

   if (!init)
   {
    init = 1;
    end = (time_t) LONG_MIN;
    new = gmtime(&end);
    if (new != NULL)
     min = *new;
    else
     min.tm_sec = min.tm_min = min.tm_hour =
    min.tm_mday = min.tm_mon = min.tm_year = INT_MIN;

    end = (time_t) LONG_MAX;
    new = gmtime(&end);
    if (new != NULL)
     max = *new;
    else
     max.tm_sec = max.tm_min = max.tm_hour =
    max.tm_mday = max.tm_mon = max.tm_year = INT_MAX;
   }

   /* Make all the elements of TP that we pay attention to
     be within the ranges of reasonable values for those things.  */
   #define  normalize(elt, min, max, nextelt)\
    while (tp->elt < min)                    \
    {                                        \
     --tp->nextelt;                          \
     tp->elt += max + 1;                     \
    }                                        \
    while (tp->elt > max)                    \
    {                                        \
     ++tp->nextelt;                          \
     tp->elt -= max + 1;                     \
    }

   normalize (tm_sec, 0, 59, tm_min);
   normalize (tm_min, 0, 59, tm_hour);
   normalize (tm_hour, 0, 24, tm_mday);

   /* Normalize the month first so we can use
      it to figure the range for the day.  */
   normalize (tm_mon, 0, 11, tm_year);
   normalize (tm_mday, 1, __mon_lengths[__isleap (tp->tm_year)][tp->tm_mon],
   tm_mon);

   /* Normalize the month again, since normalizing
      the day may have pushed it out of range.  */
   normalize (tm_mon, 0, 11, tm_year);

   /* Normalize the day again, because normalizing
      the month may have changed the range.  */
   normalize (tm_mday, 1, __mon_lengths[__isleap (tp->tm_year)][tp->tm_mon],
    tm_mon);

   /* Check for out-of-range values.  */
   #define  lowhigh(field, minmax, cmp)  (tp->field cmp minmax.field)
   #define  low(field)                  lowhigh(field, min, <)
   #define  high(field)                 lowhigh(field, max, >)
   #define  oor(field)                  (low(field) || high(field))
   #define  lowbound(field)             (tp->field == min.field)
   #define  highbound(field)            (tp->field == max.field)
   if (oor(tm_year))
    invalid();
   else
    if (lowbound(tm_year))
    {
     if (low(tm_mon))
      invalid();
     else
      if (lowbound(tm_mon))
      {
       if (low(tm_mday))
        invalid();
       else
        if (lowbound(tm_mday))
        {
         if (low(tm_hour))
          invalid();
         else
          if (lowbound(tm_hour))
          {
           if (low(tm_min))
            invalid();
           else
            if (lowbound(tm_min))
            {
             if (low(tm_sec))
             invalid();
            }
          }
        }
      }
    }
    else
     if (highbound(tm_year))
     {
      if (high(tm_mon))
       invalid();
      else
       if (highbound(tm_mon))
       {
        if (high(tm_mday))
         invalid();
        else
         if (highbound(tm_mday))
         {
          if (high(tm_hour))
           invalid();
          else
           if (highbound(tm_hour))
           {
            if (high(tm_min))
             invalid();
            else
             if (highbound(tm_min))
             {
              if (high(tm_sec))
               invalid();
             }
           }
         }
       }
     }
    t = 0;
    for (i = 1970; i > 1900 + tp->tm_year; --i)
     t -= __isleap(i) ? 366 : 365;
    for (i = 1970; i < 1900 + tp->tm_year; ++i)
     t += __isleap(i) ? 366 : 365;
    l = __mon_lengths[__isleap(1900 + tp->tm_year)];
    for (i = 0; i < tp->tm_mon; ++i)
     t += l[i];
    t += tp->tm_mday - 1;
    result = ((t * 60 * 60 * 24) +
              (tp->tm_hour * 60 * 60) +
              (tp->tm_min * 60) +
               tp->tm_sec);

    end = result;
   #if 0
   if (tp->tm_isdst < 0)
    new = localtime(&end);
   else
   #endif
    new = gmtime(&end);
   if (new == NULL)
    invalid();
   new->tm_isdst = tp->tm_isdst;
   *tp = *new;

   return result;
  }
 #endif /* ifndef _HAVE_MKTIME */

 /*
  * Get file's timestamp and package it into a 32-bit word (MS_DOS-format).
  * This function should work on any system (even on AMIGAs) :-)
  */
 ulong get_filetime (const char *filename)
 {
   struct ftime fti;
   ulong *retval = (ulong *) &fti;
   struct tm *utm;
   struct stat fst;

   *retval = 0UL;

   /* get file status */
   if (stat (filename, &fst) == 0)
   {
     /* get time of last modification and convert it to MS/DOS time */
     utm = localtime (&fst.st_mtime);

    if (utm)
    {
     #ifdef __EMX__
        /* The gmtime() implementation of EMX/GCC under OS2 already devides
        the seconds by 2.. strange!?  */
        fti.ft_tsec  = utm->tm_sec;
     #else
        fti.ft_tsec  = utm->tm_sec / 2;
     #endif
       fti.ft_min   = utm->tm_min;
       fti.ft_hour  = utm->tm_hour;
       fti.ft_day   = utm->tm_mday;
       fti.ft_month = utm->tm_mon + 1;
       fti.ft_year  = utm->tm_year - 80;

       return (*retval);
    }
  }

  /* error exit */
  fprintf (o,"\007\nCan't get file's timestamp!\n");
  return (*retval);
 }

 #ifdef _AMIGA_
  #define _SETFTIME_OK
  /*
  * Set file's timestamp
  * This function only works on AMIGA-systems
  */
  void set_filetime (const char *filename, ulong ftimestamp)
  {
   time_t atime;
   struct ftime *fti;
   struct tm utm;
   struct DateStamp fdate;

   /* convert MS/DOS ftimestamp to UNIX atime */
   fti = (struct ftime *) &ftimestamp;
   utm.tm_sec   = fti->ft_tsec * 2;
   utm.tm_min   = fti->ft_min;
   utm.tm_hour  = fti->ft_hour;
   utm.tm_mday  = fti->ft_day;
   utm.tm_mon   = fti->ft_month - 1;
   utm.tm_year  = fti->ft_year +80;
   utm.tm_wday  = utm.tm_yday  =  utm.tm_isdst = 0;
   atime = mktime (&utm);

   fdate.ds_Days = (atime/86400)-2922; /* 86400sec per Day + systimecorr.*/
   fdate.ds_Minute = (atime % 86400) / 60;
   fdate.ds_Tick = (atime % 60) * TICKS_PER_SECOND;

   SetFileDate((char*)filename,&fdate); /* (char*) eingefuegt (DG9BJA) */

   return; /* (1) nach return entfernt (DG9BJA) */
  }
 #endif /* _AMIGA_ */

 #if (defined (__unix__) || defined (OSK) || defined (__OS2__))
  #define _SETFTIME_OK

  /*
  * Set file's timestamp
  * This function only works on systems that have utime() available
  */
  void set_filetime (const char *filename, ulong ftimestamp)
  {
   time_t atime;
   struct utimbuf utim;
   struct ftime *fti;
   struct tm utm;

   /* convert MS/DOS ftimestamp to UNIX atime */
   fti = (struct ftime *) &ftimestamp;

   /* Now, setup struct utm with real data */
   utm.tm_sec   = fti->ft_tsec * 2;
   utm.tm_min   = fti->ft_min;
   utm.tm_hour  = fti->ft_hour;
   utm.tm_mday  = fti->ft_day;
   utm.tm_mon   = fti->ft_month - 1;
   utm.tm_year  = fti->ft_year + 80;
   utm.tm_wday  = utm.tm_yday  =  utm.tm_isdst = 0;

   atime = mktime(&utm);

   if (atime != -1)
   {
    /* set access time and modification time */
    utim.actime = atime;
    utim.modtime = atime;

    if (utime (filename, &utim) >= 0)
      return;
   }

   /* error exit */
   fprintf (o,"\007\nCan't set file's timestamp to: %s", ctime (&atime));
   return;
  }
 #endif /* __unix__/OSK/__OS2__ */

 #ifndef _SETFTIME_OK
  /*
  * Set file's timestamp
  *
  */
  void set_filetime (const char *filename, ulong ftimestamp)
  {
   /* error exit */
   fprintf (o,"\007\nset_filetime not (yet) implemented on this system!\n");
   return;
  }
 #endif
#endif

#ifndef _HAVE_FNSPLIT
/*
***       filenamesplit
***       (by DL1MEN, taken from SP-ST, modified for portability)
***
***       split filename up into drive, path, name and extension.
***
 */

void fnsplit (char *pth, char *dr, char *pa, char *fn, char *ft)
{
  char drv[STDSTRING], pat[STDSTRING], fna[STDSTRING];
  char fty[STDSTRING], tmp[STDSTRING];
  char *p;

  strcpy(tmp,pth);

  if ((p = strchr(tmp,':')) != NULL)
  {
    *p++ = EOS;
    strncpy(drv,tmp, MAXDRIVE);
    drv[MAXDRIVE] = EOS;
  }
  else
  {
    p = tmp;
    drv[0] = EOS;
  }
  if ((pth = strrchr(p, PATHCHAR)) != NULL)
  {
    *pth++ = EOS;
    strcpy(pat,p);
  }
  else
  {
    pth = p;
    pat[0] = EOS;
  }
  if ((p = strrchr(pth,'.')) != NULL)
  {
    strcpy(fty,p);
    fty[MAXEXT-1] = EOS;
    *p = EOS;
  }
  else
    fty[0] = EOS;

  strcpy(fna,pth);
  fna[MAXFILE-1] = EOS;

  if (dr)
  {
    strcpy(dr,drv);
    if (drv[0])
      strcat(dr,":");
  }
  if (pa)
  {
    strcpy(pa,pat);
    if (pat[0])
      strcat(pa, PATHSEP);
  }
  if (fn)
    strcpy(fn,fna);
  if (ft)
    strcpy(ft,fty);
}
#endif /** ifndef _HAVE_FNSPLIT **/

#ifndef _HAVE_ICMP
/* The following functions are unfortunately not available with all compilers */

/*
*** strupr - convert string to upper case.
***
***
 */

char *strupr (char *string)
{
  char *strcnvt (char *string, int flag);

  return (strcnvt (string, 1));
}

/*
*** strlwr - convert string to lower case.
***
***
 */

char *strlwr (char *string)
{
  char *strcnvt (char *string, int flag);

  return (strcnvt (string, 0));
}

/*
*** strcnvt - convert string to upper (flag == 1) or lower (flag == 0) case.
***
***
 */

char *strcnvt (char *string, int flag)
{
  register i = 0;

  while (string[i])
  {
    string[i] = (flag)?toupper (string[i]):tolower (string[i]);
    i++;
  }
  return (string);
}

/*
*** stricmp - same as strcmp(), but ignores case.
*** s1 and s2 are not modified.
***
 */

int stricmp (const char *s1, const char *s2)
{
  return (strnicmp (s1, s2, (size_t) 80));
}

/*
*** strnicmp - same as strncmp(), but ignores case.
*** s1 and s2 are not modified.
***
 */

int strnicmp (const char *s1, const char *s2, size_t n)
{
  char _s1[81], _s2[81];

  strncpy (_s1, s1, 80);
  strncpy (_s2, s2, 80);
  strupr (_s1);
  strupr (_s2);

  return (strncmp (_s1, _s2, n));
}
#endif /** ifndef _HAVE_ICMP **/


void usage (int err)
{
  if (err == 9)
    fprintf (o, "Too many command line parms!\n\n");

  if (err == 10)
    fprintf (o, "Syntax error!\n\n");


  fprintf (o,
    "Usage:    bs filename [-splitparm] [options]\n\n"
    "Examples: bs test.exe         Split into parts of ROUGHLY %ld bytes.\n"
    "          bs test.exe -5      Split into 5 parts of equal size.\n"
    "          bs test.exe -50000  Split into parts of 50000 bytes.\n"
    "          bs test.exe -1      Don't split at all, just add #BIN# header.\n"
    "          bs test.b01         Combine parts of 'test'.\n\n"
    "Options:  -b           Add #BIN# headers to each part.\n"
    "          -q           Quiet mode. No screen output.\n"
    "          -r range     Create only parts specified by range (HEX!),\n"
    "                       e.g. 1-3, 3C-, -4, 2 etc.\n"
    "          -s \"s ibm @dl #0\"  Specify send command (-s2: two line send).\n"
    "          -u           Write output to single upload file.\n"
    "          -u name.ext  Same as -u, but define name of upload file.\n"
    "                       When combining, define alternate name for original file.\n"
#ifndef SHORTNAMES
    "          -w           Force use of 8.3 filenames.\n"
    "          -w name      Use \"name\" for split parts and/or upload file.\n"
#endif
    "          -+           Use this option only when receiving terminal has\n"
    "                       problems with back-to-back BIN-files!\n"
    "\nNOTE: When using -b, -u or -s, use PURE binary upload, not AUTOBIN!\n"
    "Limits:   00h < parts < FFh    4999 < size of parts < 4294967296 Bytes\n"
    "BS will automatically erase the split parts after combining!\n"
    "BS always overwrites mercilessly!\n"
      , NORPART);
  
  fprintf (o,"\033pHit any key...\033q");
  getch();
  exit(err);
}

/** List of return codes:

 0 - All's well.
 1 - File not found.
 2 - File smaller than minimun splitsize.
 3 - File smaller than specified splitsize. Choose smaller splitsize.
 4 - Splitsize too small. Would result in >255 parts. Choose bigger splitsize.
 5 - Can't split into 1 part. (obsolete)
 6 - Splitsize too small. Specify less parts to split into.
 7 - Can't write to file.
 8 - Requested part no. higher than total no. of parts.
 9 - Too many command line parms
10 - Syntax error
11 - Help displayed
12 - Parts missing or have bad CRC
 When in servermode (-a), only errors 1, 7 and 8 can occur, provided the calling
 server has correctly parsed the command line.

**/
