{---------------------------------------------------------------------------}
{ Dienstprogramm QTH-Kennerberechnung als RUN Utility von BAYBOX und DIEBOX }
{                                                                           }
{ Version V2.0 vom 17.01.97  Gerd Michael Ritter DL5FBD                     }
{---------------------------------------------------------------------------}

PROGRAM QTH;

{---------------------------------------------------------------------------}
{ Speicherorganisation von QTH (Moeglichst wenig eigenreservierter Speicher)} 
{---------------------------------------------------------------------------}

{$M $4000,0,0} 
{$N+}
{$E+}

{---------------------------------------------------------------------------}
{ Verwendete externe Bibliotheksprogramme (Turbo Pascal UNITs)              }
{---------------------------------------------------------------------------}

Uses DOS,QTHBER;

{---------------------------------------------------------------------------}
{ Definition von internen Konstanten und Variablen                          }
{---------------------------------------------------------------------------}

CONST  Version       ='V2.0';      {Programmversion}
       BBSParameter  :Byte =0;     {Zusaetzliche Mailbox-Uebergabeparameter}

VAR    QTH1, QTH2    :String[20];  {Uebergebene QTH-Kenner}
       QTHN          :String[6];   {Neuer QTH-Kenner intern berechnet}
       QTHA          :String[7];   {Alter QTH-Kenner intern berechnet}
       QTHRO,QTHRN   :String[7];   {Geografische Koordinatenwinkel REAL}
       QTHK          :String[20];  {Geografische Koordinate intern berechnet}
       TEMP          :String[8];   {Zwischenspeicher fuer QTHRO und QTHRN}
       OEL,NOEB      :Extended;    {Oestliche Laenge, Noerdliche Breite}
       Entfg, Richtg :Extended;    {Entfernung und Richtung}
       I             :Byte;        {Index fuer Feldzugriffe}
       Status        :Boolean;     {Status der internen QTH-Formatpruefungen}
       Datei         :Text;        {Datei mit der Anzahl der Zusatzparameter}

BEGIN
  {Ermittlung zusaetzlicher Parameter, die mitgezaehlt werden muessen}
  {Wenn QTH unter DIEBOX laeuft existiert eine TEMP-Datei USR_PAR.TMP}
  {und es existieren 3 zusaetzliche Uebergabeparameter der DIEBOX-BBS}
  Assign(Datei,GetEnv('TMP_DIR')+'USR_PAR.TMP');
  {$I-} RESET(Datei); {$I+}
  IF IOResult=0 THEN
    BEGIN
      BBSParameter:=3;
      Close(Datei);
    END;

  {Wenn keine Parameter angegeben wurden, den internen Hilfetext ausgeben}
  IF ParamCount=0+BBSParameter THEN
    BEGIN
      Writeln;
      Writeln('Mailbox RUN-Utility  QTH ',Version,' (c) DL5FBD');
      Writeln;
      Writeln('Aufruf:  RUN QTH <QTH>          - QTH-Umrechnungen');
      Writeln('Aufruf:  RUN QTH <QTH1> <QTH2>  - Entfernungs-/Richtungsberechnung');
      Writeln;
      Writeln('Als <QTH>, <QTH1> und <QTH2> sind folgende Eingaben erlaubt:');
      Writeln;
      Writeln('  Der neue weltweite QTH-Kenner  z.B. JO40HC');
      Writeln('  Der alte QTH-Kenner            z.B. EK74H oder EK74H/2');
      Writeln('  Die geografische Koordinate    z.B. +GGG:MM:SS/+GG:MM:SS');
      Writeln('  in GMS und Realzahlabschluss   z.B. +G:M:SS.SS/+G:M:SS.SS');
      Writeln('  ab Grad, Minute oder Sekunde        +GGG:MM.MM/+GG:MM.MM');
      Writeln('                                      +GGG.GG/+GG.GG');
      Writeln;
      Writeln('Die optionale QTH-Kennerrasterkennung /1 bis /4 beim alten');
      Writeln('QTH-Kenner beruecksichtigt die Tatsache, dass die Region 1');
      Writeln('sich ueber 4 unabhaengige Alt-QTH-Kennerraster erstreckt.');
      Writeln;
      Writeln('Die Kennzeichnung mit /1- /4 ist die Rasterkennung gemaess');
      Writeln('der QTH-Kennerkarte der Region 1 mit dem alten QTH-Kenner.');
      Writeln;
      Halt(0);
    END;

  {Ein QTH-Kenner zur Umrechnung in alle QTH-Daten angegeben}
  IF ParamCount=1+BBSParameter THEN
    BEGIN
      QTH1:=ParamStr(1);
      QTH_Pruefen(QTH1,OEL,NOEB,Status);
      IF Status THEN
        BEGIN
          QTHN:=Winkel_in_Neu(OEL,NOEB);
          QTHA:=Winkel_in_Alt(OEL,NOEB);
          QTHK:=Winkel_in_GMS(OEL,NOEB);
          STR(OEL:8:3,QTHRO);
          STR(NOEB:8:3,QTHRN);
          TEMP:=QTHRO;
          QTHRO:='';
          FOR I:=1 TO LENGTH(TEMP) DO IF TEMP[I]<>' ' THEN QTHRO:=QTHRO+TEMP[I];
          TEMP:=QTHRN;
          QTHRN:='';
          FOR I:=1 TO LENGTH(TEMP) DO IF TEMP[I]<>' ' THEN QTHRN:=QTHRN+TEMP[I];
          Writeln;
          Writeln('QTH ',Version);
          Writeln;
          Writeln('Die QTH-(Kenner)-Angabe entspricht:');
          Writeln;
          Write('Dem neuen weltweiten QTH-Kenner                        : ');
          Writeln(QTHN);
          Write('Dem alten QTH-Kenner mit Region 1 Feldkennzeichnung /z : ');
          Writeln(QTHA);
          Write('Der geografischen Koordinate (Laenge/Breite in GMS)    : ');
          Writeln(QTHK);
          Write('Der geografischen Koordinate (Laenge/Breite als Zahl)  : ');
          Writeln(QTHRO,'/',QTHRN);
          Writeln;
          Halt(0);
        END
      ELSE
        BEGIN
          Writeln;
          Writeln('QTH-Umrechnung abgebrochen: Ungueltige QTH-Angabe.');
          Writeln;
          Halt(0);
        END;
    END;

  {Entfernung und Richtung berechnen}
  IF ParamCount=2+BBSParameter THEN
    BEGIN
      QTH1:=ParamStr(1);
      QTH2:=ParamStr(2);
      QTH_Entfg_Richtg(QTH1,QTH2,Entfg,Richtg,Status);
      IF Status THEN
        BEGIN
          Writeln;
          Writeln('QTH ',Version);
          Writeln;
          Writeln('Entfernungsberechnung und Richtungsberechnung zwischen:');
          Writeln;
          Writeln('QTH1= ',QTH1);
          Writeln('QTH2= ',QTH2);
          Writeln;
          Write('Die Entfernung zwischen QTH1 und QTH2 ist : ');
          Writeln(Entfg:8:2,' km');
          Write('Die Richtung von QTH1 nach QTH2 ist       : ');
          Writeln(Richtg:8:2,' Grad');
          Writeln;
          Halt(0);
        END
      ELSE
        BEGIN
          Writeln;
          Write('QTH-Entfernungs/Richtungsberechnung abgebrochen: ');
          Writeln('Ungueltige QTH-Angabe(n).');
          Writeln;
          Halt(0);
        END;
    END;

  {Dieser Programmteil duerfte normalerweise niemals erreicht werden}
  Writeln;
  Writeln('QTH ',Version,'  Parameteruebergabeproblem beim Aufruf von QTH!');
  Writeln;
  Writeln('          QTH kann die beim Aufruf uebergebenen Parameter nicht');
  Writeln('          zuordnen, weil zuviele Parameter uebergeben wurden.');
  Writeln;
  Writeln('Ursachen: Der Benutzer hat zuviele Parameter angegeben oder der');
  Writeln('          Sysop der lokalen Mailbox hat QTH falsch installiert.');
  Writeln;
END.
